/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.elanModules.playground.salt.elan2salt;

import java.io.File;
import java.util.Collection;
import java.util.Vector;
import org.corpus_tools.peppermodules.elanModules.Elan2SaltMapper;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SCorpus;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SaltProject;
import org.corpus_tools.salt.graph.Node;
import org.eclipse.emf.common.util.URI;

public class ElanImporterMain {
    private SCorpusGraph sCorpusGraph = null;

    public static SCorpusGraph createCorpusStructure(SaltProject saltProject, String path, String name) {
        SCorpusGraph sCorpGraph = SaltFactory.createSCorpusGraph();
        saltProject.addCorpusGraph(sCorpGraph);
        SCorpus sCorpus1 = SaltFactory.createSCorpus();
        System.out.println("Creating corpus structure with name: " + name);
        sCorpus1.setName(name);
        sCorpGraph.addNode((Node)sCorpus1);
        SDocument sDoc = null;
        Collection<String> filenames = ElanImporterMain.getFileNamesInDirectory(path);
        System.out.println(filenames);
        for (String filename : filenames) {
            sDoc = SaltFactory.createSDocument();
            sDoc.setName(filename);
            sDoc.createMetaAnnotation(null, "origFile", (Object)(path + "/" + filename));
            sCorpGraph.addDocument(sCorpus1, sDoc);
        }
        return sCorpGraph;
    }

    public static Collection<String> getFileNamesInDirectory(String path) {
        Vector<String> out = new Vector<String>();
        File folder = new File(path);
        File[] listOfFiles = folder.listFiles();
        System.out.println("there are a number of files in this place: " + path + ", " + listOfFiles.length);
        for (int i = 0; i < listOfFiles.length; ++i) {
            String files;
            if (!listOfFiles[i].isFile() || !(files = listOfFiles[i].getName()).endsWith(".eaf") && !files.endsWith("(1).EAF")) continue;
            out.add(files);
        }
        return out;
    }

    public static String getHello() {
        StringBuffer retVal = new StringBuffer();
        retVal.append("****************************************************************************\n");
        retVal.append("***                        Welcome to Elan2Salt                          ***\n");
        retVal.append("****************************************************************************\n");
        return retVal.toString();
    }

    public static String getBye() {
        StringBuffer retVal = new StringBuffer();
        retVal.append("****************************************************************************\n");
        retVal.append("*** Bye from Elan2Salt                                                   ***\n");
        retVal.append("****************************************************************************\n");
        return retVal.toString();
    }

    public SCorpusGraph getCorpus() {
        return this.sCorpusGraph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        System.out.println(ElanImporterMain.getHello());
        if (args == null || args.length < 1) {
            throw new NullPointerException("Please set corpus source path.");
        }
        String path = args[0];
        try {
            SaltProject saltProject = SaltFactory.createSaltProject();
            System.out.print("creating a corpus structure for salt project...");
            String corpusname = path.replaceAll("/$", "");
            System.out.println(corpusname);
            ElanImporterMain.createCorpusStructure(saltProject, path + "elan-public", corpusname.substring(corpusname.lastIndexOf("/") + 1));
            System.out.println("OK");
            System.out.println("filling all of the documents in the corpus structure with document structure data...");
            SCorpusGraph sCorpusGraph = (SCorpusGraph)saltProject.getCorpusGraphs().get(0);
            for (SDocument sDocument : sCorpusGraph.getDocuments()) {
                System.out.println("working on sdoc: " + sDocument);
                Elan2SaltMapper mapper = new Elan2SaltMapper();
                sDocument.setDocumentGraph(SaltFactory.createSDocumentGraph());
                mapper.setDocument(sDocument);
                mapper.mapSDocument();
            }
            System.out.println("OK");
            String tmpPathName = path + "salt";
            File tmpPath = new File(tmpPathName);
            if (!tmpPath.exists()) {
                tmpPath.mkdirs();
            }
            System.out.print("store salt project to tmp path ('" + tmpPath.getAbsolutePath() + "')...");
            saltProject.saveSaltProject(URI.createFileURI((String)tmpPath.getAbsolutePath()));
            System.out.println("OK");
            System.out.println();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            System.out.println(ElanImporterMain.getBye());
        }
    }
}

