/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.elanModules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.peppermodules.elanModules.ElanImporterProperties;
import org.corpus_tools.salt.SALT_TYPE;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SSequentialDS;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.STimeline;
import org.corpus_tools.salt.common.STimelineRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;
import org.corpus_tools.salt.util.DataSourceSequence;

public class GlossEnricher {
    protected SDocument curSDoc;
    protected TranscriptionImpl curElan;
    protected Map<Long, Integer> time2char = new HashMap<Long, Integer>();
    protected Map<Integer, Long> char2time = new HashMap<Integer, Long>();
    protected String MINIMAL_SEGMENTATION_TIER_NAME = null;
    protected ElanImporterProperties curProps;
    protected ArrayList<SSpan> glosspans = new ArrayList();
    protected ArrayList<SToken> glosstokens = new ArrayList();

    public ElanImporterProperties getProps() {
        return this.curProps;
    }

    public void setProps(ElanImporterProperties props) {
        this.curProps = props;
    }

    public Map<Long, Integer> getTime2Char() {
        return this.time2char;
    }

    public Map<Integer, Long> getChar2Time() {
        return this.char2time;
    }

    public ArrayList<SSpan> getGlossSpans() {
        return this.glosspans;
    }

    public void addToGlossTokens(SToken newToken) {
        this.glosstokens.add(newToken);
    }

    public void addToGlossSpans(SSpan newSpan) {
        this.glosspans.add(newSpan);
    }

    public ArrayList<SToken> getGlossTokens() {
        return this.glosstokens;
    }

    public TranscriptionImpl getElanModel() {
        return this.curElan;
    }

    public void setElanModel(TranscriptionImpl elanModel) {
        this.curElan = elanModel;
    }

    public SDocument getDocument() {
        return this.curSDoc;
    }

    public void setDocument(SDocument sDoc) {
        this.curSDoc = sDoc;
    }

    public STimeline getTimeline() {
        return this.curSDoc.getDocumentGraph().getTimeline();
    }

    public GlossEnricher(SDocument sDoc, TranscriptionImpl glossElanModel, List<STimelineRelation> availableTimelineRelations, int posPerToken, ElanImporterProperties props) {
        this.setDocument(sDoc);
        this.setElanModel(glossElanModel);
        this.setProps(props);
        this.createPrimaryData(this.getDocument());
        this.makeSTokensForGloss(this.getElanModel(), availableTimelineRelations, posPerToken);
        this.addAnnotations();
    }

    public SDocument getEnrichedDocument() {
        return this.curSDoc;
    }

    public void createPrimaryData(SDocument sDocument) {
        if (sDocument == null) {
            throw new PepperModuleException("Cannot create example, because the given sDocument is empty.");
        }
        if (sDocument.getDocumentGraph() == null) {
            throw new PepperModuleException("Cannot create example, because the given sDocument does not contain an SDocumentGraph.");
        }
        STextualDS sTextualDS = null;
        TierImpl primtexttier = (TierImpl)this.getElanModel().getTierWithId(this.getProps().getPrimTextTierName());
        StringBuffer primText = new StringBuffer();
        for (Object obj : primtexttier.getAnnotations()) {
            AbstractAnnotation charAnno = (AbstractAnnotation)obj;
            primText.append(charAnno.getValue());
        }
        sTextualDS = SaltFactory.createSTextualDS();
        sTextualDS.setText(primText.toString());
        this.getDocument().getDocumentGraph().addNode((Node)sTextualDS);
    }

    public void makeSTokensForGloss(TranscriptionImpl glossElan, List<STimelineRelation> availableTimelineRelations, int posPerToken) {
        int startPos = (Integer)availableTimelineRelations.get(0).getStart();
        int endPos = (Integer)availableTimelineRelations.get(posPerToken - 1).getEnd();
        int l = -1;
        String minimalTierName = null;
        for (Object tierobj : this.getElanModel().getTiers()) {
            TierImpl tier = (TierImpl)tierobj;
            if (tier.getNumberOfAnnotations() <= l) continue;
            l = tier.getNumberOfAnnotations();
            this.MINIMAL_SEGMENTATION_TIER_NAME = minimalTierName = tier.getName();
        }
        TierImpl smallestTier = (TierImpl)this.getElanModel().getTierWithId(minimalTierName);
        int amountOfTextualDSs = this.getDocument().getDocumentGraph().getTextualDSs().size();
        STextualDS primaryText = (STextualDS)this.getDocument().getDocumentGraph().getTextualDSs().get(amountOfTextualDSs - 1);
        String primtextchangeable = primaryText.getText();
        int offset = 0;
        ArrayList<Integer> startStopValues = new ArrayList<Integer>();
        for (Object annoObj : smallestTier.getAnnotations()) {
            Annotation anno = (Annotation)annoObj;
            String name = smallestTier.getName();
            String value = anno.getValue();
            long beginTime = anno.getBeginTimeBoundary();
            long endTime = anno.getEndTimeBoundary();
            int start = primtextchangeable.indexOf(value);
            if (start < 0) {
                throw new PepperModuleException("token was not found in primarytext: (" + name + ", " + value + ") (primtext:" + primtextchangeable + ")");
            }
            int stop = start + value.length();
            int corstart = offset + start;
            int corstop = offset + stop;
            if (!this.getTime2Char().containsKey(beginTime)) {
                this.getTime2Char().put(beginTime, corstart);
            }
            if (!this.getTime2Char().containsKey(endTime)) {
                this.getTime2Char().put(endTime, corstop);
            }
            if (!this.getChar2Time().containsKey(corstart)) {
                this.getChar2Time().put(corstart, beginTime);
            }
            if (!this.getChar2Time().containsKey(corstop)) {
                this.getChar2Time().put(corstop, endTime);
            }
            offset += stop;
            primtextchangeable = primtextchangeable.substring(stop);
            SToken newToken = null;
            boolean endToken = false;
            for (Tier tierabstr : this.getElanModel().getTiers()) {
                TierImpl tier = (TierImpl)tierabstr;
                Annotation curAnno = tier.getAnnotationAtTime(beginTime);
                if (!(curAnno != null & !tier.getName().equals(minimalTierName) & !this.getProps().getIgnoreTierNames().contains(tier.getName())) || curAnno.getEndTimeBoundary() != endTime) continue;
                endToken = true;
            }
            boolean startToken = false;
            for (Tier tierabstr : this.getElanModel().getTiers()) {
                TierImpl tier = (TierImpl)tierabstr;
                Annotation curAnno = tier.getAnnotationAtTime(beginTime);
                if (!(curAnno != null & !tier.getName().equals(minimalTierName) & !this.getProps().getIgnoreTierNames().contains(tier.getName())) || curAnno.getBeginTimeBoundary() != beginTime) continue;
                startToken = true;
            }
            if (endToken & !startToken) {
                startStopValues.add(corstart);
                startStopValues.add(corstop);
                newToken = this.getDocument().getDocumentGraph().createToken((SSequentialDS)primaryText, (Integer)startStopValues.get(0), (Integer)startStopValues.get(startStopValues.size() - 1));
                startStopValues.removeAll(startStopValues);
            }
            if (!endToken & startToken) {
                if (startStopValues.size() > 0) {
                    newToken = this.getDocument().getDocumentGraph().createToken((SSequentialDS)primaryText, (Integer)startStopValues.get(0), (Integer)startStopValues.get(startStopValues.size() - 1));
                }
                startStopValues.removeAll(startStopValues);
                startStopValues.add(corstart);
                startStopValues.add(corstop);
            }
            if (endToken & startToken) {
                if (startStopValues.size() > 0) {
                    newToken = this.getDocument().getDocumentGraph().createToken((SSequentialDS)primaryText, (Integer)startStopValues.get(0), (Integer)startStopValues.get(startStopValues.size() - 1));
                }
                newToken = this.getDocument().getDocumentGraph().createToken((SSequentialDS)primaryText, Integer.valueOf(corstart), Integer.valueOf(corstop));
                startStopValues.removeAll(startStopValues);
            }
            if (!endToken & !startToken) {
                startStopValues.add(corstart);
                startStopValues.add(corstop);
            }
            if (newToken == null) continue;
            this.addTokenToTimeline(newToken, startPos, endPos);
            this.addToGlossTokens(newToken);
            ++startPos;
            endPos += posPerToken;
        }
        List<String> segtiers = this.getProps().getSegmentationTierNames();
        for (String tiername : segtiers) {
            TierImpl tier = (TierImpl)glossElan.getTierWithId(tiername);
            for (Object segObj : tier.getAnnotations()) {
                Annotation anno = (Annotation)segObj;
                long beginTime = anno.getBeginTimeBoundary();
                long endTime = anno.getEndTimeBoundary();
                int beginChar = -1;
                int endChar = -1;
                SSpan newSpan = null;
                try {
                    beginChar = this.getTime2Char().get(beginTime);
                    endChar = this.getTime2Char().get(endTime);
                    DataSourceSequence sequence = null;
                    sequence = new DataSourceSequence();
                    sequence.setDataSource((SSequentialDS)primaryText);
                    sequence.setStart((Number)beginChar);
                    sequence.setEnd((Number)endChar);
                    List sNewTokens = null;
                    sNewTokens = this.getDocument().getDocumentGraph().getTokensBySequence(sequence);
                    newSpan = this.getDocument().getDocumentGraph().createSpan(sNewTokens);
                    newSpan.createAnnotation("gloss", tiername, (Object)anno.getValue());
                    this.addToGlossSpans(newSpan);
                }
                catch (Exception e) {
                    throw new PepperModuleException("something wrong at " + beginTime + " up to " + endTime);
                }
            }
        }
    }

    private void addTokenToTimeline(SToken newToken, int startPos, int endPos) {
        STimelineRelation sTimeRel = SaltFactory.createSTimelineRelation();
        sTimeRel.setTarget((Node)this.getTimeline());
        sTimeRel.setSource((Node)newToken);
        sTimeRel.setStart((Number)startPos);
        sTimeRel.setEnd((Number)endPos);
        this.getDocument().getDocumentGraph().addRelation((Relation)sTimeRel);
    }

    public void addAnnotations() {
        int amountOfTextualDSs = this.getDocument().getDocumentGraph().getTextualDSs().size();
        STextualDS sTextualDS = (STextualDS)this.getDocument().getDocumentGraph().getTextualDSs().get(amountOfTextualDSs - 1);
        for (Object obj : this.getElanModel().getTiers()) {
            TierImpl tier = (TierImpl)obj;
            if (!(!this.getProps().getSegmentationTierNames().contains(tier.getName()) & !this.getProps().getIgnoreTierNames().contains(tier.getName()))) continue;
            int lastSpanIndex = 0;
            for (Object annoObj : tier.getAnnotations()) {
                Annotation anno = (Annotation)annoObj;
                String value = anno.getValue().trim();
                long beginTime = anno.getBeginTimeBoundary();
                long endTime = anno.getEndTimeBoundary();
                int beginChar = 0;
                int endChar = 0;
                try {
                    beginChar = this.getTime2Char().get(beginTime);
                    endChar = this.getTime2Char().get(endTime);
                }
                catch (Exception ex) {
                    throw new PepperModuleException("something wrong at " + beginTime + " up to " + endTime);
                }
                if (value.isEmpty()) continue;
                DataSourceSequence sequence = new DataSourceSequence();
                sequence.setDataSource((SSequentialDS)sTextualDS);
                sequence.setStart((Number)beginChar);
                sequence.setEnd((Number)endChar);
                SSpan sSpan = null;
                ArrayList<SSpan> sSpansInSDoc = this.getGlossSpans();
                for (int i = lastSpanIndex; i < sSpansInSDoc.size(); ++i) {
                    SSpan sp = sSpansInSDoc.get(i);
                    List sequences = this.getDocument().getDocumentGraph().getOverlappedDataSourceSequence((SNode)sp, new SALT_TYPE[]{SALT_TYPE.STEXT_OVERLAPPING_RELATION});
                    String checkPrimAnno = sTextualDS.getText().substring(beginChar, endChar).trim();
                    String checkPrimSeq = sTextualDS.getText().substring((Integer)((DataSourceSequence)sequences.get(0)).getStart(), (Integer)((DataSourceSequence)sequences.get(0)).getEnd()).trim();
                    int startSeq = (Integer)((DataSourceSequence)sequences.get(0)).getStart();
                    int endSeq = (Integer)((DataSourceSequence)sequences.get(0)).getEnd();
                    if (!checkPrimAnno.equals(checkPrimSeq) || !(startSeq == beginChar & endSeq == endChar)) continue;
                    sSpan = sp;
                    lastSpanIndex = i;
                    break;
                }
                if (sSpan != null) {
                    sSpan.createAnnotation("gloss", tier.getName(), (Object)value);
                }
                if (sSpan != null) continue;
                ArrayList<SToken> sNewTokens = this.getGlossTokens();
                ArrayList<SToken> sNewTokensEList = new ArrayList<SToken>();
                sNewTokensEList.addAll(sNewTokens);
                if (sNewTokens.size() <= 0) continue;
                int firstTokenStart = (Integer)((DataSourceSequence)this.getDocument().getDocumentGraph().getOverlappedDataSourceSequence((SNode)sNewTokens.get(0), new SALT_TYPE[]{SALT_TYPE.STEXT_OVERLAPPING_RELATION}).get(0)).getStart();
                int lastTokenEnd = (Integer)((DataSourceSequence)this.getDocument().getDocumentGraph().getOverlappedDataSourceSequence((SNode)sNewTokens.get(sNewTokens.size() - 1), new SALT_TYPE[]{SALT_TYPE.STEXT_OVERLAPPING_RELATION}).get(0)).getEnd();
                if (firstTokenStart != beginChar || lastTokenEnd != endChar) continue;
                SSpan newSpan = this.getDocument().getDocumentGraph().createSpan(sNewTokensEList);
                newSpan.createAnnotation("gloss", tier.getName(), (Object)value);
            }
        }
    }
}

