/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.elanModules;

import java.util.ArrayList;
import java.util.List;
import org.corpus_tools.pepper.modules.PepperModuleProperties;
import org.corpus_tools.pepper.modules.PepperModuleProperty;

public class ElanImporterProperties
extends PepperModuleProperties {
    public static final String PROP_PRIMARY_TEXT_TIER_NAME = "primTextTierName";
    public static final String PROP_SEGMENTATION_TIERNAMES = "segTierNames";
    public static final String PROP_IGNORE_TIERNAMES = "ignoreTierNames";
    public static final String PROP_LINKED_FOLDER = "linkedFolder";
    public static final String PROP_ANNO_NAMESPACE = "annotationNamespace";
    public static final String PROP_METADATA_FOLDER = "metadataFolder";

    public ElanImporterProperties() {
        this.addProperty(new PepperModuleProperty(PROP_PRIMARY_TEXT_TIER_NAME, String.class, "Name of the tier containing the primary text.", false));
        this.addProperty(new PepperModuleProperty(PROP_SEGMENTATION_TIERNAMES, String.class, "Names of the tiers that will be used as segmentation layers.", false));
        this.addProperty(new PepperModuleProperty(PROP_IGNORE_TIERNAMES, String.class, "Names of the tiers that will be ignored.", false));
        this.addProperty(new PepperModuleProperty(PROP_LINKED_FOLDER, String.class, "Location of the linked files.", false));
        this.addProperty(new PepperModuleProperty(PROP_ANNO_NAMESPACE, String.class, "Determines the namespace used for annotation names.", null, false));
        this.addProperty(new PepperModuleProperty(PROP_METADATA_FOLDER, String.class, "Path of the metadata folder.", (Object)"./meta", false));
    }

    public String getPrimTextTierName() {
        return (String)this.getProperty(PROP_PRIMARY_TEXT_TIER_NAME).getValue();
    }

    public List<String> getSegmentationTierNames() {
        String[] rawNamesArr;
        ArrayList<String> retVal = new ArrayList<String>();
        String rawNames = (String)this.getProperty(PROP_SEGMENTATION_TIERNAMES).getValue();
        if (rawNames != null && (rawNamesArr = rawNames.split(",")) != null) {
            for (String rawName : rawNamesArr) {
                retVal.add(rawName.trim());
            }
        }
        return retVal;
    }

    public List<String> getIgnoreTierNames() {
        String[] rawNamesArr;
        ArrayList<String> retVal = new ArrayList<String>();
        String rawNames = (String)this.getProperty(PROP_IGNORE_TIERNAMES).getValue();
        if (rawNames != null && (rawNamesArr = rawNames.split(",")) != null) {
            for (String rawName : rawNamesArr) {
                retVal.add(rawName.trim());
            }
        }
        return retVal;
    }

    public String getLinkedFolder() {
        return (String)this.getProperty(PROP_LINKED_FOLDER).getValue();
    }

    public String getAnnotationNamespace() {
        return (String)this.getProperty(PROP_ANNO_NAMESPACE).getValue();
    }

    public String getMetadataFolderPath() {
        return this.getProperty(PROP_METADATA_FOLDER).getValue().toString();
    }
}

