/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.elanModules;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.impl.PepperMapperImpl;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.peppermodules.elanModules.AddLinkedElan;
import org.corpus_tools.peppermodules.elanModules.ElanImporterProperties;
import org.corpus_tools.peppermodules.elanModules.GlossEnricher;
import org.corpus_tools.salt.SALT_TYPE;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SSequentialDS;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.SSpanningRelation;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.STimelineRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;
import org.corpus_tools.salt.util.DataSourceSequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Elan2SaltMapper
extends PepperMapperImpl
implements PepperMapper {
    private static final Logger logger = LoggerFactory.getLogger(Elan2SaltMapper.class);
    private String annoNS = null;
    private String mdDir = null;
    protected Map<Long, Integer> time2char = new HashMap<Long, Integer>();
    protected Map<Integer, Long> char2time = new HashMap<Integer, Long>();
    protected String MINIMAL_SEGMENTATION_TIER_NAME = null;
    protected TranscriptionImpl elan = null;

    public ElanImporterProperties getProps() {
        return (ElanImporterProperties)this.getProperties();
    }

    public Map<Long, Integer> getTime2Char() {
        return this.time2char;
    }

    public Map<Integer, Long> getChar2Time() {
        return this.char2time;
    }

    public void setElanModel(String fullFilename) {
        this.elan = new TranscriptionImpl(fullFilename);
    }

    public TranscriptionImpl getElanModel() {
        return this.elan;
    }

    public String getMINIMAL_SEGMENTATION_TIER_NAME() {
        return this.MINIMAL_SEGMENTATION_TIER_NAME;
    }

    public void setMINIMAL_SEGMENTATION_TIER_NAME(String mINIMAL_SEGMENTATION_TIER_NAME) {
        this.MINIMAL_SEGMENTATION_TIER_NAME = mINIMAL_SEGMENTATION_TIER_NAME;
    }

    public void setDocumentMetaAnnotation(String key, String value) {
        this.getDocument().createMetaAnnotation(null, key, (Object)value);
    }

    public DOCUMENT_STATUS mapSDocument() {
        this.annoNS = this.getProps().getAnnotationNamespace();
        this.mdDir = this.getProps().getMetadataFolderPath();
        this.setElanModel(this.getResourceURI().toFileString());
        if (this.getDocument().getDocumentGraph() == null) {
            this.getDocument().setDocumentGraph(SaltFactory.createSDocumentGraph());
        }
        this.createPrimaryData(this.getDocument());
        this.traverseElanDocument(this.getDocument());
        return DOCUMENT_STATUS.COMPLETED;
    }

    public void createPrimaryData(SDocument sDocument) {
        if (sDocument == null) {
            throw new PepperModuleException((PepperMapper)this, "Cannot create example, because the given sDocument is empty.");
        }
        if (sDocument.getDocumentGraph() == null) {
            throw new PepperModuleException((PepperMapper)this, "Cannot create example, because the given sDocument does not contain an SDocumentGraph.");
        }
        STextualDS sTextualDS = null;
        TierImpl primtexttier = (TierImpl)this.getElanModel().getTierWithId(this.getProps().getPrimTextTierName());
        StringBuffer primText = new StringBuffer();
        if (primtexttier == null) {
            throw new PepperModuleException((PepperMapper)this, "Cannot import data, no primary text tier was found. Please use customization property 'primTextTierName'. ");
        }
        for (Object obj : primtexttier.getAnnotations()) {
            AbstractAnnotation charAnno = (AbstractAnnotation)obj;
            primText.append(charAnno.getValue());
        }
        sTextualDS = SaltFactory.createSTextualDS();
        sTextualDS.setText(primText.toString());
        this.getDocument().getDocumentGraph().addNode((Node)sTextualDS);
    }

    public void traverseElanDocument(SDocument sDocument) {
        this.createSegmentationForMainTiers();
        this.addAnnotations();
        try {
            this.addMetaAnnotations();
        }
        catch (IOException e) {
            logger.error("An error occured reading the metadata. No metadata will be available.");
        }
        try {
            String filename = this.getResourceURI().toFileString().substring(this.getResourceURI().toFileString().lastIndexOf("/"));
            this.addLinkedElan(this.getProps().getLinkedFolder() + filename);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addLinkedElan(String pathToFile) throws IOException {
        List stokens;
        TranscriptionImpl glosspart;
        TranscriptionImpl gloss = new TranscriptionImpl(pathToFile);
        for (String glossid : AddLinkedElan.getGlossIDs(this.getElanModel())) {
            glosspart = AddLinkedElan.getEafPartForGlossID(gloss, glossid);
            stokens = (List)AddLinkedElan.getSTokensForGloss(this.getDocument(), glossid);
            int numberOfMainTokens = stokens.size();
            int numberOfGlossTokens = AddLinkedElan.calcTokensNeeded(AddLinkedElan.getEafPartForGlossID(glosspart, glossid), this.getProps());
            if (numberOfGlossTokens <= numberOfMainTokens) continue;
            STextualDS curSTextualDS = (STextualDS)this.getDocument().getDocumentGraph().getTextualDSs().get(0);
            int insertPos = AddLinkedElan.getStopFromSToken((SToken)stokens.get(stokens.size() - 1));
            ArrayList<String> placeholders = new ArrayList<String>();
            for (int i = 0; i < numberOfGlossTokens - numberOfMainTokens; ++i) {
                placeholders.add("placeholder");
            }
            List placeholderTokens = this.getDocument().getDocumentGraph().insertTokensAt(curSTextualDS, Integer.valueOf(insertPos), placeholders, Boolean.valueOf(true));
            Collection<SSpan> spans = AddLinkedElan.getSpansContaintingToken((SToken)stokens.get(stokens.size() - 1));
            for (SSpan span : spans) {
                this.addSTokensToSpan(placeholderTokens, span);
            }
        }
        this.getDocument().getDocumentGraph().sortTokenByText();
        this.getDocument().getDocumentGraph().createTimeline();
        for (String glossid : AddLinkedElan.getGlossIDs(this.getElanModel())) {
            glosspart = AddLinkedElan.getEafPartForGlossID(gloss, glossid);
            stokens = (List)AddLinkedElan.getSTokensForGloss(this.getDocument(), glossid);
            ArrayList<STimelineRelation> timelineRelationsForGloss = new ArrayList<STimelineRelation>();
            for (STimelineRelation curTimelineRelation : this.getDocument().getDocumentGraph().getTimelineRelations()) {
                SToken curToken = (SToken)curTimelineRelation.getSource();
                if (!stokens.contains(curToken)) continue;
                timelineRelationsForGloss.add(curTimelineRelation);
            }
            int numberOfMainTokens = stokens.size();
            int numberOfGlossTokens = AddLinkedElan.calcTokensNeeded(AddLinkedElan.getEafPartForGlossID(glosspart, glossid), this.getProps());
            int posPerToken = (int)Math.floor((float)numberOfMainTokens / (float)numberOfGlossTokens);
            GlossEnricher ge = new GlossEnricher(this.getDocument(), glosspart, timelineRelationsForGloss, posPerToken, this.getProps());
            this.setDocument(ge.getEnrichedDocument());
        }
    }

    private void addSTokensToSpan(List<SToken> placeholderTokens, SSpan span) {
        SSpanningRelation spanRel = null;
        for (SToken sToken : placeholderTokens) {
            spanRel = SaltFactory.createSSpanningRelation();
            spanRel.setTarget((Node)sToken);
            spanRel.setSource((Node)span);
            span.getGraph().addRelation((Relation)spanRel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMetaAnnotations() throws IOException {
        String path = this.getResourceURI().toFileString();
        String[] segments = path.split(File.separator);
        if (segments.length > 2) {
            String target = segments[segments.length - 2];
            path = path.replace(target, this.mdDir);
        }
        if (segments.length > 1) {
            String fname = segments[segments.length - 1];
            path = path.replace(fname, fname.split("_")[0]);
        }
        path = path + ".txt";
        File metaFile = new File(path = path.replaceAll(".eaf", ""));
        if (!metaFile.exists()) {
            logger.warn("Cannot read meta data file '" + metaFile.getAbsolutePath() + "'.");
        } else {
            try (BufferedReader br = new BufferedReader(new FileReader(path));){
                String line;
                while ((line = br.readLine()) != null) {
                    String val;
                    String attr;
                    block10: {
                        attr = line.split("=")[0];
                        val = "NA";
                        try {
                            val = line.split("=")[1];
                            if (!val.equals("null")) break block10;
                            val = "NA";
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            continue;
                        }
                    }
                    this.getDocument().createMetaAnnotation(null, attr, (Object)val);
                }
            }
        }
    }

    public void addAnnotations() {
        int amountOfTextualDSs = this.getDocument().getDocumentGraph().getTextualDSs().size();
        STextualDS sTextualDS = (STextualDS)this.getDocument().getDocumentGraph().getTextualDSs().get(amountOfTextualDSs - 1);
        for (Object obj : this.getElanModel().getTiers()) {
            TierImpl tier = (TierImpl)obj;
            if (!(!this.getProps().getSegmentationTierNames().contains(tier.getName()) & !this.getProps().getIgnoreTierNames().contains(tier.getName()))) continue;
            int lastSpanIndex = 0;
            for (Object annoObj : tier.getAnnotations()) {
                List sNewTokens;
                Annotation anno = (Annotation)annoObj;
                String value = anno.getValue().trim();
                long beginTime = anno.getBeginTimeBoundary();
                long endTime = anno.getEndTimeBoundary();
                int beginChar = 0;
                int endChar = 0;
                try {
                    beginChar = this.getTime2Char().get(beginTime);
                    endChar = this.getTime2Char().get(endTime);
                }
                catch (Exception ex) {
                    throw new PepperModuleException((PepperMapper)this, "something wrong at " + beginTime + " up to " + endTime + "in file " + this.getElanModel().getFullPath());
                }
                if (value.isEmpty()) continue;
                DataSourceSequence sequence = new DataSourceSequence();
                sequence.setDataSource((SSequentialDS)sTextualDS);
                sequence.setStart((Number)beginChar);
                sequence.setEnd((Number)endChar);
                SSpan sSpan = null;
                List sSpansInSDoc = this.getDocument().getDocumentGraph().getSpans();
                for (int i = lastSpanIndex; i < sSpansInSDoc.size(); ++i) {
                    int endSeq;
                    SSpan sp = (SSpan)sSpansInSDoc.get(i);
                    List sequences = this.getDocument().getDocumentGraph().getOverlappedDataSourceSequence((SNode)sp, new SALT_TYPE[]{SALT_TYPE.STEXT_OVERLAPPING_RELATION});
                    int startSeq = (Integer)((DataSourceSequence)sequences.get(0)).getStart();
                    if (!(startSeq == beginChar & (endSeq = ((Integer)((DataSourceSequence)sequences.get(0)).getEnd()).intValue()) == endChar)) continue;
                    sSpan = sp;
                    lastSpanIndex = i;
                    break;
                }
                if (sSpan != null) {
                    sSpan.createAnnotation(this.annoNS, tier.getName(), (Object)value);
                }
                if (sSpan != null || (sNewTokens = this.getDocument().getDocumentGraph().getTokensBySequence(sequence)) == null || sNewTokens.size() <= 0) continue;
                SSpan newSpan = this.getDocument().getDocumentGraph().createSpan(sNewTokens);
                newSpan.createAnnotation(this.annoNS, tier.getName(), (Object)value);
            }
        }
    }

    public void createSegmentationForMainTiers() {
        int l = -1;
        String minimalTierName = null;
        for (Object tierobj : this.getElanModel().getTiers()) {
            TierImpl tier = (TierImpl)tierobj;
            if (tier.getNumberOfAnnotations() <= l) continue;
            l = tier.getNumberOfAnnotations();
            this.MINIMAL_SEGMENTATION_TIER_NAME = minimalTierName = tier.getName();
        }
        TierImpl smallestTier = (TierImpl)this.getElanModel().getTierWithId(minimalTierName);
        int amountOfTextualDSs = this.getDocument().getDocumentGraph().getTextualDSs().size();
        STextualDS primaryText = (STextualDS)this.getDocument().getDocumentGraph().getTextualDSs().get(amountOfTextualDSs - 1);
        String primtextchangeable = primaryText.getText();
        int offset = 0;
        ArrayList<Integer> startStopValues = new ArrayList<Integer>();
        for (Object annoObj : smallestTier.getAnnotations()) {
            Annotation anno = (Annotation)annoObj;
            String name = smallestTier.getName();
            String value = anno.getValue();
            long beginTime = anno.getBeginTimeBoundary();
            long endTime = anno.getEndTimeBoundary();
            int start = primtextchangeable.indexOf(value);
            if (start < 0) {
                throw new PepperModuleException((PepperMapper)this, "token was not found in primarytext: (" + name + ", " + value + ") (primtext:" + primtextchangeable + ")");
            }
            int stop = start + value.length();
            int corstart = offset + start;
            int corstop = offset + stop;
            if (!this.getTime2Char().containsKey(beginTime)) {
                this.getTime2Char().put(beginTime, corstart);
            }
            if (!this.getTime2Char().containsKey(endTime)) {
                this.getTime2Char().put(endTime, corstop);
            }
            if (!this.getChar2Time().containsKey(corstart)) {
                this.getChar2Time().put(corstart, beginTime);
            }
            if (!this.getChar2Time().containsKey(corstop)) {
                this.getChar2Time().put(corstop, endTime);
            }
            offset += stop;
            primtextchangeable = primtextchangeable.substring(stop);
            boolean endToken = false;
            for (Tier tierabstr : this.getElanModel().getTiers()) {
                TierImpl tier = (TierImpl)tierabstr;
                Annotation curAnno = tier.getAnnotationAtTime(beginTime);
                if (!(curAnno != null & !tier.getName().equals(minimalTierName) & !this.getProps().getIgnoreTierNames().contains(tier.getName())) || curAnno.getEndTimeBoundary() != endTime) continue;
                endToken = true;
            }
            boolean startToken = false;
            for (Tier tierabstr : this.getElanModel().getTiers()) {
                TierImpl tier = (TierImpl)tierabstr;
                Annotation curAnno = tier.getAnnotationAtTime(beginTime);
                if (!(curAnno != null & !tier.getName().equals(minimalTierName) & !this.getProps().getIgnoreTierNames().contains(tier.getName())) || curAnno.getBeginTimeBoundary() != beginTime) continue;
                startToken = true;
            }
            if (endToken & !startToken) {
                startStopValues.add(corstart);
                startStopValues.add(corstop);
                this.getDocument().getDocumentGraph().createToken((SSequentialDS)primaryText, (Integer)startStopValues.get(0), (Integer)startStopValues.get(startStopValues.size() - 1));
                startStopValues.removeAll(startStopValues);
            }
            if (!endToken & startToken) {
                if (startStopValues.size() > 0) {
                    this.getDocument().getDocumentGraph().createToken((SSequentialDS)primaryText, (Integer)startStopValues.get(0), (Integer)startStopValues.get(startStopValues.size() - 1));
                }
                startStopValues.removeAll(startStopValues);
                startStopValues.add(corstart);
                startStopValues.add(corstop);
            }
            if (endToken & startToken) {
                if (startStopValues.size() > 0) {
                    this.getDocument().getDocumentGraph().createToken((SSequentialDS)primaryText, (Integer)startStopValues.get(0), (Integer)startStopValues.get(startStopValues.size() - 1));
                }
                this.getDocument().getDocumentGraph().createToken((SSequentialDS)primaryText, Integer.valueOf(corstart), Integer.valueOf(corstop));
                startStopValues.removeAll(startStopValues);
            }
            if (!(!endToken & !startToken)) continue;
            startStopValues.add(corstart);
            startStopValues.add(corstop);
        }
        List<String> segtiers = this.getProps().getSegmentationTierNames();
        for (String tiername : segtiers) {
            TierImpl tier = (TierImpl)this.getElanModel().getTierWithId(tiername);
            for (Object segObj : tier.getAnnotations()) {
                Annotation anno = (Annotation)segObj;
                long beginTime = anno.getBeginTimeBoundary();
                long endTime = anno.getEndTimeBoundary();
                int beginChar = -1;
                int endChar = -1;
                SSpan newSpan = null;
                try {
                    beginChar = this.getTime2Char().get(beginTime);
                    endChar = this.getTime2Char().get(endTime);
                    DataSourceSequence sequence = null;
                    sequence = new DataSourceSequence();
                    sequence.setDataSource((SSequentialDS)primaryText);
                    sequence.setStart((Number)beginChar);
                    sequence.setEnd((Number)endChar);
                    List sNewTokens = null;
                    sNewTokens = this.getDocument().getDocumentGraph().getTokensBySequence(sequence);
                    newSpan = this.getDocument().getDocumentGraph().createSpan(sNewTokens);
                    newSpan.createAnnotation(this.annoNS, tiername, (Object)anno.getValue());
                }
                catch (Exception e) {
                    throw new PepperModuleException((PepperMapper)this, "something wrong at " + beginTime + " up to " + endTime + "in file " + this.getElanModel().getFullPath());
                }
            }
        }
    }
}

