/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.elanModules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import org.corpus_tools.peppermodules.elanModules.ElanImporterProperties;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.SSpanningRelation;
import org.corpus_tools.salt.common.STextualRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.SAnnotation;

public class AddLinkedElan {
    public static ArrayList<String> getGlossIDs(TranscriptionImpl main) {
        ArrayList<String> out = new ArrayList<String>();
        TierImpl glosstier = (TierImpl)main.getTierWithId("Glosse");
        for (Object annoObj : glosstier.getAnnotations()) {
            Annotation anno = (Annotation)annoObj;
            out.add(anno.getValue());
        }
        return out;
    }

    public static TranscriptionImpl getEafPartForGlossID(TranscriptionImpl gloss, String glossid) {
        long start = -1L;
        long stop = -1L;
        TranscriptionImpl out = null;
        TierImpl glossidtier = (TierImpl)gloss.getTierWithId("Glosse");
        for (Object annoObj : glossidtier.getAnnotations()) {
            Annotation anno = (Annotation)annoObj;
            if (!glossid.equals(anno.getValue())) continue;
            start = anno.getBeginTimeBoundary();
            stop = anno.getEndTimeBoundary();
            out = AddLinkedElan.getEafBetween(gloss, start, stop);
            break;
        }
        return out;
    }

    public static TranscriptionImpl getEafBetween(TranscriptionImpl in, long beginTime, long endTime) {
        TranscriptionImpl out = new TranscriptionImpl();
        for (Object tierobj : in.getTiers()) {
            TierImpl tier = (TierImpl)tierobj;
            TierImpl newTier = new TierImpl(tier.getName(), null, (Transcription)out, new LinguisticType("main-tier"));
            for (Object annoobj : tier.getAnnotations()) {
                Annotation anno = (Annotation)annoobj;
                if (anno.getBeginTimeBoundary() < beginTime || anno.getEndTimeBoundary() > endTime) continue;
                newTier.addAnnotation(anno);
            }
            out.addTier((Tier)newTier);
        }
        return out;
    }

    public static Collection<SToken> getSTokensForGloss(SDocument sDocument, String glossid) {
        List<SToken> out = null;
        block0: for (SSpan span : sDocument.getDocumentGraph().getSpans()) {
            for (SAnnotation sAnno : span.getAnnotations()) {
                String annoValue;
                if (!sAnno.getName().equals("Glosse") || !(annoValue = sAnno.getValue().toString()).equals(glossid)) continue;
                out = AddLinkedElan.getSTokensFromSSpan(span);
                continue block0;
            }
        }
        return out;
    }

    public static int calcTokensNeeded(TranscriptionImpl glosspart, ElanImporterProperties props) {
        int count = 0;
        for (Object tierobj : glosspart.getTiers()) {
            int annoCount;
            TierImpl tier = (TierImpl)tierobj;
            if (props.getIgnoreTierNames().contains(tier.getName()) || (annoCount = tier.getAnnotations().size()) <= count) continue;
            count = annoCount;
        }
        return count;
    }

    private static STextualRelation getTextualRelationFromSToken(SToken stok) {
        STextualRelation out = null;
        for (STextualRelation stextrel : stok.getGraph().getTextualRelations()) {
            if (!((SToken)stextrel.getSource()).equals(stok)) continue;
            out = stextrel;
            break;
        }
        return out;
    }

    public static int getStopFromSToken(SToken sToken) {
        int out = -1;
        for (STextualRelation stextrel : sToken.getGraph().getTextualRelations()) {
            if (!((SToken)stextrel.getSource()).equals(sToken)) continue;
            out = (Integer)stextrel.getEnd();
            break;
        }
        return out;
    }

    public static int getStartFromSToken(SToken sToken) {
        int out = -1;
        for (STextualRelation stextrel : sToken.getGraph().getTextualRelations()) {
            if (!((SToken)stextrel.getSource()).equals(sToken)) continue;
            out = (Integer)stextrel.getStart();
            break;
        }
        return out;
    }

    public static ArrayList<SToken> getGlossTokens(SDocument sDocument, SToken sToken, int tokensNeeded) {
        ArrayList<SToken> out = new ArrayList<SToken>();
        int start = AddLinkedElan.getStartFromSToken(sToken);
        int stop = start + tokensNeeded;
        for (STextualRelation sTextRel : sDocument.getDocumentGraph().getTextualRelations()) {
            if ((Integer)sTextRel.getStart() < start || (Integer)sTextRel.getEnd() > stop) continue;
            out.add((SToken)sTextRel.getSource());
        }
        return out;
    }

    public static List<SToken> getSTokensFromSSpan(SSpan span) {
        SDocumentGraph docGraph = span.getGraph();
        List spanningRelations = docGraph.getSpanningRelations();
        ArrayList<SToken> spanTokens = new ArrayList<SToken>();
        for (SSpanningRelation spanningRel : spanningRelations) {
            if (spanningRel.getSource() != span) continue;
            SToken token = (SToken)spanningRel.getTarget();
            spanTokens.add(token);
        }
        return spanTokens;
    }

    public static int getEndFromSSpan(SSpan span, SDocumentGraph docGraph) {
        List spanningRelations = docGraph.getSpanningRelations();
        int out = -1;
        for (SSpanningRelation spanningRel : spanningRelations) {
            SToken token;
            int newStop;
            if (spanningRel.getSource() != span || (newStop = AddLinkedElan.getStopFromSToken(token = (SToken)spanningRel.getTarget())) <= out) continue;
            out = newStop;
        }
        return out;
    }

    public static int getStartFromSSpan(SSpan span, SDocumentGraph docGraph) {
        List spanningRelations = docGraph.getSpanningRelations();
        int out = 999999999;
        for (SSpanningRelation spanningRel : spanningRelations) {
            SToken token;
            int newStart;
            if (spanningRel.getSource() != span || (newStart = AddLinkedElan.getStartFromSToken(token = (SToken)spanningRel.getTarget())) >= out) continue;
            out = newStart;
        }
        return out;
    }

    public static Collection<SSpan> getSpansContaintingToken(SToken sToken) {
        ArrayList<SSpan> out = new ArrayList<SSpan>();
        SDocumentGraph curSDocGraph = sToken.getGraph();
        List spans = curSDocGraph.getSpans();
        for (SSpan span : spans) {
            List spanningRelations = curSDocGraph.getSpanningRelations();
            ArrayList<SToken> spanTokens = new ArrayList<SToken>();
            for (SSpanningRelation spanningRel : spanningRelations) {
                if (spanningRel.getSource() != span) continue;
                SToken token = (SToken)spanningRel.getTarget();
                spanTokens.add(token);
            }
            if (!spanTokens.contains(sToken)) continue;
            out.add(span);
        }
        return out;
    }
}

