/*
 * Decompiled with CFR 0.152.
 */
package edu.eurac.commul.pepperModules.mmax2;

import edu.eurac.commul.annotations.mmax2.mmax2wrapper.MMAX2WrapperException;
import edu.eurac.commul.annotations.mmax2.mmax2wrapper.MarkableFactory;
import edu.eurac.commul.annotations.mmax2.mmax2wrapper.SchemeFactory;
import edu.eurac.commul.pepperModules.mmax2.exceptions.SaltExtendedMMAX2WrapperException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import org.xml.sax.SAXException;

public class SaltExtendedMarkableFactory
extends MarkableFactory {
    public SaltExtendedMarkableFactory(SchemeFactory.Scheme scheme) {
        super(scheme);
    }

    public SaltExtendedMarkableFactory(SchemeFactory.Scheme scheme, DocumentBuilder documentBuilder) {
        super(scheme, documentBuilder);
    }

    ArrayList<SaltExtendedMarkable> getSaltExtendedMarkables(String documentId) throws MMAX2WrapperException, SAXException, IOException {
        ArrayList<SaltExtendedMarkable> results = new ArrayList<SaltExtendedMarkable>();
        for (MarkableFactory.Markable markable : super.getMarkables(documentId)) {
            results.add(new SaltExtendedMarkable(this, markable.getId(), markable.getSpan(), markable.getAttributes()));
        }
        return results;
    }

    ArrayList<SaltExtendedMarkable> getSaltExtendedMarkables(String documentId, Hashtable<String, Hashtable<String, String>> saltInfos) throws SAXException, IOException, MMAX2WrapperException {
        ArrayList<SaltExtendedMarkable> results = new ArrayList<SaltExtendedMarkable>();
        for (MarkableFactory.Markable markable : super.getMarkables(documentId)) {
            if (saltInfos.containsKey(markable.getId())) {
                Hashtable<String, String> saltInfoMarkable = saltInfos.get(markable.getId());
                if (!saltInfoMarkable.get("salt_type").equals("SContainer")) {
                    results.add(this.newMarkable(markable.getId(), markable.getSpan(), markable.getAttributes(), saltInfoMarkable.get("salt_type"), saltInfoMarkable.get("salt_name"), saltInfoMarkable.get("salt_id")));
                } else {
                    results.add(new SaltExtendedMarkableContainer(this, markable.getId(), markable.getSpan(), markable.getAttributes(), saltInfoMarkable.get("salt_type"), saltInfoMarkable.get("salt_name"), saltInfoMarkable.get("salt_id"), saltInfoMarkable.get("contained_id"), saltInfoMarkable.get("contained_scheme")));
                }
                saltInfos.remove(markable.getId());
                continue;
            }
            throw new SaltExtendedMMAX2WrapperException("Data corruption: SaltExtendedMarkable " + markable + " has no related Salt Informations");
        }
        return results;
    }

    public SaltExtendedMarkable newMarkable(String id, String span, ArrayList<SchemeFactory.MarkableAttributeFactory.MarkableAttribute> attributes, String sType, String sName, String sId) {
        return new SaltExtendedMarkable(this, id, span, attributes, sType, sName, sId);
    }

    public SaltExtendedMarkableContainer newMarkableContainer(String id, String span, ArrayList<SchemeFactory.MarkableAttributeFactory.MarkableAttribute> attributes, String sType, String sName, String sId, String containedId, String containedSchemeName) {
        return new SaltExtendedMarkableContainer(this, id, span, attributes, sType, sName, sId, containedId, containedSchemeName);
    }

    public class SaltExtendedMarkableContainer
    extends SaltExtendedMarkable {
        private String containedId;
        private String containedSchemeName;

        protected SaltExtendedMarkableContainer(SaltExtendedMarkableFactory factory, String id, String span, ArrayList<SchemeFactory.MarkableAttributeFactory.MarkableAttribute> attributes, String sType, String sName, String sId, String containedId, String containedSchemeName) {
            super(factory, id, span, attributes, sType, sName, sId);
            this.containedId = containedId;
            this.containedSchemeName = containedSchemeName;
        }

        public String getContainedId() {
            return this.containedId;
        }

        public String getContainedSchemeName() {
            return this.containedSchemeName;
        }
    }

    public class SaltExtendedMarkable
    extends MarkableFactory.Markable {
        private boolean hasSaltInformation;
        private String sId;
        private String sType;
        private String sName;

        protected SaltExtendedMarkable(SaltExtendedMarkableFactory factory, String id, String span, ArrayList<SchemeFactory.MarkableAttributeFactory.MarkableAttribute> attributes) {
            super((MarkableFactory)SaltExtendedMarkableFactory.this, (MarkableFactory)factory, id, span, attributes);
            this.hasSaltInformation = false;
            this.sId = "";
            this.sType = "";
            this.sName = "";
        }

        protected SaltExtendedMarkable(SaltExtendedMarkableFactory factory, String id, String span, ArrayList<SchemeFactory.MarkableAttributeFactory.MarkableAttribute> attributes, String sType, String sName, String sId) {
            super((MarkableFactory)SaltExtendedMarkableFactory.this, (MarkableFactory)factory, id, span, attributes);
            this.hasSaltInformation = true;
            this.sType = sType;
            this.sName = sName;
            this.sId = sId;
        }

        public String getSName() {
            return this.sName;
        }

        public String getSType() {
            return this.sType;
        }

        public String getSId() {
            return this.sId;
        }

        public boolean hasSaltInformation() {
            return this.hasSaltInformation;
        }
    }
}

