/*
 * Decompiled with CFR 0.152.
 */
package edu.eurac.commul.pepperModules.mmax2;

import edu.eurac.commul.annotations.mmax2.mmax2wrapper.CorpusFactory;
import edu.eurac.commul.annotations.mmax2.mmax2wrapper.DocumentFactory;
import edu.eurac.commul.annotations.mmax2.mmax2wrapper.FileGenerator;
import edu.eurac.commul.annotations.mmax2.mmax2wrapper.MMAX2WrapperException;
import edu.eurac.commul.pepperModules.mmax2.SaltExtendedCorpusFactory;
import edu.eurac.commul.pepperModules.mmax2.SaltExtendedDocumentFactory;
import edu.eurac.commul.pepperModules.mmax2.SaltExtendedMarkableFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;

public class SaltExtendedFileGenerator
extends FileGenerator {
    private static final String MMAX2_SALT_INFO_GENERIC = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<saltInfos>\n\t@salt_infos@\n</saltInfos>";
    private static final String MMAX2_SALT_INFO_ENTRY_GENERIC = "\t<saltInfo id=\"@markable_id@\" salt_id=\"@salt_id@\" salt_type=\"@salt_type@\" salt_name=\"@salt_name@\" @additional@/>";
    private static final String[] prohibed_arguments = new String[]{"markable_id", "salt_layer", "salt_type", "salt_name", "salt_infos"};
    private static final String prohibed_regexp = Pattern.quote("@") + "(" + StringUtils.join((Object[])prohibed_arguments, (String)"|") + ")" + Pattern.quote("@");

    public static void createCorpus(SaltExtendedCorpusFactory.SaltExtendedCorpus corpus) throws IOException, ParserConfigurationException, MMAX2WrapperException {
        FileGenerator.outputCorpus((CorpusFactory.Corpus)corpus);
        File saltInfosDirectory = new File(corpus.getCorpusPath() + File.separator + corpus.getSaltInfoPath());
        if (!saltInfosDirectory.mkdirs()) {
            throw new PepperModuleException("create folder for SaltInfo '" + saltInfosDirectory.getAbsolutePath() + "'");
        }
        for (SaltExtendedDocumentFactory.SaltExtendedDocument document : corpus.getSaltExtendedDocuments()) {
            SaltExtendedFileGenerator.createSaltInfoFile(document);
        }
    }

    public static void initializeCorpus(SaltExtendedCorpusFactory.SaltExtendedCorpus corpus) throws IOException, MMAX2WrapperException {
        FileGenerator.initializeCorpus((CorpusFactory.Corpus)corpus);
        File saltInfosDirectory = new File(corpus.getCorpusPath() + File.separator + corpus.getSaltInfoPath());
        if (!saltInfosDirectory.mkdirs()) {
            throw new PepperModuleException("create folder for SaltInfo '" + saltInfosDirectory.getAbsolutePath() + "'");
        }
    }

    public static void outputDocument(SaltExtendedCorpusFactory.SaltExtendedCorpus corpus, SaltExtendedDocumentFactory.SaltExtendedDocument document) throws MMAX2WrapperException, IOException {
        FileGenerator.outputDocument((CorpusFactory.Corpus)corpus, (DocumentFactory.Document)document);
        SaltExtendedFileGenerator.createSaltInfoFile(document);
    }

    public static void finalizeCorpus(SaltExtendedCorpusFactory.SaltExtendedCorpus corpus) throws MMAX2WrapperException, IOException {
        FileGenerator.finalizeCorpus((CorpusFactory.Corpus)corpus);
    }

    private static void createSaltInfoFile(SaltExtendedDocumentFactory.SaltExtendedDocument document) throws IOException, MMAX2WrapperException {
        SaltExtendedFileGenerator.OutputXmlFile((String)(document.getFactory().getCorpus().getCorpusPath() + File.separator + document.getFactory().getCorpus().getSaltInfoPath() + File.separator + document.getDocumentId() + ".xml"), (String)SaltExtendedFileGenerator.createSaltInfoFileString(document));
    }

    private static String createSaltInfoFileString(SaltExtendedDocumentFactory.SaltExtendedDocument document) throws MMAX2WrapperException {
        String cpy = MMAX2_SALT_INFO_GENERIC;
        ArrayList<SaltExtendedMarkableFactory.SaltExtendedMarkable> markables = document.getAllSaltExtendedMarkables();
        ArrayList<String> markablesStr = new ArrayList<String>();
        for (SaltExtendedMarkableFactory.SaltExtendedMarkable markable : markables) {
            markablesStr.add(SaltExtendedFileGenerator.createSaltInfoEntry(markable));
        }
        cpy = cpy.replaceAll("@salt_infos@", SaltExtendedFileGenerator.EscapeStringSimple(StringUtils.join(markablesStr, (String)"\n")));
        return cpy;
    }

    private static String createSaltInfoEntry(SaltExtendedMarkableFactory.SaltExtendedMarkable markable) throws MMAX2WrapperException {
        String cpy = MMAX2_SALT_INFO_ENTRY_GENERIC;
        cpy = cpy.replaceAll("@markable_id@", SaltExtendedFileGenerator.EscapeString(markable.getId()));
        cpy = cpy.replaceAll("@salt_id@", SaltExtendedFileGenerator.EscapeString(markable.getSId()));
        cpy = cpy.replaceAll("@salt_type@", SaltExtendedFileGenerator.EscapeString(markable.getSType()));
        cpy = cpy.replaceAll("@salt_name@", SaltExtendedFileGenerator.EscapeString(markable.getSName()));
        if (markable.getSType().equals("SContainer")) {
            SaltExtendedMarkableFactory.SaltExtendedMarkableContainer containerMarkable = (SaltExtendedMarkableFactory.SaltExtendedMarkableContainer)markable;
            cpy = cpy.replaceAll("@additional@", "contained_id=\"" + SaltExtendedFileGenerator.EscapeString(containerMarkable.getContainedId()) + "\" " + "contained_scheme" + "=\"" + SaltExtendedFileGenerator.EscapeString(containerMarkable.getContainedSchemeName()));
        } else {
            cpy = cpy.replaceAll("@additional@", "");
        }
        return cpy;
    }

    protected static String EscapeString(String original) throws MMAX2WrapperException {
        String copy = original + "";
        return SaltExtendedFileGenerator.EscapeStringSimple(StringEscapeUtils.escapeXml((String)copy));
    }

    protected static String EscapeStringSimple(String original) throws MMAX2WrapperException {
        String copy = original + "";
        if (copy.matches(prohibed_regexp)) {
            throw new PepperModuleException("'" + copy + "' contains one of the following reserved @argument@ (" + prohibed_arguments + ")");
        }
        return FileGenerator.EscapeStringSimple((String)copy);
    }
}

