/*
 * Decompiled with CFR 0.152.
 */
package edu.eurac.commul.pepperModules.mmax2;

import edu.eurac.commul.annotations.mmax2.mmax2wrapper.CorpusFactory;
import edu.eurac.commul.annotations.mmax2.mmax2wrapper.DocumentFactory;
import edu.eurac.commul.annotations.mmax2.mmax2wrapper.MMAX2WrapperException;
import edu.eurac.commul.annotations.mmax2.mmax2wrapper.MarkableFactory;
import edu.eurac.commul.annotations.mmax2.mmax2wrapper.SchemeFactory;
import edu.eurac.commul.pepperModules.mmax2.SaltExtendedCorpusFactory;
import edu.eurac.commul.pepperModules.mmax2.SaltExtendedMarkableFactory;
import edu.eurac.commul.pepperModules.mmax2.SaltExtendedMmax2Infos;
import edu.eurac.commul.pepperModules.mmax2.exceptions.SaltExtendedMMAX2WrapperException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SaltExtendedDocumentFactory
extends DocumentFactory {
    private SaltExtendedCorpusFactory.SaltExtendedCorpus corpus;

    public SaltExtendedDocumentFactory(SaltExtendedCorpusFactory.SaltExtendedCorpus corpus) {
        super((CorpusFactory.Corpus)corpus);
        this.corpus = corpus;
    }

    public SaltExtendedDocumentFactory(SaltExtendedCorpusFactory.SaltExtendedCorpus corpus, DocumentBuilder documentBuilder) {
        super((CorpusFactory.Corpus)corpus, documentBuilder);
        this.corpus = corpus;
    }

    public SaltExtendedDocument getDocument(String documentId) throws MMAX2WrapperException, SAXException, IOException {
        if (this.documentBuilder == null) {
            throw new MMAX2WrapperException("To use function 'getNewDocument' a DocumentBuilder needs to be provided at instantiation");
        }
        ArrayList schemes = this.corpus.getSchemes();
        for (SchemeFactory.Scheme scheme : schemes) {
            this.addMarkableFactory(new SaltExtendedMarkableFactory(scheme, this.documentBuilder));
        }
        return new SaltExtendedDocument(documentId, this, this.getBaseDataUnits(documentId), this.getSaltExtendedMarkables(documentId));
    }

    protected ArrayList<SaltExtendedMarkableFactory.SaltExtendedMarkable> getSaltExtendedMarkables(String documentId) throws SAXException, IOException, MMAX2WrapperException {
        if (this.documentBuilder == null) {
            throw new MMAX2WrapperException("To use function 'getSaltExtendedMarkables' a DocumentBuilder needs to be provided at instantiation");
        }
        ArrayList<SaltExtendedMarkableFactory.SaltExtendedMarkable> markables = new ArrayList<SaltExtendedMarkableFactory.SaltExtendedMarkable>();
        File saltInfoFile = new File(this.corpus.getCorpusPath() + File.separator + this.corpus.getSaltInfoPath() + File.separator + documentId + ".xml");
        Hashtable<String, Hashtable<String, String>> saltInfos = new Hashtable<String, Hashtable<String, String>>();
        if (saltInfoFile.exists()) {
            NodeList nodes = this.documentBuilder.parse(saltInfoFile).getDocumentElement().getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node sNameAttributeNode;
                Node xmlNode = nodes.item(i);
                String nodeName = xmlNode.getNodeName();
                if (nodeName == null || !nodeName.equals("saltInfo")) continue;
                NamedNodeMap attributes = xmlNode.getAttributes();
                Hashtable<String, String> saltInfoMarkable = new Hashtable<String, String>();
                Node idAttributeNode = attributes.getNamedItem("id");
                if (idAttributeNode == null) {
                    throw new SaltExtendedMMAX2WrapperException("Salt information '" + xmlNode.toString() + " in File '" + saltInfoFile + "' has no '" + "id" + "' attribute defined");
                }
                String idAttribute = idAttributeNode.getNodeValue();
                Node sTypeAttributeNode = attributes.getNamedItem("salt_type");
                if (sTypeAttributeNode == null) {
                    throw new SaltExtendedMMAX2WrapperException("Salt information '" + xmlNode.toString() + " in File '" + saltInfoFile + "' has no '" + "salt_type" + "' attribute defined");
                }
                String sTypeAttribute = sTypeAttributeNode.getNodeValue();
                saltInfoMarkable.put("salt_type", sTypeAttribute);
                if (sTypeAttribute.equals("SContainer")) {
                    Node containedIdAttributeNode = attributes.getNamedItem("contained_id");
                    if (containedIdAttributeNode == null) {
                        throw new SaltExtendedMMAX2WrapperException("Salt information '" + xmlNode.toString() + " on a SContainer in File '" + saltInfoFile + "' has no '" + "contained_id" + "' attribute defined");
                    }
                    saltInfoMarkable.put("contained_id", containedIdAttributeNode.getNodeValue());
                    Node containedSchemeNameIdAttributeNode = attributes.getNamedItem("contained_scheme");
                    if (containedSchemeNameIdAttributeNode == null) {
                        throw new SaltExtendedMMAX2WrapperException("Salt information '" + xmlNode.toString() + " on a SContainer in File '" + saltInfoFile + "' has no '" + "contained_scheme" + "' attribute defined");
                    }
                    saltInfoMarkable.put("contained_scheme", containedSchemeNameIdAttributeNode.getNodeValue());
                }
                if ((sNameAttributeNode = attributes.getNamedItem("salt_name")) == null) {
                    throw new SaltExtendedMMAX2WrapperException("Salt information '" + xmlNode.toString() + " in File '" + saltInfoFile + "' has no '" + "salt_name" + "' attribute defined");
                }
                String sNameAttribute = sNameAttributeNode.getNodeValue();
                saltInfoMarkable.put("salt_name", sNameAttribute);
                Node sidAttributeNode = attributes.getNamedItem("salt_id");
                if (sidAttributeNode == null) {
                    throw new SaltExtendedMMAX2WrapperException("Salt information '" + xmlNode.toString() + " in File '" + saltInfoFile + "' has no '" + "salt_id" + "' attribute defined");
                }
                String sIdAttribute = sidAttributeNode.getNodeValue();
                saltInfoMarkable.put("salt_id", sIdAttribute);
                saltInfos.put(idAttribute, saltInfoMarkable);
            }
        }
        ArrayList schemes = this.corpus.getSchemes();
        for (Object scheme : schemes) {
            SaltExtendedMarkableFactory markableFactory = this.getMarkableFactory((SchemeFactory.Scheme)scheme);
            if (SaltExtendedMmax2Infos.isSaltScheme(scheme.getName())) {
                markables.addAll(markableFactory.getSaltExtendedMarkables(documentId, saltInfos));
                continue;
            }
            markables.addAll(markableFactory.getSaltExtendedMarkables(documentId));
        }
        if (saltInfos.size() != 0) {
            Hashtable<String, Integer> nonClaimedStypes = new Hashtable<String, Integer>();
            for (String markableId : saltInfos.keySet()) {
                nonClaimedStypes.put(saltInfos.get(markableId).get("salt_type"), 1);
            }
            String nonClaimedStypesStr = "";
            for (String nonClaimedStypeStr : nonClaimedStypes.keySet()) {
                nonClaimedStypesStr = nonClaimedStypesStr + ", " + nonClaimedStypeStr;
            }
            throw new SaltExtendedMMAX2WrapperException("Data corruption: SaltInfos have not been all reimported " + saltInfos.size() + " informations of stypes " + nonClaimedStypesStr.substring(1) + " are non claimed...");
        }
        return markables;
    }

    public SaltExtendedDocument newDocument(String documentId) {
        return new SaltExtendedDocument(documentId, this);
    }

    public SaltExtendedMarkableFactory getMarkableFactory(SchemeFactory.Scheme scheme) {
        return (SaltExtendedMarkableFactory)super.getMarkableFactory(scheme);
    }

    public void addMarkableFactory(SaltExtendedMarkableFactory factory) {
        super.addMarkableFactory((MarkableFactory)factory);
    }

    public SaltExtendedCorpusFactory.SaltExtendedCorpus getCorpus() {
        return this.corpus;
    }

    public class SaltExtendedDocument
    extends DocumentFactory.Document {
        protected SaltExtendedDocument(String documentId, SaltExtendedDocumentFactory factory) {
            super((DocumentFactory)SaltExtendedDocumentFactory.this, documentId, (DocumentFactory)factory);
        }

        protected SaltExtendedDocument(String documentId, SaltExtendedDocumentFactory factory, ArrayList<DocumentFactory.Document.BaseDataUnit> baseDataUnits, ArrayList<SaltExtendedMarkableFactory.SaltExtendedMarkable> markables) {
            super((DocumentFactory)SaltExtendedDocumentFactory.this, documentId, (DocumentFactory)factory, baseDataUnits, new ArrayList());
            for (SaltExtendedMarkableFactory.SaltExtendedMarkable markable : markables) {
                this.addMarkable(markable);
            }
        }

        public ArrayList<SaltExtendedMarkableFactory.SaltExtendedMarkable> getAllSaltExtendedMarkables() {
            ArrayList<SaltExtendedMarkableFactory.SaltExtendedMarkable> results = new ArrayList<SaltExtendedMarkableFactory.SaltExtendedMarkable>();
            for (MarkableFactory.Markable markable : super.getAllMarkables()) {
                results.add((SaltExtendedMarkableFactory.SaltExtendedMarkable)markable);
            }
            return results;
        }

        public SaltExtendedDocumentFactory getFactory() {
            return (SaltExtendedDocumentFactory)this.factory;
        }

        public void addMarkable(SaltExtendedMarkableFactory.SaltExtendedMarkable markable) {
            super.addMarkable((MarkableFactory.Markable)markable);
        }

        public void removeMarkable(SaltExtendedMarkableFactory.SaltExtendedMarkable markable) {
            super.removeMarkable((MarkableFactory.Markable)markable);
        }

        public ArrayList<SaltExtendedMarkableFactory.SaltExtendedMarkable> getSaltExtendedMarkablesOfLevel(String levelName) {
            ArrayList<SaltExtendedMarkableFactory.SaltExtendedMarkable> results = new ArrayList<SaltExtendedMarkableFactory.SaltExtendedMarkable>();
            for (MarkableFactory.Markable markable : (ArrayList)this.markables.get(levelName)) {
                results.add((SaltExtendedMarkableFactory.SaltExtendedMarkable)markable);
            }
            return results;
        }
    }
}

