/*
 * Decompiled with CFR 0.152.
 */
package edu.eurac.commul.pepperModules.mmax2;

import edu.eurac.commul.pepperModules.mmax2.MMAX2ExporterProperties;
import edu.eurac.commul.pepperModules.mmax2.SAnnotationAndMatchCondition;
import edu.eurac.commul.pepperModules.mmax2.SAnnotationMapping;
import edu.eurac.commul.pepperModules.mmax2.SAnnotationMatchCondition;
import edu.eurac.commul.pepperModules.mmax2.SAnnotationNameSpaceMatchCondition;
import edu.eurac.commul.pepperModules.mmax2.SAnnotationNotMatchCondition;
import edu.eurac.commul.pepperModules.mmax2.SAnnotationOrMatchCondition;
import edu.eurac.commul.pepperModules.mmax2.SAnnotationSLayerMatchCondition;
import edu.eurac.commul.pepperModules.mmax2.SAnnotationSNameMatchCondition;
import edu.eurac.commul.pepperModules.mmax2.SAnnotationStringValueMatchCondition;
import edu.eurac.commul.pepperModules.mmax2.SRelationAndMatchCondition;
import edu.eurac.commul.pepperModules.mmax2.SRelationMapping;
import edu.eurac.commul.pepperModules.mmax2.SRelationMatchCondition;
import edu.eurac.commul.pepperModules.mmax2.SRelationNotMatchCondition;
import edu.eurac.commul.pepperModules.mmax2.SRelationOrMatchCondition;
import edu.eurac.commul.pepperModules.mmax2.SRelationSLayerMatchCondition;
import edu.eurac.commul.pepperModules.mmax2.SRelationSNameMatchCondition;
import edu.eurac.commul.pepperModules.mmax2.SRelationSTypeMatchCondition;
import edu.eurac.commul.pepperModules.mmax2.SRelationSourceTypeMatchCondition;
import edu.eurac.commul.pepperModules.mmax2.SRelationTargetTypeMatchCondition;
import edu.eurac.commul.pepperModules.mmax2.Salt2MMAX2Mapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class Salt2MMAXMapping {
    public static final Logger logger = LoggerFactory.getLogger(Salt2MMAX2Mapper.class);
    public static final String MAPPING_NODE_NAME = "mapping";
    public static final String MAPPING_INFOS_NODE_NAME = "mapping_infos";
    public static final String CONDITION_NODE_NAME = "condition";
    public static final String AND_MATCH_CONDITION = "and";
    public static final String OR_MATCH_CONDITION = "or";
    public static final String NOT_MATCH_CONDITION = "not";
    public static final String SANN_MAPPING_ASS_SCHEME = "ass_scheme";
    public static final String SANN_MAPPING_ASS_ATTR = "ass_attr";
    public static final String SANN_SNAME_CONDITION = "sname_cond";
    public static final String SANN_NS_CONDITION = "namespace_cond";
    public static final String SANN_SLAYER_CONDITION = "slayer_cond";
    public static final String SANN_STR_VALUE_CONDITION = "string_value_cond";
    public static final String SANN_NS_REGEXP = "namespace_regexp";
    public static final String SANN_SLAYER_REGEXP = "slayer_regexp";
    public static final String SANN_SNAME_REGEXP = "sname_regexp";
    public static final String SANN_STRING_VALUE_REGEXP = "value_regexp";
    public static final String SREL_MAPP_SOURCE_SCHEME_NAME = "source_scheme";
    public static final String SREL_MAPP_TARGET_SCHEME_NAME = "target_scheme";
    public static final String SREL_MAPP_POINTER_ATTR_NAME = "source_attr";
    public static final String SREL_SNAME_CONDITION = "sname_cond";
    public static final String SREL_STYPE_CONDITION = "stype_cond";
    public static final String SREL_SLAYER_CONDITION = "slayer_cond";
    public static final String SREL_SOURCE_TYPE_CONDITION = "source_type_cond";
    public static final String SREL_TARGET_TYPE_CONDITION = "target_type_cond";
    public static final String SREL_SNAME_REGEXP = "sname_regexp";
    public static final String SREL_SLAYER_REGEXP = "slayer_regexp";
    public static final String SREL_STYPE_REGEXP = "stype_regexp";
    public static final String SREL_SOURCE_TYPE_REGEXP = "source_type_regexp";
    public static final String SREL_TARGET_TYPE_REGEXP = "target_type_regexp";

    Salt2MMAXMapping() {
    }

    public static ArrayList<SAnnotationMapping> getSAnnotationMappingsFromFile(MMAX2ExporterProperties props) {
        ArrayList<SAnnotationMapping> mappings = new ArrayList<SAnnotationMapping>();
        if (props.getSAnnotationMappingsFilePath() != null) {
            DocumentBuilder documentBuilder;
            try {
                documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new PepperModuleException(e.getMessage(), (Throwable)e);
            }
            File configurationFile = new File(props.getSAnnotationMappingsFilePath());
            NodeList nodes = null;
            try {
                nodes = documentBuilder.parse(configurationFile).getDocumentElement().getChildNodes();
            }
            catch (SAXException e) {
                throw new PepperModuleException(e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                throw new PepperModuleException(e.getMessage(), (Throwable)e);
            }
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node xmlNode = nodes.item(i);
                if (xmlNode.getNodeType() != 1) continue;
                String nodeName = xmlNode.getNodeName();
                if (nodeName.equals(MAPPING_NODE_NAME)) {
                    Node mapping_infos = null;
                    Node condition_infos = null;
                    NodeList sub_nodes = xmlNode.getChildNodes();
                    for (int j = 0; j < sub_nodes.getLength(); ++j) {
                        Node sub_xmlNode = sub_nodes.item(j);
                        if (sub_xmlNode.getNodeType() != 1) continue;
                        String sub_nodeName = sub_xmlNode.getNodeName();
                        if (sub_nodeName.equals(MAPPING_INFOS_NODE_NAME)) {
                            if (mapping_infos == null) {
                                mapping_infos = sub_xmlNode;
                                continue;
                            }
                            throw new PepperModuleException("More than one mapping infos defined on SAnnotation Mapping '" + xmlNode + "'");
                        }
                        if (sub_nodeName.equals(CONDITION_NODE_NAME)) {
                            if (condition_infos == null) {
                                condition_infos = sub_xmlNode;
                                continue;
                            }
                            throw new PepperModuleException("More than one match condition defined on SAnnotation Mapping '" + xmlNode + "'");
                        }
                        throw new PepperModuleException("Unknown type of Node '" + sub_xmlNode + "' with name '" + sub_nodeName + "' on SAnnotation Mapping '" + xmlNode + "'");
                    }
                    NamedNodeMap mapping_attributes = mapping_infos.getAttributes();
                    Node associatedSchemeNameAttribute = mapping_attributes.getNamedItem(SANN_MAPPING_ASS_SCHEME);
                    if (associatedSchemeNameAttribute == null) {
                        throw new PepperModuleException("associated scheme name 'ass_scheme' on SAnnotation Mapping infos Node '" + mapping_infos + "' is not defined...");
                    }
                    String associatedSchemeName = associatedSchemeNameAttribute.getNodeValue();
                    mapping_attributes.removeNamedItem(SANN_MAPPING_ASS_SCHEME);
                    Node associatedAttributeNameAttribute = mapping_attributes.getNamedItem(SANN_MAPPING_ASS_ATTR);
                    if (associatedAttributeNameAttribute == null) {
                        throw new PepperModuleException("associated attribute name 'ass_attr' on SAnnotation Mapping infos Node  '" + mapping_infos + "' is not defined...");
                    }
                    String associatedAttributeName = associatedAttributeNameAttribute.getNodeValue();
                    mapping_attributes.removeNamedItem(SANN_MAPPING_ASS_ATTR);
                    SAnnotationMatchCondition condition = Salt2MMAXMapping.parseSAnnotationMatchCondition(condition_infos);
                    if (mapping_attributes.getLength() != 0) {
                        ArrayList<String> unknownAttributes = new ArrayList<String>();
                        for (int j = 0; j < mapping_attributes.getLength(); ++j) {
                            unknownAttributes.add(mapping_attributes.item(j).getNodeName());
                        }
                        throw new PepperModuleException("Unknown attributes '" + StringUtils.join(unknownAttributes, (String)",") + "' on SAnnotation Mapping infos Node  '" + mapping_infos + "'");
                    }
                    mappings.add(new SAnnotationMapping(condition, associatedSchemeName, associatedAttributeName));
                    continue;
                }
                if (xmlNode.getNodeType() != 1) continue;
                throw new PepperModuleException("Unknown type of Node among Mapping nodes '" + xmlNode + "' with name '" + nodeName + "'");
            }
        }
        return mappings;
    }

    public static SAnnotationMatchCondition parseSAnnotationMatchCondition(Node node) {
        String nodeName = node.getNodeName();
        if (nodeName.equals(CONDITION_NODE_NAME)) {
            return Salt2MMAXMapping.parseMainSAnnotationMatchCondition(node);
        }
        if (nodeName.equals(AND_MATCH_CONDITION)) {
            return Salt2MMAXMapping.parseSAnnotationAndMatchCondition(node);
        }
        if (nodeName.equals(OR_MATCH_CONDITION)) {
            return Salt2MMAXMapping.parseSAnnotationOrMatchCondition(node);
        }
        if (nodeName.equals(NOT_MATCH_CONDITION)) {
            return Salt2MMAXMapping.parseSAnnotationNotMatchCondition(node);
        }
        if (nodeName.equals("slayer_cond")) {
            return Salt2MMAXMapping.parseSAnnotationSLayerMatchCondition(node);
        }
        if (nodeName.equals("sname_cond")) {
            return Salt2MMAXMapping.parseSAnnotationSNameMatchCondition(node);
        }
        if (nodeName.equals(SANN_NS_CONDITION)) {
            return Salt2MMAXMapping.parseSAnnotationNameSpaceMatchCondition(node);
        }
        if (nodeName.equals(SANN_STR_VALUE_CONDITION)) {
            return Salt2MMAXMapping.parseSAnnotationStringValueMatchCondition(node);
        }
        throw new PepperModuleException("Unknown SAnnotation match condition type '" + nodeName + "'");
    }

    public static SAnnotationMatchCondition parseMainSAnnotationMatchCondition(Node node) {
        Node condition_node = null;
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node sub_node = nodes.item(i);
            if (sub_node.getNodeType() != 1) continue;
            if (condition_node == null) {
                condition_node = sub_node;
                continue;
            }
            throw new PepperModuleException("A condition node of a mapping should have only one \"super\" condition, found two: '" + condition_node + "' and '" + sub_node + "'");
        }
        return Salt2MMAXMapping.parseSAnnotationMatchCondition(condition_node);
    }

    public static SAnnotationAndMatchCondition parseSAnnotationAndMatchCondition(Node node) {
        ArrayList<SAnnotationMatchCondition> subconditions = new ArrayList<SAnnotationMatchCondition>();
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node xmlNode = nodes.item(i);
            if (xmlNode.getNodeType() != 1) continue;
            subconditions.add(Salt2MMAXMapping.parseSAnnotationMatchCondition(xmlNode));
        }
        if (subconditions.size() < 1) {
            throw new PepperModuleException("And Match condition '" + node + "' has no sub conditions...");
        }
        return new SAnnotationAndMatchCondition(subconditions);
    }

    public static SAnnotationOrMatchCondition parseSAnnotationOrMatchCondition(Node node) {
        ArrayList<SAnnotationMatchCondition> subconditions = new ArrayList<SAnnotationMatchCondition>();
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node xmlNode = nodes.item(i);
            if (xmlNode.getNodeType() != 1) continue;
            subconditions.add(Salt2MMAXMapping.parseSAnnotationMatchCondition(xmlNode));
        }
        if (subconditions.size() < 1) {
            throw new PepperModuleException("And Match condition '" + node + "' has no sub conditions...");
        }
        return new SAnnotationOrMatchCondition(subconditions);
    }

    public static SAnnotationNotMatchCondition parseSAnnotationNotMatchCondition(Node node) {
        SAnnotationMatchCondition subcondition = null;
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node xmlNode = nodes.item(i);
            if (xmlNode.getNodeType() != 1) continue;
            SAnnotationMatchCondition local_sub_condition = Salt2MMAXMapping.parseSAnnotationMatchCondition(xmlNode);
            if (subcondition != null) {
                throw new PepperModuleException("Not Match condition '" + node + "' has several conditions...");
            }
            subcondition = local_sub_condition;
        }
        if (subcondition == null) {
            throw new PepperModuleException("And Match condition '" + node + "' has no sub conditions...");
        }
        return new SAnnotationNotMatchCondition(subcondition);
    }

    public static SAnnotationSNameMatchCondition parseSAnnotationSNameMatchCondition(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        Node snameAttributeNode = attributes.getNamedItem("sname_regexp");
        String nameRegExp = null;
        if (snameAttributeNode == null) {
            throw new PepperModuleException("'sname_regexp' attribute not found on SAnnotation SName Match Condition '" + node + "'");
        }
        nameRegExp = snameAttributeNode.getNodeValue();
        attributes.removeNamedItem("sname_regexp");
        if (attributes.getLength() != 0) {
            throw new PepperModuleException("Additional unexpected attributes found on SAnnotation SName Match Condition '" + node + "'");
        }
        return new SAnnotationSNameMatchCondition(Pattern.compile(nameRegExp));
    }

    public static SAnnotationSLayerMatchCondition parseSAnnotationSLayerMatchCondition(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        Node slayerAttributeNode = attributes.getNamedItem("slayer_regexp");
        String slayerRegExp = null;
        if (slayerAttributeNode == null) {
            throw new PepperModuleException("'slayer_regexp attribute not found on SAnnotation SLayer Match Condition '" + node + "'");
        }
        slayerRegExp = slayerAttributeNode.getNodeValue();
        attributes.removeNamedItem("slayer_regexp");
        if (attributes.getLength() != 0) {
            throw new PepperModuleException("Additional unexpected attributes found on SAnnnotation SLayer Match Condition '" + node + "'");
        }
        return new SAnnotationSLayerMatchCondition(Pattern.compile(slayerRegExp));
    }

    public static SAnnotationNameSpaceMatchCondition parseSAnnotationNameSpaceMatchCondition(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        Node nsAttributeNode = attributes.getNamedItem(SANN_NS_REGEXP);
        String nsRegExp = null;
        if (nsAttributeNode == null) {
            throw new PepperModuleException("'namespace_regexp' attribute not found on SAnnotation NameSpace Match Condition '" + node + "'");
        }
        nsRegExp = nsAttributeNode.getNodeValue();
        attributes.removeNamedItem(SANN_NS_REGEXP);
        if (attributes.getLength() != 0) {
            throw new PepperModuleException("Additional unexpected attributes found on SAnnotation NameSpace Match Condition '" + node + "'");
        }
        return new SAnnotationNameSpaceMatchCondition(Pattern.compile(nsRegExp));
    }

    public static SAnnotationStringValueMatchCondition parseSAnnotationStringValueMatchCondition(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        Node stringValueAttributeNode = attributes.getNamedItem(SANN_STRING_VALUE_REGEXP);
        String stringValueRegExp = null;
        if (stringValueAttributeNode == null) {
            throw new PepperModuleException("'value_regexp' attribute not found on SAnnotation String Value Match Condition '" + node + "'");
        }
        stringValueRegExp = stringValueAttributeNode.getNodeValue();
        attributes.removeNamedItem(SANN_STRING_VALUE_REGEXP);
        if (attributes.getLength() != 0) {
            throw new PepperModuleException("Additional unexpected attributes found on SAnnotation String Value Match Condition '" + node + "'");
        }
        return new SAnnotationStringValueMatchCondition(Pattern.compile(stringValueRegExp));
    }

    public static ArrayList<SRelationMapping> getSRelationMappingsFromFile(MMAX2ExporterProperties props) {
        ArrayList<SRelationMapping> mappings = new ArrayList<SRelationMapping>();
        if (props.getSRelationMappingsFilePath() != null) {
            DocumentBuilder documentBuilder;
            try {
                documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new PepperModuleException(e.getMessage(), (Throwable)e);
            }
            File configurationFile = new File(props.getSRelationMappingsFilePath());
            NodeList nodes = null;
            try {
                nodes = documentBuilder.parse(configurationFile).getDocumentElement().getChildNodes();
            }
            catch (SAXException e) {
                throw new PepperModuleException(e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                throw new PepperModuleException(e.getMessage(), (Throwable)e);
            }
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node xmlNode = nodes.item(i);
                if (xmlNode.getNodeType() != 1) continue;
                String nodeName = xmlNode.getNodeName();
                if (nodeName.equals(MAPPING_NODE_NAME)) {
                    Node mapping_infos = null;
                    Node condition_infos = null;
                    NodeList sub_nodes = xmlNode.getChildNodes();
                    for (int j = 0; j < sub_nodes.getLength(); ++j) {
                        Node sub_xmlNode = sub_nodes.item(j);
                        if (sub_xmlNode.getNodeType() != 1) continue;
                        String sub_nodeName = sub_xmlNode.getNodeName();
                        if (sub_nodeName.equals(MAPPING_INFOS_NODE_NAME)) {
                            if (mapping_infos == null) {
                                mapping_infos = sub_xmlNode;
                                continue;
                            }
                            throw new PepperModuleException("More than one mapping infos defined on SRelation Mapping '" + xmlNode + "'");
                        }
                        if (sub_nodeName.equals(CONDITION_NODE_NAME)) {
                            if (condition_infos == null) {
                                condition_infos = sub_xmlNode;
                                continue;
                            }
                            throw new PepperModuleException("More than one match condition defined on SRelation Mapping '" + xmlNode + "'");
                        }
                        if (sub_nodeName.equals("")) continue;
                        throw new PepperModuleException("Unknown type of Node '" + sub_xmlNode + "' with name '" + sub_nodeName + "' on SRelation Mapping '" + xmlNode + "'");
                    }
                    NamedNodeMap mapping_attributes = mapping_infos.getAttributes();
                    Node sourceDestSchemeNode = mapping_attributes.getNamedItem(SREL_MAPP_SOURCE_SCHEME_NAME);
                    if (sourceDestSchemeNode == null) {
                        throw new PepperModuleException("Source destination scheme 'source_scheme' on SRelation Mapping infos Node '" + mapping_infos + "' is not defined...");
                    }
                    mapping_attributes.removeNamedItem(SREL_MAPP_SOURCE_SCHEME_NAME);
                    String sourceSchemeName = sourceDestSchemeNode.getNodeValue();
                    Node targetDestSchemeNode = mapping_attributes.getNamedItem(SREL_MAPP_TARGET_SCHEME_NAME);
                    if (targetDestSchemeNode == null) {
                        throw new PepperModuleException("Target destination scheme 'target_scheme' on SRelation Mapping infos Node '" + mapping_infos + "' is not defined...");
                    }
                    mapping_attributes.removeNamedItem(SREL_MAPP_TARGET_SCHEME_NAME);
                    String targetSchemeName = targetDestSchemeNode.getNodeValue();
                    Node destAttrNode = mapping_attributes.getNamedItem(SREL_MAPP_POINTER_ATTR_NAME);
                    if (destAttrNode == null) {
                        throw new PepperModuleException("Source attribute 'source_attr' on SRelation Mapping infos Node '" + mapping_infos + "' is not defined...");
                    }
                    mapping_attributes.removeNamedItem(SREL_MAPP_POINTER_ATTR_NAME);
                    String attrName = destAttrNode.getNodeValue();
                    SRelationMatchCondition condition = Salt2MMAXMapping.parseSRelationMatchCondition(condition_infos);
                    if (mapping_attributes.getLength() != 0) {
                        ArrayList<String> unknownAttributes = new ArrayList<String>();
                        for (int j = 0; j < mapping_attributes.getLength(); ++j) {
                            unknownAttributes.add(mapping_attributes.item(j).getNodeName());
                        }
                        throw new PepperModuleException("Unknown attributes '" + StringUtils.join(unknownAttributes, (String)",") + "' on SRelation Mapping infos Node '" + mapping_infos + "'");
                    }
                    mappings.add(new SRelationMapping(condition, sourceSchemeName, targetSchemeName, attrName));
                    continue;
                }
                throw new PepperModuleException("Unknown type of Node among Mapping nodes '" + xmlNode + "' with name '" + nodeName + "'");
            }
        }
        return mappings;
    }

    public static SRelationMatchCondition parseSRelationMatchCondition(Node node) {
        String nodeName = node.getNodeName();
        if (nodeName.equals(CONDITION_NODE_NAME)) {
            return Salt2MMAXMapping.parseMainSRelationMatchCondition(node);
        }
        if (nodeName.equals(AND_MATCH_CONDITION)) {
            return Salt2MMAXMapping.parseSRelationAndMatchCondition(node);
        }
        if (nodeName.equals(OR_MATCH_CONDITION)) {
            return Salt2MMAXMapping.parseSRelationOrMatchCondition(node);
        }
        if (nodeName.equals(NOT_MATCH_CONDITION)) {
            return Salt2MMAXMapping.parseSRelationNotMatchCondition(node);
        }
        if (nodeName.equals(SREL_STYPE_CONDITION)) {
            return Salt2MMAXMapping.parseSRelationSTypeMatchCondition(node);
        }
        if (nodeName.equals("slayer_cond")) {
            return Salt2MMAXMapping.parseSRelationSLayerMatchCondition(node);
        }
        if (nodeName.equals("sname_cond")) {
            return Salt2MMAXMapping.parseSRelationSNameMatchCondition(node);
        }
        if (nodeName.equals(SREL_SOURCE_TYPE_CONDITION)) {
            return Salt2MMAXMapping.parseSRelationSourceTypeMatchCondition(node);
        }
        if (nodeName.equals(SREL_TARGET_TYPE_CONDITION)) {
            return Salt2MMAXMapping.parseSRelationTargetTypeMatchCondition(node);
        }
        throw new PepperModuleException("Unknown SRelation match condition type '" + nodeName + "'");
    }

    public static SRelationMatchCondition parseMainSRelationMatchCondition(Node node) {
        Node condition_node = null;
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node sub_node = nodes.item(i);
            if (sub_node.getNodeType() != 1) continue;
            if (condition_node == null) {
                condition_node = sub_node;
                continue;
            }
            throw new PepperModuleException("A condition node of a mapping should have only one \"super\" condition, found two: '" + condition_node + "' and '" + sub_node + "'");
        }
        return Salt2MMAXMapping.parseSRelationMatchCondition(condition_node);
    }

    public static SRelationAndMatchCondition parseSRelationAndMatchCondition(Node node) {
        ArrayList<SRelationMatchCondition> subconditions = new ArrayList<SRelationMatchCondition>();
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node xmlNode = nodes.item(i);
            if (xmlNode.getNodeType() != 1) continue;
            subconditions.add(Salt2MMAXMapping.parseSRelationMatchCondition(xmlNode));
        }
        if (subconditions.size() < 1) {
            throw new PepperModuleException("And match condition '" + node + "'  has no sub conditions...");
        }
        return new SRelationAndMatchCondition(subconditions);
    }

    public static SRelationOrMatchCondition parseSRelationOrMatchCondition(Node node) {
        ArrayList<SRelationMatchCondition> subconditions = new ArrayList<SRelationMatchCondition>();
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node xmlNode = nodes.item(i);
            if (xmlNode.getNodeType() != 1) continue;
            subconditions.add(Salt2MMAXMapping.parseSRelationMatchCondition(xmlNode));
        }
        if (subconditions.size() < 1) {
            throw new PepperModuleException("Or Match condition '" + node + "' has no sub conditions...");
        }
        return new SRelationOrMatchCondition(subconditions);
    }

    public static SRelationNotMatchCondition parseSRelationNotMatchCondition(Node node) {
        SRelationMatchCondition subcondition = null;
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node xmlNode = nodes.item(i);
            if (xmlNode.getNodeType() != 1) continue;
            SRelationMatchCondition local_sub_condition = Salt2MMAXMapping.parseSRelationMatchCondition(xmlNode);
            if (subcondition != null) {
                throw new PepperModuleException("Not Match condition '" + node + "' has several conditions...");
            }
            subcondition = local_sub_condition;
        }
        if (subcondition == null) {
            throw new PepperModuleException("And Match condition '" + node + "' has no sub conditions...");
        }
        return new SRelationNotMatchCondition(subcondition);
    }

    public static SRelationSNameMatchCondition parseSRelationSNameMatchCondition(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        Node snameAttributeNode = attributes.getNamedItem("sname_regexp");
        String snameRegExp = null;
        if (snameAttributeNode == null) {
            throw new PepperModuleException("'sname_regexp attribute not found on SRelation SName Match Condition '" + node + "'");
        }
        snameRegExp = snameAttributeNode.getNodeValue();
        attributes.removeNamedItem("sname_regexp");
        if (attributes.getLength() != 0) {
            throw new PepperModuleException("Additional unexpected attributes found on SRelation SName Match Condition '" + node + "'");
        }
        return new SRelationSNameMatchCondition(Pattern.compile(snameRegExp));
    }

    public static SRelationSTypeMatchCondition parseSRelationSTypeMatchCondition(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        Node stypeAttributeNode = attributes.getNamedItem(SREL_STYPE_REGEXP);
        String stypeRegExp = null;
        if (stypeAttributeNode == null) {
            throw new PepperModuleException("'stype_regexp attribute not found on SRelation SType Match Condition '" + node + "'");
        }
        stypeRegExp = stypeAttributeNode.getNodeValue();
        attributes.removeNamedItem(SREL_STYPE_REGEXP);
        if (attributes.getLength() != 0) {
            throw new PepperModuleException("Additional unexpected attributes found on SRelation SType Match Condition '" + node + "'");
        }
        return new SRelationSTypeMatchCondition(Pattern.compile(stypeRegExp));
    }

    public static SRelationSLayerMatchCondition parseSRelationSLayerMatchCondition(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        Node slayerAttributeNode = attributes.getNamedItem("slayer_regexp");
        String slayerRegExp = null;
        if (slayerAttributeNode == null) {
            throw new PepperModuleException("'slayer_regexp attribute not found on SRelation SLayer Match Condition '" + node + "'");
        }
        slayerRegExp = slayerAttributeNode.getNodeValue();
        attributes.removeNamedItem("slayer_regexp");
        if (attributes.getLength() != 0) {
            throw new PepperModuleException("Additional unexpected attributes found on SRelation SLayer Match Condition '" + node + "'");
        }
        return new SRelationSLayerMatchCondition(Pattern.compile(slayerRegExp));
    }

    public static SRelationSourceTypeMatchCondition parseSRelationSourceTypeMatchCondition(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        Node sourceTypeAttributeNode = attributes.getNamedItem(SREL_SOURCE_TYPE_REGEXP);
        String sourceTypeRegExp = null;
        if (sourceTypeAttributeNode == null) {
            throw new PepperModuleException("'source_type_regexp attribute not found on SRelation SourceType Match Condition '" + node + "'");
        }
        sourceTypeRegExp = sourceTypeAttributeNode.getNodeValue();
        attributes.removeNamedItem(SREL_SOURCE_TYPE_REGEXP);
        if (attributes.getLength() != 0) {
            throw new PepperModuleException("Additional unexpected attributes found on SRelation SourceType Match Condition '" + node + "'");
        }
        return new SRelationSourceTypeMatchCondition(Pattern.compile(sourceTypeRegExp));
    }

    public static SRelationTargetTypeMatchCondition parseSRelationTargetTypeMatchCondition(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        Node targetTypeAttributeNode = attributes.getNamedItem(SREL_TARGET_TYPE_REGEXP);
        String targetTypeRegExp = null;
        if (targetTypeAttributeNode == null) {
            throw new PepperModuleException("'target_type_regexp attribute not found on SRelation TargetType Match Condition '" + node + "'");
        }
        targetTypeRegExp = targetTypeAttributeNode.getNodeValue();
        attributes.removeNamedItem(SREL_TARGET_TYPE_REGEXP);
        if (attributes.getLength() != 0) {
            throw new PepperModuleException("Additional unexpected attributes found on SRelation TargetType Match Condition '" + node + "'");
        }
        return new SRelationTargetTypeMatchCondition(Pattern.compile(targetTypeRegExp));
    }
}

