/*
 * Decompiled with CFR 0.152.
 */
package edu.eurac.commul.pepperModules.mmax2;

import edu.eurac.commul.annotations.mmax2.mmax2wrapper.MMAX2WrapperException;
import edu.eurac.commul.annotations.mmax2.mmax2wrapper.SchemeFactory;
import edu.eurac.commul.pepperModules.mmax2.SAnnotationMapping;
import edu.eurac.commul.pepperModules.mmax2.SRelationMapping;
import edu.eurac.commul.pepperModules.mmax2.SaltExtendedCorpusFactory;
import edu.eurac.commul.pepperModules.mmax2.SaltExtendedDocumentFactory;
import edu.eurac.commul.pepperModules.mmax2.SaltExtendedFileGenerator;
import edu.eurac.commul.pepperModules.mmax2.SaltExtendedMarkableFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import org.apache.commons.lang3.StringUtils;
import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.impl.PepperMapperImpl;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SDominanceRelation;
import org.corpus_tools.salt.common.SPointingRelation;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.SSpanningRelation;
import org.corpus_tools.salt.common.SStructure;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.STextualRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.SAbstractAnnotation;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SAnnotationContainer;
import org.corpus_tools.salt.core.SLayer;
import org.corpus_tools.salt.core.SMetaAnnotation;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;

public class Salt2MMAX2Mapper
extends PepperMapperImpl {
    private Hashtable<STextualRelation, Integer> spanStextualRelationCorrespondance;
    private Hashtable<STextualDS, ArrayList<String>> spanStextualDSCorrespondance;
    private Hashtable<SNode, SaltExtendedMarkableFactory.SaltExtendedMarkable> registeredSNodesMarkables;
    private Hashtable<SRelation, SaltExtendedMarkableFactory.SaltExtendedMarkable> registeredSRelationsMarkables;
    private HashMap<SLayer, SaltExtendedMarkableFactory.SaltExtendedMarkable> registeredSLayerMarkables;
    private DocumentBuilder documentBuilder;
    private Hashtable<Object, Hashtable<SchemeFactory.Scheme, SaltExtendedMarkableFactory.SaltExtendedMarkableContainer>> sContainerMarkables;
    private ArrayList<SAnnotationMapping> sannotationmappings;
    private ArrayList<SRelationMapping> srelationMappings;
    private SaltExtendedCorpusFactory.SaltExtendedCorpus corpus;
    private SaltExtendedDocumentFactory.SaltExtendedDocument document;
    private SchemeFactory schemeFactory;
    private SaltExtendedDocumentFactory factory = null;
    private int markableIdCpt = 0;

    public Salt2MMAX2Mapper() {
        this.sannotationmappings = new ArrayList();
        this.srelationMappings = new ArrayList();
    }

    public Salt2MMAX2Mapper(DocumentBuilder documentBuilder, SchemeFactory schemeFactory, SaltExtendedDocumentFactory factory) {
        this.sannotationmappings = new ArrayList();
        this.srelationMappings = new ArrayList();
        this.documentBuilder = documentBuilder;
        this.schemeFactory = schemeFactory;
        this.factory = factory;
        this.corpus = this.factory.getCorpus();
    }

    public Salt2MMAX2Mapper(DocumentBuilder documentBuilder, SchemeFactory schemeFactory, SaltExtendedDocumentFactory factory, ArrayList<SAnnotationMapping> sannotationmappings, ArrayList<SRelationMapping> srelationMappings) {
        this.sannotationmappings = sannotationmappings;
        this.srelationMappings = srelationMappings;
        this.documentBuilder = documentBuilder;
        this.schemeFactory = schemeFactory;
        this.factory = factory;
        this.corpus = this.factory.getCorpus();
    }

    private String getNewId() {
        ++this.markableIdCpt;
        return this.markableIdCpt + "";
    }

    private String makeSpan(int startEnd) {
        String span = "word_" + startEnd;
        return span;
    }

    private String makeSpan(int start, int end) {
        String span = "word_" + start + "..word_" + end;
        return span;
    }

    private String makeSpan(ArrayList<String> indices) {
        String span = StringUtils.join((Object[])indices.toArray(new String[indices.size()]), (String)",");
        return span;
    }

    private void registerSRelationMarkable(SaltExtendedMarkableFactory.SaltExtendedMarkable markable, SRelation key) {
        this.registeredSRelationsMarkables.put(key, markable);
    }

    private SaltExtendedMarkableFactory.SaltExtendedMarkable getSRelationMarkable(SRelation key) throws MMAX2WrapperException {
        SaltExtendedMarkableFactory.SaltExtendedMarkable markable = this.registeredSRelationsMarkables.get(key);
        if (markable == null) {
            if (key instanceof SSpanningRelation) {
                markable = this.mapSpanningRelation((SSpanningRelation)key);
            } else if (key instanceof SDominanceRelation) {
                markable = this.mapDominanceRelation((SDominanceRelation)key);
            } else if (key instanceof STextualRelation) {
                markable = this.mapTextualRelation((STextualRelation)key);
            } else if (key instanceof SPointingRelation) {
                markable = this.mapPointingRelation((SPointingRelation)key);
            } else {
                throw new PepperModuleException((PepperMapper)this, "Developper error Unknown Type of SRelation => " + key.getClass());
            }
            this.registerSRelationMarkable(markable, key);
        }
        return markable;
    }

    private void registerSNodeMarkable(SaltExtendedMarkableFactory.SaltExtendedMarkable markable, SNode key) {
        this.registeredSNodesMarkables.put(key, markable);
    }

    private SaltExtendedMarkableFactory.SaltExtendedMarkable getSNodeMarkable(SNode key) throws MMAX2WrapperException {
        SaltExtendedMarkableFactory.SaltExtendedMarkable markable = this.registeredSNodesMarkables.get(key);
        if (markable == null) {
            if (key instanceof SSpan) {
                markable = this.mapSpan((SSpan)key);
            } else if (key instanceof SToken) {
                markable = this.mapSToken((SToken)key);
            } else if (key instanceof SStructure) {
                markable = this.mapStruct((SStructure)key);
            } else if (key instanceof STextualDS) {
                markable = this.mapSTextualDS((STextualDS)key);
            } else {
                throw new PepperModuleException((PepperMapper)this, "Developper error Unknown Type of SNode => " + key.getClass());
            }
            this.registerSNodeMarkable(markable, key);
        }
        return markable;
    }

    public DOCUMENT_STATUS mapSCorpus() {
        return DOCUMENT_STATUS.COMPLETED;
    }

    /*
     * WARNING - void declaration
     */
    public DOCUMENT_STATUS mapSDocument() {
        String documentName = this.getDocument().getName();
        this.spanStextualRelationCorrespondance = new Hashtable();
        this.spanStextualDSCorrespondance = new Hashtable();
        this.registeredSNodesMarkables = new Hashtable();
        this.registeredSRelationsMarkables = new Hashtable();
        this.registeredSLayerMarkables = new HashMap();
        this.sContainerMarkables = new Hashtable();
        this.document = this.factory.newDocument(documentName);
        ArrayList sTextualDSList = new ArrayList(this.getDocument().getDocumentGraph().getTextualDSs());
        ArrayList sTextualRelationList = new ArrayList(this.getDocument().getDocumentGraph().getTextualRelations());
        int compteurId = 0;
        Hashtable correspondanceDsTextualRelations = new Hashtable();
        for (STextualRelation sTextualRelation : sTextualRelationList) {
            void var8_10;
            ArrayList arrayList = (ArrayList)correspondanceDsTextualRelations.get(sTextualRelation.getTarget());
            if (arrayList == null) {
                ArrayList arrayList2 = new ArrayList();
                correspondanceDsTextualRelations.put(sTextualRelation.getTarget(), arrayList2);
            }
            var8_10.add(sTextualRelation);
        }
        for (STextualDS sTextualDS : sTextualDSList) {
            String string = sTextualDS.getText();
            ArrayList listRelation = (ArrayList)correspondanceDsTextualRelations.get(sTextualDS);
            STextualRelation[] coveredCarachter = new STextualRelation[string.length()];
            if (listRelation != null) {
                for (STextualRelation sTextualRelation : listRelation) {
                    int start = (Integer)sTextualRelation.getStart();
                    int end = (Integer)sTextualRelation.getEnd();
                    for (int i = start; i < end; ++i) {
                        if (coveredCarachter[i] != null) {
                            throw new PepperModuleException("Unexportable Salt Document => Two STextualRelation span a same caracter/token at position '" + i + "':\n" + sTextualRelation + "\n" + coveredCarachter[i] + "\nAs Stokens and STextualRelations are, when available, mapped to MMax2 Base Data Units, they are not allowed to overlap.");
                        }
                        coveredCarachter[i] = sTextualRelation;
                    }
                }
            }
            ArrayList<String> spansTextualDS = new ArrayList<String>();
            for (int i = 0; i < coveredCarachter.length; ++i) {
                ++compteurId;
                if (coveredCarachter[i] != null) {
                    String text = string.substring((Integer)coveredCarachter[i].getStart(), (Integer)coveredCarachter[i].getEnd());
                    this.document.addBaseDataUnit(this.document.newBaseDataUnit("word_" + compteurId, text));
                    this.spanStextualRelationCorrespondance.put(coveredCarachter[i], compteurId);
                    i = (Integer)coveredCarachter[i].getEnd() - 1;
                } else {
                    this.document.addBaseDataUnit(this.document.newBaseDataUnit("word_" + compteurId, string.substring(i, i + 1)));
                }
                spansTextualDS.add("word_" + compteurId);
            }
            this.spanStextualDSCorrespondance.put(sTextualDS, spansTextualDS);
        }
        try {
            Set sLayers;
            SaltExtendedMarkableFactory.SaltExtendedMarkable markable;
            this.mapSDocument(compteurId);
            for (SLayer sLayer : new ArrayList(this.getDocument().getDocumentGraph().getLayers())) {
                this.mapSLayer(sLayer, compteurId);
            }
            ArrayList<Object> allSnodes = new ArrayList<Object>();
            ArrayList<Object> allSrelations = new ArrayList<Object>();
            for (STextualDS sTextualDS : sTextualDSList) {
                this.getSNodeMarkable((SNode)sTextualDS);
                allSnodes.add(sTextualDS);
            }
            for (STextualRelation sTextualRelation : sTextualRelationList) {
                this.getSRelationMarkable((SRelation)sTextualRelation);
                allSrelations.add(sTextualRelation);
            }
            for (SToken sToken : this.getDocument().getDocumentGraph().getTokens()) {
                this.getSNodeMarkable((SNode)sToken);
                allSnodes.add(sToken);
            }
            for (SSpanningRelation sSpanningRelation : this.getDocument().getDocumentGraph().getSpanningRelations()) {
                this.getSRelationMarkable((SRelation)sSpanningRelation);
                allSrelations.add(sSpanningRelation);
            }
            for (SSpan sSpan : this.getDocument().getDocumentGraph().getSpans()) {
                this.getSNodeMarkable((SNode)sSpan);
                allSnodes.add(sSpan);
            }
            for (SDominanceRelation sDominanceRelation : this.getDocument().getDocumentGraph().getDominanceRelations()) {
                this.getSRelationMarkable((SRelation)sDominanceRelation);
                allSrelations.add(sDominanceRelation);
            }
            for (SStructure sStructure : this.getDocument().getDocumentGraph().getStructures()) {
                this.getSNodeMarkable((SNode)sStructure);
                allSnodes.add(sStructure);
            }
            for (SPointingRelation sPointingRelation : this.getDocument().getDocumentGraph().getPointingRelations()) {
                this.getSRelationMarkable((SRelation)sPointingRelation);
                allSrelations.add(sPointingRelation);
            }
            for (SNode sNode : allSnodes) {
                markable = this.getSNodeMarkable(sNode);
                sLayers = sNode.getLayers();
                this.mapSMetaAnnotations(markable.getSName(), markable.getId(), (SAnnotationContainer)sNode, markable.getId(), markable.getSpan(), markable.getFactory().getScheme().getName(), sLayers);
                this.mapSAnnotations(markable.getSName(), markable.getId(), (SAnnotationContainer)sNode, markable.getId(), markable.getSpan(), markable.getFactory().getScheme().getName(), sLayers);
                if (sLayers.size() == 0) continue;
                this.mapSLayersToMarkable(markable, markable.getFactory().getScheme().getName(), sLayers);
            }
            for (SRelation sRelation : allSrelations) {
                markable = this.getSRelationMarkable(sRelation);
                sLayers = sRelation.getLayers();
                this.mapSMetaAnnotations(markable.getSName(), markable.getId(), (SAnnotationContainer)sRelation, markable.getId(), markable.getSpan(), markable.getFactory().getScheme().getName(), sLayers);
                this.mapSAnnotations(markable.getSName(), markable.getId(), (SAnnotationContainer)sRelation, markable.getId(), markable.getSpan(), markable.getFactory().getScheme().getName(), sLayers);
                if (sLayers.size() != 0) {
                    this.mapSLayersToMarkable(markable, markable.getFactory().getScheme().getName(), sLayers);
                }
                this.mapSTypesToMarkable(markable, markable.getFactory().getScheme().getName(), sRelation.getType());
            }
        }
        catch (MMAX2WrapperException e) {
            throw new PepperModuleException((PepperMapper)this, "", (Throwable)e);
        }
        this.corpus.addDocument(this.document);
        try {
            SaltExtendedFileGenerator.outputDocument(this.corpus, this.document);
        }
        catch (Exception e) {
            throw new PepperModuleException((PepperMapper)this, "", (Throwable)e);
        }
        return DOCUMENT_STATUS.COMPLETED;
    }

    private void mapSDocument(int lastBaseUnitId) throws MMAX2WrapperException {
        SDocument sDoc = this.getDocument();
        String markableSPan = this.makeSpan(1, lastBaseUnitId);
        String markableId = this.getNewId();
        SchemeFactory.Scheme scheme = this.getScheme("SDocument");
        String sName = sDoc.getName();
        String sId = sDoc.getId();
        SaltExtendedMarkableFactory.SaltExtendedMarkable markable = this.getMarkable(scheme, markableId, markableSPan, "SDocument", sName, sId);
        this.document.addMarkable(markable);
        this.mapSMetaAnnotations(sName, sId, (SAnnotationContainer)sDoc, markableId, markableSPan, "SDocument", null);
        this.mapSAnnotations(sName, sId, (SAnnotationContainer)sDoc, markableId, markableSPan, "SDocument", null);
        markableId = this.getNewId();
        scheme = this.getScheme("SDocumentGraph");
        sName = sDoc.getDocumentGraph().getName();
        sId = sDoc.getDocumentGraph().getId();
        markable = this.getMarkable(scheme, markableId, markableSPan, "SDocumentGraph", sName, sId);
        this.document.addMarkable(markable);
        this.mapSMetaAnnotations(sName, sId, (SAnnotationContainer)sDoc.getDocumentGraph(), markableId, markableSPan, "SDocumentGraph", null);
        this.mapSAnnotations(sName, sId, (SAnnotationContainer)sDoc.getDocumentGraph(), markableId, markableSPan, "SDocumentGraph", null);
    }

    private void mapSLayer(SLayer sLayer, int lastBaseUnitId) throws MMAX2WrapperException {
        String markableId = this.getNewId();
        String markableSPan = this.makeSpan(1, lastBaseUnitId);
        SchemeFactory.Scheme scheme = this.getScheme("SLayer");
        String sName = sLayer.getName();
        String sId = sLayer.getId();
        SaltExtendedMarkableFactory.SaltExtendedMarkable markable = this.getMarkable(scheme, markableId, markableSPan, "SLayer", sName, sId);
        this.registeredSLayerMarkables.put(sLayer, markable);
        this.document.addMarkable(markable);
        this.mapSMetaAnnotations(sName, sId, (SAnnotationContainer)sLayer, markableId, markableSPan, "SLayer", null);
        this.mapSAnnotations(sName, sId, (SAnnotationContainer)sLayer, markableId, markableSPan, "SLayer", null);
    }

    private SaltExtendedMarkableFactory.SaltExtendedMarkable mapSToken(SToken sToken) throws MMAX2WrapperException {
        return this.createMarkableForSNode(this.getNewId(), "", (SNode)sToken, "SToken");
    }

    private SaltExtendedMarkableFactory.SaltExtendedMarkable mapSpan(SSpan sSpan) throws MMAX2WrapperException {
        return this.createMarkableForSNode(this.getNewId(), "", (SNode)sSpan, "SSpan");
    }

    private SaltExtendedMarkableFactory.SaltExtendedMarkable mapStruct(SStructure struct) throws MMAX2WrapperException {
        ArrayList<SaltExtendedMarkableFactory.SaltExtendedMarkable> sDomRelMarkableList = new ArrayList<SaltExtendedMarkableFactory.SaltExtendedMarkable>();
        Hashtable<SaltExtendedMarkableFactory.SaltExtendedMarkable, SRelationMapping> sDomRelMarkableHash = new Hashtable<SaltExtendedMarkableFactory.SaltExtendedMarkable, SRelationMapping>();
        ArrayList<String> spans = new ArrayList<String>();
        for (SRelation rel : this.getDocument().getDocumentGraph().getOutRelations(struct.getId())) {
            if (!(rel instanceof SDominanceRelation)) continue;
            SDominanceRelation sDomRel = (SDominanceRelation)rel;
            SaltExtendedMarkableFactory.SaltExtendedMarkable sDomRelMarkable = this.getSRelationMarkable((SRelation)sDomRel);
            spans.add(sDomRelMarkable.getSpan());
            SRelationMapping validated = this.matchSRelation((SRelation)sDomRel);
            sDomRelMarkableList.add(sDomRelMarkable);
            if (validated == null) continue;
            sDomRelMarkableHash.put(sDomRelMarkable, validated);
        }
        SaltExtendedMarkableFactory.SaltExtendedMarkable markable = this.createMarkableForSNode(this.getNewId(), this.makeSpan(spans), (SNode)struct, "SStruct");
        for (SaltExtendedMarkableFactory.SaltExtendedMarkable sDomRelMarkable : sDomRelMarkableList) {
            if (sDomRelMarkableHash.containsKey((Object)sDomRelMarkable)) {
                SRelationMapping validated = (SRelationMapping)sDomRelMarkableHash.get((Object)sDomRelMarkable);
                SaltExtendedMarkableFactory.SaltExtendedMarkable containerSourceMarkable = this.getSContainerMarkable((Object)markable, validated.getSourceAssociatedSchemeName(), markable.getSpan(), markable.getSName(), markable.getId(), markable.getId(), markable.getFactory().getScheme().getName());
                this.addPointerAttribute(containerSourceMarkable, validated.getSourceAssociatedSchemeName(), validated.getTargetAssociatedSchemeName(), validated.getPointedAssociatedAttributeName(), sDomRelMarkable.getAttribute("id_target").getValue());
                sDomRelMarkable.removeAttribute(sDomRelMarkable.getAttribute("id_target"));
                this.addFreetextAttribute(sDomRelMarkable, "SDominanceRel", "struct_attr", validated.getPointedAssociatedAttributeName());
                this.addFreetextAttribute(sDomRelMarkable, "SDominanceRel", "struct_scheme", validated.getSourceAssociatedSchemeName());
                this.addFreetextAttribute(sDomRelMarkable, "SDominanceRel", "struct", containerSourceMarkable.getId());
                continue;
            }
            this.addPointerAttribute(sDomRelMarkable, "SDominanceRel", "SStruct", "struct", markable.getId());
        }
        return markable;
    }

    private SaltExtendedMarkableFactory.SaltExtendedMarkable mapSTextualDS(STextualDS sTextualDs) throws MMAX2WrapperException {
        return this.createMarkableForSNode(this.getNewId(), this.makeSpan(this.spanStextualDSCorrespondance.get(sTextualDs)), (SNode)sTextualDs, "STextualDS");
    }

    private SaltExtendedMarkableFactory.SaltExtendedMarkable mapDominanceRelation(SDominanceRelation domRel) throws MMAX2WrapperException {
        SaltExtendedMarkableFactory.SaltExtendedMarkable targetMarkable = this.getSNodeMarkable((SNode)domRel.getTarget());
        String markableId = this.getNewId();
        String markableSPan = targetMarkable.getSpan();
        SaltExtendedMarkableFactory.SaltExtendedMarkable markable = this.createMarkableForSRelation(markableId, markableSPan, (SRelation)domRel, "SDominanceRel");
        SRelationMapping validated = this.matchSRelation((SRelation)domRel);
        if (validated == null) {
            this.addFreetextAttribute(markable, "SDominanceRel", "target", targetMarkable.getId());
            this.addFreetextAttribute(markable, "SDominanceRel", "target_scheme", targetMarkable.getFactory().getScheme().getName());
        } else {
            SaltExtendedMarkableFactory.SaltExtendedMarkable containerTargetMarkable = this.getSContainerMarkable((Object)targetMarkable, validated.getTargetAssociatedSchemeName(), targetMarkable.getSpan(), targetMarkable.getSName(), targetMarkable.getId(), targetMarkable.getId(), targetMarkable.getFactory().getScheme().getName());
            this.addFreetextAttribute(markable, "SDominanceRel", "id_target", containerTargetMarkable.getId());
        }
        return markable;
    }

    private SaltExtendedMarkableFactory.SaltExtendedMarkable mapPointingRelation(SPointingRelation pointRel) throws MMAX2WrapperException {
        SaltExtendedMarkableFactory.SaltExtendedMarkable sourceMarkable = this.getSNodeMarkable((SNode)pointRel.getSource());
        SaltExtendedMarkableFactory.SaltExtendedMarkable targetMarkable = this.getSNodeMarkable((SNode)pointRel.getTarget());
        String markableId = this.getNewId();
        String markableSPan = sourceMarkable.getSpan();
        SaltExtendedMarkableFactory.SaltExtendedMarkable markable = this.createMarkableForSRelation(markableId, markableSPan, (SRelation)pointRel, "SPointingRel");
        SRelationMapping validated = this.matchSRelation((SRelation)pointRel);
        if (validated == null) {
            this.addFreetextAttribute(markable, "SPointingRel", "source_scheme", sourceMarkable.getFactory().getScheme().getName());
            this.addFreetextAttribute(markable, "SPointingRel", "source", sourceMarkable.getId());
            this.addFreetextAttribute(markable, "SPointingRel", "target_scheme", targetMarkable.getFactory().getScheme().getName());
            this.addFreetextAttribute(markable, "SPointingRel", "target", targetMarkable.getId());
        } else {
            SaltExtendedMarkableFactory.SaltExtendedMarkable containerSourceMarkable = this.getSContainerMarkable((Object)sourceMarkable, validated.getSourceAssociatedSchemeName(), sourceMarkable.getSpan(), sourceMarkable.getSName(), sourceMarkable.getId(), sourceMarkable.getId(), sourceMarkable.getFactory().getScheme().getName());
            SaltExtendedMarkableFactory.SaltExtendedMarkable containerTargetMarkable = this.getSContainerMarkable((Object)targetMarkable, validated.getTargetAssociatedSchemeName(), targetMarkable.getSpan(), targetMarkable.getSName(), targetMarkable.getId(), targetMarkable.getId(), targetMarkable.getFactory().getScheme().getName());
            this.addPointerAttribute(containerSourceMarkable, validated.getSourceAssociatedSchemeName(), validated.getTargetAssociatedSchemeName(), validated.getPointedAssociatedAttributeName(), containerTargetMarkable.getId());
            this.addFreetextAttribute(markable, "SPointingRel", "source_attr", validated.getPointedAssociatedAttributeName());
            this.addFreetextAttribute(markable, "SPointingRel", "source_scheme", validated.getSourceAssociatedSchemeName());
            this.addFreetextAttribute(markable, "SPointingRel", "source", containerSourceMarkable.getId());
        }
        return markable;
    }

    private SaltExtendedMarkableFactory.SaltExtendedMarkable mapSpanningRelation(SSpanningRelation sSpanningRel) throws MMAX2WrapperException {
        SaltExtendedMarkableFactory.SaltExtendedMarkable tokenMarkable = this.getSNodeMarkable((SNode)sSpanningRel.getTarget());
        SaltExtendedMarkableFactory.SaltExtendedMarkable spanMarkable = this.getSNodeMarkable((SNode)sSpanningRel.getSource());
        String markableSpan = tokenMarkable.getSpan();
        String markableId = this.getNewId();
        spanMarkable.addSpan(markableSpan);
        SaltExtendedMarkableFactory.SaltExtendedMarkable markable = this.createMarkableForSRelation(markableId, markableSpan, (SRelation)sSpanningRel, "SSpanningRel");
        this.addPointerAttribute(markable, "SSpanningRel", "SSpan", "source_span", spanMarkable.getId());
        this.addPointerAttribute(markable, "SSpanningRel", "SToken", "target_token", tokenMarkable.getId());
        return markable;
    }

    private SaltExtendedMarkableFactory.SaltExtendedMarkable mapTextualRelation(STextualRelation sTextualRelation) throws MMAX2WrapperException {
        SaltExtendedMarkableFactory.SaltExtendedMarkable markable = null;
        SaltExtendedMarkableFactory.SaltExtendedMarkable tokenMarkable = this.getSNodeMarkable((SNode)sTextualRelation.getSource());
        SaltExtendedMarkableFactory.SaltExtendedMarkable textualDsMarkable = this.getSNodeMarkable((SNode)sTextualRelation.getTarget());
        String markableId = this.getNewId();
        Integer i = this.spanStextualRelationCorrespondance.get(sTextualRelation);
        String markableSPan = this.makeSpan(i);
        tokenMarkable.setSpan(markableSPan);
        markable = this.createMarkableForSRelation(markableId, markableSPan, (SRelation)sTextualRelation, "STextualRel");
        this.addPointerAttribute(markable, "STextualRel", "SToken", "target_token", tokenMarkable.getId());
        this.addPointerAttribute(markable, "STextualRel", "STextualDS", "target_textual_ds", textualDsMarkable.getId());
        return markable;
    }

    public SaltExtendedMarkableFactory.SaltExtendedMarkable createMarkableForSNode(String markableId, String markableSpan, SNode sNode, String markableSKind) throws MMAX2WrapperException {
        SchemeFactory.Scheme scheme = this.getScheme(markableSKind);
        String sName = sNode.getName();
        String sId = sNode.getId();
        SaltExtendedMarkableFactory.SaltExtendedMarkable markable = this.getMarkable(scheme, markableId, markableSpan, markableSKind, sName, sId);
        this.document.addMarkable(markable);
        return markable;
    }

    public SaltExtendedMarkableFactory.SaltExtendedMarkable createMarkableForSRelation(String markableId, String markableSpan, SRelation sRelation, String markableSKind) throws MMAX2WrapperException {
        SchemeFactory.Scheme scheme = this.getScheme(markableSKind);
        String sName = sRelation.getName();
        String sId = sRelation.getId();
        SaltExtendedMarkableFactory.SaltExtendedMarkable markable = this.getMarkable(scheme, markableId, markableSpan, markableSKind, sName, sId);
        this.document.addMarkable(markable);
        return markable;
    }

    public void addPointerAttribute(SaltExtendedMarkableFactory.SaltExtendedMarkable markable, String schemeName, String targetScheme, String attributeName, String targetId) throws MMAX2WrapperException {
        SchemeFactory.Scheme scheme = this.getScheme(schemeName);
        SchemeFactory.MarkablePointerAttributeFactory pointerAttributeFactory = this.getMarkablePointerAttributeFactory(scheme, attributeName, targetScheme);
        markable.addAttribute((SchemeFactory.MarkableAttributeFactory.MarkableAttribute)pointerAttributeFactory.newAttribute(targetId));
    }

    public void addNominalAttribute(SaltExtendedMarkableFactory.SaltExtendedMarkable markable, String schemeName, String attributeName, String attributeValue) throws MMAX2WrapperException {
        SchemeFactory.Scheme scheme = this.getScheme(schemeName);
        SchemeFactory.MarkableNominalAttributeFactory typeAttributeFactory = this.getMarkableNominalAttributeFactory(scheme, attributeName);
        if (!typeAttributeFactory.isValueAccepted(attributeValue)) {
            typeAttributeFactory.enableValue(attributeValue);
        }
        markable.addAttribute((SchemeFactory.MarkableAttributeFactory.MarkableAttribute)typeAttributeFactory.newAttribute(attributeValue));
    }

    public void addFreetextAttribute(SaltExtendedMarkableFactory.SaltExtendedMarkable markable, String schemeName, String attributeName, String attributeValue) throws MMAX2WrapperException {
        SchemeFactory.Scheme scheme = this.getScheme(schemeName);
        SchemeFactory.MarkableFreetextAttributeFactory typeAttributeFactory = this.getMarkableFreetextAttributeFactory(scheme, attributeName);
        markable.addAttribute((SchemeFactory.MarkableAttributeFactory.MarkableAttribute)typeAttributeFactory.newAttribute(attributeValue));
    }

    public void addSetAttribute(SaltExtendedMarkableFactory.SaltExtendedMarkable markable, String schemeName, String attributeName, String attributeValue) throws MMAX2WrapperException {
        SchemeFactory.Scheme scheme = this.getScheme(schemeName);
        SchemeFactory.MarkableSetAttributeFactory typeAttributeFactory = this.getMarkableSetAttributeFactory(scheme, attributeName);
        markable.addAttribute((SchemeFactory.MarkableAttributeFactory.MarkableAttribute)typeAttributeFactory.newAttribute(attributeValue));
    }

    private void mapSAnnotations(String sName, String sId, SAnnotationContainer sElem, String markableId, String markableSpan, String schemeBaseName, Set<SLayer> sLayers) throws MMAX2WrapperException {
        for (SAnnotation sAnnotation : sElem.getAnnotations()) {
            this.mapAnnotations(sElem, "SAnnotation", sName, sId, markableId, markableSpan, schemeBaseName, (SAbstractAnnotation)sAnnotation, sLayers);
        }
    }

    private void mapSMetaAnnotations(String sName, String sId, SAnnotationContainer sElem, String markableId, String markableSpan, String schemeBaseName, Set<SLayer> sLayers) throws MMAX2WrapperException {
        for (SMetaAnnotation sAnnotation : sElem.getMetaAnnotations()) {
            this.mapAnnotations(sElem, "SMetaAnnotation", sName, sId, markableId, markableSpan, schemeBaseName, (SAbstractAnnotation)sAnnotation, sLayers);
        }
    }

    private void mapAnnotations(Object sELem, String sType, String sName, String sId, String idRef, String span, String schemeBaseName, SAbstractAnnotation annotation, Set<SLayer> sLayers) throws MMAX2WrapperException {
        String attributeName = annotation.getName();
        String attributeValue = annotation.getValue_STEXT();
        String attributeNs = annotation.getNamespace();
        String schemeName = schemeBaseName + "_" + sType;
        SchemeFactory.Scheme scheme = this.getScheme(schemeName);
        SaltExtendedMarkableFactory.SaltExtendedMarkable markable = this.getMarkable(scheme, this.getNewId(), span, sType, sName, sId);
        this.addFreetextAttribute(markable, schemeName, "namespace", attributeNs);
        this.addFreetextAttribute(markable, schemeName, "attr_name", attributeName);
        SaltExtendedMarkableFactory.SaltExtendedMarkable containerMarkable = null;
        SAnnotationMapping validated = this.matchSNode(annotation, sLayers);
        if (validated != null) {
            containerMarkable = this.getSContainerMarkable(sELem, validated.getAssociatedSchemeName(), span, sName, sId, idRef, schemeBaseName);
            String attributeContainerName = validated.getAssociatedAttributeName();
            if (!attributeContainerName.equals("@none")) {
                if (containerMarkable.getAttribute(attributeContainerName) != null) {
                    throw new PepperModuleException((PepperMapper)this, "Matched markable '" + (Object)((Object)markable) + "' has already an attribute '" + attributeContainerName + "'");
                }
                this.addFreetextAttribute(containerMarkable, validated.getAssociatedSchemeName(), attributeContainerName, attributeValue);
            }
        }
        if (containerMarkable != null) {
            this.addFreetextAttribute(markable, schemeName, "target_markable", containerMarkable.getId());
            this.addFreetextAttribute(markable, schemeName, "container_scheme", validated.getAssociatedSchemeName());
            this.addFreetextAttribute(markable, schemeName, "container_attr", validated.getAssociatedAttributeName());
        } else {
            this.addFreetextAttribute(markable, schemeName, "target_markable", idRef);
            this.addFreetextAttribute(markable, schemeName, "value", attributeValue);
        }
        this.document.addMarkable(markable);
    }

    private void mapSLayersToMarkable(SaltExtendedMarkableFactory.SaltExtendedMarkable markable, String markableSKind, Set<SLayer> sLayers) throws MMAX2WrapperException {
        String schemeName = markableSKind + "_slayer_link";
        SchemeFactory.Scheme scheme = this.getScheme(schemeName);
        for (SLayer sLayer : sLayers) {
            SaltExtendedMarkableFactory.SaltExtendedMarkable linkMarkable = this.getMarkable(scheme, this.getNewId(), markable.getSpan(), "SLayer_link", markable.getSName(), markable.getId());
            SaltExtendedMarkableFactory.SaltExtendedMarkable sLayerMarkable = this.registeredSLayerMarkables.get(sLayer);
            this.addPointerAttribute(linkMarkable, schemeName, markableSKind, "selement", markable.getId());
            this.addPointerAttribute(linkMarkable, schemeName, "SLayer", "slayer", sLayerMarkable.getId());
            this.document.addMarkable(linkMarkable);
        }
    }

    private void mapSTypesToMarkable(SaltExtendedMarkableFactory.SaltExtendedMarkable markable, String markableSKind, String sType) throws MMAX2WrapperException {
        String schemeName = markableSKind + "_stype_link";
        SchemeFactory.Scheme scheme = this.getScheme(schemeName);
        SaltExtendedMarkableFactory.SaltExtendedMarkable linkMarkable = this.getMarkable(scheme, this.getNewId(), markable.getSpan(), "SType_link", markable.getSName(), markable.getId());
        this.addPointerAttribute(linkMarkable, schemeName, markableSKind, "selement", markable.getId());
        this.addFreetextAttribute(linkMarkable, schemeName, "stype", sType);
        this.document.addMarkable(linkMarkable);
    }

    private SchemeFactory.Scheme getScheme(String schemeName) {
        SchemeFactory.Scheme scheme = this.corpus.getScheme(schemeName);
        if (scheme == null) {
            scheme = this.schemeFactory.newScheme(schemeName);
            this.corpus.addScheme(scheme);
        }
        return scheme;
    }

    private SaltExtendedMarkableFactory.SaltExtendedMarkable getMarkable(SchemeFactory.Scheme scheme, String markableId, String markableSpan, String sType, String sName, String sId) {
        SaltExtendedMarkableFactory markableFactory = this.document.getFactory().getMarkableFactory(scheme);
        if (markableFactory == null) {
            markableFactory = new SaltExtendedMarkableFactory(scheme, this.documentBuilder);
            this.document.getFactory().addMarkableFactory(markableFactory);
        }
        SaltExtendedMarkableFactory.SaltExtendedMarkable markable = markableFactory.newMarkable(markableId, markableSpan, new ArrayList<SchemeFactory.MarkableAttributeFactory.MarkableAttribute>(), sType, sName, sId);
        return markable;
    }

    private SaltExtendedMarkableFactory.SaltExtendedMarkable getSContainerMarkable(Object sElem, String schemeName, String span, String sName, String sId, String containedId, String containedScheme) {
        if (!this.sContainerMarkables.containsKey(sElem)) {
            this.sContainerMarkables.put(sElem, new Hashtable());
        }
        Hashtable<SchemeFactory.Scheme, SaltExtendedMarkableFactory.SaltExtendedMarkableContainer> associatedMarkables = this.sContainerMarkables.get(sElem);
        SaltExtendedMarkableFactory.SaltExtendedMarkableContainer containerMarkable = null;
        SchemeFactory.Scheme associatedScheme = this.getScheme(schemeName);
        if (!associatedMarkables.containsKey(associatedScheme)) {
            SaltExtendedMarkableFactory markableFactory = this.document.getFactory().getMarkableFactory(associatedScheme);
            if (markableFactory == null) {
                markableFactory = new SaltExtendedMarkableFactory(associatedScheme, this.documentBuilder);
                this.document.getFactory().addMarkableFactory(markableFactory);
            }
            containerMarkable = markableFactory.newMarkableContainer(this.getNewId(), span, new ArrayList<SchemeFactory.MarkableAttributeFactory.MarkableAttribute>(), "SContainer", sName, sId, containedId, containedScheme);
            associatedMarkables.put(associatedScheme, containerMarkable);
            this.document.addMarkable(containerMarkable);
        } else {
            containerMarkable = associatedMarkables.get(associatedScheme);
        }
        return containerMarkable;
    }

    private SchemeFactory.MarkableNominalAttributeFactory getMarkableNominalAttributeFactory(SchemeFactory.Scheme scheme, String attributeName) {
        SchemeFactory.MarkableAttributeFactory attributeFactory = scheme.getAttributeFactory(attributeName);
        if (attributeFactory == null) {
            attributeFactory = this.schemeFactory.newMarkableNominalAttributeFactory(scheme, attributeName);
            scheme.addMarkableAttributeFactory(attributeFactory);
        }
        return (SchemeFactory.MarkableNominalAttributeFactory)attributeFactory;
    }

    private SchemeFactory.MarkablePointerAttributeFactory getMarkablePointerAttributeFactory(SchemeFactory.Scheme scheme, String attributeName, String targetSchemeName) {
        SchemeFactory.MarkableAttributeFactory attributeFactory = scheme.getAttributeFactory(attributeName);
        if (attributeFactory == null) {
            attributeFactory = this.schemeFactory.newMarkablePointerAttributeFactory(scheme, attributeName, targetSchemeName);
            scheme.addMarkableAttributeFactory(attributeFactory);
        }
        return (SchemeFactory.MarkablePointerAttributeFactory)attributeFactory;
    }

    private SchemeFactory.MarkableFreetextAttributeFactory getMarkableFreetextAttributeFactory(SchemeFactory.Scheme scheme, String attributeName) {
        SchemeFactory.MarkableAttributeFactory attributeFactory = scheme.getAttributeFactory(attributeName);
        if (attributeFactory == null) {
            attributeFactory = this.schemeFactory.newMarkableFreetextAttributeFactory(scheme, attributeName);
            scheme.addMarkableAttributeFactory(attributeFactory);
        }
        return (SchemeFactory.MarkableFreetextAttributeFactory)attributeFactory;
    }

    private SchemeFactory.MarkableSetAttributeFactory getMarkableSetAttributeFactory(SchemeFactory.Scheme scheme, String attributeName) {
        SchemeFactory.MarkableAttributeFactory attributeFactory = scheme.getAttributeFactory(attributeName);
        if (attributeFactory == null) {
            attributeFactory = this.schemeFactory.newMarkableSetAttributeFactory(scheme, attributeName);
            scheme.addMarkableAttributeFactory(attributeFactory);
        }
        return (SchemeFactory.MarkableSetAttributeFactory)attributeFactory;
    }

    public SAnnotationMapping matchSNode(SAbstractAnnotation annotation, Set<SLayer> sLayers) {
        SAnnotationMapping validated = null;
        for (SAnnotationMapping mapping : this.sannotationmappings) {
            if (!mapping.isMatched(annotation, sLayers)) continue;
            if (validated != null) {
                throw new PepperModuleException((PepperMapper)this, "Ambiguous matching confitions '" + validated + "' and '" + mapping + "' have both matched on '" + annotation + "/" + sLayers + "'");
            }
            validated = mapping;
        }
        return validated;
    }

    public SRelationMapping matchSRelation(SRelation sRelation) {
        SRelationMapping validated = null;
        for (SRelationMapping mapping : this.srelationMappings) {
            if (!mapping.isMatched(sRelation)) continue;
            if (validated != null) {
                throw new PepperModuleException((PepperMapper)this, "Ambiguous matching confitions '" + validated + "' and '" + mapping + "' have both matched '" + sRelation + "'");
            }
            validated = mapping;
        }
        return validated;
    }
}

