/*
 * Decompiled with CFR 0.152.
 */
package edu.eurac.commul.pepperModules.mmax2;

import edu.eurac.commul.pepperModules.mmax2.SAnnotationMatchCondition;
import java.util.Set;
import java.util.regex.Pattern;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.salt.SDATATYPE;
import org.corpus_tools.salt.core.SAbstractAnnotation;
import org.corpus_tools.salt.core.SLayer;

class SAnnotationStringValueMatchCondition
extends SAnnotationMatchCondition {
    private Pattern stringValuePattern;

    public SAnnotationStringValueMatchCondition(Pattern stringValuePattern) {
        this.stringValuePattern = stringValuePattern;
    }

    @Override
    public boolean isMatched(SAbstractAnnotation sannotation, Set<SLayer> sLayers) {
        String stringValue = "";
        SDATATYPE dataType = sannotation.getValueType();
        switch (dataType) {
            case SBOOLEAN: {
                stringValue = "" + sannotation.getValue_SBOOLEAN();
                break;
            }
            case SFLOAT: {
                stringValue = "" + sannotation.getValue_SFLOAT();
                break;
            }
            case SNUMERIC: {
                stringValue = "" + sannotation.getValue_SNUMERIC();
                break;
            }
            case STEXT: {
                stringValue = "" + sannotation.getValue_STEXT();
                break;
            }
            case SURI: {
                stringValue = "" + sannotation.getValue_SURI();
                break;
            }
            case SOBJECT: {
                stringValue = "" + sannotation.getValue_SOBJECT().toString();
                break;
            }
            default: {
                throw new PepperModuleException("Unknown type of SDATATYPE '" + dataType + "'");
            }
        }
        return this.stringValuePattern.matcher(stringValue).matches();
    }
}

