/*
 * Decompiled with CFR 0.152.
 */
package edu.eurac.commul.pepperModules.mmax2;

import edu.eurac.commul.pepperModules.mmax2.MMAX22SaltMapper;
import edu.eurac.commul.pepperModules.mmax2.SaltExtendedCorpusFactory;
import edu.eurac.commul.pepperModules.mmax2.SaltExtendedDocumentFactory;
import java.io.File;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilderFactory;
import org.corpus_tools.pepper.impl.PepperImporterImpl;
import org.corpus_tools.pepper.modules.PepperImporter;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.PepperModule;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SCorpus;
import org.corpus_tools.salt.common.SCorpusGraph;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.graph.Graph;
import org.corpus_tools.salt.graph.Identifier;
import org.eclipse.emf.common.util.URI;
import org.osgi.service.component.annotations.Component;

@Component(name="MMAX2ImporterComponent", factory="PepperImporterComponentFactory")
public class MMAX2Importer
extends PepperImporterImpl
implements PepperImporter {
    private SaltExtendedDocumentFactory saltExtendedDocumentFactory = null;
    private SaltExtendedCorpusFactory.SaltExtendedCorpus corpus;

    public MMAX2Importer() {
        this.setName("MMAX2Importer");
        this.setSupplierHomepage(URI.createURI((String)"https://github.com/korpling/pepperModules-MMAX2Modules"));
        this.setDesc("The MMAX2Importer maps files produced by the MMAX2 tool to a Salt model.");
        this.addSupportedFormat("mmax2", "1.0", null);
    }

    public void importCorpusStructure(SCorpusGraph sCorpusGraph) throws PepperModuleException {
        if (this.getCorpusDesc().getCorpusPath() == null) {
            throw new PepperModuleException((PepperModule)this, "Cannot import corpus-structure, because no corpus-path is given.");
        }
        SCorpus sCorpus = SaltFactory.createSCorpus();
        this.setCorpusGraph(sCorpusGraph);
        URI corpusUri = this.getCorpusDesc().getCorpusPath();
        try {
            SaltExtendedCorpusFactory factory = new SaltExtendedCorpusFactory(DocumentBuilderFactory.newInstance().newDocumentBuilder());
            String currentPath = corpusUri.toFileString();
            File corpusPath = new File(currentPath);
            this.corpus = factory.getCorpus(corpusUri.toFileString());
            sCorpus.setName(corpusPath.getName());
            this.getCorpusGraph().setName(corpusPath.getName() + "_graph");
            sCorpus.setGraph((Graph)this.getCorpusGraph());
            ArrayList documentsIds = factory.getDocumentIds(corpusUri.path());
            if (documentsIds.size() == 0) {
                throw new PepperModuleException((PepperModule)this, "No documents found for the corpus in '" + corpusUri.toFileString() + "'");
            }
            for (String documentId : documentsIds) {
                this.getCorpusGraph().createDocument(sCorpus, documentId);
            }
            this.saltExtendedDocumentFactory = new SaltExtendedDocumentFactory(this.corpus, DocumentBuilderFactory.newInstance().newDocumentBuilder());
        }
        catch (Exception exception) {
            throw new PepperModuleException((PepperModule)this, "Cannot import corpus structure '" + corpusUri.toFileString() + "'. The reason is: ", (Throwable)exception);
        }
    }

    public PepperMapper createPepperMapper(Identifier sElementId) {
        MMAX22SaltMapper mapper = new MMAX22SaltMapper();
        if (sElementId.getIdentifiableElement() instanceof SDocument) {
            SDocument sDocument = (SDocument)sElementId.getIdentifiableElement();
            try {
                SaltExtendedDocumentFactory.SaltExtendedDocument extendedDocument = this.saltExtendedDocumentFactory.getDocument(sDocument.getName());
                mapper.setDocument(extendedDocument);
            }
            catch (Exception e) {
                throw new PepperModuleException((PepperModule)this, "Cannot create mmax2 document for SDocument '" + sElementId.getId() + "' because of nested exception.", (Throwable)e);
            }
        } else if (sElementId.getIdentifiableElement() instanceof SCorpus) {
            mapper.setCorpus((SCorpus)sElementId.getIdentifiableElement());
        }
        return mapper;
    }
}

