/*
 * Decompiled with CFR 0.152.
 */
package edu.eurac.commul.pepperModules.mmax2;

import edu.eurac.commul.annotations.mmax2.mmax2wrapper.CorpusFactory;
import edu.eurac.commul.annotations.mmax2.mmax2wrapper.MMAX2WrapperException;
import edu.eurac.commul.annotations.mmax2.mmax2wrapper.SchemeFactory;
import edu.eurac.commul.pepperModules.mmax2.MMAX2ExporterProperties;
import edu.eurac.commul.pepperModules.mmax2.SAnnotationMapping;
import edu.eurac.commul.pepperModules.mmax2.SRelationMapping;
import edu.eurac.commul.pepperModules.mmax2.Salt2MMAX2Mapper;
import edu.eurac.commul.pepperModules.mmax2.Salt2MMAXMapping;
import edu.eurac.commul.pepperModules.mmax2.SaltExtendedCorpusFactory;
import edu.eurac.commul.pepperModules.mmax2.SaltExtendedDocumentFactory;
import edu.eurac.commul.pepperModules.mmax2.SaltExtendedFileGenerator;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.corpus_tools.pepper.impl.PepperExporterImpl;
import org.corpus_tools.pepper.modules.PepperExporter;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.PepperModule;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.salt.graph.Identifier;
import org.eclipse.emf.common.util.URI;
import org.osgi.service.component.annotations.Component;

@Component(name="MMAX2ExporterComponent", factory="PepperExporterComponentFactory")
public class MMAX2Exporter
extends PepperExporterImpl
implements PepperExporter {
    private SaltExtendedCorpusFactory.SaltExtendedCorpus corpus;
    private SchemeFactory schemeFactory;
    private SaltExtendedDocumentFactory documentFactory;
    private ArrayList<SAnnotationMapping> sannotationMappings;
    private ArrayList<SRelationMapping> srelationsMappings;

    public MMAX2Exporter() {
        this.setName("MMAX2Exporter");
        this.setProperties(new MMAX2ExporterProperties());
        this.setSupplierContact(URI.createURI((String)"lionel.nicolas@eurac.edu"));
        this.setSupplierHomepage(URI.createURI((String)"https://github.com/korpling/pepperModules-MMAX2Modules"));
        this.setDesc("The MMAX2Exporter maps a Salt model to the MMAX2 format.");
        this.addSupportedFormat("mmax2", "1.0", null);
    }

    public void exportCorpusStructure() {
        DocumentBuilder documentBuilder;
        try {
            documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new PepperModuleException((PepperModule)this, "Could not create a new document builder", (Throwable)e);
        }
        MMAX2ExporterProperties props = (MMAX2ExporterProperties)this.getProperties();
        try {
            this.sannotationMappings = Salt2MMAXMapping.getSAnnotationMappingsFromFile(props);
            this.srelationsMappings = Salt2MMAXMapping.getSRelationMappingsFromFile(props);
        }
        catch (Exception e) {
            throw new PepperModuleException((PepperModule)this, "Could not parse mappings", (Throwable)e);
        }
        this.corpus = new SaltExtendedCorpusFactory(documentBuilder).newEmptyCorpus(this.getCorpusDesc().getCorpusPath().toFileString());
        this.schemeFactory = new SchemeFactory((CorpusFactory.Corpus)this.corpus, documentBuilder);
        this.documentFactory = new SaltExtendedDocumentFactory(this.corpus, documentBuilder);
        try {
            SaltExtendedFileGenerator.initializeCorpus(this.corpus);
        }
        catch (IOException e) {
            throw new PepperModuleException((PepperModule)this, "Could not init corpus", (Throwable)e);
        }
        catch (MMAX2WrapperException e) {
            throw new PepperModuleException((PepperModule)this, "Could not init corpus", (Throwable)e);
        }
    }

    public PepperMapper createPepperMapper(Identifier sElementId) {
        DocumentBuilder documentBuilder;
        try {
            documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new PepperModuleException((PepperModule)this, "Could not create a document builder", (Throwable)e);
        }
        Salt2MMAX2Mapper mapper = null;
        if (sElementId.getIdentifiableElement() != null) {
            mapper = new Salt2MMAX2Mapper(documentBuilder, this.schemeFactory, this.documentFactory, this.sannotationMappings, this.srelationsMappings);
        }
        return mapper;
    }

    public void end() throws PepperModuleException {
        try {
            SaltExtendedFileGenerator.finalizeCorpus(this.corpus);
        }
        catch (Exception e) {
            throw new PepperModuleException((PepperModule)this, "Could not finalize corpus", (Throwable)e);
        }
    }
}

