/*
 * Decompiled with CFR 0.152.
 */
package edu.eurac.commul.pepperModules.mmax2;

import edu.eurac.commul.annotations.mmax2.mmax2wrapper.DocumentFactory;
import edu.eurac.commul.annotations.mmax2.mmax2wrapper.SchemeFactory;
import edu.eurac.commul.pepperModules.mmax2.SaltExtendedDocumentFactory;
import edu.eurac.commul.pepperModules.mmax2.SaltExtendedMarkableFactory;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.impl.PepperMapperImpl;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleDataException;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SDominanceRelation;
import org.corpus_tools.salt.common.SPointingRelation;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.SSpanningRelation;
import org.corpus_tools.salt.common.SStructure;
import org.corpus_tools.salt.common.SStructuredNode;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.STextualRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SAnnotationContainer;
import org.corpus_tools.salt.core.SLayer;
import org.corpus_tools.salt.core.SMetaAnnotation;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.graph.IdentifiableElement;
import org.corpus_tools.salt.graph.Layer;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;

public class MMAX22SaltMapper
extends PepperMapperImpl {
    private Hashtable<SaltExtendedMarkableFactory.SaltExtendedMarkable, SNode> sNodesHash;
    private Hashtable<SaltExtendedMarkableFactory.SaltExtendedMarkable, SRelation> sRelationsHash;
    private Hashtable<String, SLayer> sLayerHash;
    private Hashtable<STextualDS, Integer> sTextualDsOfset;
    private Hashtable<String, SToken> sTokensHash;
    private Hashtable<String, Hashtable<String, SaltExtendedMarkableFactory.SaltExtendedMarkable>> saltExtendedMarkableHash;
    private Hashtable<String, STextualDS> sTextualDsBaseDataUnitCorrespondance;
    private Hashtable<SaltExtendedMarkableFactory.SaltExtendedMarkable, SaltExtendedMarkableFactory.SaltExtendedMarkable> claimSContainer;
    private Hashtable<String, IdentifiableElement> saltIds;
    private SaltExtendedDocumentFactory.SaltExtendedDocument document = null;

    public SaltExtendedDocumentFactory.SaltExtendedDocument getEDocument() {
        return this.document;
    }

    public void setDocument(SaltExtendedDocumentFactory.SaltExtendedDocument document) {
        this.document = document;
    }

    public DOCUMENT_STATUS mapSCorpus() {
        return DOCUMENT_STATUS.COMPLETED;
    }

    public DOCUMENT_STATUS mapSDocument() {
        if (this.getDocument().getDocumentGraph() == null) {
            this.getDocument().setDocumentGraph(SaltFactory.createSDocumentGraph());
        }
        if (this.getDocument() == null) {
            throw new PepperModuleException((PepperMapper)this, "Cannot start mapping, because no mmax2 document was given.");
        }
        this.mapSDocument(this.getEDocument(), this.getDocument());
        return DOCUMENT_STATUS.COMPLETED;
    }

    public void mapSDocument(SaltExtendedDocumentFactory.SaltExtendedDocument document, SDocument sDocument) {
        int i;
        this.sNodesHash = new Hashtable();
        this.sRelationsHash = new Hashtable();
        this.sLayerHash = new Hashtable();
        this.sTextualDsOfset = new Hashtable();
        this.sTokensHash = new Hashtable();
        this.saltExtendedMarkableHash = new Hashtable();
        this.sTextualDsBaseDataUnitCorrespondance = new Hashtable();
        this.claimSContainer = new Hashtable();
        this.saltIds = new Hashtable();
        SDocumentGraph sDocumentGraph = sDocument.getDocumentGraph();
        sDocumentGraph.setName(document.getDocumentId() + "_graph");
        ArrayList<SaltExtendedMarkableFactory.SaltExtendedMarkable> markables = document.getAllSaltExtendedMarkables();
        Hashtable<String, SaltExtendedMarkableFactory.SaltExtendedMarkable> baseDataUnitInTextualDS = new Hashtable<String, SaltExtendedMarkableFactory.SaltExtendedMarkable>();
        for (SaltExtendedMarkableFactory.SaltExtendedMarkable markable : markables) {
            if (!markable.hasSaltInformation() || !markable.getSType().equals("STextualDS")) continue;
            String[] markableSpans = markable.getSpan().split(",");
            for (int i2 = 0; i2 < markableSpans.length; ++i2) {
                ArrayList<String> baseDataUnits = this.getBaseUnitIds(markableSpans[i2]);
                for (String baseDataUnit : baseDataUnits) {
                    if (baseDataUnitInTextualDS.containsKey(baseDataUnit)) {
                        throw new PepperModuleDataException((PepperMapper)this, "Two textualDS covers one same basedata unit: markables '" + markable.getId() + "' and '" + ((SaltExtendedMarkableFactory.SaltExtendedMarkable)((Object)baseDataUnitInTextualDS.get(baseDataUnit))).getId() + "' both covers '" + baseDataUnit + "'");
                    }
                    baseDataUnitInTextualDS.put(baseDataUnit, markable);
                }
            }
        }
        int nbBaseDataUnits = 0;
        Hashtable<String, int[]> indicesTokens = new Hashtable<String, int[]>();
        Hashtable<SaltExtendedMarkableFactory.SaltExtendedMarkable, ArrayList<DocumentFactory.Document.BaseDataUnit>> sTextualDSBaseDataUnits = new Hashtable<SaltExtendedMarkableFactory.SaltExtendedMarkable, ArrayList<DocumentFactory.Document.BaseDataUnit>>();
        SaltExtendedMarkableFactory.SaltExtendedMarkable lastTextualDsMarkable = null;
        ArrayList<Object> bufferBaseDataUnit = new ArrayList<DocumentFactory.Document.BaseDataUnit>();
        ArrayList baseDataUnits = document.getBaseDataUnits();
        int indice = 0;
        Hashtable<SaltExtendedMarkableFactory.SaltExtendedMarkable, String> previouslySeenTextualDs = new Hashtable<SaltExtendedMarkableFactory.SaltExtendedMarkable, String>();
        nbBaseDataUnits = baseDataUnits.size();
        for (DocumentFactory.Document.BaseDataUnit baseDataUnit : baseDataUnits) {
            int newIndice = indice + baseDataUnit.getText().length();
            int[] indices = new int[]{indice, newIndice};
            indicesTokens.put(baseDataUnit.getId(), indices);
            indice = newIndice;
            bufferBaseDataUnit.add(baseDataUnit);
            if (!baseDataUnitInTextualDS.containsKey(baseDataUnit.getId())) continue;
            SaltExtendedMarkableFactory.SaltExtendedMarkable textualDsMarkable = (SaltExtendedMarkableFactory.SaltExtendedMarkable)((Object)baseDataUnitInTextualDS.get(baseDataUnit.getId()));
            if (textualDsMarkable != lastTextualDsMarkable && previouslySeenTextualDs.containsKey((Object)textualDsMarkable)) {
                throw new PepperModuleDataException((PepperMapper)this, "The spans of textualDs markables '" + textualDsMarkable.getId() + "' and '" + (Object)((Object)lastTextualDsMarkable) + "' overlap one another.");
            }
            lastTextualDsMarkable = textualDsMarkable;
            previouslySeenTextualDs.put(lastTextualDsMarkable, "");
            ArrayList<DocumentFactory.Document.BaseDataUnit> localBaseDataUnits = (ArrayList<DocumentFactory.Document.BaseDataUnit>)sTextualDSBaseDataUnits.get((Object)lastTextualDsMarkable);
            if (localBaseDataUnits == null) {
                localBaseDataUnits = new ArrayList<DocumentFactory.Document.BaseDataUnit>();
                sTextualDSBaseDataUnits.put(lastTextualDsMarkable, localBaseDataUnits);
            }
            localBaseDataUnits.addAll(bufferBaseDataUnit);
            bufferBaseDataUnit = new ArrayList();
        }
        if (bufferBaseDataUnit.size() != 0) {
            if (lastTextualDsMarkable != null) {
                ((ArrayList)sTextualDSBaseDataUnits.get((Object)lastTextualDsMarkable)).addAll(bufferBaseDataUnit);
            } else {
                this.createSTextualDS(sDocumentGraph, null, bufferBaseDataUnit, indicesTokens);
            }
        }
        ArrayList<SSpanningRelation> sSpanRelNodes = new ArrayList<SSpanningRelation>();
        ArrayList<SaltExtendedMarkableFactory.SaltExtendedMarkable> sSpanRelMarkables = new ArrayList<SaltExtendedMarkableFactory.SaltExtendedMarkable>();
        ArrayList<SDominanceRelation> sDomRelNodes = new ArrayList<SDominanceRelation>();
        ArrayList<SaltExtendedMarkableFactory.SaltExtendedMarkable> sDomRelMarkables = new ArrayList<SaltExtendedMarkableFactory.SaltExtendedMarkable>();
        ArrayList<STextualRelation> sTextRelNodes = new ArrayList<STextualRelation>();
        ArrayList<SaltExtendedMarkableFactory.SaltExtendedMarkable> sTextRelMarkables = new ArrayList<SaltExtendedMarkableFactory.SaltExtendedMarkable>();
        ArrayList<SPointingRelation> sPointerNodes = new ArrayList<SPointingRelation>();
        ArrayList<SaltExtendedMarkableFactory.SaltExtendedMarkable> sPointerMarkables = new ArrayList<SaltExtendedMarkableFactory.SaltExtendedMarkable>();
        ArrayList<SaltExtendedMarkableFactory.SaltExtendedMarkable> sContainerMarkables = new ArrayList<SaltExtendedMarkableFactory.SaltExtendedMarkable>();
        ArrayList<SaltExtendedMarkableFactory.SaltExtendedMarkable> sAnnotationMarkables = new ArrayList<SaltExtendedMarkableFactory.SaltExtendedMarkable>();
        Hashtable<String, Object> correspondanceSAnnotations = new Hashtable<String, Object>();
        ArrayList<SaltExtendedMarkableFactory.SaltExtendedMarkable> sMetaAnnotationMarkables = new ArrayList<SaltExtendedMarkableFactory.SaltExtendedMarkable>();
        Hashtable<String, Object> correspondanceSMetaAnnotations = new Hashtable<String, Object>();
        ArrayList<SaltExtendedMarkableFactory.SaltExtendedMarkable> sLayerLinkMarkables = new ArrayList<SaltExtendedMarkableFactory.SaltExtendedMarkable>();
        ArrayList<SaltExtendedMarkableFactory.SaltExtendedMarkable> sTypeLinkMarkables = new ArrayList<SaltExtendedMarkableFactory.SaltExtendedMarkable>();
        Hashtable<SchemeFactory.Scheme, ArrayList<SaltExtendedMarkableFactory.SaltExtendedMarkable>> newMarkables = new Hashtable<SchemeFactory.Scheme, ArrayList<SaltExtendedMarkableFactory.SaltExtendedMarkable>>();
        SaltExtendedMarkableFactory.SaltExtendedMarkable sDocumentMarkable = null;
        SaltExtendedMarkableFactory.SaltExtendedMarkable sDocumentGraphMarkable = null;
        for (SaltExtendedMarkableFactory.SaltExtendedMarkable markable : markables) {
            this.registerMarkable(markable);
            if (!markable.hasSaltInformation()) {
                ArrayList<SaltExtendedMarkableFactory.SaltExtendedMarkable> markableOfScheme = (ArrayList<SaltExtendedMarkableFactory.SaltExtendedMarkable>)newMarkables.get(markable.getFactory().getScheme());
                if (markableOfScheme == null) {
                    markableOfScheme = new ArrayList<SaltExtendedMarkableFactory.SaltExtendedMarkable>();
                    newMarkables.put(markable.getFactory().getScheme(), markableOfScheme);
                }
                markableOfScheme.add(markable);
                continue;
            }
            String sType = markable.getSType();
            String key = markable.getSId();
            if (sType.equals("SDocument")) {
                if (sDocumentMarkable != null) {
                    throw new PepperModuleDataException((PepperMapper)this, "Two SDocument markable have been found: markables '" + markable.getId() + "' and '" + sDocumentMarkable.getId() + "'");
                }
                sDocumentMarkable = markable;
                correspondanceSAnnotations.put(key, sDocument);
                correspondanceSMetaAnnotations.put(key, sDocument);
                continue;
            }
            if (sType.equals("SDocumentGraph")) {
                if (sDocumentGraphMarkable != null) {
                    throw new PepperModuleDataException((PepperMapper)this, "Two SDocumentGraph markable have been found: markables '" + markable.getId() + "' and '" + sDocumentGraphMarkable.getId() + "'");
                }
                sDocumentGraphMarkable = markable;
                correspondanceSAnnotations.put(key, sDocumentGraph);
                correspondanceSMetaAnnotations.put(key, sDocumentGraph);
                continue;
            }
            if (sType.equals("SLayer")) {
                SLayer sLayer = this.createSLayer(sDocumentGraph, markable);
                correspondanceSAnnotations.put(key, sLayer);
                correspondanceSMetaAnnotations.put(key, sLayer);
                continue;
            }
            if (sType.equals("STextualDS")) {
                STextualDS sTextualDS = this.createSTextualDS(sDocumentGraph, markable, (ArrayList)sTextualDSBaseDataUnits.get((Object)markable), indicesTokens);
                correspondanceSAnnotations.put(key, sTextualDS);
                correspondanceSMetaAnnotations.put(key, sTextualDS);
                continue;
            }
            if (sType.equals("SToken")) {
                SToken sToken = this.createSToken(sDocumentGraph, markable);
                correspondanceSAnnotations.put(key, sToken);
                correspondanceSMetaAnnotations.put(key, sToken);
                continue;
            }
            if (sType.equals("SStruct")) {
                SStructure sStruct = this.createSStruct(sDocumentGraph, markable);
                correspondanceSAnnotations.put(key, sStruct);
                correspondanceSMetaAnnotations.put(key, sStruct);
                continue;
            }
            if (sType.equals("SSpan")) {
                SSpan sSpan = this.createSSPan(sDocumentGraph, markable);
                correspondanceSAnnotations.put(key, sSpan);
                correspondanceSMetaAnnotations.put(key, sSpan);
                continue;
            }
            if (sType.equals("STextualRel")) {
                sTextRelMarkables.add(markable);
                STextualRelation sTextualRelation = this.createSTextualRelation(sDocumentGraph, markable);
                sTextRelNodes.add(sTextualRelation);
                correspondanceSAnnotations.put(key, sTextualRelation);
                correspondanceSMetaAnnotations.put(key, sTextualRelation);
                continue;
            }
            if (sType.equals("SSpanningRel")) {
                sSpanRelMarkables.add(markable);
                SSpanningRelation sSpanningRelation = this.createSSpanningRelation(sDocumentGraph, markable);
                sSpanRelNodes.add(sSpanningRelation);
                correspondanceSAnnotations.put(key, sSpanningRelation);
                correspondanceSMetaAnnotations.put(key, sSpanningRelation);
                continue;
            }
            if (sType.equals("SDominanceRel")) {
                sDomRelMarkables.add(markable);
                SDominanceRelation sDomRel = this.createSDomRel(sDocumentGraph, markable);
                sDomRelNodes.add(sDomRel);
                correspondanceSAnnotations.put(key, sDomRel);
                correspondanceSMetaAnnotations.put(key, sDomRel);
                continue;
            }
            if (sType.equals("SPointingRel")) {
                sPointerMarkables.add(markable);
                SPointingRelation sPointer = this.createSPointer(sDocumentGraph, markable);
                sPointerNodes.add(sPointer);
                correspondanceSAnnotations.put(key, sPointer);
                correspondanceSMetaAnnotations.put(key, sPointer);
                continue;
            }
            if (sType.equals("SAnnotation")) {
                sAnnotationMarkables.add(markable);
                continue;
            }
            if (sType.equals("SMetaAnnotation")) {
                sMetaAnnotationMarkables.add(markable);
                continue;
            }
            if (sType.equals("SLayer_link")) {
                sLayerLinkMarkables.add(markable);
                continue;
            }
            if (sType.equals("SType_link")) {
                sTypeLinkMarkables.add(markable);
                continue;
            }
            if (sType.equals("SContainer")) {
                sContainerMarkables.add(markable);
                continue;
            }
            throw new PepperModuleException("Developper error:Unknown type '" + sType + "'");
        }
        if (sDocumentMarkable != null) {
            sDocument.setName(sDocumentMarkable.getSName());
        }
        if (sDocumentGraphMarkable != null) {
            sDocumentGraph.setName(sDocumentGraphMarkable.getSName());
        }
        for (SaltExtendedMarkableFactory.SaltExtendedMarkable markable : sContainerMarkables) {
            this.handleSContainer(markable);
        }
        for (SaltExtendedMarkableFactory.SaltExtendedMarkable markable : sAnnotationMarkables) {
            this.createSAnnotation(sDocumentGraph, (SAnnotationContainer)correspondanceSAnnotations.get(markable.getSId()), markable);
        }
        for (SaltExtendedMarkableFactory.SaltExtendedMarkable markable : sMetaAnnotationMarkables) {
            this.createSMetaAnnotation(sDocumentGraph, (SAnnotationContainer)correspondanceSMetaAnnotations.get(markable.getSId()), markable);
        }
        for (SaltExtendedMarkableFactory.SaltExtendedMarkable markable : sLayerLinkMarkables) {
            this.createSLayerLink(sDocumentGraph, markable);
        }
        for (i = 0; i < sTextRelNodes.size(); ++i) {
            this.completeSTextualRelation((STextualRelation)sTextRelNodes.get(i), (SaltExtendedMarkableFactory.SaltExtendedMarkable)((Object)sTextRelMarkables.get(i)), indicesTokens);
        }
        for (i = 0; i < sDomRelNodes.size(); ++i) {
            this.completeSDomRel((SDominanceRelation)sDomRelNodes.get(i), (SaltExtendedMarkableFactory.SaltExtendedMarkable)((Object)sDomRelMarkables.get(i)));
        }
        for (i = 0; i < sSpanRelNodes.size(); ++i) {
            this.completeSPanningRelation((SSpanningRelation)sSpanRelNodes.get(i), (SaltExtendedMarkableFactory.SaltExtendedMarkable)((Object)sSpanRelMarkables.get(i)));
        }
        for (i = 0; i < sPointerNodes.size(); ++i) {
            this.completeSPointer((SPointingRelation)sPointerNodes.get(i), (SaltExtendedMarkableFactory.SaltExtendedMarkable)((Object)sPointerMarkables.get(i)));
        }
        for (SaltExtendedMarkableFactory.SaltExtendedMarkable markable : sTypeLinkMarkables) {
            this.createSTypeLink(markable);
        }
        SLayer mmaxSLayer = null;
        if (newMarkables.keySet().size() != 0) {
            for (SLayer sLayer : this.sLayerHash.values()) {
                if (!sLayer.getName().equals("Mmax2_SLayer")) continue;
                mmaxSLayer = sLayer;
                break;
            }
            if (mmaxSLayer == null) {
                mmaxSLayer = SaltFactory.createSLayer();
                mmaxSLayer.setName("Mmax2_SLayer");
                mmaxSLayer.setId("Mmax2_SLayer");
                sDocumentGraph.addLayer((Layer)mmaxSLayer);
            }
            for (SchemeFactory.Scheme scheme : newMarkables.keySet()) {
                String schemeName = scheme.getName();
                ArrayList<SaltExtendedMarkableFactory.SaltExtendedMarkable> markablesToIgnore = new ArrayList<SaltExtendedMarkableFactory.SaltExtendedMarkable>();
                ArrayList schemeMarkables = (ArrayList)newMarkables.get(scheme);
                for (SaltExtendedMarkableFactory.SaltExtendedMarkable markable : schemeMarkables) {
                    String span = markable.getSpan();
                    String[] spans = span.split(",");
                    ArrayList<String> baseDateUnitIds = new ArrayList<String>();
                    for (int i3 = 0; i3 < spans.length; ++i3) {
                        baseDateUnitIds.addAll(this.getBaseUnitIds(spans[i3]));
                    }
                    boolean containsNoPointers = true;
                    for (SchemeFactory.MarkableAttributeFactory.MarkableAttribute markableAttribute : markable.getAttributes()) {
                        String attributeType = markableAttribute.getFactory().getAttributeType();
                        if (!attributeType.equals("MMAX2_POINTER")) continue;
                        containsNoPointers = false;
                    }
                    boolean isMetaMarkable = false;
                    if (containsNoPointers && baseDateUnitIds.size() >= nbBaseDataUnits - 1) {
                        isMetaMarkable = true;
                    }
                    if (!isMetaMarkable) {
                        SSpan sSpan = SaltFactory.createSSpan();
                        sSpan.setName(schemeName);
                        sDocumentGraph.addNode((Node)sSpan);
                        this.registerSNode(markable, (SNode)sSpan);
                        SAnnotation sAnnotation = SaltFactory.createSAnnotation();
                        sAnnotation.setNamespace("Mmax2");
                        sAnnotation.setName("markable_scheme");
                        sAnnotation.setValue((Object)schemeName);
                        sSpan.addAnnotation(sAnnotation);
                        mmaxSLayer.addNode((Node)sSpan);
                        for (String baseDataUnitId : baseDateUnitIds) {
                            if (!indicesTokens.containsKey(baseDataUnitId)) continue;
                            SToken sToken = this.getSToken(baseDataUnitId, indicesTokens);
                            SSpanningRelation sSpanRel = SaltFactory.createSSpanningRelation();
                            sSpanRel.setSource((Node)sSpan);
                            sSpanRel.setTarget((Node)sToken);
                            sDocumentGraph.addRelation((Relation)sSpanRel);
                            mmaxSLayer.addRelation((Relation)sSpanRel);
                        }
                        continue;
                    }
                    for (SchemeFactory.MarkableAttributeFactory.MarkableAttribute markableAttribute : markable.getAttributes()) {
                        SMetaAnnotation sMetaAnnotation = SaltFactory.createSMetaAnnotation();
                        sMetaAnnotation.setName(markableAttribute.getName());
                        sMetaAnnotation.setNamespace("Mmax2");
                        String value = markableAttribute.getValue();
                        value = value.replaceAll("\n", "");
                        sMetaAnnotation.setValue((Object)value);
                        sDocument.addMetaAnnotation(sMetaAnnotation);
                        markablesToIgnore.add(markable);
                    }
                }
                schemeMarkables.removeAll(markablesToIgnore);
            }
        }
        if (newMarkables.keySet().size() != 0) {
            for (SchemeFactory.Scheme scheme : newMarkables.keySet()) {
                for (SaltExtendedMarkableFactory.SaltExtendedMarkable markable : (ArrayList)newMarkables.get(scheme)) {
                    SSpan sSpan = (SSpan)this.getSNode(markable);
                    for (SchemeFactory.MarkableAttributeFactory.MarkableAttribute markableAttribute : markable.getAttributes()) {
                        String attributeType = markableAttribute.getFactory().getAttributeType();
                        if (attributeType.equals("MMAX2_FREETEXT") || attributeType.equals("MMAX2_NOMINAL") || attributeType.equals("MMAX2_SET")) {
                            SAnnotation sAnnotation = SaltFactory.createSAnnotation();
                            String value = markableAttribute.getValue();
                            value = value.replaceAll("\n", "");
                            if (markableAttribute.getName().equals("markable_sheme")) {
                                sAnnotation.setName(value);
                            } else {
                                sAnnotation.setName(scheme.getName() + "_" + markableAttribute.getName());
                            }
                            sAnnotation.setNamespace("Mmax2");
                            sAnnotation.setValue((Object)value);
                            sSpan.addAnnotation(sAnnotation);
                            continue;
                        }
                        if (attributeType.equals("MMAX2_POINTER")) {
                            SchemeFactory.MarkablePointerAttributeFactory factory = (SchemeFactory.MarkablePointerAttributeFactory)markableAttribute.getFactory();
                            String markablePointerValue = markableAttribute.getValue();
                            String[] markablePointerValues = markablePointerValue.split(";");
                            if (markablePointerValues.length == 0) {
                                throw new PepperModuleDataException((PepperMapper)this, "The target of the pointer '" + markableAttribute.getName() + "' within markable '" + (Object)((Object)markable) + "' is empty...");
                            }
                            for (int i4 = 0; i4 < markablePointerValues.length; ++i4) {
                                if ("empty".equals(markablePointerValues[i4])) continue;
                                SPointingRelation sPointingRelation = SaltFactory.createSPointingRelation();
                                sPointingRelation.setName(markableAttribute.getName());
                                sPointingRelation.setType(markableAttribute.getName());
                                sPointingRelation.setSource((Node)sSpan);
                                SaltExtendedMarkableFactory.SaltExtendedMarkable targetMarkable = this.getMarkable(markablePointerValues[i4], factory.getTargetSchemeName());
                                if (targetMarkable == null) {
                                    throw new PepperModuleDataException((PepperMapper)this, "An unknown markable of id '" + markablePointerValues[i4] + "' belonging to scheme '" + factory.getTargetSchemeName() + "' is referenced as the target of the pointer '" + markableAttribute.getName() + "' within markable '" + (Object)((Object)markable) + "'");
                                }
                                SNode sTarget = this.getSNode(targetMarkable);
                                sPointingRelation.setTarget((Node)((SStructuredNode)sTarget));
                                sDocumentGraph.addRelation((Relation)sPointingRelation);
                                if (mmaxSLayer == null) continue;
                                mmaxSLayer.addRelation((Relation)sPointingRelation);
                            }
                            continue;
                        }
                        throw new PepperModuleException("Developper error: unknown type of markable attribute '" + attributeType + "'...");
                    }
                }
            }
        }
        for (DocumentFactory.Document.BaseDataUnit baseDataUnit : baseDataUnits) {
            this.getSToken(baseDataUnit.getId(), indicesTokens);
        }
    }

    private void handleSContainer(SaltExtendedMarkableFactory.SaltExtendedMarkable markable) {
        SaltExtendedMarkableFactory.SaltExtendedMarkableContainer containerMarkable = (SaltExtendedMarkableFactory.SaltExtendedMarkableContainer)markable;
        SaltExtendedMarkableFactory.SaltExtendedMarkable containedMarkable = this.getMarkable(containerMarkable.getAttribute("contained_id").getValue(), containerMarkable.getAttribute("contained_scheme").getValue());
        if (containedMarkable == null) {
            throw new PepperModuleException("Unknow contained SNode markable in SContainer markable '" + (Object)((Object)containerMarkable) + "'");
        }
        this.claimSContainer.put(markable, containedMarkable);
    }

    private SLayer createSLayer(SDocumentGraph sDocumentGraph, SaltExtendedMarkableFactory.SaltExtendedMarkable markable) {
        SLayer sLayer = SaltFactory.createSLayer();
        sLayer.setName(markable.getSName());
        this.affectSId((IdentifiableElement)sLayer, markable.getSId());
        this.sLayerHash.put(markable.getId(), sLayer);
        sDocumentGraph.addLayer((Layer)sLayer);
        return sLayer;
    }

    private STextualDS createSTextualDS(SDocumentGraph sDocumentGraph, SaltExtendedMarkableFactory.SaltExtendedMarkable markable, ArrayList<DocumentFactory.Document.BaseDataUnit> baseDataUnits, Hashtable<String, int[]> indicesTokens) {
        STextualDS sTextualDS = SaltFactory.createSTextualDS();
        if (markable == null) {
            sTextualDS.setName("Mmax2_textualDs");
            sTextualDS.setId("Mmax2_textualDs");
        } else {
            sTextualDS.setName(markable.getSName());
            this.registerSNode(markable, (SNode)sTextualDS);
            this.affectSId((IdentifiableElement)sTextualDS, markable.getSId());
        }
        if (baseDataUnits == null || baseDataUnits.size() == 0) {
            throw new PepperModuleDataException((PepperMapper)this, "TextualDS markable " + sTextualDS.getName() + " covers no BaseData unit at all...");
        }
        int[] startAndEnd = this.getStartAndEnd(baseDataUnits.get(0).getId(), indicesTokens);
        ArrayList<String> allStr = new ArrayList<String>();
        for (DocumentFactory.Document.BaseDataUnit baseDataUnit : baseDataUnits) {
            this.sTextualDsBaseDataUnitCorrespondance.put(baseDataUnit.getId(), sTextualDS);
            allStr.add(baseDataUnit.getText());
        }
        sTextualDS.setText(StringUtils.join((Object[])allStr.toArray(new String[allStr.size()]), (String)""));
        sDocumentGraph.addNode((Node)sTextualDS);
        this.sTextualDsOfset.put(sTextualDS, startAndEnd[0]);
        return sTextualDS;
    }

    private SStructure createSStruct(SDocumentGraph sDocumentGraph, SaltExtendedMarkableFactory.SaltExtendedMarkable markable) {
        SStructure sStruct = SaltFactory.createSStructure();
        sStruct.setName(markable.getSName());
        this.registerSNode(markable, (SNode)sStruct);
        sDocumentGraph.addNode((Node)sStruct);
        this.affectSId((IdentifiableElement)sStruct, markable.getSId());
        return sStruct;
    }

    private SToken createSToken(SDocumentGraph sDocumentGraph, SaltExtendedMarkableFactory.SaltExtendedMarkable markable) {
        SToken sToken = SaltFactory.createSToken();
        sToken.setName(markable.getSName());
        this.registerSNode(markable, (SNode)sToken);
        sDocumentGraph.addNode((Node)sToken);
        this.affectSId((IdentifiableElement)sToken, markable.getSId());
        return sToken;
    }

    private SSpan createSSPan(SDocumentGraph sDocumentGraph, SaltExtendedMarkableFactory.SaltExtendedMarkable markable) {
        SSpan sSpan = SaltFactory.createSSpan();
        sSpan.setName(markable.getSName());
        this.registerSNode(markable, (SNode)sSpan);
        sDocumentGraph.addNode((Node)sSpan);
        this.affectSId((IdentifiableElement)sSpan, markable.getSId());
        return sSpan;
    }

    private STextualRelation createSTextualRelation(SDocumentGraph sDocumentGraph, SaltExtendedMarkableFactory.SaltExtendedMarkable markable) {
        STextualRelation sTextualRel = SaltFactory.createSTextualRelation();
        sTextualRel.setName(markable.getSName());
        sDocumentGraph.addRelation((Relation)sTextualRel);
        this.registerSRelation(markable, (SRelation)sTextualRel);
        this.affectSId((IdentifiableElement)sTextualRel, markable.getSId());
        return sTextualRel;
    }

    private void completeSTextualRelation(STextualRelation sTextualRelation, SaltExtendedMarkableFactory.SaltExtendedMarkable markable, Hashtable<String, int[]> indicesTokens) {
        SchemeFactory.MarkableAttributeFactory.MarkableAttribute targetTokenAttribute = null;
        SchemeFactory.MarkableAttributeFactory.MarkableAttribute targetTextualDsAttribute = null;
        ArrayList markableAttributes = markable.getAttributes();
        for (SchemeFactory.MarkableAttributeFactory.MarkableAttribute markableAttribute : markableAttributes) {
            if (markableAttribute.getName().equals("target_token")) {
                targetTokenAttribute = markableAttribute;
                continue;
            }
            if (!markableAttribute.getName().equals("target_textual_ds")) continue;
            targetTextualDsAttribute = markableAttribute;
        }
        if (targetTokenAttribute == null) {
            throw new PepperModuleDataException((PepperMapper)this, "'target_token' attribute is missing on Saltextended markable '" + (Object)((Object)markable) + "' representing an STextualRelation");
        }
        markable.removeAttribute(targetTokenAttribute);
        if (targetTextualDsAttribute == null) {
            throw new PepperModuleDataException((PepperMapper)this, "'target_textual_ds' attribute is missing on Saltextended markable '" + (Object)((Object)markable) + "' representing an STextualRelation");
        }
        markable.removeAttribute(targetTextualDsAttribute);
        SchemeFactory.MarkablePointerAttributeFactory targetFactory = (SchemeFactory.MarkablePointerAttributeFactory)targetTokenAttribute.getFactory();
        SaltExtendedMarkableFactory.SaltExtendedMarkable targetSTokenMarkable = this.getMarkable(targetTokenAttribute.getValue(), targetFactory.getTargetSchemeName());
        if (targetSTokenMarkable == null) {
            throw new PepperModuleDataException((PepperMapper)this, "An unknown markable of id '" + targetTokenAttribute.getValue() + "' belonging to scheme '" + targetFactory.getTargetSchemeName() + "' is referenced as the target of the pointer '" + targetTokenAttribute.getName() + "' within markable '" + (Object)((Object)markable) + "'");
        }
        SToken sToken = (SToken)this.getSNode(targetSTokenMarkable);
        if (sToken == null) {
            throw new PepperModuleDataException((PepperMapper)this, "An unknown SToken node represented by markable '" + (Object)((Object)targetSTokenMarkable) + "' is referenced as the target for the STextualRelation represented by markable '" + (Object)((Object)markable) + "'");
        }
        try {
            sTextualRelation.setSource((Node)sToken);
        }
        catch (ClassCastException e) {
            throw new PepperModuleDataException((PepperMapper)this, "The SNode represented by markable '" + (Object)((Object)targetSTokenMarkable) + "' and referenced as the target for the STextualRelation represented by markable '" + (Object)((Object)markable) + "' is not a SToken...");
        }
        String baseDataUnitId = markable.getSpan();
        if (baseDataUnitId.contains("..") || baseDataUnitId.contains(",")) {
            throw new PepperModuleDataException((PepperMapper)this, "The SaltExtendedMarkable representing an STextualRelation is corrupted: it covers more than one base data unit...  '" + (Object)((Object)markable) + "'");
        }
        this.sTokensHash.put(baseDataUnitId, sToken);
        SchemeFactory.MarkablePointerAttributeFactory targettextualDsFactory = (SchemeFactory.MarkablePointerAttributeFactory)targetTextualDsAttribute.getFactory();
        SaltExtendedMarkableFactory.SaltExtendedMarkable targetDSMarkable = this.getMarkable(targetTextualDsAttribute.getValue(), targettextualDsFactory.getTargetSchemeName());
        if (targetDSMarkable == null) {
            throw new PepperModuleDataException((PepperMapper)this, "An unknown markable of id '" + targetTextualDsAttribute.getValue() + "' belonging to scheme '" + targettextualDsFactory.getTargetSchemeName() + "' is referenced as the target of the pointer '" + targetTextualDsAttribute.getName() + "' within markable '" + (Object)((Object)markable) + "'");
        }
        STextualDS sTextualDs = (STextualDS)this.getSNode(targetDSMarkable);
        if (sTextualDs == null) {
            throw new PepperModuleDataException((PepperMapper)this, "An unknown STextualDS node represented by markable '" + (Object)((Object)targetDSMarkable) + "' is referenced as the target for the STextualRelation represented by markable '" + (Object)((Object)markable) + "'");
        }
        try {
            sTextualRelation.setTarget((Node)sTextualDs);
        }
        catch (ClassCastException e) {
            throw new PepperModuleDataException((PepperMapper)this, "The SNode represented by markable '" + (Object)((Object)targetDSMarkable) + "' and referenced as the target for the STextualRelation represented by markable '" + (Object)((Object)markable) + "' is not a STextualDS...");
        }
        int[] startAndEnd = this.getStartAndEnd(baseDataUnitId, indicesTokens);
        sTextualRelation.setStart((Number)(startAndEnd[0] - this.sTextualDsOfset.get(sTextualDs)));
        sTextualRelation.setEnd((Number)(startAndEnd[1] - this.sTextualDsOfset.get(sTextualDs)));
    }

    private SDominanceRelation createSDomRel(SDocumentGraph sDocumentGraph, SaltExtendedMarkableFactory.SaltExtendedMarkable markable) {
        SDominanceRelation sDomRel = SaltFactory.createSDominanceRelation();
        sDomRel.setName(markable.getSName());
        sDocumentGraph.addRelation((Relation)sDomRel);
        this.registerSRelation(markable, (SRelation)sDomRel);
        this.affectSId((IdentifiableElement)sDomRel, markable.getSId());
        return sDomRel;
    }

    private void completeSDomRel(SDominanceRelation sDomRel, SaltExtendedMarkableFactory.SaltExtendedMarkable markable) {
        SchemeFactory.MarkableAttributeFactory.MarkableAttribute structAttribute = null;
        SchemeFactory.MarkableAttributeFactory.MarkableAttribute structSchemeAttribute = null;
        SchemeFactory.MarkableAttributeFactory.MarkableAttribute targetAttribute = null;
        SchemeFactory.MarkableAttributeFactory.MarkableAttribute targetSchemeAttribute = null;
        SchemeFactory.MarkableAttributeFactory.MarkableAttribute containerPointerAttribute = null;
        ArrayList markableAttributes = markable.getAttributes();
        for (SchemeFactory.MarkableAttributeFactory.MarkableAttribute markableAttribute : markableAttributes) {
            if (markableAttribute.getName().equals("struct")) {
                structAttribute = markableAttribute;
                continue;
            }
            if (markableAttribute.getName().equals("struct_scheme")) {
                structSchemeAttribute = markableAttribute;
                continue;
            }
            if (markableAttribute.getName().equals("target")) {
                targetAttribute = markableAttribute;
                continue;
            }
            if (markableAttribute.getName().equals("target_scheme")) {
                targetSchemeAttribute = markableAttribute;
                continue;
            }
            if (!markableAttribute.getName().equals("source_attr")) continue;
            containerPointerAttribute = markableAttribute;
        }
        if (structAttribute == null) {
            throw new PepperModuleDataException((PepperMapper)this, "'struct' attribute is missing on Saltextended markable '" + (Object)((Object)markable) + "' representing an SDominationRelation");
        }
        markable.removeAttribute(structAttribute);
        SNode sStruct = null;
        SNode sStructuredTarget = null;
        if (structSchemeAttribute != null) {
            SaltExtendedMarkableFactory.SaltExtendedMarkable sStructMarkable = this.getMarkable(structAttribute.getValue(), structSchemeAttribute.getValue());
            if (sStructMarkable == null) {
                throw new PepperModuleDataException((PepperMapper)this, "An unknown SContainer markable is referenced as the sStructured target of the pointer within markable '" + (Object)((Object)markable) + "'");
            }
            SaltExtendedMarkableFactory.SaltExtendedMarkable sstructContainedMarkable = this.claimSContainer.get((Object)sStructMarkable);
            sStruct = this.getSNode(sstructContainedMarkable);
            if (containerPointerAttribute == null) {
                throw new PepperModuleDataException((PepperMapper)this, "'source_attr' attribute is missing on Saltextended markable '" + (Object)((Object)markable) + "' representing an SDominanceRelation");
            }
            markableAttributes.remove(containerPointerAttribute);
            SchemeFactory.MarkableAttributeFactory.MarkableAttribute pointer = null;
            String sstructPointerAttribute = containerPointerAttribute.getValue();
            for (SchemeFactory.MarkableAttributeFactory.MarkableAttribute sstructMarkableAttribute : sStructMarkable.getAttributes()) {
                if (!sstructMarkableAttribute.getName().equals(sstructPointerAttribute)) continue;
                pointer = sstructMarkableAttribute;
                break;
            }
            if (pointer == null) {
                throw new PepperModuleDataException((PepperMapper)this, "'" + sstructPointerAttribute + "' attribute is missing on SContainer markable '" + (Object)((Object)sStructMarkable) + "'");
            }
            sStructMarkable.removeAttribute(pointer);
            SchemeFactory.MarkablePointerAttributeFactory pointerFactory = (SchemeFactory.MarkablePointerAttributeFactory)pointer.getFactory();
            SaltExtendedMarkableFactory.SaltExtendedMarkable targetMarkable = this.getMarkable(pointer.getValue(), pointerFactory.getTargetSchemeName());
            if (targetMarkable == null) {
                throw new PepperModuleDataException((PepperMapper)this, " An unknown markable is referenced as the target of Saltextended markable '" + (Object)((Object)markable) + "' representing an SDominanceRelation");
            }
            SaltExtendedMarkableFactory.SaltExtendedMarkable targetContainedMarkable = this.claimSContainer.get((Object)targetMarkable);
            sStructuredTarget = this.getSNode(targetContainedMarkable);
            if (sStructuredTarget == null) {
                throw new PepperModuleDataException((PepperMapper)this, "An unknown target node is referenced as the target for the SDominanceRelation represented by markable '" + (Object)((Object)markable) + "'");
            }
        } else {
            SaltExtendedMarkableFactory.SaltExtendedMarkable sStructMarkable = this.getMarkable(structAttribute.getValue(), "SStruct");
            if (sStructMarkable == null) {
                throw new PepperModuleDataException((PepperMapper)this, "An unknown markable is referenced as the sStructured source of the pointer within markable '" + (Object)((Object)markable) + "'");
            }
            if (targetAttribute == null) {
                throw new PepperModuleDataException((PepperMapper)this, "'target' attribute is missing on SContainer markable '" + (Object)((Object)markable) + "'");
            }
            markable.removeAttribute(targetAttribute);
            if (targetSchemeAttribute == null) {
                throw new PepperModuleDataException((PepperMapper)this, "'target_scheme' attribute is missing on SContainer markable '" + (Object)((Object)markable) + "'");
            }
            markable.removeAttribute(targetSchemeAttribute);
            SaltExtendedMarkableFactory.SaltExtendedMarkable targetMarkable = this.getMarkable(targetAttribute.getValue(), targetSchemeAttribute.getValue());
            if (targetMarkable == null) {
                throw new PepperModuleDataException((PepperMapper)this, " An unknown markable is referenced as the target of markable '" + (Object)((Object)markable) + "' representing an SDominanceRelation");
            }
            sStructuredTarget = this.getSNode(targetMarkable);
            if (sStructuredTarget == null) {
                throw new PepperModuleDataException((PepperMapper)this, "An unknown target node is referenced as the target for the SDominanceRelation represented by markable '" + (Object)((Object)markable) + "'");
            }
        }
        try {
            sDomRel.setSource((Node)((SStructure)sStruct));
        }
        catch (ClassCastException e) {
            throw new PepperModuleDataException((PepperMapper)this, "The SNode referenced as source sstruct by SDominanceRelation markable '" + (Object)((Object)markable) + "' is not anymore a SSTructure");
        }
        try {
            sDomRel.setTarget((Node)((SStructuredNode)sStructuredTarget));
        }
        catch (ClassCastException e) {
            throw new PepperModuleDataException((PepperMapper)this, "The SNode referenced as target by SDominanceRelation markable '" + (Object)((Object)markable) + "' is not anymore a SStructuredNode");
        }
    }

    private SSpanningRelation createSSpanningRelation(SDocumentGraph sDocumentGraph, SaltExtendedMarkableFactory.SaltExtendedMarkable markable) {
        SSpanningRelation sSpanningRel = SaltFactory.createSSpanningRelation();
        sSpanningRel.setName(markable.getSName());
        sDocumentGraph.addRelation((Relation)sSpanningRel);
        this.registerSRelation(markable, (SRelation)sSpanningRel);
        this.affectSId((IdentifiableElement)sSpanningRel, markable.getSId());
        return sSpanningRel;
    }

    private void completeSPanningRelation(SSpanningRelation sSpanningRel, SaltExtendedMarkableFactory.SaltExtendedMarkable markable) {
        SchemeFactory.MarkableAttributeFactory.MarkableAttribute targetTokenAttribute = null;
        SchemeFactory.MarkableAttributeFactory.MarkableAttribute sourceSpanAttribute = null;
        ArrayList markableAttributes = markable.getAttributes();
        for (SchemeFactory.MarkableAttributeFactory.MarkableAttribute markableAttribute : markableAttributes) {
            if (markableAttribute.getName().equals("target_token")) {
                targetTokenAttribute = markableAttribute;
                continue;
            }
            if (!markableAttribute.getName().equals("source_span")) continue;
            sourceSpanAttribute = markableAttribute;
        }
        if (sourceSpanAttribute == null) {
            throw new PepperModuleDataException((PepperMapper)this, "'source_span' attribute is missing on Saltextended markable '" + (Object)((Object)markable) + "' representing an SPanningRelation");
        }
        markable.removeAttribute(sourceSpanAttribute);
        SchemeFactory.MarkablePointerAttributeFactory sourceSpanAttrFactory = (SchemeFactory.MarkablePointerAttributeFactory)sourceSpanAttribute.getFactory();
        SaltExtendedMarkableFactory.SaltExtendedMarkable sourceSpanMarkable = this.getMarkable(sourceSpanAttribute.getValue(), sourceSpanAttrFactory.getTargetSchemeName());
        if (sourceSpanMarkable == null) {
            throw new PepperModuleDataException((PepperMapper)this, "An unknown markable of id '" + sourceSpanAttribute.getValue() + "' belonging to scheme '" + sourceSpanAttrFactory.getTargetSchemeName() + "' is referenced as the target of the pointer '" + sourceSpanAttribute.getName() + "' within markable '" + (Object)((Object)markable) + "'");
        }
        SNode sSpan = this.getSNode(sourceSpanMarkable);
        if (sSpan == null) {
            throw new PepperModuleDataException((PepperMapper)this, "An unknown SSPan node represented by markable '" + (Object)((Object)sourceSpanMarkable) + "' is referenced as the source for the SPanningRelation represented by markable '" + (Object)((Object)markable) + "'");
        }
        try {
            sSpanningRel.setSource((Node)((SSpan)sSpan));
        }
        catch (ClassCastException e) {
            throw new PepperModuleDataException((PepperMapper)this, "The SNode represented by markable '" + (Object)((Object)sourceSpanMarkable) + "' and referenced as the source for the SPanningRelation represented by markable '" + (Object)((Object)markable) + "' is not an SSpan...");
        }
        if (targetTokenAttribute == null) {
            throw new PepperModuleDataException((PepperMapper)this, "'target_token' attribute is missing on Saltextended markable '" + (Object)((Object)markable) + "' representing an SPanningRelation");
        }
        markable.removeAttribute(targetTokenAttribute);
        SchemeFactory.MarkablePointerAttributeFactory targetTokenAttrFactory = (SchemeFactory.MarkablePointerAttributeFactory)targetTokenAttribute.getFactory();
        SaltExtendedMarkableFactory.SaltExtendedMarkable targetTokenMarkable = this.getMarkable(targetTokenAttribute.getValue(), targetTokenAttrFactory.getTargetSchemeName());
        if (targetTokenMarkable == null) {
            throw new PepperModuleDataException((PepperMapper)this, "An unknown markable of id '" + targetTokenAttribute.getValue() + "' belonging to scheme '" + targetTokenAttrFactory.getTargetSchemeName() + "' is referenced as the target of the pointer '" + targetTokenAttribute.getName() + "' within markable '" + (Object)((Object)markable) + "'");
        }
        SNode sToken = this.getSNode(targetTokenMarkable);
        if (sToken == null) {
            throw new PepperModuleDataException((PepperMapper)this, "An unknown SToken node represented by markable '" + (Object)((Object)targetTokenMarkable) + "' is referenced as the target for the SPanningRelation represented by markable '" + (Object)((Object)markable) + "'");
        }
        try {
            sSpanningRel.setTarget((Node)((SToken)sToken));
        }
        catch (ClassCastException e) {
            throw new PepperModuleDataException((PepperMapper)this, "The SNode represented by markable '" + (Object)((Object)targetTokenMarkable) + "' and referenced as the target for the SPanningRelation represented by markable '" + (Object)((Object)markable) + "' is not a SToken");
        }
    }

    private SPointingRelation createSPointer(SDocumentGraph sDocumentGraph, SaltExtendedMarkableFactory.SaltExtendedMarkable markable) {
        SPointingRelation sPointingRelation = SaltFactory.createSPointingRelation();
        sPointingRelation.setName(markable.getSName());
        sDocumentGraph.addRelation((Relation)sPointingRelation);
        this.registerSRelation(markable, (SRelation)sPointingRelation);
        this.affectSId((IdentifiableElement)sPointingRelation, markable.getSId());
        return sPointingRelation;
    }

    private void completeSPointer(SPointingRelation sPointingRelation, SaltExtendedMarkableFactory.SaltExtendedMarkable markable) {
        SchemeFactory.MarkableAttributeFactory.MarkableAttribute sourceAttribute = null;
        SchemeFactory.MarkableAttributeFactory.MarkableAttribute sourceSchemeAttribute = null;
        SchemeFactory.MarkableAttributeFactory.MarkableAttribute targetAttribute = null;
        SchemeFactory.MarkableAttributeFactory.MarkableAttribute targetSchemeAttribute = null;
        SchemeFactory.MarkableAttributeFactory.MarkableAttribute containerPointerAttribute = null;
        ArrayList markableAttributes = markable.getAttributes();
        for (SchemeFactory.MarkableAttributeFactory.MarkableAttribute markableAttribute : markableAttributes) {
            if (markableAttribute.getName().equals("source")) {
                sourceAttribute = markableAttribute;
                continue;
            }
            if (markableAttribute.getName().equals("source_attr")) {
                containerPointerAttribute = markableAttribute;
                continue;
            }
            if (markableAttribute.getName().equals("target")) {
                targetAttribute = markableAttribute;
                continue;
            }
            if (markableAttribute.getName().equals("target_scheme")) {
                targetSchemeAttribute = markableAttribute;
                continue;
            }
            if (!markableAttribute.getName().equals("source_scheme")) continue;
            sourceSchemeAttribute = markableAttribute;
        }
        if (sourceAttribute == null) {
            throw new PepperModuleDataException((PepperMapper)this, "'source' attribute is missing on Saltextended markable '" + (Object)((Object)markable) + "' representing an SPointingRelation");
        }
        markableAttributes.remove(sourceAttribute);
        if (sourceSchemeAttribute == null) {
            throw new PepperModuleDataException((PepperMapper)this, "'source_scheme' attribute is missing on Saltextended markable '" + (Object)((Object)markable) + "' representing an SPointingRelation");
        }
        markableAttributes.remove(sourceSchemeAttribute);
        SaltExtendedMarkableFactory.SaltExtendedMarkable sourceMarkable = this.getMarkable(sourceAttribute.getValue(), sourceSchemeAttribute.getValue());
        if (sourceMarkable == null) {
            throw new PepperModuleDataException((PepperMapper)this, "An unknown markable is referenced as the source for the SPointingRelation represented by markable '" + (Object)((Object)markable) + "'");
        }
        SNode sSource = null;
        SNode sTarget = null;
        if (sourceMarkable.getSType().equals("SContainer")) {
            SaltExtendedMarkableFactory.SaltExtendedMarkable sourceContainedMarkable = this.claimSContainer.get((Object)sourceMarkable);
            sSource = this.getSNode(sourceContainedMarkable);
            if (containerPointerAttribute == null) {
                throw new PepperModuleDataException((PepperMapper)this, "'source_attr' attribute is missing on Saltextended markable '" + (Object)((Object)markable) + "' representing an SPointingRelation");
            }
            markableAttributes.remove(containerPointerAttribute);
            SchemeFactory.MarkableAttributeFactory.MarkableAttribute pointer = null;
            String sourcePointerAttribute = containerPointerAttribute.getValue();
            for (SchemeFactory.MarkableAttributeFactory.MarkableAttribute sourceMarkableAttribute : sourceMarkable.getAttributes()) {
                if (!sourceMarkableAttribute.getName().equals(sourcePointerAttribute)) continue;
                pointer = sourceMarkableAttribute;
                break;
            }
            if (pointer == null) {
                throw new PepperModuleDataException((PepperMapper)this, "'" + sourcePointerAttribute + "' attribute is missing on SContainer markable '" + (Object)((Object)sourceMarkable) + "'");
            }
            sourceMarkable.removeAttribute(pointer);
            SchemeFactory.MarkablePointerAttributeFactory pointerFactory = (SchemeFactory.MarkablePointerAttributeFactory)pointer.getFactory();
            SaltExtendedMarkableFactory.SaltExtendedMarkable targetMarkable = this.getMarkable(pointer.getValue(), pointerFactory.getTargetSchemeName());
            if (targetMarkable == null) {
                throw new PepperModuleDataException((PepperMapper)this, " An unknown markable is referenced as the target of Saltextended markable '" + (Object)((Object)markable) + "' representing an SPointingRelation");
            }
            SaltExtendedMarkableFactory.SaltExtendedMarkable targetContainedMarkable = this.claimSContainer.get((Object)targetMarkable);
            sTarget = this.getSNode(targetContainedMarkable);
            if (sTarget == null) {
                throw new PepperModuleDataException((PepperMapper)this, "An unknown target node is referenced as the target for the SPointingRelation represented by markable '" + (Object)((Object)markable) + "'");
            }
        } else {
            sSource = this.getSNode(sourceMarkable);
            if (sSource == null) {
                throw new PepperModuleDataException((PepperMapper)this, "An unknown SNode node is referenced as the source for the SPointingRelation represented by markable '" + (Object)((Object)markable) + "'");
            }
            if (targetAttribute == null) {
                throw new PepperModuleDataException((PepperMapper)this, "'target' attribute is missing on Saltextended markable '" + (Object)((Object)markable) + "' representing an SPointingRelation");
            }
            markableAttributes.remove(targetAttribute);
            if (targetSchemeAttribute == null) {
                throw new PepperModuleDataException((PepperMapper)this, "'target_scheme' attribute is missing on Saltextended markable '" + (Object)((Object)markable) + "' representing an SPointingRelation");
            }
            markableAttributes.remove(targetSchemeAttribute);
            SaltExtendedMarkableFactory.SaltExtendedMarkable targetMarkable = this.getMarkable(targetAttribute.getValue(), targetSchemeAttribute.getValue());
            if (targetMarkable == null) {
                throw new PepperModuleDataException((PepperMapper)this, " An unknown markable is referenced as the target of Saltextended markable '" + (Object)((Object)markable) + "' representing an SPointingRelation");
            }
            sTarget = this.getSNode(targetMarkable);
            if (sTarget == null) {
                throw new PepperModuleDataException((PepperMapper)this, "An unknown target node is referenced as the target for the SPointingRelation represented by markable '" + (Object)((Object)markable) + "'");
            }
        }
        sPointingRelation.setSource((Node)((SStructuredNode)sSource));
        sPointingRelation.setTarget((Node)((SStructuredNode)sTarget));
    }

    private void createSMetaAnnotation(SDocumentGraph sDocumentGraph, SAnnotationContainer sAnnotatableElement, SaltExtendedMarkableFactory.SaltExtendedMarkable annotationMarkable) {
        String attributeName;
        SchemeFactory.MarkableAttributeFactory.MarkableAttribute namespaceAttribute = null;
        SchemeFactory.MarkableAttributeFactory.MarkableAttribute targetMarkableAttribute = null;
        SchemeFactory.MarkableAttributeFactory.MarkableAttribute nameAttribute = null;
        SchemeFactory.MarkableAttributeFactory.MarkableAttribute containerSchemeAttribute = null;
        SchemeFactory.MarkableAttributeFactory.MarkableAttribute containerAttrNameAttribute = null;
        SchemeFactory.MarkableAttributeFactory.MarkableAttribute valueAttribute = null;
        ArrayList markableAttributes = annotationMarkable.getAttributes();
        for (SchemeFactory.MarkableAttributeFactory.MarkableAttribute markableAttribute : markableAttributes) {
            String attributeName2 = markableAttribute.getName();
            if (attributeName2.equals("namespace")) {
                namespaceAttribute = markableAttribute;
                continue;
            }
            if (attributeName2.equals("target_markable")) {
                targetMarkableAttribute = markableAttribute;
                continue;
            }
            if (attributeName2.equals("attr_name")) {
                nameAttribute = markableAttribute;
                continue;
            }
            if (attributeName2.equals("container_scheme")) {
                containerSchemeAttribute = markableAttribute;
                continue;
            }
            if (attributeName2.equals("container_attr")) {
                containerAttrNameAttribute = markableAttribute;
                continue;
            }
            if (!attributeName2.equals("value")) continue;
            valueAttribute = markableAttribute;
        }
        if (namespaceAttribute == null) {
            throw new PepperModuleDataException((PepperMapper)this, "'namespace' attribute is missing on Saltextended markable '" + (Object)((Object)annotationMarkable) + "' representing an SAnnotation");
        }
        annotationMarkable.removeAttribute(namespaceAttribute);
        if (targetMarkableAttribute == null) {
            throw new PepperModuleDataException((PepperMapper)this, "'target_markable' attribute is missing on Saltextended markable '" + (Object)((Object)annotationMarkable) + "' representing an SAnnotation");
        }
        annotationMarkable.removeAttribute(targetMarkableAttribute);
        if (nameAttribute == null) {
            throw new PepperModuleDataException((PepperMapper)this, "'attr_name' attribute is missing on Saltextended markable '" + (Object)((Object)annotationMarkable) + "' representing an SAnnotation");
        }
        annotationMarkable.removeAttribute(nameAttribute);
        String attributeNameSpace = namespaceAttribute.getValue();
        String completeAttributeName = attributeName = nameAttribute.getValue();
        if (!attributeNameSpace.equals("")) {
            completeAttributeName = attributeNameSpace + "__" + attributeName;
        }
        if (containerSchemeAttribute != null || containerAttrNameAttribute != null) {
            if (containerSchemeAttribute != null && containerAttrNameAttribute != null) {
                annotationMarkable.removeAttribute(containerSchemeAttribute);
                annotationMarkable.removeAttribute(containerAttrNameAttribute);
                SaltExtendedMarkableFactory.SaltExtendedMarkable containerMarkable = this.getMarkable(targetMarkableAttribute.getValue(), containerSchemeAttribute.getValue());
                if (containerMarkable == null) {
                    throw new PepperModuleDataException((PepperMapper)this, "An unknown SContainer markable is referenced in SMetaAnnotationMarkable '" + (Object)((Object)annotationMarkable) + "'");
                }
                valueAttribute = containerMarkable.getAttribute(containerAttrNameAttribute.getValue());
                containerMarkable.removeAttribute(valueAttribute);
            } else {
                if (containerSchemeAttribute == null) {
                    throw new PepperModuleDataException((PepperMapper)this, "'container_scheme' attribute is missing for Annotation markable '" + (Object)((Object)annotationMarkable) + "'");
                }
                if (containerAttrNameAttribute == null) {
                    throw new PepperModuleDataException((PepperMapper)this, "'container_attr' attribute is missing for Annotation markable '" + (Object)((Object)annotationMarkable) + "'");
                }
            }
        }
        if (valueAttribute == null) {
            throw new PepperModuleDataException((PepperMapper)this, "'" + completeAttributeName + "' attribute is missing for Annotation markable '" + (Object)((Object)annotationMarkable) + "'");
        }
        SMetaAnnotation sMetaAnnotation = SaltFactory.createSMetaAnnotation();
        if (!attributeNameSpace.equals("") && !attributeNameSpace.equals("null")) {
            sMetaAnnotation.setNamespace(namespaceAttribute.getValue());
        }
        sMetaAnnotation.setName(attributeName);
        sMetaAnnotation.setValue((Object)valueAttribute.getValue());
        sAnnotatableElement.addMetaAnnotation(sMetaAnnotation);
    }

    private void createSAnnotation(SDocumentGraph sDocumentGraph, SAnnotationContainer sAnnotatableElement, SaltExtendedMarkableFactory.SaltExtendedMarkable annotationMarkable) {
        String attributeName;
        SchemeFactory.MarkableAttributeFactory.MarkableAttribute namespaceAttribute = null;
        SchemeFactory.MarkableAttributeFactory.MarkableAttribute targetMarkableAttribute = null;
        SchemeFactory.MarkableAttributeFactory.MarkableAttribute nameAttribute = null;
        SchemeFactory.MarkableAttributeFactory.MarkableAttribute containerSchemeAttribute = null;
        SchemeFactory.MarkableAttributeFactory.MarkableAttribute containerAttrNameAttribute = null;
        SchemeFactory.MarkableAttributeFactory.MarkableAttribute valueAttribute = null;
        ArrayList markableAttributes = annotationMarkable.getAttributes();
        for (SchemeFactory.MarkableAttributeFactory.MarkableAttribute markableAttribute : markableAttributes) {
            String attributeName2 = markableAttribute.getName();
            if (attributeName2.equals("namespace")) {
                namespaceAttribute = markableAttribute;
                continue;
            }
            if (attributeName2.equals("target_markable")) {
                targetMarkableAttribute = markableAttribute;
                continue;
            }
            if (attributeName2.equals("attr_name")) {
                nameAttribute = markableAttribute;
                continue;
            }
            if (attributeName2.equals("container_scheme")) {
                containerSchemeAttribute = markableAttribute;
                continue;
            }
            if (attributeName2.equals("container_attr")) {
                containerAttrNameAttribute = markableAttribute;
                continue;
            }
            if (!attributeName2.equals("value")) continue;
            valueAttribute = markableAttribute;
        }
        if (namespaceAttribute == null) {
            throw new PepperModuleDataException((PepperMapper)this, "'namespace' attribute is missing on Saltextended markable '" + (Object)((Object)annotationMarkable) + "' representing an SAnnotation");
        }
        annotationMarkable.removeAttribute(namespaceAttribute);
        if (targetMarkableAttribute == null) {
            throw new PepperModuleDataException((PepperMapper)this, "'target_markable' attribute is missing on Saltextended markable '" + (Object)((Object)annotationMarkable) + "' representing an SAnnotation");
        }
        annotationMarkable.removeAttribute(targetMarkableAttribute);
        if (nameAttribute == null) {
            throw new PepperModuleDataException((PepperMapper)this, "'attr_name' attribute is missing on Saltextended markable '" + (Object)((Object)annotationMarkable) + "' representing an SAnnotation");
        }
        annotationMarkable.removeAttribute(nameAttribute);
        String attributeNameSpace = namespaceAttribute.getValue();
        String completeAttributeName = attributeName = nameAttribute.getValue();
        if (!attributeNameSpace.equals("")) {
            completeAttributeName = attributeNameSpace + "__" + attributeName;
        }
        if (containerSchemeAttribute != null || containerAttrNameAttribute != null) {
            if (containerSchemeAttribute != null && containerAttrNameAttribute != null) {
                annotationMarkable.removeAttribute(containerSchemeAttribute);
                annotationMarkable.removeAttribute(containerAttrNameAttribute);
                SaltExtendedMarkableFactory.SaltExtendedMarkable containerMarkable = this.getMarkable(targetMarkableAttribute.getValue(), containerSchemeAttribute.getValue());
                if (containerMarkable == null) {
                    throw new PepperModuleDataException((PepperMapper)this, "An unknown SContainer markable is referenced in SMetaAnnotationMarkable '" + (Object)((Object)annotationMarkable) + "'");
                }
                valueAttribute = containerMarkable.getAttribute(containerAttrNameAttribute.getValue());
                containerMarkable.removeAttribute(valueAttribute);
            } else {
                if (containerSchemeAttribute == null) {
                    throw new PepperModuleDataException((PepperMapper)this, "'container_scheme' attribute is missing for Annotation markable '" + (Object)((Object)annotationMarkable) + "'");
                }
                if (containerAttrNameAttribute == null) {
                    throw new PepperModuleDataException((PepperMapper)this, "'container_attr' attribute is missing for Annotation markable '" + (Object)((Object)annotationMarkable) + "'");
                }
            }
        }
        if (valueAttribute == null) {
            throw new PepperModuleDataException((PepperMapper)this, "the value of '" + completeAttributeName + "' attribute is missing for Annotation markable '" + (Object)((Object)annotationMarkable) + "'");
        }
        SAnnotation sAnnotation = SaltFactory.createSAnnotation();
        if (!attributeNameSpace.equals("") && !attributeNameSpace.equals("null")) {
            sAnnotation.setNamespace(attributeNameSpace);
        }
        sAnnotation.setName(attributeName);
        sAnnotation.setValue((Object)valueAttribute.getValue());
        sAnnotatableElement.addAnnotation(sAnnotation);
    }

    private void createSLayerLink(SDocumentGraph sDocumentGraph, SaltExtendedMarkableFactory.SaltExtendedMarkable markable) {
        SchemeFactory.MarkableAttributeFactory.MarkableAttribute slayerAttr = markable.getAttribute("slayer");
        if (slayerAttr == null) {
            throw new PepperModuleDataException((PepperMapper)this, "'slayer' attribute is missing for SLayerLink markable '" + (Object)((Object)markable) + "'");
        }
        SLayer sLayer = this.sLayerHash.get(slayerAttr.getValue());
        if (sLayer == null) {
            throw new PepperModuleDataException((PepperMapper)this, "An unknown SLayer is referenced within SLayerLink markable '" + (Object)((Object)markable) + "'");
        }
        SchemeFactory.MarkableAttributeFactory.MarkableAttribute selementAttr = markable.getAttribute("selement");
        if (selementAttr == null) {
            throw new PepperModuleDataException((PepperMapper)this, "'selement' attribute is missing for SLayerLink markable '" + (Object)((Object)markable) + "'");
        }
        SchemeFactory.MarkablePointerAttributeFactory selementAttrFactory = (SchemeFactory.MarkablePointerAttributeFactory)selementAttr.getFactory();
        SaltExtendedMarkableFactory.SaltExtendedMarkable markableElement = this.getMarkable(selementAttr.getValue(), selementAttrFactory.getTargetSchemeName());
        if (markableElement == null) {
            throw new PepperModuleDataException((PepperMapper)this, "'selement' pointer '" + selementAttr + "' within SLayerLink markable '" + (Object)((Object)markable) + "' points to an unkown markable");
        }
        SNode sNode = this.getSNode(markableElement);
        if (sNode == null) {
            SRelation sRelation = this.getSRelation(markableElement);
            if (sRelation == null) {
                throw new PepperModuleDataException((PepperMapper)this, "An unknow SElement is referenced within SLayerLink markable '" + (Object)((Object)markable) + "'");
            }
            sRelation.addLayer((Layer)sLayer);
        } else {
            sNode.addLayer((Layer)sLayer);
        }
    }

    private void createSTypeLink(SaltExtendedMarkableFactory.SaltExtendedMarkable markable) {
        SchemeFactory.MarkableAttributeFactory.MarkableAttribute selementAttr = markable.getAttribute("selement");
        if (selementAttr == null) {
            throw new PepperModuleDataException((PepperMapper)this, "'selement' attribute is missing for STypeLink markable '" + (Object)((Object)markable) + "'");
        }
        SchemeFactory.MarkablePointerAttributeFactory selementAttrFactory = (SchemeFactory.MarkablePointerAttributeFactory)selementAttr.getFactory();
        SaltExtendedMarkableFactory.SaltExtendedMarkable markableElement = this.getMarkable(selementAttr.getValue(), selementAttrFactory.getScheme().getName());
        if (markableElement == null) {
            throw new PepperModuleDataException((PepperMapper)this, "'selement' pointer within STypeLink markable '" + (Object)((Object)markable) + "' points to an unkown markable");
        }
        SRelation sRelation = this.getSRelation(markableElement);
        if (sRelation == null) {
            throw new PepperModuleDataException((PepperMapper)this, "An unknow SRelation is referenced within STypeLink markable '" + (Object)((Object)markable) + "'");
        }
        SchemeFactory.MarkableAttributeFactory.MarkableAttribute stypeAttr = markable.getAttribute("stype");
        if (stypeAttr == null) {
            throw new PepperModuleDataException((PepperMapper)this, "'stype' attribute is missing for STypeLink markable '" + (Object)((Object)markable) + "'");
        }
        sRelation.setType(stypeAttr.getValue());
    }

    private int[] getStartAndEnd(String BaseDataUnitId, Hashtable<String, int[]> indicesTokens) {
        if (indicesTokens.containsKey(BaseDataUnitId)) {
            Integer start = indicesTokens.get(BaseDataUnitId)[0];
            Integer end = indicesTokens.get(BaseDataUnitId)[1];
            int[] result = new int[]{start, end};
            return result;
        }
        throw new PepperModuleDataException((PepperMapper)this, "An error in data was found: Cannot find start/end offset of base data unit '" + BaseDataUnitId + "'.");
    }

    private ArrayList<String> getBaseUnitIds(String span) {
        String[] limitBaseUnitIds = span.split(Pattern.quote(".."));
        ArrayList<String> results = new ArrayList<String>();
        if (limitBaseUnitIds.length == 2) {
            int start = new Integer(limitBaseUnitIds[0].replaceAll("word_", ""));
            int end = new Integer(limitBaseUnitIds[1].replaceAll("word_", ""));
            for (int i = start; i <= end; ++i) {
                results.add("word_" + i);
            }
        } else {
            results.add(span);
        }
        return results;
    }

    private SToken getSToken(String baseInitId, Hashtable<String, int[]> indicesTokens) {
        int[] startAndEnd;
        SToken sToken = this.sTokensHash.get(baseInitId);
        if (sToken == null && (startAndEnd = this.getStartAndEnd(baseInitId, indicesTokens)) != null) {
            sToken = SaltFactory.createSToken();
            STextualRelation sTextualRel = SaltFactory.createSTextualRelation();
            sTextualRel.setSource((Node)sToken);
            STextualDS sTextualDsOfToken = this.sTextualDsBaseDataUnitCorrespondance.get(baseInitId);
            sTextualRel.setTarget((Node)sTextualDsOfToken);
            sTextualRel.setStart((Number)(startAndEnd[0] - this.sTextualDsOfset.get(sTextualDsOfToken)));
            sTextualRel.setEnd((Number)(startAndEnd[1] - this.sTextualDsOfset.get(sTextualDsOfToken)));
            sTextualDsOfToken.getGraph().addNode((Node)sToken);
            for (SLayer sLayer : sTextualDsOfToken.getLayers()) {
                sLayer.getNodes().add(sToken);
            }
            sTextualDsOfToken.getGraph().addRelation((Relation)sTextualRel);
            for (SLayer sLayer : sTextualDsOfToken.getLayers()) {
                sLayer.addRelation((Relation)sTextualRel);
            }
            this.sTokensHash.put(baseInitId, sToken);
        }
        return sToken;
    }

    private void affectSId(IdentifiableElement elem, String SId) {
        if (this.saltIds.containsKey(SId)) {
            throw new PepperModuleDataException((PepperMapper)this, "Data is corrupted => Two SIdentifiable elements have the same SId '" + SId + "' => '" + elem + "' and '" + this.saltIds.get(SId) + "'");
        }
        this.saltIds.put(SId, elem);
        elem.setId(SId);
    }

    private void registerSRelation(SaltExtendedMarkableFactory.SaltExtendedMarkable key, SRelation sRelation) {
        this.sRelationsHash.put(key, sRelation);
    }

    private SRelation getSRelation(SaltExtendedMarkableFactory.SaltExtendedMarkable key) {
        return this.sRelationsHash.get((Object)key);
    }

    private void registerSNode(SaltExtendedMarkableFactory.SaltExtendedMarkable key, SNode sNode) {
        this.sNodesHash.put(key, sNode);
    }

    private SNode getSNode(SaltExtendedMarkableFactory.SaltExtendedMarkable key) {
        if (key.getSType().equals("SContainer")) {
            try {
                return (SNode)this.claimSContainer.get((Object)key);
            }
            catch (ClassCastException e) {
                throw new PepperModuleDataException((PepperMapper)this, "An SContainer markable '" + (Object)((Object)key) + "'working as an alias for something that is not an SNode has been referenced...");
            }
        }
        return this.sNodesHash.get((Object)key);
    }

    private SaltExtendedMarkableFactory.SaltExtendedMarkable registerMarkable(SaltExtendedMarkableFactory.SaltExtendedMarkable markable) {
        String schemeName = markable.getFactory().getScheme().getName();
        if (!this.saltExtendedMarkableHash.containsKey(schemeName)) {
            this.saltExtendedMarkableHash.put(schemeName, new Hashtable());
        }
        return this.saltExtendedMarkableHash.get(schemeName).put(markable.getId(), markable);
    }

    private SaltExtendedMarkableFactory.SaltExtendedMarkable getMarkable(String markableId, String schemeName) {
        if (schemeName == null || schemeName.isEmpty()) {
            for (Hashtable<String, SaltExtendedMarkableFactory.SaltExtendedMarkable> markablesForDomain : this.saltExtendedMarkableHash.values()) {
                SaltExtendedMarkableFactory.SaltExtendedMarkable result = markablesForDomain.get(markableId);
                if (result == null) continue;
                return result;
            }
        } else if (this.saltExtendedMarkableHash.containsKey(schemeName)) {
            return this.saltExtendedMarkableHash.get(schemeName).get(markableId);
        }
        return null;
    }
}

