/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.TEIModules;

import com.neovisionaries.i18n.LanguageCode;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.impl.PepperMapperImpl;
import org.corpus_tools.peppermodules.TEIModules.TEIImporterMetaData;
import org.corpus_tools.peppermodules.TEIModules.TEIImporterProperties;
import org.corpus_tools.peppermodules.TEIModules.TEITagLibrary;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SDominanceRelation;
import org.corpus_tools.salt.common.SSequentialDS;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.SStructure;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.common.tokenizer.Tokenizer;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;
import org.corpus_tools.salt.semantics.SWordAnnotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.AttributesImpl;

public class TEIMapper
extends PepperMapperImpl {
    Logger logger = LoggerFactory.getLogger((String)"TEIImporter");

    public DOCUMENT_STATUS mapSDocument() {
        TEIImporterProperties props = (TEIImporterProperties)this.getProperties();
        SDocumentGraph docGraph = this.getDocument().getDocumentGraph();
        TEIImporterReader reader = new TEIImporterReader(props);
        reader.setsDocGraph(docGraph);
        this.readXMLResource(reader, this.getResourceURI());
        return DOCUMENT_STATUS.COMPLETED;
    }

    public static class TEIImporterReader
    extends DefaultHandler2
    implements TEITagLibrary {
        Logger logger = LoggerFactory.getLogger((String)"TEIImporter");
        private Boolean default_tokenization = false;
        private Boolean sub_tokenization = false;
        private Boolean surplus_removal = false;
        private Boolean unclear_as_token = false;
        private Boolean foreign_as_token = false;
        private Boolean use_tokenizer = false;
        private LanguageCode use_tokenizer_language = null;
        private Boolean del_redundant_metadata = null;
        private Boolean skip_default_annotations = false;
        private Boolean use_namespace = false;
        private Boolean generic_struct = false;
        private Boolean generic_span = false;
        private Boolean generic_attr = false;
        private Boolean token_anno_span = false;
        private Boolean lastPart = false;
        private Set<String> excludeMetaSet = null;
        private String lb_name = "lb";
        private String pb_name = "pb";
        private String w_name = "w";
        private String phr_name = "phr";
        private String body_head_name = "head";
        private String div_name = "div";
        private String p_name = "p";
        private String foreign_name = "foreign";
        private String figure_name = "figure";
        private String unclear_name = "unclear";
        private String text_name = "text";
        private String lb_anno_value = "lb";
        private String pb_anno_value = "pb";
        private String phr_anno_value = "phr";
        private String body_head_anno_value = "head";
        private String div_anno_value = "div";
        private String p_anno_value = "p";
        private String figure_anno_value = "figure";
        private String text_anno_value = "text";
        private String default_token_tag = "w";
        private Boolean insidetext = false;
        private Boolean metadata = false;
        private Stack<SToken> lbSpanTokenStack = new Stack();
        private Stack<SToken> pbSpanTokenStack = new Stack();
        private Map<String, Stack<SToken>> genericSpanMap = null;
        private Map<String, Attributes> attrMap = null;
        private Stack<SNode> sNodeStack = null;
        private Stack<String> TagStack = new Stack();
        private Stack<SAnnotation> SAnnoStack = null;
        StringBuilder txt = new StringBuilder();
        StringBuilder meta_txt = new StringBuilder();
        private SDocumentGraph sDocGraph = null;
        private TEIImporterMetaData tei_metadata = new TEIImporterMetaData();
        private STextualDS primaryText = null;
        private TEIImporterProperties props = null;
        Tokenizer tokenizer = null;

        public void setDEFAULT_TOKENIZATION() {
            this.default_tokenization = true;
        }

        public void setSUB_TOKENIZATION() {
            this.sub_tokenization = true;
        }

        public void setGENERIC_STRUCT() {
            this.generic_struct = true;
        }

        public void setGENERIC_SPAN() {
            this.generic_span = true;
        }

        public void setGENERIC_ATTR() {
            this.generic_attr = true;
        }

        public void set_default_token_tag(String param) {
            this.default_token_tag = param;
        }

        private Stack<SNode> getNodeStack() {
            if (this.sNodeStack == null) {
                this.sNodeStack = new Stack();
            }
            return this.sNodeStack;
        }

        private Stack<String> getTagStack() {
            if (this.TagStack == null) {
                this.TagStack = new Stack();
            }
            return this.TagStack;
        }

        private Stack<SAnnotation> getSAnnoStack() {
            if (this.SAnnoStack == null) {
                this.SAnnoStack = new Stack();
            }
            return this.SAnnoStack;
        }

        public SDocumentGraph getsDocGraph() {
            return this.sDocGraph;
        }

        public void setsDocGraph(SDocumentGraph DocGraph) {
            this.sDocGraph = DocGraph;
        }

        public TEIImporterProperties getProps() {
            return this.props;
        }

        public void setProps(TEIImporterProperties props) {
            this.props = props;
        }

        public TEIImporterReader(TEIImporterProperties props) {
            this.setProps(props);
            this.default_tokenization = props.isDefaultTokenization();
            this.sub_tokenization = props.isSubTokenization();
            this.surplus_removal = props.isSurplusRemoval();
            this.unclear_as_token = props.isUnclearAsToken();
            this.foreign_as_token = props.isForeignAsToken();
            this.use_tokenizer = props.isUseTokenizer();
            this.use_tokenizer_language = props.tokenizer_code();
            this.del_redundant_metadata = props.isDelMetadata();
            this.skip_default_annotations = props.isSkipAnnotations();
            this.generic_struct = props.isUseGenericStruct();
            this.generic_span = props.isUseGenericSpan();
            this.generic_attr = props.isUseGenericAttr();
            this.lastPart = props.isUseLastPart();
            this.token_anno_span = props.isUseTokenAnnoSpan();
            props.fillMappings();
            this.excludeMetaSet = props.retrieveExcludeMetadataSet();
            this.lb_name = props.getTagName("lb");
            this.pb_name = props.getTagName("pb");
            this.w_name = props.getTagName("w");
            this.phr_name = props.getTagName("phr");
            this.body_head_name = props.getTagName("head");
            this.div_name = props.getTagName("div");
            this.p_name = props.getTagName("p");
            this.foreign_name = props.getTagName("foreign");
            this.figure_name = props.getTagName("figure");
            this.unclear_name = props.getTagName("unclear");
            this.text_name = props.getTagName("text");
            this.lb_anno_value = props.getValuesName("lb");
            this.pb_anno_value = props.getValuesName("pb");
            this.phr_anno_value = props.getValuesName("phr");
            this.body_head_anno_value = props.getValuesName("head");
            this.div_anno_value = props.getValuesName("div");
            this.p_anno_value = props.getValuesName("p");
            this.figure_anno_value = props.getValuesName("figure");
            this.text_anno_value = props.getValuesName("text");
        }

        public TEIImporterReader() {
            this.sDocGraph = SaltFactory.createSDocumentGraph();
        }

        @Override
        public void startDocument() {
        }

        private void setDominatingToken(SToken token) {
            SDominanceRelation sDominatingRelation = SaltFactory.createSDominanceRelation();
            sDominatingRelation.setSource((Node)((SStructure)this.getNodeStack().peek()));
            sDominatingRelation.setTarget((Node)token);
            this.sDocGraph.addRelation((Relation)sDominatingRelation);
        }

        private void setDominatingStruc(SStructure struc) {
            SDominanceRelation sDominatingRelation = SaltFactory.createSDominanceRelation();
            sDominatingRelation.setSource((Node)((SStructure)this.getNodeStack().peek()));
            sDominatingRelation.setTarget((Node)struc);
            this.sDocGraph.addRelation((Relation)sDominatingRelation);
        }

        private void addSpace(STextualDS text) {
            text.setText(text.getText() + " ");
        }

        private void addDefaultAnnotation(SNode node, String name, String value, String namespace) {
            if (!this.skip_default_annotations.booleanValue()) {
                node.createAnnotation(namespace, name, (Object)value);
            }
        }

        private String retrieveNamespace(Boolean prop, String name) {
            String namespace = null;
            if (prop.booleanValue()) {
                namespace = name;
                return namespace;
            }
            if (!prop.booleanValue()) {
                return namespace;
            }
            return "erratic namespace";
        }

        private void setEmptyToken() {
            SToken temp_tok = null;
            if (this.primaryText.getEnd() == null) {
                this.addSpace(this.primaryText);
            }
            temp_tok = this.sDocGraph.createToken((SSequentialDS)this.primaryText, (Integer)this.primaryText.getEnd(), (Integer)this.primaryText.getEnd());
            this.setDominatingToken(temp_tok);
            this.push_spans(temp_tok);
        }

        private void createTokenAnnoSpan(SToken token, SAnnotation anno) {
            if (this.token_anno_span.booleanValue()) {
                SSpan span = this.sDocGraph.createSpan(new SToken[]{token});
                span.addAnnotation(anno);
            }
        }

        private void setGapToken() {
            SToken temp_tok = null;
            temp_tok = this.sDocGraph.createToken((SSequentialDS)this.primaryText, (Integer)this.primaryText.getEnd(), (Integer)this.primaryText.getEnd());
            while (!this.getSAnnoStack().isEmpty()) {
                this.createTokenAnnoSpan(temp_tok, this.getSAnnoStack().peek());
                if (temp_tok.getLabel(null, this.getSAnnoStack().peek().getName()) == null) {
                    try {
                        temp_tok.addAnnotation(this.getSAnnoStack().pop());
                    }
                    catch (Exception e) {
                        this.logger.warn(e.getMessage());
                    }
                    continue;
                }
                this.getSAnnoStack().pop();
            }
            this.setDominatingToken(temp_tok);
            this.push_spans(temp_tok);
        }

        private Boolean checkOutgoingRelations(SNode closingStructure) {
            if (closingStructure.getOutRelations().size() < 1) {
                return false;
            }
            return true;
        }

        private void popNodeWithNoTokenCheck() {
            if (!this.getNodeStack().empty()) {
                if (this.checkOutgoingRelations(this.getNodeStack().peek()).booleanValue()) {
                    this.getNodeStack().pop();
                } else {
                    this.setEmptyToken();
                    this.getNodeStack().pop();
                }
            }
        }

        private void setStandardToken(StringBuilder str) {
            if (str.toString().trim().length() > 0) {
                if (this.primaryText != null) {
                    SToken temp_tok = null;
                    if (str.length() > 0 && this.primaryText.getText() == null) {
                        String tempstr = str.toString();
                        tempstr = tempstr.replaceAll("\\s+", " ");
                        tempstr = tempstr.trim();
                        this.primaryText.setText(tempstr);
                        temp_tok = this.sDocGraph.createToken((SSequentialDS)this.primaryText, Integer.valueOf(0), (Integer)this.primaryText.getEnd());
                        this.setDominatingToken(temp_tok);
                    } else if (str.length() > 0 && this.primaryText.getText() != null) {
                        this.addSpace(this.primaryText);
                        int oldposition = (Integer)this.primaryText.getEnd();
                        String tempstr = str.toString();
                        tempstr = tempstr.replaceAll("\\s+", " ");
                        tempstr = tempstr.trim();
                        this.primaryText.setText(this.primaryText.getText() + tempstr);
                        temp_tok = this.sDocGraph.createToken((SSequentialDS)this.primaryText, Integer.valueOf(oldposition), (Integer)this.primaryText.getEnd());
                        this.setDominatingToken(temp_tok);
                    }
                    while (!this.getSAnnoStack().isEmpty()) {
                        this.createTokenAnnoSpan(temp_tok, this.getSAnnoStack().peek());
                        if (temp_tok.getLabel(null, this.getSAnnoStack().peek().getName()) == null) {
                            temp_tok.addAnnotation(this.getSAnnoStack().pop());
                            continue;
                        }
                        this.getSAnnoStack().pop();
                    }
                    this.push_spans(temp_tok);
                }
                str.setLength(0);
            }
        }

        private void setTokenList(List<String> tokenlist) {
            for (String tokstring : tokenlist) {
                SToken temp_tok = null;
                if (this.primaryText.getText() != null) {
                    this.addSpace(this.primaryText);
                }
                if (this.primaryText.getText() == null) {
                    this.primaryText.setText("");
                }
                int oldposition = (Integer)this.primaryText.getEnd();
                if (this.primaryText.getText() == null) {
                    this.primaryText.setText(tokstring);
                } else if (this.primaryText.getText() != null) {
                    this.primaryText.setText(this.primaryText.getText() + tokstring);
                }
                temp_tok = this.sDocGraph.createToken((SSequentialDS)this.primaryText, Integer.valueOf(oldposition), (Integer)this.primaryText.getEnd());
                this.setDominatingToken(temp_tok);
                this.push_spans(temp_tok);
            }
        }

        private void setTokenizedTokens(StringBuilder str) {
            if (str.toString().trim().length() > 0) {
                if (this.primaryText != null) {
                    String tempstr = str.toString();
                    tempstr = tempstr.replaceAll("\\s+", " ");
                    tempstr = tempstr.trim();
                    List tokenliste = this.tokenizer.tokenizeToString(tempstr, this.use_tokenizer_language);
                    this.setTokenList(tokenliste);
                }
                str.setLength(0);
            }
        }

        private void setToken(StringBuilder str) {
            if (str.toString().trim().length() > 0 && this.primaryText != null) {
                if (this.use_tokenizer.booleanValue()) {
                    this.setTokenizedTokens(str);
                } else if (!this.use_tokenizer.booleanValue()) {
                    this.setStandardToken(str);
                }
            }
        }

        private void generic_break(String tag, Stack<SToken> tokenStack, String annovalue) {
            if (this.sub_tokenization.booleanValue()) {
                this.setToken(this.txt);
            }
            ArrayList<SToken> overlappingTokens = new ArrayList<SToken>();
            while (!tokenStack.isEmpty()) {
                overlappingTokens.add(tokenStack.pop());
            }
            SSpan line = this.sDocGraph.createSpan(overlappingTokens);
            if (line != null) {
                Attributes attributes;
                line.createAnnotation(null, tag, (Object)annovalue);
                if (this.generic_attr.booleanValue() && this.attrMap != null && (attributes = this.attrMap.get(tag)) != null) {
                    int length = attributes.getLength();
                    for (int i = 0; i < length; ++i) {
                        String name = attributes.getQName(i);
                        String value = attributes.getValue(i);
                        line.createAnnotation(null, name, (Object)value);
                    }
                }
            }
        }

        private void addGenericAnno(SNode node, Attributes attr, String namespace) {
            int length = attr.getLength();
            for (int i = 0; i < length; ++i) {
                String name = attr.getQName(i);
                String value = attr.getValue(i);
                SAnnotation tempAnno = this.sDocGraph.createAnnotation(namespace, name, (Object)value);
                node.addAnnotation(tempAnno);
            }
        }

        private void push_spans(SToken tok) {
            this.lbSpanTokenStack.push(tok);
            this.pbSpanTokenStack.push(tok);
            this.pushToGenerics(tok);
        }

        private void addToGenericSpans(String name, Attributes attr) {
            if (this.genericSpanMap == null) {
                this.genericSpanMap = new Hashtable<String, Stack<SToken>>();
            }
            if (this.attrMap == null) {
                this.attrMap = new Hashtable<String, Attributes>();
            }
            this.attrMap.put(name, new AttributesImpl(attr));
            Stack gen_stack = new Stack();
            this.genericSpanMap.put(name, gen_stack);
        }

        private void pushToGenerics(SToken token) {
            if (this.genericSpanMap != null) {
                Set<String> keySet = this.genericSpanMap.keySet();
                for (String s : keySet) {
                    Stack<SToken> tempStack = this.genericSpanMap.get(s);
                    tempStack.push(token);
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            int i;
            StringBuilder tempstr;
            if (this.insidetext.booleanValue()) {
                tempstr = new StringBuilder();
                for (i = start; i < start + length; ++i) {
                    tempstr.append(ch[i]);
                }
                this.txt.append(tempstr.toString().trim());
            }
            if (this.metadata.booleanValue()) {
                tempstr = new StringBuilder();
                for (i = start; i < start + length; ++i) {
                    tempstr.append(ch[i]);
                }
                this.meta_txt.append(tempstr.toString().trim());
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("teiHeader".equals(qName)) {
                this.metadata = true;
                return;
            }
            if (this.metadata.booleanValue()) {
                this.tei_metadata.push(qName);
                int i = 0;
                while (i < attributes.getLength()) {
                    this.tei_metadata.push_attribute_XPathMap(attributes.getQName(i), attributes.getValue(i));
                    ++i;
                }
                return;
            }
            if ("text".equals(qName)) {
                String namespace = this.retrieveNamespace(this.use_namespace, this.text_name);
                this.getTagStack().push("text");
                this.primaryText = SaltFactory.createSTextualDS();
                this.sDocGraph.addNode((Node)this.primaryText);
                this.insidetext = true;
                SStructure text_struc = SaltFactory.createSStructure();
                this.addDefaultAnnotation((SNode)text_struc, this.text_name, this.text_anno_value, namespace);
                this.addGenericAnno((SNode)text_struc, attributes, namespace);
                this.getNodeStack().add((SNode)text_struc);
                this.sDocGraph.addNode((Node)text_struc);
                return;
            }
            if (this.insidetext == false) return;
            this.tokenizer = this.sDocGraph.createTokenizer();
            if ("lb".equals(qName)) {
                this.generic_break(this.lb_name, this.lbSpanTokenStack, this.lb_anno_value);
                return;
            }
            if ("pb".equals(qName)) {
                this.generic_break(this.pb_name, this.pbSpanTokenStack, this.pb_anno_value);
                return;
            }
            if ("w".equals(qName)) {
                String namespace = this.retrieveNamespace(this.use_namespace, this.w_name);
                this.setToken(this.txt);
                this.getTagStack().push("w");
                if (!this.default_tokenization.booleanValue() || this.default_token_tag != "w") {
                    SStructure w_struc = SaltFactory.createSStructure();
                    this.addGenericAnno((SNode)w_struc, attributes, namespace);
                    SWordAnnotation wordanno = SaltFactory.createSWordAnnotation();
                    w_struc.addAnnotation((SAnnotation)wordanno);
                    if (attributes.getValue("type") != null) {
                        w_struc.createAnnotation(namespace, "type", (Object)attributes.getValue("type"));
                    }
                    if (attributes.getValue("lemma") != null) {
                        w_struc.createAnnotation(namespace, "lemma", (Object)attributes.getValue("lemma"));
                    }
                    if (attributes.getValue("xml:lang") != null) {
                        w_struc.createAnnotation(namespace, "lang", (Object)attributes.getValue("xml:lang"));
                    }
                    this.sDocGraph.addNode((Node)w_struc);
                    this.setDominatingStruc(w_struc);
                    this.getNodeStack().add((SNode)w_struc);
                    return;
                }
                SWordAnnotation wordanno = SaltFactory.createSWordAnnotation();
                this.getSAnnoStack().add((SAnnotation)wordanno);
                int length = attributes.getLength();
                int i = 0;
                while (i < length) {
                    String name = attributes.getQName(i);
                    String value = attributes.getValue(i);
                    SAnnotation tempanno = SaltFactory.createSAnnotation();
                    tempanno.setName(name);
                    tempanno.setValue((Object)attributes.getValue(value));
                    tempanno.setNamespace(namespace);
                    this.getSAnnoStack().add(tempanno);
                    ++i;
                }
                return;
            }
            if ("phr".equals(qName)) {
                String namespace = this.retrieveNamespace(this.use_namespace, this.phr_name);
                this.getTagStack().push("phr");
                SStructure phr_struc = SaltFactory.createSStructure();
                this.addDefaultAnnotation((SNode)phr_struc, this.phr_name, this.phr_anno_value, namespace);
                this.addGenericAnno((SNode)phr_struc, attributes, namespace);
                this.sDocGraph.addNode((Node)phr_struc);
                this.setDominatingStruc(phr_struc);
                this.getNodeStack().add((SNode)phr_struc);
                return;
            }
            if ("head".equals(qName)) {
                String namespace = this.retrieveNamespace(this.use_namespace, this.body_head_name);
                if (this.getTagStack().peek() != "figure") {
                    this.getTagStack().push("head");
                    SStructure head_struc = SaltFactory.createSStructure();
                    this.addDefaultAnnotation((SNode)head_struc, this.body_head_name, this.body_head_anno_value, namespace);
                    this.addGenericAnno((SNode)head_struc, attributes, namespace);
                    this.sDocGraph.addNode((Node)head_struc);
                    this.setDominatingStruc(head_struc);
                    this.getNodeStack().add((SNode)head_struc);
                    return;
                }
                if (this.getTagStack().peek() != "figure") return;
                return;
            } else {
                if ("div".equals(qName)) {
                    String namespace = this.retrieveNamespace(this.use_namespace, this.div_name);
                    this.getTagStack().push("div");
                    SStructure div_struc = SaltFactory.createSStructure();
                    this.addDefaultAnnotation((SNode)div_struc, this.div_name, this.div_anno_value, namespace);
                    this.addGenericAnno((SNode)div_struc, attributes, namespace);
                    this.sDocGraph.addNode((Node)div_struc);
                    this.setDominatingStruc(div_struc);
                    this.getNodeStack().add((SNode)div_struc);
                    return;
                }
                if ("p".equals(qName)) {
                    String namespace = this.retrieveNamespace(this.use_namespace, this.p_name);
                    this.getTagStack().push("p");
                    SStructure p_struc = SaltFactory.createSStructure();
                    this.addDefaultAnnotation((SNode)p_struc, this.p_name, this.p_anno_value, namespace);
                    this.addGenericAnno((SNode)p_struc, attributes, namespace);
                    this.sDocGraph.addNode((Node)p_struc);
                    this.setDominatingStruc(p_struc);
                    this.getNodeStack().add((SNode)p_struc);
                    return;
                }
                if ("foreign".equals(qName)) {
                    String namespace = this.retrieveNamespace(this.use_namespace, this.foreign_name);
                    if (this.foreign_as_token == false) return;
                    this.setToken(this.txt);
                    this.getTagStack().push("foreign");
                    int length = attributes.getLength();
                    int i = 0;
                    while (i < length) {
                        String name = attributes.getQName(i);
                        String value = attributes.getValue(i);
                        SAnnotation tempanno = SaltFactory.createSAnnotation();
                        tempanno.setName(name);
                        tempanno.setValue((Object)attributes.getValue(value));
                        tempanno.setNamespace(namespace);
                        this.getSAnnoStack().add(tempanno);
                        ++i;
                    }
                    return;
                }
                if ("figure".equals(qName)) {
                    String namespace = this.retrieveNamespace(this.use_namespace, this.figure_name);
                    this.setToken(this.txt);
                    this.getTagStack().push("figure");
                    SStructure figure_struc = SaltFactory.createSStructure();
                    this.addDefaultAnnotation((SNode)figure_struc, this.figure_name, this.figure_anno_value, namespace);
                    this.addGenericAnno((SNode)figure_struc, attributes, namespace);
                    this.sDocGraph.addNode((Node)figure_struc);
                    this.setDominatingStruc(figure_struc);
                    this.getNodeStack().add((SNode)figure_struc);
                    this.setEmptyToken();
                    return;
                }
                if ("m".equals(qName)) {
                    String namespace = this.retrieveNamespace(this.use_namespace, this.figure_name);
                    this.setToken(this.txt);
                    this.getTagStack().push("m");
                    int length = attributes.getLength();
                    int i = 0;
                    while (i < length) {
                        String name = attributes.getQName(i);
                        String value = attributes.getValue(i);
                        SAnnotation tempanno = SaltFactory.createSAnnotation();
                        tempanno.setName(name);
                        tempanno.setValue((Object)attributes.getValue(value));
                        tempanno.setNamespace(namespace);
                        this.getSAnnoStack().add(tempanno);
                        ++i;
                    }
                    return;
                }
                if ("unclear".equals(qName)) {
                    String namespace = this.retrieveNamespace(this.use_namespace, this.unclear_name);
                    if (this.unclear_as_token == false) return;
                    this.setToken(this.txt);
                    this.getTagStack().push("m");
                    SWordAnnotation wordanno = SaltFactory.createSWordAnnotation();
                    this.getSAnnoStack().add((SAnnotation)wordanno);
                    SAnnotation wordanno2 = SaltFactory.createSAnnotation();
                    wordanno2.setName("unclear");
                    this.getSAnnoStack().add(wordanno2);
                    int length = attributes.getLength();
                    int i = 0;
                    while (i < length) {
                        String name = attributes.getQName(i);
                        String value = attributes.getValue(i);
                        SAnnotation tempanno = SaltFactory.createSAnnotation();
                        tempanno.setName(name);
                        tempanno.setValue((Object)attributes.getValue(value));
                        tempanno.setNamespace(namespace);
                        this.getSAnnoStack().add(tempanno);
                        ++i;
                    }
                    return;
                }
                if ("surplus".equals(qName)) {
                    String namespace = this.retrieveNamespace(this.use_namespace, this.unclear_name);
                    this.setToken(this.txt);
                    int length = attributes.getLength();
                    int i = 0;
                    while (i < length) {
                        String name = attributes.getQName(i);
                        String value = attributes.getValue(i);
                        SAnnotation tempanno = SaltFactory.createSAnnotation();
                        tempanno.setName(name);
                        tempanno.setValue((Object)attributes.getValue(value));
                        tempanno.setNamespace(namespace);
                        this.getSAnnoStack().add(tempanno);
                        ++i;
                    }
                    return;
                }
                if ("gap".equals(qName)) {
                    String namespace = this.retrieveNamespace(this.use_namespace, this.unclear_name);
                    this.setToken(this.txt);
                    this.getTagStack().push("gap");
                    int length = attributes.getLength();
                    int i = 0;
                    while (true) {
                        if (i >= length) {
                            this.setGapToken();
                            return;
                        }
                        String name = attributes.getQName(i);
                        String value = attributes.getValue(i);
                        SAnnotation tempanno = SaltFactory.createSAnnotation();
                        tempanno.setName(name);
                        tempanno.setValue((Object)attributes.getValue(value));
                        tempanno.setNamespace(namespace);
                        this.getSAnnoStack().add(tempanno);
                        ++i;
                    }
                }
                if ("app".equals(qName)) {
                    return;
                }
                if ("body".equals(qName)) {
                    return;
                }
                if (this.generic_struct.booleanValue()) {
                    String namespace = this.retrieveNamespace(this.use_namespace, qName);
                    this.getTagStack().push(qName);
                    SStructure gen_struc = SaltFactory.createSStructure();
                    this.addDefaultAnnotation((SNode)gen_struc, qName, qName, namespace);
                    this.sDocGraph.addNode((Node)gen_struc);
                    this.setDominatingStruc(gen_struc);
                    this.getNodeStack().add((SNode)gen_struc);
                    if (this.generic_attr == false) return;
                    int length = attributes.getLength();
                    int i = 0;
                    while (i < length) {
                        String name = attributes.getQName(i);
                        String value = attributes.getValue(i);
                        SAnnotation tempAnno = this.sDocGraph.createAnnotation(namespace, name, (Object)value);
                        gen_struc.addAnnotation(tempAnno);
                        ++i;
                    }
                    return;
                }
                if (this.generic_span == false) return;
                this.addToGenericSpans(qName, attributes);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("teiHeader".equals(qName)) {
                this.metadata = false;
                Map<String, String> custommappings = this.props.getMappingTable();
                Map<String, String> united = this.tei_metadata.uniteMappings(custommappings);
                Map<String, String> sineonesmap = this.tei_metadata.remove_ones(this.tei_metadata.getXPathMap());
                Map<String, String> completedmappings = this.tei_metadata.mapToXpathMap(sineonesmap, united, this.del_redundant_metadata);
                this.tei_metadata.add_to_SDoc(this.sDocGraph.getDocument(), completedmappings, this.lastPart, this.excludeMetaSet);
            } else if (this.metadata.booleanValue()) {
                this.tei_metadata.push_to_XPathMap(this.meta_txt.toString());
                this.meta_txt.setLength(0);
                this.tei_metadata.pop();
            } else if (this.insidetext.booleanValue()) {
                if ("w".equals(qName)) {
                    this.setToken(this.txt);
                    if (!this.default_tokenization.booleanValue() || this.default_token_tag != "w") {
                        this.popNodeWithNoTokenCheck();
                    }
                } else if ("phr".equals(qName)) {
                    this.popNodeWithNoTokenCheck();
                } else if ("head".equals(qName)) {
                    String namespace = this.retrieveNamespace(this.use_namespace, this.body_head_name);
                    if (this.getTagStack().peek() == "head") {
                        if (this.txt.length() > 0) {
                            this.setToken(this.txt);
                        } else {
                            this.setEmptyToken();
                        }
                        this.popNodeWithNoTokenCheck();
                    }
                    if (this.getTagStack().peek() == "figure") {
                        this.getNodeStack().peek().createAnnotation(namespace, this.body_head_name, (Object)this.txt.toString().trim());
                        this.txt.setLength(0);
                    }
                } else if ("div".equals(qName)) {
                    this.popNodeWithNoTokenCheck();
                } else if ("p".equals(qName)) {
                    if (this.insidetext.booleanValue()) {
                        this.setToken(this.txt);
                        this.popNodeWithNoTokenCheck();
                    }
                } else if ("foreign".equals(qName)) {
                    this.setToken(this.txt);
                } else if ("figure".equals(qName)) {
                    this.popNodeWithNoTokenCheck();
                } else if ("m".equals(qName)) {
                    SAnnotation tempanno = SaltFactory.createSAnnotation();
                    tempanno.setName("morpheme");
                    this.getSAnnoStack().add(tempanno);
                    this.setToken(this.txt);
                } else if ("unclear".equals(qName)) {
                    if (this.unclear_as_token.booleanValue()) {
                        if (this.txt.length() == 0) {
                            SToken temp_tok = null;
                            temp_tok = this.sDocGraph.createToken((SSequentialDS)this.primaryText, (Integer)this.primaryText.getEnd(), (Integer)this.primaryText.getEnd());
                            this.setDominatingToken(temp_tok);
                            this.push_spans(temp_tok);
                            while (!this.getSAnnoStack().isEmpty()) {
                                if (temp_tok.getLabel(null, this.getSAnnoStack().peek().getName()) == null) {
                                    temp_tok.addAnnotation(this.getSAnnoStack().pop());
                                    continue;
                                }
                                this.getSAnnoStack().pop();
                            }
                        }
                        this.setToken(this.txt);
                    }
                } else if ("text".equals(qName)) {
                    this.insidetext = false;
                    this.popNodeWithNoTokenCheck();
                } else if ("surplus".equals(qName)) {
                    if (this.surplus_removal.booleanValue()) {
                        this.txt.setLength(0);
                    } else {
                        this.setToken(this.txt);
                    }
                } else if (!("title".equals(qName) || "gap".equals(qName) || "app".equals(qName) || "lem".equals(qName) || "body".equals(qName) || "lb".equals(qName) || "pb".equals(qName))) {
                    if (this.generic_struct.booleanValue()) {
                        this.setToken(this.txt);
                        this.popNodeWithNoTokenCheck();
                    } else if (this.generic_span.booleanValue()) {
                        this.generic_break(qName, this.genericSpanMap.get(qName), qName);
                    }
                }
            }
            if (!this.getTagStack().isEmpty() && this.getTagStack().peek().equals(qName)) {
                this.getTagStack().pop();
            }
        }
    }
}

