/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.TEIModules;

import com.neovisionaries.i18n.LanguageCode;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.corpus_tools.pepper.modules.PepperModuleProperties;
import org.corpus_tools.pepper.modules.PepperModuleProperty;

public class TEIImporterProperties
extends PepperModuleProperties {
    private static final long serialVersionUID = -2871690146180228706L;
    public static final String PROP_TOKEN_TOKENIZATION_SUB = "token.tokenization.sub";
    public static final String PROP_TOKEN_TOKENIZATION_DEFAULTTAG = "token.tokenization.defaulttag";
    public static final String PROP_ELEMENT_SURPLUS_REMOVE = "element.surplus.remove";
    public static final String PROP_ELEMENT_UNCLEAR_TOKEN = "element.unclear.token";
    public static final String PROP_ELEMENT_FOREIGN_TOKEN = "element.foreign.token";
    public static final String PROP_TOKEN_TOKENIZE = "token.tokenize";
    public static final String PROP_TOKEN_TOKENIZE_LANG = "token.tokenize.lang";
    public static final String PROP_METADATA_REDUNDANT_REMOVE = "metadata.redundant.remove";
    public static final String PROP_ANNOTATION_DEFAULT_REMOVE = "annotation.default.remove";
    public static final String PROP_ANNOTATION_NAMESPACE = "annotation.namespace";
    public static final String PROP_ANNOTATION_ELEMENT_RENAME = "annotation.element.rename";
    public static final String PROP_ANNOTATION_VALUE_RENAME = "annotation.value.rename";
    public static final String PROP_METADATA_RENAME = "metadata.rename";
    public static final String PROP_ELEMENT_GENERIC_NODE = "element.generic.node";
    public static final String PROP_ELEMENT_GENERIC_ATTRIBUTE = "element.generic.attribute";
    public static final String PROP_ANNOTATION_TOKEN_SPAN = "annotation.token.span";
    public static final String PROP_METADATA_LASTPARTONLY = "metadata.lastpartonly";
    public static final String PROP_METADATA_REMOVE_LIST = "metadata.remove.list";
    private Map<String, String> tagRenameTable = null;
    private Map<String, String> tagRenameValuesTable = null;
    private Map<String, String> mappingTable = null;

    public TEIImporterProperties() {
        this.addProperty(new PepperModuleProperty(PROP_TOKEN_TOKENIZATION_SUB, Boolean.class, "In this scenario, units smaller than \u2018words\u2019 exist. Elements within <w> etc. are possible", (Object)true, false));
        this.addProperty(new PepperModuleProperty(PROP_TOKEN_TOKENIZATION_DEFAULTTAG, Boolean.class, "One element is responsible for tokenization. Default is <w> in this mode.", (Object)false, false));
        this.addProperty(new PepperModuleProperty(PROP_ELEMENT_SURPLUS_REMOVE, Boolean.class, "Will text from <surplus> appear in Salt?", (Object)true, false));
        this.addProperty(new PepperModuleProperty(PROP_ELEMENT_UNCLEAR_TOKEN, Boolean.class, "Does <unclear> exclusively include one token?", (Object)true, false));
        this.addProperty(new PepperModuleProperty(PROP_ELEMENT_FOREIGN_TOKEN, Boolean.class, "Does <foreign> exclusively include one token?", (Object)true, false));
        this.addProperty(new PepperModuleProperty(PROP_TOKEN_TOKENIZE, Boolean.class, "Do you want to tokenize the text?", (Object)false, false));
        this.addProperty(new PepperModuleProperty(PROP_TOKEN_TOKENIZE_LANG, String.class, "What language do you want to use for tokenization? (ISO 639-1 code)", (Object)"", false));
        this.addProperty(new PepperModuleProperty(PROP_METADATA_REDUNDANT_REMOVE, Boolean.class, "Do you want metadata with a custom mapping to appear only once?", (Object)true, false));
        this.addProperty(new PepperModuleProperty(PROP_ANNOTATION_DEFAULT_REMOVE, Boolean.class, "Do you want to remove default annotations(e.g. p=p)?", (Object)false, false));
        this.addProperty(new PepperModuleProperty(PROP_ANNOTATION_NAMESPACE, Boolean.class, "Do you want to add the tag-namespace to SAnnotations?", (Object)false, false));
        this.addProperty(new PepperModuleProperty(PROP_ELEMENT_GENERIC_NODE, String.class, "Do you want generic nodes? And if yes what kind?", (Object)"struct", false));
        this.addProperty(new PepperModuleProperty(PROP_ELEMENT_GENERIC_ATTRIBUTE, Boolean.class, "Do you want to include generic attribute annotations?", (Object)true, false));
        this.addProperty(new PepperModuleProperty(PROP_ANNOTATION_TOKEN_SPAN, Boolean.class, "Do you want to have spans for all token annotations?", (Object)false, false));
        this.addProperty(new PepperModuleProperty(PROP_ANNOTATION_ELEMENT_RENAME, String.class, "String containing the tag renaming configuration set by the user", (Object)"", false));
        this.addProperty(new PepperModuleProperty(PROP_ANNOTATION_VALUE_RENAME, String.class, "String containing the value renaming configuration set by the user", (Object)"", false));
        this.addProperty(new PepperModuleProperty(PROP_METADATA_RENAME, String.class, "String containing the metadata mappings set by the user", (Object)"", false));
        this.addProperty(new PepperModuleProperty(PROP_METADATA_LASTPARTONLY, Boolean.class, "Do you want to remove everything from metadata but what is after the last '/'?", (Object)false, false));
        this.addProperty(new PepperModuleProperty(PROP_METADATA_REMOVE_LIST, String.class, "List of keys of metadata to be omitted.", (Object)"", false));
    }

    public boolean isDefaultTokenization() {
        boolean retVal = false;
        String prop = this.getProperty(PROP_TOKEN_TOKENIZATION_DEFAULTTAG).getValue().toString();
        if (prop != null && !prop.isEmpty()) {
            retVal = Boolean.valueOf(prop);
        }
        return retVal;
    }

    public boolean isSubTokenization() {
        boolean retVal = false;
        String prop = this.getProperty(PROP_TOKEN_TOKENIZATION_SUB).getValue().toString();
        if (prop != null && !prop.isEmpty()) {
            retVal = Boolean.valueOf(prop);
        }
        return retVal;
    }

    public boolean isSurplusRemoval() {
        boolean retVal = false;
        String prop = this.getProperty(PROP_ELEMENT_SURPLUS_REMOVE).getValue().toString();
        if (prop != null && !prop.isEmpty()) {
            retVal = Boolean.valueOf(prop);
        }
        return retVal;
    }

    public boolean isUnclearAsToken() {
        boolean retVal = false;
        String prop = this.getProperty(PROP_ELEMENT_UNCLEAR_TOKEN).getValue().toString();
        if (prop != null && !prop.isEmpty()) {
            retVal = Boolean.valueOf(prop);
        }
        return retVal;
    }

    public boolean isForeignAsToken() {
        boolean retVal = false;
        String prop = this.getProperty(PROP_ELEMENT_FOREIGN_TOKEN).getValue().toString();
        if (prop != null && !prop.isEmpty()) {
            retVal = Boolean.valueOf(prop);
        }
        return retVal;
    }

    public boolean isUseTokenizer() {
        boolean retVal = false;
        String prop = this.getProperty(PROP_TOKEN_TOKENIZE).getValue().toString();
        if (prop != null && !prop.isEmpty()) {
            retVal = Boolean.valueOf(prop);
        }
        return retVal;
    }

    public boolean isDelMetadata() {
        boolean retVal = false;
        String prop = this.getProperty(PROP_METADATA_REDUNDANT_REMOVE).getValue().toString();
        if (prop != null && !prop.isEmpty()) {
            retVal = Boolean.valueOf(prop);
        }
        return retVal;
    }

    public boolean isSkipAnnotations() {
        boolean retVal = false;
        String prop = this.getProperty(PROP_ANNOTATION_DEFAULT_REMOVE).getValue().toString();
        if (prop != null && !prop.isEmpty()) {
            retVal = Boolean.valueOf(prop);
        }
        return retVal;
    }

    public boolean isUseNamespace() {
        boolean retVal = false;
        String prop = this.getProperty(PROP_ANNOTATION_NAMESPACE).getValue().toString();
        if (prop != null && !prop.isEmpty()) {
            retVal = Boolean.valueOf(prop);
        }
        return retVal;
    }

    public boolean isUseGenericStruct() {
        boolean retVal = false;
        String prop = this.getProperty(PROP_ELEMENT_GENERIC_NODE).getValue().toString();
        if (prop != null && !prop.isEmpty() && prop.equals("struct")) {
            retVal = true;
        }
        return retVal;
    }

    public boolean isUseGenericSpan() {
        boolean retVal = false;
        String prop = this.getProperty(PROP_ELEMENT_GENERIC_NODE).getValue().toString();
        if (prop != null && !prop.isEmpty() && prop.equals("span")) {
            retVal = true;
        }
        return retVal;
    }

    public boolean isUseGenericAttr() {
        boolean retVal = false;
        String prop = this.getProperty(PROP_ELEMENT_GENERIC_ATTRIBUTE).getValue().toString();
        if (prop != null && !prop.isEmpty()) {
            retVal = Boolean.valueOf(prop);
        }
        return retVal;
    }

    public boolean isUseTokenAnnoSpan() {
        boolean retVal = false;
        String prop = this.getProperty(PROP_ANNOTATION_TOKEN_SPAN).getValue().toString();
        if (prop != null && !prop.isEmpty()) {
            retVal = Boolean.valueOf(prop);
        }
        return retVal;
    }

    public boolean isUseLastPart() {
        boolean retVal = false;
        String prop = this.getProperty(PROP_METADATA_LASTPARTONLY).getValue().toString();
        if (prop != null && !prop.isEmpty()) {
            retVal = Boolean.valueOf(prop);
        }
        return retVal;
    }

    public String customAnnotationString(String param) {
        String retVal = "";
        Object propO = this.getProperty(param).getValue();
        String prop = null;
        if (propO != null) {
            prop = propO.toString();
        }
        if (prop != null && !prop.isEmpty()) {
            retVal = prop;
        }
        return retVal;
    }

    private String tokenizer_lang() {
        String retVal = "";
        Object propO = this.getProperty(PROP_TOKEN_TOKENIZE_LANG).getValue();
        String prop = null;
        if (propO != null) {
            prop = propO.toString();
        }
        if (prop != null && !prop.isEmpty()) {
            retVal = prop;
        }
        LinkedList<String> langlist = new LinkedList<String>();
        langlist.push("de");
        langlist.push("en");
        langlist.push("fr");
        langlist.push("it");
        if (langlist.contains(retVal)) {
            return retVal;
        }
        return "en";
    }

    public LanguageCode tokenizer_code() {
        Hashtable<String, LanguageCode> langmap = new Hashtable<String, LanguageCode>();
        langmap.put("de", LanguageCode.de);
        langmap.put("en", LanguageCode.en);
        langmap.put("fr", LanguageCode.fr);
        langmap.put("it", LanguageCode.it);
        return (LanguageCode)langmap.get(this.tokenizer_lang());
    }

    public String getTagName(String tagName) {
        String retVal;
        if (this.tagRenameTable == null) {
            this.tagRenameTable = new Hashtable<String, String>();
            Object propO = this.getProperty(PROP_ANNOTATION_ELEMENT_RENAME).getValue();
            String prop = null;
            if (propO.toString().trim() != "") {
                String[] renameParts;
                prop = propO.toString();
                for (String part : renameParts = prop.split(";")) {
                    String[] attVal = part.split(":");
                    this.tagRenameTable.put(attVal[0], attVal[1]);
                }
            }
        }
        if ((retVal = this.tagRenameTable.get(tagName)) == null) {
            retVal = tagName;
        }
        return retVal;
    }

    public String getValuesName(String tagName) {
        String retVal;
        if (this.tagRenameValuesTable == null) {
            this.tagRenameValuesTable = new Hashtable<String, String>();
            Object propO = this.getProperty(PROP_ANNOTATION_VALUE_RENAME).getValue();
            String prop = null;
            if (propO.toString().trim() != "") {
                String[] renameParts;
                prop = propO.toString();
                for (String part : renameParts = prop.split(";")) {
                    String[] attVal = part.split(":");
                    this.tagRenameValuesTable.put(attVal[0], attVal[1]);
                }
            }
        }
        if ((retVal = this.tagRenameValuesTable.get(tagName)) == null) {
            retVal = tagName;
        }
        return retVal;
    }

    public Map<String, String> getMappingTable() {
        return this.mappingTable;
    }

    public String getMappings(String mappingString) {
        String retVal = this.mappingTable.get(mappingString);
        return retVal;
    }

    public void fillMappings() {
        if (this.mappingTable == null) {
            this.mappingTable = new Hashtable<String, String>();
            Object propO = null;
            propO = this.getProperty(PROP_METADATA_RENAME) != null ? this.getProperty(PROP_METADATA_RENAME).getValue() : "";
            String prop = null;
            if (propO.toString().trim() != "") {
                String[] renameParts;
                prop = propO.toString();
                for (String part : renameParts = prop.split(";")) {
                    String[] attVal = part.split(":");
                    this.mappingTable.put(attVal[0], attVal[1]);
                }
            }
        }
    }

    public Set<String> retrieveExcludeMetadataSet() {
        Object propO = null;
        HashSet<String> excludeSet = null;
        if (this.getProperty(PROP_METADATA_REMOVE_LIST) != null) {
            propO = this.getProperty(PROP_METADATA_REMOVE_LIST).getValue();
            String prop = propO.toString();
            String[] propList = prop.split(";");
            excludeSet = new HashSet<String>(Arrays.asList(propList));
        }
        return excludeSet;
    }
}

