/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.TEIModules;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.corpus_tools.salt.common.SDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TEIImporterMetaData {
    private static Logger logger = LoggerFactory.getLogger(TEIImporterMetaData.class);
    private Stack<String> pathStack = new Stack();
    private Map<String, String> XPathMap = null;
    private Set<String> PathSet = new HashSet<String>();
    private Map<String, String> MappingMap = new Hashtable<String, String>();

    public Map<String, String> getMappingMap() {
        return this.MappingMap;
    }

    public Stack<String> getPathStack() {
        return this.pathStack;
    }

    public void setPathStack(Stack<String> pathStack) {
        this.pathStack = pathStack;
    }

    public Map<String, String> getXPathMap() {
        return this.XPathMap;
    }

    public void setXPathMap(Map<String, String> xPathMap) {
        this.XPathMap = xPathMap;
    }

    public Set<String> getPathSet() {
        return this.PathSet;
    }

    public void setPathSet(Set<String> pathSet) {
        this.PathSet = pathSet;
    }

    public TEIImporterMetaData() {
        this.MappingMap.put("/fileDesc/titleStmt/author", "author");
        this.MappingMap.put("/fileDesc/titleStmt/title", "title");
    }

    public void push(String tag) {
        boolean run = true;
        int i = 1;
        while (run) {
            if (!this.PathSet.contains(this.getcurrentpath() + "/" + tag + "[" + i + "]")) {
                this.pathStack.push(tag + "[" + i + "]");
                run = false;
            }
            ++i;
        }
        this.PathSet.add(this.getcurrentpath());
    }

    public String pop() {
        return this.pathStack.pop();
    }

    public String getcurrentpath() {
        String temp = "/";
        for (int i = 0; i < this.pathStack.size(); ++i) {
            temp = temp + (String)this.pathStack.elementAt(i) + "/";
        }
        if (temp.length() > 0) {
            temp = temp.substring(0, temp.length() - 1);
        }
        return temp;
    }

    public void push_to_XPathMap(String value) {
        if (this.XPathMap == null) {
            this.XPathMap = new Hashtable<String, String>();
        }
        this.XPathMap.put(this.getcurrentpath(), value);
    }

    public void push_attribute_XPathMap(String attribute, String value) {
        if (this.XPathMap == null) {
            this.XPathMap = new Hashtable<String, String>();
        }
        this.XPathMap.put(this.getcurrentpath() + "/@" + attribute, value);
    }

    public Map<String, String> uniteMappings(Map<String, String> overwritingMap) {
        this.MappingMap.putAll(overwritingMap);
        return this.MappingMap;
    }

    public Map<String, String> mapToXpathMap(Map<String, String> MetaMap, Map<String, String> customMap, Boolean delRedundant) {
        Set<String> customSet = customMap.keySet();
        for (String oldKey : customSet) {
            if (!MetaMap.containsKey(oldKey)) continue;
            String value = MetaMap.get(oldKey);
            String newKey = customMap.get(oldKey);
            MetaMap.put(newKey, value);
        }
        if (delRedundant.booleanValue()) {
            for (String oldKey : customSet) {
                MetaMap.remove(oldKey);
            }
        }
        return MetaMap;
    }

    public Map<String, String> remove_ones(Map<String, String> map) {
        Hashtable<String, String> newMap = new Hashtable<String, String>();
        Set<String> keySet = this.XPathMap.keySet();
        for (String s : keySet) {
            String t = s.replace("[1]", "");
            String tempvalue = this.XPathMap.get(s);
            newMap.put(t, tempvalue);
        }
        return newMap;
    }

    public void add_to_SDoc(SDocument sdoc, Map<String, String> map, Boolean lastPartOnly, Set<String> exclude) {
        Set<String> keySet = map.keySet();
        for (String tempkey : keySet) {
            String tempvalue = map.get(tempkey);
            if (lastPartOnly.booleanValue()) {
                String[] tempArray = tempkey.split("/");
                int len = tempArray.length;
                tempkey = tempArray[len - 1];
                tempkey = tempkey.replace("@", "");
            }
            if (tempvalue.length() <= 0) continue;
            String cleanedKey = tempkey.replaceAll("\\[\\d\\]", "");
            if (exclude.contains(tempkey) || exclude.contains(cleanedKey)) continue;
            if (sdoc.getMetaAnnotation(tempkey) == null) {
                sdoc.createMetaAnnotation(null, tempkey, (Object)tempvalue);
                continue;
            }
            logger.warn("You try to add a metadatum using a key for the second time. This second one will be ignored!");
        }
    }
}

