/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.TEIModules;

import org.corpus_tools.pepper.impl.PepperImporterImpl;
import org.corpus_tools.pepper.modules.PepperImporter;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleNotReadyException;
import org.corpus_tools.peppermodules.TEIModules.TEIImporterProperties;
import org.corpus_tools.peppermodules.TEIModules.TEIMapper;
import org.corpus_tools.salt.graph.Identifier;
import org.eclipse.emf.common.util.URI;
import org.osgi.service.component.annotations.Component;

@Component(name="TEIImporterComponent", factory="PepperImporterComponentFactory")
public class TEIImporter
extends PepperImporterImpl
implements PepperImporter {
    public static final String MODULE_NAME = "TEIImporter";

    public TEIImporter() {
        this.setName(MODULE_NAME);
        this.setSupplierContact(URI.createURI((String)"saltnpepper@lists.hu-berlin.de"));
        this.setSupplierHomepage(URI.createURI((String)"https://github.com/korpling/pepperModules-TEIModules"));
        this.setDesc("This importer transforms data in TEI format (see http://www.tei-c.org/index.xml) to a Salt model. Please note that this module only supports a sbset of the TEI P5 guidelines. ");
        this.addSupportedFormat("TEI", "P5 2.6.0", null);
        this.setProperties(new TEIImporterProperties());
        this.getDocumentEndings().add("xml");
        this.getDocumentEndings().add("tei");
    }

    public PepperMapper createPepperMapper(Identifier sElementId) {
        TEIMapper mapper = new TEIMapper();
        mapper.setResourceURI((URI)this.getIdentifier2ResourceTable().get(sElementId));
        return mapper;
    }

    public void end() throws PepperModuleException {
        super.end();
    }

    public Double isImportable(URI corpusPath) {
        return null;
    }

    public boolean isReadyToStart() throws PepperModuleNotReadyException {
        return super.isReadyToStart();
    }
}

