/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.ridgesModules;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.impl.PepperManipulatorImpl;
import org.corpus_tools.pepper.impl.PepperMapperImpl;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.PepperModuleProperties;
import org.corpus_tools.pepper.modules.PepperModuleProperty;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.SSpanningRelation;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.STextualRelation;
import org.corpus_tools.salt.common.STimelineRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SAnnotationContainer;
import org.corpus_tools.salt.core.SFeature;
import org.corpus_tools.salt.core.SLayer;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.graph.Identifier;
import org.corpus_tools.salt.graph.LabelableElement;
import org.corpus_tools.salt.graph.Layer;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;
import org.corpus_tools.salt.util.SaltUtil;
import org.eclipse.emf.common.util.URI;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="Timeline2TokenComponent", factory="PepperManipulatorComponentFactory")
public class Timeline2Token
extends PepperManipulatorImpl {
    private static final Logger logger = LoggerFactory.getLogger(Timeline2Token.class);

    public Timeline2Token() {
        this.setSupplierContact(URI.createURI((String)"saltnpepper@lists.hu-berlin.de"));
        this.setSupplierHomepage(URI.createURI((String)"https://github.com/korpling/pepperModules-RidgesModules"));
        this.setDesc("The Timeline2Token manipulator converts all primary text tokens to spans of an newly created artifical primary text which represents the timeline. ");
        this.setName("Timeline2Token");
        this.setProperties(new Timeline2TokenProperties());
    }

    public PepperMapper createPepperMapper(Identifier sElementId) {
        Timeline2TokenMapper mapper = new Timeline2TokenMapper();
        return mapper;
    }

    private class Timeline2TokenMapper
    extends PepperMapperImpl {
        private Timeline2TokenMapper() {
        }

        public DOCUMENT_STATUS mapSDocument() {
            SDocument doc = this.getDocument();
            SDocumentGraph graph = doc.getDocumentGraph();
            String annoNamespace = ((Timeline2TokenProperties)this.getProperties()).getAnnoNamespace();
            HashSet<SToken> artificialTokenSet = new HashSet<SToken>();
            ArrayList<SToken> artificialTokens = new ArrayList<SToken>();
            STextualDS timelineText = SaltFactory.createSTextualDS();
            graph.addNode((Node)timelineText);
            StringBuilder sbText = new StringBuilder();
            int i = 0;
            if (graph.getTimeline() == null) {
                throw new PepperModuleException((PepperMapper)this, "No timeline was found for document '" + SaltUtil.getGlobalId((Identifier)doc.getIdentifier()) + "'. ");
            }
            if (graph.getTimeline().getEnd() == null) {
                throw new PepperModuleException((PepperMapper)this, "The timeline for document '" + SaltUtil.getGlobalId((Identifier)doc.getIdentifier()) + "' does not contain any points of time. ");
            }
            SLayer tokenLayer = null;
            String tokenLayerProp = ((Timeline2TokenProperties)this.getProperties()).getTokenLayer();
            if (tokenLayerProp != null && !tokenLayerProp.isEmpty()) {
                tokenLayer = SaltFactory.createSLayer();
                tokenLayer.setName(tokenLayerProp);
                graph.addLayer((Layer)tokenLayer);
            }
            for (int t = 0; t <= (Integer)graph.getTimeline().getEnd(); ++t) {
                STextualRelation textRel = SaltFactory.createSTextualRelation();
                textRel.setStart((Number)sbText.length());
                if (((Timeline2TokenProperties)this.getProperties()).getNumberArtificialTokens()) {
                    sbText.append(i);
                }
                textRel.setEnd((Number)sbText.length());
                sbText.append(" ");
                SToken tok = SaltFactory.createSToken();
                tok.setName("virtualToken" + t);
                textRel.setSource((Node)tok);
                textRel.setTarget((Node)timelineText);
                graph.addNode((Node)tok);
                graph.addRelation((Relation)textRel);
                if (tokenLayer != null) {
                    tokenLayer.addNode((Node)tok);
                }
                artificialTokens.add(tok);
                artificialTokenSet.add(tok);
                ++i;
            }
            timelineText.setText(sbText.toString());
            this.setProgress(0.1);
            ArrayList timeRels = new ArrayList(graph.getTimelineRelations());
            ListIterator it = timeRels.listIterator();
            while (it.hasNext()) {
                int currentPosition = it.nextIndex();
                double ratio = (double)currentPosition / (double)timeRels.size();
                this.setProgress(0.1 + ratio * 0.7);
                STimelineRelation timeRel = (STimelineRelation)it.next();
                SToken tok = (SToken)timeRel.getSource();
                if (artificialTokenSet.contains(tok)) continue;
                SSpan span = SaltFactory.createSSpan();
                graph.addNode((Node)span);
                List<SToken> coveredArtificialToken = artificialTokens.subList((Integer)timeRel.getStart(), (Integer)timeRel.getEnd());
                for (SToken newTok : coveredArtificialToken) {
                    SSpanningRelation spanRel = SaltFactory.createSSpanningRelation();
                    spanRel.setSource((Node)span);
                    spanRel.setTarget((Node)newTok);
                    graph.addRelation((Relation)spanRel);
                }
                this.copySpan(graph, tok, span, annoNamespace);
                this.copyTokenAttributes(graph, coveredArtificialToken, tok, span);
                graph.removeNode((Node)tok);
            }
            this.setProgress(0.8);
            LinkedList oldTexts = new LinkedList(graph.getTextualDSs());
            oldTexts.remove(timelineText);
            for (STextualDS text : oldTexts) {
                graph.removeNode((Node)text);
            }
            this.setProgress(1.0);
            return DOCUMENT_STATUS.COMPLETED;
        }

        private void copySpan(SDocumentGraph graph, SToken tok, SSpan span, String annoNamespace) {
            STextualRelation textRel = null;
            for (Relation e : graph.getOutRelations(tok.getId())) {
                if (!(e instanceof STextualRelation)) continue;
                textRel = (STextualRelation)e;
                break;
            }
            if (textRel != null) {
                STextualDS text = (STextualDS)textRel.getTarget();
                SAnnotation spanAnno = SaltFactory.createSAnnotation();
                spanAnno.setNamespace(annoNamespace);
                spanAnno.setName(text.getName());
                spanAnno.setValue((Object)text.getText().substring((Integer)textRel.getStart(), (Integer)textRel.getEnd()));
                span.addAnnotation(spanAnno);
            }
        }

        private void copyTokenAttributes(SDocumentGraph graph, List<SToken> coveredArtificialTokens, SToken tok, SSpan span) {
            this.copyAnnotations((LabelableElement)tok, (LabelableElement)span);
            ArrayList inRelations = new ArrayList(graph.getInRelations(tok.getId()));
            for (Relation e : inRelations) {
                if (!(e instanceof SRelation)) continue;
                if (e instanceof SSpanningRelation) {
                    SSpanningRelation spanRel = (SSpanningRelation)e;
                    this.copySpanRelation(graph, spanRel, coveredArtificialTokens);
                    graph.removeRelation((Relation)spanRel);
                    continue;
                }
                ((SRelation)e).setTarget((Node)span);
            }
            ArrayList outRelations = new ArrayList(graph.getOutRelations(tok.getId()));
            for (Relation e : outRelations) {
                if (!(e instanceof SRelation)) continue;
                if (e instanceof STextualRelation) {
                    STextualRelation textRel = (STextualRelation)e;
                    this.copyTextualRelation(graph, textRel, coveredArtificialTokens);
                    graph.removeRelation((Relation)textRel);
                    continue;
                }
                ((SRelation)e).setSource((Node)span);
            }
        }

        private void copyTextualRelation(SDocumentGraph graph, STextualRelation origRel, List<SToken> newSources) {
            for (SToken tok : newSources) {
                STextualRelation rel = SaltFactory.createSTextualRelation();
                rel.setSource((Node)tok);
                rel.setTarget(origRel.getTarget());
                this.copyAnnotations((LabelableElement)origRel, (LabelableElement)rel);
                graph.addRelation((Relation)rel);
            }
        }

        private void copySpanRelation(SDocumentGraph graph, SSpanningRelation origRel, List<SToken> newTargets) {
            for (SToken tok : newTargets) {
                SSpanningRelation rel = SaltFactory.createSSpanningRelation();
                rel.setSource(origRel.getSource());
                rel.setTarget((Node)tok);
                this.copyAnnotations((LabelableElement)origRel, (LabelableElement)rel);
                graph.addRelation((Relation)rel);
            }
        }

        private void copyAnnotations(LabelableElement orig, LabelableElement copy) {
            if (orig instanceof SAnnotationContainer && copy instanceof SAnnotationContainer) {
                for (SAnnotation anno : ((SAnnotationContainer)orig).getAnnotations()) {
                    ((SAnnotationContainer)copy).addAnnotation(anno);
                }
            }
            if (orig instanceof SAnnotationContainer && copy instanceof SAnnotationContainer) {
                for (SFeature feature : ((SAnnotationContainer)orig).getFeatures()) {
                    if ("salt".equals(feature.getNamespace())) continue;
                    ((SAnnotationContainer)copy).addFeature(feature);
                }
            }
        }
    }

    public class Timeline2TokenProperties
    extends PepperModuleProperties {
        private static final String PROP_NUMBER_ARTIFICIAL_TOKEN = "number-artificial-token";
        private static final String PROP_ANNO_NAMESPACE = "anno-namespace";
        private static final String PROP_TOKEN_LAYER = "token-layer";

        public Timeline2TokenProperties() {
            this.addProperty(new PepperModuleProperty(PROP_NUMBER_ARTIFICIAL_TOKEN, Boolean.class, "???", (Object)Boolean.TRUE, false));
            this.addProperty(new PepperModuleProperty(PROP_ANNO_NAMESPACE, String.class, "Namespace given to the annotation created from the token. Default is \"annis\"", (Object)"annis", false));
            this.addProperty(new PepperModuleProperty(PROP_TOKEN_LAYER, String.class, "If set and not empty the layer to which each token should be added to.", null, false));
        }

        public boolean getNumberArtificialTokens() {
            boolean numberArtificialTokens = "true".equalsIgnoreCase(this.getProperty(PROP_NUMBER_ARTIFICIAL_TOKEN).getValue().toString());
            return numberArtificialTokens;
        }

        public String getAnnoNamespace() {
            return (String)this.getProperty(PROP_ANNO_NAMESPACE).getValue();
        }

        public String getTokenLayer() {
            PepperModuleProperty prop = this.getProperty(PROP_TOKEN_LAYER);
            if (prop != null) {
                return (String)prop.getValue();
            }
            return null;
        }
    }
}

