/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.falkoModules;

import java.util.ArrayList;
import java.util.List;
import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.impl.PepperManipulatorImpl;
import org.corpus_tools.pepper.impl.PepperMapperImpl;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.peppermodules.falkoModules.FalkoMaipulatorProperties;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.SSpanningRelation;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.STextualRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SLayer;
import org.corpus_tools.salt.graph.Identifier;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;
import org.eclipse.emf.common.util.URI;
import org.osgi.service.component.annotations.Component;

@Component(name="FALKOManipulatorComponent", factory="PepperManipulatorComponentFactory")
public class FALKOManipulator
extends PepperManipulatorImpl {
    public FALKOManipulator() {
        this.setName("FALKOManipulator");
        this.setSupplierContact(URI.createURI((String)"saltnpepper@lists.hu-berlin.de"));
        this.setSupplierHomepage(URI.createURI((String)"https://github.com/korpling/pepperModules-FALKOModules"));
        this.setDesc("This manipulator was developed especially for the FALKO Corpus. It creates a SSpan-objects for every SToken object in the document. All annotations for STokens will be duplicated and added to the spans. The annotations of the tokens will be renamed from 'annoName' to 'annoName.'. For example a 'pos'-annotation of SToken-object will be renamed to a 'pos.'-annotation. All spans, tokens and spanning relations will be added to an artificial layer named 'falko'. ");
        this.setProperties(new FalkoMaipulatorProperties());
    }

    public PepperMapper createPepperMapper(Identifier sElementId) {
        FalkoMapper mapper = new FalkoMapper();
        return mapper;
    }

    private class FalkoMapper
    extends PepperMapperImpl {
        private static final String KW_POSTFIX = ".";
        private static final String KW_WORD = "word";

        private FalkoMapper() {
        }

        public DOCUMENT_STATUS mapSDocument() {
            SDocumentGraph sDocGraph;
            if (this.getDocument().getDocumentGraph() == null) {
                this.getDocument().setDocumentGraph(SaltFactory.createSDocumentGraph());
            }
            if ((sDocGraph = this.getDocument().getDocumentGraph()) != null) {
                List sTokens = sDocGraph.getTokens();
                ArrayList<SToken> emptyTokensAtStart = new ArrayList<SToken>();
                if (sTokens != null && sTokens.size() > 0) {
                    SToken sToken = null;
                    STextualRelation sTextRel = null;
                    SSpan sSpan = null;
                    SSpanningRelation sSpanRel = null;
                    SAnnotation sNewAnno = null;
                    for (int i = 0; i < sTokens.size(); ++i) {
                        sToken = (SToken)sTokens.get(i);
                        List outRelations = sDocGraph.getOutRelations(sToken.getId());
                        for (Relation outRelation : outRelations) {
                            if (!(outRelation instanceof STextualRelation)) continue;
                            sTextRel = (STextualRelation)outRelation;
                            break;
                        }
                        if (sTextRel == null) continue;
                        String text = ((STextualDS)sTextRel.getTarget()).getText().substring((Integer)sTextRel.getStart(), (Integer)sTextRel.getEnd());
                        if ((Integer)sTextRel.getStart() < (Integer)sTextRel.getEnd() && !" ".equals(text)) {
                            sSpan = SaltFactory.createSSpan();
                            sDocGraph.addNode((Node)sSpan);
                            sNewAnno = SaltFactory.createSAnnotation();
                            sNewAnno.setName(KW_WORD);
                            sNewAnno.setValue((Object)((STextualDS)sTextRel.getTarget()).getText().substring((Integer)sTextRel.getStart(), (Integer)sTextRel.getEnd()));
                            sSpan.addAnnotation(sNewAnno);
                            if (sToken.getAnnotations() != null && sToken.getAnnotations().size() > 0) {
                                for (SAnnotation sAnno : sToken.getAnnotations()) {
                                    if ("<unknown>".equalsIgnoreCase(sAnno.getValue_STEXT())) {
                                        sAnno.setValue((Object)"[unknown]");
                                    }
                                    sNewAnno = SaltFactory.createSAnnotation();
                                    sNewAnno.setNamespace(sAnno.getNamespace());
                                    sNewAnno.setName(sAnno.getName());
                                    sNewAnno.setValue((Object)sAnno.getValue_STEXT());
                                    sAnno.setName(sAnno.getName() + KW_POSTFIX);
                                    sSpan.addAnnotation(sNewAnno);
                                }
                            }
                            if (emptyTokensAtStart.size() >= 0) {
                                for (SToken emptyToken : emptyTokensAtStart) {
                                    sSpanRel = SaltFactory.createSSpanningRelation();
                                    sSpanRel.setTarget((Node)emptyToken);
                                    sSpanRel.setSource((Node)sSpan);
                                    sDocGraph.addRelation((Relation)sSpanRel);
                                }
                                emptyTokensAtStart.clear();
                            }
                        }
                        if (sSpan != null) {
                            sSpanRel = SaltFactory.createSSpanningRelation();
                            sSpanRel.setTarget((Node)sToken);
                            sSpanRel.setSource((Node)sSpan);
                            sDocGraph.addRelation((Relation)sSpanRel);
                            continue;
                        }
                        emptyTokensAtStart.add(sToken);
                    }
                }
                SLayer sLayer = SaltFactory.createSLayer();
                sLayer.setName(((FalkoMaipulatorProperties)this.getProperties()).getSLayerName());
                boolean addLayer = false;
                for (SToken sToken : sDocGraph.getTokens()) {
                    if (sToken.getLayers() != null && sToken.getLayers().size() != 0) continue;
                    sToken.getLayers().add(sLayer);
                    addLayer = true;
                }
                for (SSpan sSpan : sDocGraph.getSpans()) {
                    if (sSpan.getLayers() != null && sSpan.getLayers().size() != 0) continue;
                    sSpan.getLayers().add(sLayer);
                    addLayer = true;
                }
                for (SSpanningRelation sSpanRel : sDocGraph.getSpanningRelations()) {
                    if (sSpanRel.getLayers() != null && sSpanRel.getLayers().size() != 0) continue;
                    sSpanRel.getLayers().add(sLayer);
                    addLayer = true;
                }
                if (addLayer) {
                    sDocGraph.getLayers().add(sLayer);
                }
            }
            return DOCUMENT_STATUS.COMPLETED;
        }
    }
}

