/*
 * Decompiled with CFR 0.152.
 */
package tag_list;

import basicinfo.ArgList;
import basicinfo.PipeList;
import java.util.Vector;
import tag_list.FileList;
import tag_list.UberEmptiesList;
import tag_list.UberPOSList;
import tag_list.UberSynList;

public class UberList {
    private UberPOSList upos;
    private UberSynList usyn;
    private UberEmptiesList uempty;
    private String pos_dividers;
    private String syn_dividers;
    private String trace_dividers;
    private String empt_str;
    protected Vector syn_divide;
    protected Vector pos_divide;
    protected Vector trace_divide;
    protected ArgList empties;

    private /* synthetic */ void finit$() {
        this.pos_dividers = "+|-";
        this.syn_dividers = "-|=";
        this.trace_dividers = "-";
        this.empt_str = "0|\\**";
    }

    public UberList() {
        this.finit$();
        this.upos = new UberPOSList();
        this.usyn = new UberSynList();
        this.uempty = new UberEmptiesList();
        this.syn_divide = PipeList.makeCharacterList(this.syn_dividers);
        this.pos_divide = PipeList.makeCharacterList(this.pos_dividers);
        this.trace_divide = PipeList.makeCharacterList(this.trace_dividers);
        this.empties = new ArgList(this.empt_str);
    }

    public int sizePOS() {
        return this.upos.size();
    }

    public int sizeSyn() {
        return this.usyn.size();
    }

    public UberPOSList getPOSList() {
        return this.upos;
    }

    public UberSynList getSynList() {
        return this.usyn;
    }

    public UberEmptiesList getEmptyList() {
        return this.uempty;
    }

    public ArgList getEmpties() {
        return this.empties;
    }

    public Vector getSynDivide() {
        return this.syn_divide;
    }

    public Vector getPOSDivide() {
        return this.pos_divide;
    }

    public Vector getTraceDivide() {
        return this.trace_divide;
    }

    public String getSynDivideStr() {
        return this.syn_dividers;
    }

    public String getPOSDivideStr() {
        return this.pos_dividers;
    }

    public String getTraceDivideStr() {
        return this.trace_dividers;
    }

    public void addFileList(FileList fileList) {
        this.upos.addFileList(fileList.getPOSList());
        this.usyn.addFileList(fileList.getSynList());
        this.uempty.addFileList(fileList.getEmptiesList());
    }

    public void Sort() {
        this.upos.Sort();
        this.usyn.Sort();
    }

    public void PrintToSystemErr() {
        System.err.println("UberList:  ");
        this.upos.PrintToSystemErr();
        this.usyn.PrintToSystemErr();
    }

    public void PrintToSystemErr(int n, int n2) {
        System.err.println("UberList:  ");
        this.upos.PrintToSystemErr(n, n2);
        this.usyn.PrintToSystemErr(n, n2);
    }
}

