/*
 * Decompiled with CFR 0.152.
 */
package tag_list;

import java.util.Vector;
import tag_list.LexEntry;

public class SentenceList {
    private Vector syn_list = new Vector();
    private Vector pos_list = new Vector();
    private Vector trace_list = new Vector();

    public void addPOSEntry(String string, Vector vector) {
        LexEntry lexEntry = new LexEntry(string, vector);
        this.pos_list.addElement(lexEntry);
    }

    public void addSynEntry(String string, Vector vector) {
        LexEntry lexEntry = new LexEntry(string, vector);
        this.syn_list.addElement(lexEntry);
    }

    public void addTraceEntry(String string, Vector vector) {
        LexEntry lexEntry = new LexEntry(string, vector);
        this.trace_list.addElement(lexEntry);
    }

    public Vector getPOSList() {
        return this.pos_list;
    }

    public Vector getSynList() {
        return this.syn_list;
    }

    public Vector getTraceList() {
        return this.trace_list;
    }

    public LexEntry entryAtPOS(int n) {
        return (LexEntry)this.pos_list.elementAt(n);
    }

    public LexEntry entryAtSyn(int n) {
        return (LexEntry)this.syn_list.elementAt(n);
    }

    public boolean isEmpty() {
        return this.pos_list.isEmpty() && this.syn_list.isEmpty();
    }

    public boolean isEmptyPOS() {
        return this.pos_list.isEmpty();
    }

    public boolean isEmptySyn() {
        return this.syn_list.isEmpty();
    }

    public int sizePOS() {
        return this.pos_list.size();
    }

    public int sizeSyn() {
        return this.syn_list.size();
    }

    public int size() {
        return this.pos_list.size() + this.syn_list.size();
    }

    public void PrintToSystemErr() {
        this.PrintToSystemErr(0, this.sizePOS(), 0, this.sizeSyn());
    }

    public void PrintToSystemErr(int n, int n2) {
        this.PrintToSystemErr(n, n2, n, n2);
    }

    public void PrintToSystemErr(int n, int n2, int n3, int n4) {
        LexEntry lexEntry;
        int n5;
        System.err.println("SentenceList:  POS tags: ");
        if (n < 0) {
            n = 0;
        }
        if (n2 > this.sizePOS()) {
            n2 = this.sizePOS();
        }
        for (n5 = n; n5 < n2; ++n5) {
            lexEntry = (LexEntry)this.pos_list.elementAt(n5);
            lexEntry.PrintToSystemErr();
        }
        System.err.println("syntactic tags: ");
        if (n3 < 0) {
            n3 = 0;
        }
        if (n4 > this.sizeSyn()) {
            n4 = this.sizeSyn();
        }
        for (n5 = n3; n5 < n4; ++n5) {
            lexEntry = (LexEntry)this.syn_list.elementAt(n5);
            lexEntry.PrintToSystemErr();
        }
    }
}

