/*
 * Decompiled with CFR 0.152.
 */
package tag_list;

import basicinfo.PipeList;
import java.util.Random;
import java.util.Vector;

public class LexEntry {
    private String canonical;
    private int total;
    private Vector dividers;
    private Vector dash_tags;
    private Vector all_tags;
    private Vector dash_tags_list;
    private boolean has_tags;

    public LexEntry() {
        this.total = 0;
    }

    public LexEntry(String string, Vector vector) {
        this.has_tags = false;
        this.all_tags = PipeList.split(string, vector);
        this.splitUp(this.all_tags);
        this.total = 1;
    }

    public boolean hasTags() {
        return this.has_tags;
    }

    private void splitUp(Vector vector) {
        Character c = new Character('Q');
        this.canonical = (String)vector.firstElement();
        if (vector.size() == 1) {
            this.has_tags = false;
            return;
        }
        this.has_tags = true;
        this.dash_tags_list = new Vector();
        for (int i = 1; i < vector.size(); ++i) {
            String string = (String)vector.elementAt(i);
            if (Character.isDigit(string.charAt(0))) continue;
            this.dash_tags = new Vector();
            this.dash_tags.addElement(string);
            this.dash_tags_list.addElement(this.dash_tags);
        }
    }

    public boolean belongs(LexEntry lexEntry) {
        if (lexEntry.getCanonical().equals(this.canonical)) {
            this.addTags(lexEntry);
            return true;
        }
        return false;
    }

    public int tagsSize() {
        return this.dash_tags_list.size();
    }

    public Vector dashTagsAt(int n) {
        return (Vector)this.dash_tags_list.elementAt(n);
    }

    public Vector getDashTagsList() {
        return this.dash_tags_list;
    }

    private void addTags(LexEntry lexEntry) {
        if (!lexEntry.hasTags()) {
            return;
        }
        if (!this.hasTags()) {
            this.dash_tags_list = lexEntry.getDashTagsList();
            this.has_tags = true;
            return;
        }
        for (int i = 0; i < lexEntry.tagsSize(); ++i) {
            Vector vector = lexEntry.dashTagsAt(i);
            if (i >= this.tagsSize()) {
                this.dash_tags_list.addElement(vector);
                continue;
            }
            Vector vector2 = this.dashTagsAt(i);
            for (int j = 0; j < vector.size(); ++j) {
                String string = (String)vector.elementAt(j);
                if (this.containsTag(vector2, string)) continue;
                vector2.addElement(string);
            }
        }
    }

    public boolean containsTag(Vector vector, String string) {
        for (int i = 0; i < vector.size(); ++i) {
            String string2 = (String)vector.elementAt(i);
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public void setCanonical(String string) {
        this.canonical = string.toLowerCase();
    }

    public String getCanonical() {
        return this.canonical;
    }

    public void incrementTotal() {
        ++this.total;
    }

    public int getTotal() {
        return this.total;
    }

    public int getASCIInum() {
        Character c = new Character('Q');
        if (this.canonical.length() == 0) {
            return 0;
        }
        int n = this.canonical.charAt(0);
        int n2 = n = Character.toUpperCase((char)n);
        if ((n2 -= 64) < 1 || n2 > 26) {
            n2 = 0;
        }
        return n2;
    }

    public boolean LaterEntry(LexEntry lexEntry) {
        return this.canonical.compareTo(lexEntry.getCanonical()) > 0;
    }

    public boolean MoreLaterEntry(LexEntry lexEntry) {
        return this.canonical.compareTo(lexEntry.getCanonical()) > 0;
    }

    public void Sort() {
        if (!this.has_tags) {
            return;
        }
        for (int i = 0; i < this.dash_tags_list.size(); ++i) {
            Vector vector = (Vector)this.dash_tags_list.elementAt(i);
            this.QuickSortTags(0, vector.size() - 1, vector);
        }
    }

    private int SplitTags(int n, int n2, int n3, Vector vector) {
        try {
            try {
                String string = (String)vector.elementAt(n3);
                this.Swap(n, n3, vector);
                n3 = n;
                for (int i = n + 1; i <= n2; ++i) {
                    String string2 = (String)vector.elementAt(i);
                    if (string.compareTo(string2) <= 0) continue;
                    this.Swap(++n3, i, vector);
                }
                this.Swap(n, n3, vector);
            }
            catch (Exception exception) {
                System.err.println("SplitTags:  ");
                System.err.println(exception.getMessage());
                exception.printStackTrace();
            }
        }
        catch (Throwable throwable) {}
        return n3;
    }

    private void Swap(int n, int n2, Vector vector) {
        String string = (String)vector.elementAt(n);
        vector.setElementAt((String)vector.elementAt(n2), n);
        vector.setElementAt(string, n2);
    }

    private void QuickSortTags(int n, int n2, Vector vector) {
        Random random = new Random();
        if (n2 > n) {
            int n3 = random.nextInt(n2 - n);
            int n4 = n + n3;
            int n5 = this.SplitTags(n, n2, n4, vector);
            this.QuickSortTags(n, n5 - 1, vector);
            this.QuickSortTags(n5 + 1, n2, vector);
        }
    }

    public void PrintToSystemErr() {
        this.PrintToSystemErr(0, this.dash_tags_list.size());
    }

    public void PrintToSystemErr(int n, int n2) {
        System.err.print(this.canonical);
        if (!this.has_tags) {
            System.err.println("");
            return;
        }
        if (n < 0) {
            n = 0;
        }
        if (n2 > this.dash_tags_list.size()) {
            n2 = this.dash_tags_list.size();
        }
        for (int i = n; i < n2; ++i) {
            this.dash_tags = (Vector)this.dash_tags_list.elementAt(i);
            System.err.print(":");
            for (int j = 0; j < this.dash_tags.size(); ++j) {
                String string = (String)this.dash_tags.elementAt(j);
                System.err.print(string);
                if (j == this.dash_tags.size() - 1) continue;
                System.err.print("|");
            }
        }
        System.err.println("");
    }
}

