/*
 * Decompiled with CFR 0.152.
 */
package syntree;

import java.util.Vector;
import syntree.Node;
import syntree.SparseMatrix;

public class SynTree
extends SparseMatrix {
    public Node ROOT;
    public Node METAROOT;
    public Node ID_POS;
    public Node ID_TEXT;
    public boolean ORTHOtype;

    public void setORTHOFalse() {
        this.ORTHOtype = false;
    }

    public void setORTHOTrue() {
        this.ORTHOtype = true;
    }

    public void setORTHO(boolean bl) {
        this.ORTHOtype = bl;
    }

    public boolean hasORTHO() {
        return this.ORTHOtype;
    }

    public void removeAllElements() {
        super.removeAllElements();
    }

    public void RemoveAllElements() {
        super.removeAllElements();
    }

    public void setEndVector(Vector vector) {
        super.setEndVector(vector);
    }

    public void setLabelVector(Vector vector) {
        super.setLabelVector(vector);
    }

    public Vector getEndVector() {
        return super.GetEndVector();
    }

    public Vector getLabelVector() {
        return super.GetLabelVector();
    }

    public Integer getEndAt(int n) {
        return super.EndDexAt(n);
    }

    public String getLabelAt(int n) {
        return super.LabelAt(n);
    }

    public SynTree synCopy() {
        int n;
        Vector<Integer> vector = new Vector<Integer>();
        Vector<String> vector2 = new Vector<String>();
        for (n = 0; n < super.size(); ++n) {
            vector.addElement(this.getEndAt(n));
        }
        for (n = 0; n < super.size(); ++n) {
            vector2.addElement(this.getLabelAt(n));
        }
        SynTree synTree = new SynTree();
        synTree.setEndVector(vector);
        synTree.setLabelVector(vector2);
        synTree.setConstantNodes();
        synTree.setORTHO(this.ORTHOtype);
        return synTree;
    }

    public Vector GetDescendants(Integer n) {
        Vector<Node> vector = new Vector<Node>();
        int n2 = super.EndDexAt(n);
        for (int i = n + 1; i <= n2; ++i) {
            Node node = super.NodeAt(i);
            vector.addElement(node);
        }
        return vector;
    }

    public Vector GetDescendants(Node node) {
        Integer n = node.getIndex();
        return this.GetDescendants(n);
    }

    public Vector GetDescendants(int n) {
        Integer n2 = new Integer(n);
        return this.GetDescendants(n2);
    }

    public Vector GetDaughters(Vector vector) {
        Vector<Node> vector2 = new Vector<Node>();
        for (int i = 0; i < vector.size(); ++i) {
            Node node = (Node)vector.elementAt(i);
            Vector vector3 = this.GetDaughters(node);
            for (int j = 0; j < vector3.size(); ++j) {
                vector2.addElement((Node)vector3.elementAt(j));
            }
        }
        return vector2;
    }

    public Vector GetDaughters(int n) {
        Integer n2 = new Integer(n);
        return this.GetDaughters(n2);
    }

    public Vector getDaughters(Node node) {
        Integer n = node.getIndex();
        return this.GetDaughters(n);
    }

    public Vector GetDaughters(Node node) {
        return this.getDaughters(node);
    }

    public Vector GetDaughters(Integer n) {
        Vector<Node> vector = new Vector<Node>();
        Integer n2 = new Integer(0);
        int n3 = super.EndDexAt(n);
        for (int i = n + 1; i <= n3; ++i) {
            Integer n4 = n2;
            n2 = super.EndDexAt(i);
            Node node = super.NodeAt(i);
            if (!n2.equals(n4) || this.IsLeafPOS(n2)) {
                vector.addElement(node);
            }
            if (n2 <= i + 1) continue;
            i = n2 - 1;
        }
        return vector;
    }

    public Node FirstDaughter(Integer n) {
        if (this.IsLeafText(n) || n < 0) {
            return new Node("NULL");
        }
        return super.NodeAt(n + 1);
    }

    public Node FirstDaughter(Node node) {
        Integer n = node.getIndex();
        return this.FirstDaughter(n);
    }

    public Node FirstDaughter(int n) {
        Integer n2 = new Integer(n);
        return this.FirstDaughter(n2);
    }

    public Node LastDaughter(int n) {
        return this.LastDaughter(super.NodeAt(n));
    }

    public Node LastDaughter(Node node) {
        Vector vector = this.GetDaughters(node);
        if (vector.isEmpty()) {
            return new Node("NULL");
        }
        return (Node)vector.lastElement();
    }

    public Node LastDescendant(Node node) {
        Integer n = node.getIndex();
        int n2 = super.intEndDexAt(n);
        if (this.IsLeafText(n) || n < 0) {
            return new Node("NULL");
        }
        return super.NodeAt(n2);
    }

    public Node GetMother(int n) {
        Integer n2 = new Integer(n);
        return this.GetMother(n2);
    }

    public Node GetMother(Node node) {
        Integer n = node.getIndex();
        return this.GetMother(n);
    }

    public Node GetMother(Integer n) {
        Integer n2 = super.EndDexAt(n);
        Integer n3 = n;
        while (n3 > 0) {
            Integer n4 = super.EndDexAt(n3 = new Integer(n3 - 1));
            if (n4 < n2) continue;
            Node node = super.NodeAt(n3);
            return node;
        }
        Node node = new Node("NULL");
        return node;
    }

    public Vector GetAncestors(Node node) {
        Vector<Node> vector = new Vector<Node>();
        Node node2 = node;
        while (!node2.IsNullNode()) {
            if ((node2 = this.GetMother(node2)).IsNullNode()) continue;
            vector.addElement(node2);
        }
        return vector;
    }

    public Vector GetAncestors(int n) {
        Node node = super.NodeAt(n);
        return this.GetAncestors(node);
    }

    public Node GetCommonAncestor(Node node, Node node2) {
        return this.GetCommonAncestor(node.getIndex(), node2.getIndex());
    }

    public Node GetCommonAncestor(int n, int n2) {
        Integer n3 = new Integer(n);
        Integer n4 = new Integer(n2);
        return this.GetCommonAncestor(n3, n4);
    }

    public Node GetCommonAncestor(Integer n, Integer n2) {
        Vector<Node> vector = new Vector<Node>();
        Node node = this.GetMother(n);
        while (!node.IsNullNode()) {
            vector.addElement(node);
            node = this.GetMother(node);
        }
        Node node2 = this.GetMother(n2);
        while (!node2.IsNullNode()) {
            for (int i = 0; i < vector.size(); ++i) {
                if (!node2.equals((Node)vector.elementAt(i))) continue;
                return node2;
            }
            node2 = this.GetMother(node2);
        }
        Node node3 = new Node("NULL");
        return node3;
    }

    public Vector GetSisters(Node node) {
        return this.GetSisters(node.getIndex_int());
    }

    public Vector GetSisters(Integer n) {
        return this.GetSisters((int)n);
    }

    public Vector GetSisters(int n) {
        Vector<Node> vector = new Vector<Node>();
        Node node = this.GetMother(n);
        int n2 = node.getIndex_int();
        if (n2 == -1) {
            return vector;
        }
        int n3 = super.intEndDexAt(n2);
        int n4 = super.intEndDexAt(n) + 1;
        while (n4 <= n3) {
            Node node2 = super.NodeAt(n4);
            vector.addElement(node2);
            n4 = super.intEndDexAt(n4) + 1;
        }
        return vector;
    }

    public Vector GetAllSisters(int n) {
        Integer n2 = new Integer(n);
        return this.GetAllSisters(n2);
    }

    public Vector GetAllSisters(Node node) {
        Integer n = node.getIndex();
        return this.GetAllSisters(n);
    }

    public Vector GetAllSisters(Integer n) {
        Vector vector = new Vector();
        Node node = this.GetMother(n);
        vector = this.GetDaughters(node);
        return vector;
    }

    public boolean isOnlyChild(Node node) {
        Vector vector = this.GetAllSisters(node);
        return vector.size() == 1;
    }

    public Node nextSister(Node node) {
        Node node2 = new Node("NULL");
        Node node3 = this.GetMother(node);
        int n = node3.getIndex_int();
        if (n == -1) {
            return node2;
        }
        int n2 = super.intEndDexAt(n);
        int n3 = super.intEndDexAt(node.getIndex_int()) + 1;
        if (n3 <= n2) {
            node2 = super.NodeAt(n3);
        }
        return node2;
    }

    public Node prevSister(int n) {
        return this.prevSister(super.NodeAt(n));
    }

    public Node prevSister(Node node) {
        Node node2 = new Node("NULL");
        Node node3 = this.GetMother(node);
        Vector vector = this.GetDaughters(node3);
        for (int i = 0; i < vector.size(); ++i) {
            node2 = (Node)vector.elementAt(i);
            if (!node2.equals(node)) continue;
            if (i == 0) {
                return new Node("NULL");
            }
            return (Node)vector.elementAt(i - 1);
        }
        return new Node("NULL");
    }

    public boolean IsRightMost(Node node) {
        Integer n;
        Node node2 = this.GetMother(node);
        Integer n2 = this.EndDexAt(node2.getIndex());
        return n2.equals(n = this.EndDexAt(node.getIndex()));
    }

    public boolean IsLeftMost(Node node) {
        Node node2 = this.GetMother(node);
        Integer n = node2.getIndex();
        Integer n2 = node.getIndex();
        return n + 1 == n2;
    }

    public boolean IsLeafPOS(Integer n) {
        Integer n2;
        Integer n3;
        Integer n4 = super.EndDexAt(n);
        return n4.equals(n3 = super.EndDexAt(n2 = new Integer(n + 1))) && n3.equals(n2);
    }

    public boolean IsLeafPOS(int n) {
        Integer n2 = new Integer(n);
        return this.IsLeafPOS(n2);
    }

    public boolean IsLeafPOS(Node node) {
        Integer n = node.getIndex();
        return this.IsLeafPOS(n);
    }

    public boolean IsLeafText(Integer n) {
        Integer n2 = super.EndDexAt(n);
        return n2.equals(n);
    }

    public boolean IsLeafText(int n) {
        Integer n2 = new Integer(n);
        return this.IsLeafText(n2);
    }

    public boolean IsLeafText(Node node) {
        Integer n = node.getIndex();
        return this.IsLeafText(n);
    }

    public boolean dominates(Node node, Node node2) {
        int n = node.getIndex_int();
        int n2 = node2.getIndex_int();
        if (n2 <= n) {
            return false;
        }
        int n3 = super.EndDexAt(n);
        return n2 <= n3;
    }

    public boolean precedes(Node node, Node node2) {
        int n;
        int n2 = node.getIndex_int();
        return n2 <= (n = node2.getIndex_int());
    }

    public Vector getText(Node node) {
        Vector<Node> vector = new Vector<Node>();
        Vector vector2 = this.GetDescendants(node);
        for (int i = 0; i < vector2.size(); ++i) {
            Node node2 = (Node)vector2.elementAt(i);
            if (!this.IsLeafText(node2)) continue;
            vector.addElement(node2);
        }
        return vector;
    }

    public void setIDs() {
        for (int i = super.size() - 1; i > 0; --i) {
            Node node = super.NodeAt(i);
            if (!node.getLabel().equals("ID")) continue;
            this.ID_POS = node;
            this.ID_TEXT = super.NodeAt(i + 1);
            return;
        }
        this.ID_POS = new Node("NULL");
        this.ID_TEXT = new Node("NULL");
    }

    public boolean isRoot(Node node) {
        return this.ROOT.equals(node);
    }

    public boolean isMetaRoot(Node node) {
        return this.METAROOT.equals(node);
    }

    public void setConstantNodes() {
        this.setRoot();
        this.setIDs();
    }

    public void setRoot() {
        if (super.isEmpty()) {
            return;
        }
        this.ROOT = this.getRootNode();
        this.METAROOT = super.NodeAt(0);
    }

    public void conflateRoots() {
        this.setRoot();
        this.ROOT = this.METAROOT;
    }

    public Node getRootNode() {
        String string = "";
        int n = 0;
        string = super.LabelAt(n);
        while (string.length() == 0 || this.IsLeafPOS(n) || this.IsLeafText(n)) {
            if (this.IsLeafPOS(++n) && n + 2 >= super.size()) {
                if (super.LabelAt(n).equals("ID")) {
                    return super.NodeAt(1);
                }
                return super.NodeAt(n);
            }
            if (n >= super.size()) {
                n = 0;
                break;
            }
            string = super.LabelAt(n);
            if (!string.equals("METADATA")) continue;
            n = super.intEndDexAt(n) + 1;
        }
        return super.NodeAt(n);
    }

    public Node getMETADATA() {
        for (int i = 0; i < super.size(); ++i) {
            Node node = super.NodeAt(i);
            if (!node.getLabel().equals("METADATA")) continue;
            return node;
        }
        return new Node("NULL");
    }

    public int getDepth(Node node) {
        int n = 0;
        Node node2 = node;
        while (!node2.IsNullNode()) {
            node2 = this.GetMother(node2);
            ++n;
            if (!node2.equals(this.getRootNode())) continue;
            return n;
        }
        return n;
    }

    public int getDepth(Vector vector) {
        int n = 0;
        for (int i = 0; i < vector.size(); ++i) {
            Node node = (Node)vector.elementAt(i);
            int n2 = this.getDepth(node);
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public int getSubtreeDepth(Node node) {
        return this.getSubtreeDepth(node.getIndex_int());
    }

    public int getSubtreeDepth(int n) {
        int n2 = 0;
        Vector vector = this.GetDescendants(n);
        n2 = this.getDepth(vector);
        return n2;
    }

    public Vector getNodesforDepth(int n) {
        Vector vector = new Vector();
        boolean bl = false;
        vector.addElement(this.getRootNode());
        for (int i = 0; i < n; ++i) {
            vector = this.GetDaughters(vector);
        }
        return vector;
    }

    public Vector getAllNodesforDepth(int n) {
        Vector vector = new Vector();
        boolean bl = false;
        vector.addElement(this.NodeAt(0));
        for (int i = 0; i < n; ++i) {
            vector = this.GetDaughters(vector);
        }
        return vector;
    }

    public Vector allLabelDexes() {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < super.size(); ++i) {
            Node node = super.NodeAt(i);
            String string = node.getLabelDex();
            if (string.equals("UNKNOWN") || string.equals("")) continue;
            vector.addElement(string);
        }
        return vector;
    }

    public String getNewLabelDex() {
        Vector vector = this.allLabelDexes();
        Integer n = this.getMaxDex(vector);
        n = new Integer(n + 1);
        return n.toString();
    }

    public Integer getMaxDex(Vector vector) {
        Integer n = new Integer(0);
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.elementAt(i);
            Integer n2 = new Integer(string);
            if (n2.compareTo(n) <= 0) continue;
            n = n2;
        }
        return n;
    }

    public Node getAntecedent(Node node) {
        Node node2 = this.FirstDaughter(node);
        String string = node2.getLabelDex();
        if (string.equals("")) {
            return new Node("NULL");
        }
        String string2 = node.minusTags();
        for (int i = 0; i < this.size(); ++i) {
            String string3 = super.LabelAt(i);
            if (!string3.startsWith(string2) || !string3.endsWith(string)) continue;
            return super.NodeAt(i);
        }
        return new Node("NULL");
    }

    public Node getTrace(Node node) {
        String string = node.getLabelDex();
        if (string.equals("")) {
            return new Node("NULL");
        }
        String string2 = node.minusTags();
        for (int i = 0; i < this.size(); ++i) {
            String string3 = super.LabelAt(i);
            String string4 = this.FirstDaughter(i).getLabel();
            if (!string3.startsWith(string2) || !string4.endsWith(string)) continue;
            return super.NodeAt(i);
        }
        return new Node("NULL");
    }

    public Node getPartner(Node node) {
        if (this.IsLeafPOS(node)) {
            return this.getAntecedent(node);
        }
        return this.getTrace(node);
    }

    public Vector getCoIndexed(Node node) {
        Vector<Node> vector = new Vector<Node>();
        if (!node.hasLabelDex()) {
            return vector;
        }
        String string = node.getLabelDex();
        for (int i = 0; i < this.size(); ++i) {
            String string2;
            Node node2 = this.NodeAt(i);
            if (node2.equals(node) || !node2.hasLabelDex() || !(string2 = node2.getLabelDex()).equals(string)) continue;
            vector.addElement(node2);
        }
        return vector;
    }

    public Vector leftDescend(int n) {
        Vector<Node> vector = new Vector<Node>();
        Node node = this.FirstDaughter(n);
        while (!node.IsNullNode()) {
            vector.addElement(node);
            node = this.FirstDaughter(node);
        }
        return vector;
    }
}

