/*
 * Decompiled with CFR 0.152.
 */
package syntree;

import java.io.PrintWriter;
import java.util.Vector;
import syntree.Node;
import syntree.SynTree;

public class SparseMatrix {
    private Vector label_vec;
    private Vector end_vec;
    private Integer minus1;

    private /* synthetic */ void finit$() {
        this.minus1 = new Integer(-1);
    }

    public SparseMatrix() {
        this.finit$();
        this.Init();
    }

    public SparseMatrix(String string) {
        this.finit$();
        this.Init();
    }

    public void setSparseMatrix(SynTree synTree) {
        this.label_vec = synTree.GetLabelVector();
        this.end_vec = synTree.GetEndVector();
    }

    private void Init() {
        this.label_vec = new Vector();
        this.end_vec = new Vector();
    }

    public Vector GetLabelVector() {
        return this.label_vec;
    }

    public Vector GetEndVector() {
        return this.end_vec;
    }

    public void setLabelVector(Vector vector) {
        this.label_vec = vector;
    }

    public void setEndVector(Vector vector) {
        this.end_vec = vector;
    }

    public boolean isEmpty() {
        return this.label_vec.isEmpty();
    }

    public void removeAllElements() {
        this.label_vec.removeAllElements();
        this.end_vec.removeAllElements();
    }

    public int size() {
        return this.label_vec.size();
    }

    public void addWrapper() {
        Integer n = new Integer(this.label_vec.size());
        this.label_vec.insertElementAt("", 0);
        this.end_vec.insertElementAt(n, 0);
        for (int i = 1; i < this.end_vec.size(); ++i) {
            Integer n2 = (Integer)this.end_vec.elementAt(i);
            n = new Integer(n2 + 1);
            this.end_vec.setElementAt(n, i);
        }
    }

    public Node NodeAt(Integer n) {
        return new Node(n, this.LabelAt(n));
    }

    public Node NodeAt(int n) {
        Integer n2 = new Integer(n);
        return this.NodeAt(n2);
    }

    public void SetLabelAt(String string, int n) {
        this.setLabelAt(string, n);
    }

    public void setLabelAt(String string, int n) {
        while (n >= this.label_vec.size()) {
            this.label_vec.addElement("_");
        }
        this.label_vec.setElementAt(string, n);
    }

    public void SetLabelAt(String string, Integer n) {
        this.SetLabelAt(string, (int)n);
    }

    public void SetEndDexAt(Integer n, int n2) {
        while (n2 >= this.end_vec.size()) {
            this.end_vec.addElement(this.minus1);
        }
        this.end_vec.setElementAt(n, n2);
    }

    public void SetEndDexAt(int n, int n2) {
        Integer n3 = new Integer(n);
        this.SetEndDexAt(n3, n2);
    }

    public void SetEndDexAt(Integer n, Integer n2) {
        this.SetEndDexAt(n, (int)n2);
    }

    public String LabelAt(int n) {
        return this.labelAt(n);
    }

    public String labelAt(int n) {
        return (String)this.label_vec.elementAt(n);
    }

    public String LabelAt(Integer n) {
        return this.LabelAt((int)n);
    }

    public int intEndDexAt(int n) {
        return this.EndDexAt(n);
    }

    public int intEndDexAt(Integer n) {
        return this.intEndDexAt((int)n);
    }

    public Integer EndDexAt(Integer n) {
        return this.EndDexAt((int)n);
    }

    public Integer EndDexAt(int n) {
        if (n >= this.end_vec.size() || n < 0) {
            return this.minus1;
        }
        return (Integer)this.end_vec.elementAt(n);
    }

    public void AddItem(String string, Integer n) {
        this.label_vec.addElement(string);
        this.end_vec.addElement(n);
    }

    public void AddItem(String string, int n) {
        Integer n2 = new Integer(n);
        this.AddItem(string, n2);
    }

    public void InsertItem(String string, Integer n, int n2) {
        this.label_vec.insertElementAt(string, n2);
        this.end_vec.insertElementAt(n, n2);
    }

    public void insertNode(String string, Integer n, int n2) {
        this.label_vec.insertElementAt(string, n2);
        this.end_vec.insertElementAt(n, n2);
    }

    public void insertNode(String string, int n, int n2) {
        Integer n3 = new Integer(n);
        this.insertNode(string, n3, n2);
    }

    public void AddLabel(String string) {
        this.label_vec.addElement(string);
    }

    public void AddDex(Integer n) {
        try {
            try {
                this.end_vec.addElement(n);
            }
            catch (Exception exception) {
                System.err.println("in SparseMatrix: AddDex:  ");
                System.err.println(exception.getMessage());
                exception.printStackTrace();
                System.exit(0);
            }
        }
        catch (Throwable throwable) {}
    }

    public void AddDex(int n) {
        Integer n2 = new Integer(n);
        this.AddDex(n2);
    }

    public void AddDex(String string) {
        try {
            try {
                Integer n = new Integer(Integer.parseInt(string));
                this.AddDex(n);
            }
            catch (Exception exception) {
                System.err.print("in SparseMatrix.AddDex:  ");
                System.err.print("could not parse to Int: ");
                System.err.println(string);
                System.err.println(exception.getMessage());
                exception.printStackTrace();
                System.exit(0);
            }
        }
        catch (Throwable throwable) {}
    }

    public void deleteNode(int n) {
        this.end_vec.removeElementAt(n);
        this.label_vec.removeElementAt(n);
    }

    public boolean Verify() {
        if (this.end_vec.size() != this.label_vec.size()) {
            System.err.print("ERROR!  label_vec and end_vec ");
            System.err.println("not the same size:");
            System.err.print("label_vec.size, end_vec.size:  ");
            System.err.println(this.label_vec.size() + ", " + this.end_vec.size());
            return false;
        }
        return true;
    }

    public void PrintToPrintWriter(PrintWriter printWriter) {
        int n;
        for (n = 0; n < this.size(); ++n) {
            printWriter.print(this.LabelAt(n) + " ");
        }
        printWriter.println("");
        for (n = 0; n < this.size(); ++n) {
            printWriter.print(this.EndDexAt(n).toString() + " ");
        }
        printWriter.println("");
        printWriter.println("");
        printWriter.flush();
    }

    public void PrintToSystemErr() {
        if (this.isEmpty()) {
            System.err.println("sparse matrix is empty");
        }
        this.PrintToSystemErr(0, this.size());
    }

    public void PrintToSystemErr(int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        if (n2 > this.size()) {
            n2 = this.size();
        }
        for (int i = n; i < n2; ++i) {
            System.err.print(i + ".  " + this.LabelAt(i) + " ");
            System.err.println(this.EndDexAt(i).toString());
        }
    }

    public static void main(String[] stringArray) {
        SparseMatrix sparseMatrix = new SparseMatrix("EXAMPLE");
        sparseMatrix.PrintToSystemErr();
    }
}

