/*
 * Decompiled with CFR 0.152.
 */
package stats;

import java.io.PrintWriter;
import java.util.Vector;
import stats.StatsPerFile;

public class StatsPerSearch {
    private int hits = 0;
    private int tokens = 0;
    private int total = 0;
    private String command_name;
    private String dest_name;
    private Vector file_stats = new Vector();

    public StatsPerSearch() {
    }

    public StatsPerSearch(String string, String string2) {
        this.setCommandName(string);
        this.setDestName(string2);
    }

    public void file_statsAdd(StatsPerFile statsPerFile) {
        this.hits += statsPerFile.getHits();
        this.tokens += statsPerFile.getTokens();
        this.total += statsPerFile.getTotal();
        this.file_stats.addElement(statsPerFile);
    }

    public StatsPerFile getStatsPerFile(int n) {
        return (StatsPerFile)this.file_stats.elementAt(n);
    }

    public int size() {
        return this.file_stats.size();
    }

    public void hitsAdd(int n) {
        this.hits += n;
    }

    public void tokensAdd1() {
        ++this.tokens;
    }

    public void totalAdd1() {
        ++this.total;
    }

    public int getHits() {
        return this.hits;
    }

    public int getTokens() {
        return this.tokens;
    }

    public int getTotal() {
        return this.total;
    }

    public void setCommandName(String string) {
        this.command_name = string;
    }

    public void setDestName(String string) {
        this.dest_name = string;
    }

    public String getCommandName() {
        return this.command_name;
    }

    public String getDestName() {
        return this.dest_name;
    }

    public void PrintToPrintWriter(PrintWriter printWriter) {
        String string = "\t";
        printWriter.println("source files, hits/tokens/total");
        for (int i = 0; i < this.size(); ++i) {
            string = "\t";
            StatsPerFile statsPerFile = this.getStatsPerFile(i);
            String string2 = statsPerFile.getFileID();
            printWriter.print("  " + string2);
            if (string2.length() < 6) {
                string = string + "\t";
            }
            if (string2.length() < 14) {
                string = string + "\t";
            }
            printWriter.print(string);
            printWriter.print(statsPerFile.getHits() + "/");
            printWriter.print(statsPerFile.getTokens() + "/");
            printWriter.println(statsPerFile.getTotal());
        }
        printWriter.println("whole search, hits/tokens/total");
        printWriter.print(string);
        printWriter.print("\t" + this.getHits() + "/");
        printWriter.print(this.getTokens() + "/");
        printWriter.println(this.getTotal());
    }

    public void PrintToSysOut() {
        String string = "\t";
        System.out.println("source files, hits/tokens/total");
        for (int i = 0; i < this.size(); ++i) {
            string = "\t";
            StatsPerFile statsPerFile = this.getStatsPerFile(i);
            String string2 = statsPerFile.getFileID();
            System.out.print("  " + string2);
            if (string2.length() < 6) {
                string = string + "\t";
            }
            if (string2.length() < 14) {
                string = string + "\t";
            }
            System.out.print(string);
            System.out.print(statsPerFile.getHits() + "/");
            System.out.print(statsPerFile.getTokens() + "/");
            System.out.println(statsPerFile.getTotal());
        }
        System.out.println("whole search, hits/tokens/total");
        System.out.print(string);
        System.out.print("\t" + this.getHits() + "/");
        System.out.print(this.getTokens() + "/");
        System.out.println(this.getTotal());
    }
}

