/*
 * Decompiled with CFR 0.152.
 */
package stats;

import java.io.PrintWriter;

public class StatsPerFile {
    private String file_name;
    private String file_ID;
    private int hits;
    private int tokens;
    private int total;

    public StatsPerFile(String string) {
        this.file_name = string;
        this.file_ID = this.cleanUp(string);
        this.hits = 0;
        this.tokens = 0;
        this.total = 0;
    }

    private String cleanUp(String string) {
        String string2 = string;
        if (string2.equals("")) {
            return string2;
        }
        if (string.lastIndexOf(47) > 0) {
            string2 = string.substring(string.lastIndexOf(47) + 1);
        }
        return string2;
    }

    public void hitsAdd(int n) {
        this.hits += n;
    }

    public void tokensAdd1() {
        ++this.tokens;
    }

    public void totalAdd1() {
        ++this.total;
    }

    public String getFileID() {
        return this.file_ID;
    }

    public int getHits() {
        return this.hits;
    }

    public int getTokens() {
        return this.tokens;
    }

    public int getTotal() {
        return this.total;
    }

    public void PrintToPrintWriter(PrintWriter printWriter) {
        printWriter.println("  source file, hits/tokens/total");
        String string = this.getFileID();
        printWriter.print("  " + string);
        if (string.length() < 6) {
            printWriter.print("\t");
        }
        if (string.length() < 14) {
            printWriter.print("\t");
        }
        printWriter.print("\t" + this.getHits() + "/");
        printWriter.print(this.getTokens() + "/");
        printWriter.println(this.getTotal());
    }

    public void PrintToSysOut() {
        System.out.println("  source file, hits/tokens/total");
        String string = this.getFileID();
        System.out.print("  " + string);
        if (string.length() < 6) {
            System.out.print("\t");
        }
        if (string.length() < 14) {
            System.out.print("\t");
        }
        System.out.print("\t" + this.getHits() + "/");
        System.out.print(this.getTokens() + "/");
        System.out.println(this.getTotal());
    }

    public void PrintToSystemErr() {
        System.err.println("  source file, hits/tokens/total");
        this.file_name = this.getFileID();
        System.err.print("  " + this.file_name);
        if (this.file_name.length() < 6) {
            System.err.print("\t");
        }
        if (this.file_name.length() < 14) {
            System.err.print("\t");
        }
        System.err.print("\t" + this.getHits() + "/");
        System.err.print(this.getTokens() + "/");
        System.err.println(this.getTotal());
    }
}

