/*
 * Decompiled with CFR 0.152.
 */
package search;

import java.util.BitSet;
import java.util.Vector;
import search.Syntax;
import syntree.Node;
import syntree.SynTree;

public class TreeBits
extends Syntax {
    private BitSet sparse_bits;

    public TreeBits(SynTree synTree) {
        this.sparse_bits = new BitSet(synTree.size());
    }

    public TreeBits(int n) {
        this.sparse_bits = new BitSet(n);
    }

    public void SetBounds(SynTree synTree) {
        for (int i = 0; i < synTree.size(); ++i) {
            Node node = synTree.NodeAt(i);
            if (!Syntax.IsBoundary(synTree, node)) continue;
            this.sparse_bits.set(i);
        }
    }

    public void Descending_Bits(SynTree synTree, Node node) {
        Node node2 = new Node();
        Vector vector = synTree.GetDescendants(node);
        for (int i = 0; i < vector.size(); ++i) {
            node2 = (Node)vector.elementAt(i);
            int n = node2.getIndex_int();
            this.sparse_bits.set(n);
        }
    }

    public void ClearNode(Node node) {
        int n = node.getIndex_int();
        this.sparse_bits.clear(n);
    }

    public void ClearSubTree(SynTree synTree, Node node) {
        int n = node.getIndex_int();
        this.sparse_bits.clear(n);
        Vector vector = synTree.GetDescendants(node);
        for (int i = 0; i < vector.size(); ++i) {
            Node node2 = (Node)vector.elementAt(i);
            n = node2.getIndex_int();
            this.sparse_bits.clear(n);
        }
    }

    public Node NextNodeForBits(SynTree synTree, Node node) {
        return this.NextNodeForBits(synTree, node.getIndex_int());
    }

    public Node NextNodeForBits(SynTree synTree, int n) {
        for (int i = n + 1; i < this.sparse_bits.size(); ++i) {
            if (!this.sparse_bits.get(i)) continue;
            return synTree.NodeAt(i);
        }
        Node node = new Node("NULL");
        return node;
    }

    public Vector NodesForBits(SynTree synTree) {
        Vector<Node> vector = new Vector<Node>();
        for (int i = 0; i < this.sparse_bits.size(); ++i) {
            if (!this.sparse_bits.get(i)) continue;
            vector.addElement(synTree.NodeAt(i));
        }
        return vector;
    }

    public void PrintToSystemErr(SynTree synTree) {
        Node node = new Node("NULL");
        Vector vector = new Vector();
        vector = this.NodesForBits(synTree);
        node.PrintNodeVector(vector);
        System.err.println("");
    }
}

