/*
 * Decompiled with CFR 0.152.
 */
package print;

import java.io.PrintWriter;
import java.util.Vector;
import print.Parameters;
import print.RemoveSys;
import search_result.SentenceResult;
import search_result.SubResult;
import syntree.Node;
import syntree.SynTree;

public class PrintTreeSys
extends Parameters {
    protected static boolean previous_leaf = false;
    protected static Vector bound_list = new Vector();

    protected static void PhraseVec(SynTree synTree, int n, int n2, SentenceResult sentenceResult, PrintWriter printWriter) {
        String string = "";
        try {
            try {
                Node node = synTree.NodeAt(n2);
                string = node.getLabel();
                int n3 = n;
                n3 += 1 + string.length() + 1;
                if (previous_leaf) {
                    PrintTreeSys.IndentIt(n, printWriter);
                    previous_leaf = false;
                }
                printWriter.print("(");
                n3 = PrintTreeSys.HandleIndices(node, n3, printWriter);
                PrintTreeSys.PrintWithColor(node, sentenceResult, true, printWriter);
                Vector vector = synTree.GetDaughters(n2);
                boolean bl = PrintTreeSys.HasJustLeaves(synTree, vector);
                for (int i = 0; i < vector.size(); ++i) {
                    Node node2 = (Node)vector.elementAt(i);
                    Integer n4 = node2.getIndex();
                    if (!synTree.IsLeafPOS(n4)) {
                        PrintTreeSys.PhraseVec(synTree, n3, n4, sentenceResult, printWriter);
                        continue;
                    }
                    if (i > 0 && !bl) {
                        PrintTreeSys.IndentIt(n3, printWriter);
                    }
                    PrintTreeSys.PrintLeafNode(synTree, node2, sentenceResult, printWriter);
                    if (!bl || i >= vector.size() - 1) continue;
                    printWriter.print(" ");
                }
                printWriter.print(")");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.err.println("in PrintTree:  sparse_dex:  " + n2);
                synTree.PrintToSystemErr();
            }
        }
        catch (Throwable throwable) {}
    }

    public static void Nodes(SynTree synTree, SentenceResult sentenceResult, PrintWriter printWriter) {
        synTree.setConstantNodes();
        PrintTreeSys.subNodes(synTree, 0, sentenceResult, printWriter);
        bound_list.removeAllElements();
    }

    protected static void subNodes(SynTree synTree, int n, SentenceResult sentenceResult, PrintWriter printWriter) {
        Node node;
        SubResult subResult;
        int n2;
        Node node2 = synTree.NodeAt(n);
        for (n2 = 0; n2 < sentenceResult.size(); ++n2) {
            subResult = sentenceResult.subResultAt(n2);
            node = subResult.getBoundary();
            if (!node.equals(node2) || !PrintTreeSys.notDupe(node)) continue;
            previous_leaf = false;
            if (node.equals(synTree.METAROOT)) {
                PrintTreeSys.PhraseVec(synTree, 0, n, sentenceResult, printWriter);
                printWriter.println("");
                return;
            }
            printWriter.print("( ");
            PrintTreeSys.CodingAndMetadata(synTree, node, sentenceResult, printWriter);
            PrintTreeSys.PhraseVec(synTree, 2, n, sentenceResult, printWriter);
            PrintTreeSys.PrintIDStuff(synTree, sentenceResult, printWriter);
        }
        Vector vector = synTree.GetDaughters(n);
        for (int i = 0; i < vector.size(); ++i) {
            Node node3 = (Node)vector.elementAt(i);
            int n3 = node3.getIndex_int();
            if (!synTree.IsLeafPOS(node3)) {
                PrintTreeSys.subNodes(synTree, n3, sentenceResult, printWriter);
                continue;
            }
            for (n2 = 0; n2 < sentenceResult.size(); ++n2) {
                subResult = sentenceResult.subResultAt(n2);
                node = subResult.getBoundary();
                if (!node.equals(node3) || !PrintTreeSys.notDupe(node)) continue;
                PrintTreeSys.PrintLeafTree(synTree, node3, sentenceResult, printWriter);
            }
        }
    }

    protected static boolean HasJustLeaves(SynTree synTree, Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            Node node = (Node)vector.elementAt(i);
            if (!synTree.IsLeafPOS(node)) {
                return false;
            }
            previous_leaf = true;
            Node node2 = synTree.FirstDaughter(node);
            String string = node2.getLabel();
            if (!string.startsWith("*") && !string.startsWith("RMV") && string.indexOf(":") <= 0) continue;
            return false;
        }
        return true;
    }

    protected static void PrintLeafTree(SynTree synTree, Node node, SentenceResult sentenceResult, PrintWriter printWriter) {
        printWriter.println("");
        printWriter.print("( ");
        PrintTreeSys.PrintLeafNode(synTree, node, sentenceResult, printWriter);
        PrintTreeSys.PrintIDNode(synTree, sentenceResult, printWriter);
        printWriter.println(" )");
    }

    protected static void CodingAndMetadata(SynTree synTree, Node node, SentenceResult sentenceResult, PrintWriter printWriter) {
        boolean bl = false;
        bl = PrintTreeSys.PrintMETADATA(synTree, sentenceResult, printWriter);
        PrintTreeSys.PrintCODINGNode(synTree, node, "( ", bl, sentenceResult, printWriter);
    }

    protected static boolean PrintCODINGNode(SynTree synTree, Node node, String string, boolean bl, SentenceResult sentenceResult, PrintWriter printWriter) {
        Node node2 = PrintTreeSys.GetAssocNode(synTree, node, "CODING");
        if (!node2.IsNullNode()) {
            if (bl) {
                printWriter.println("");
                printWriter.print("  ");
            }
            PrintTreeSys.PrintLeafNode(synTree, node2, sentenceResult, printWriter);
            return true;
        }
        return false;
    }

    protected static boolean PrintMETADATA(SynTree synTree, SentenceResult sentenceResult, PrintWriter printWriter) {
        Node node = synTree.getMETADATA();
        if (node.IsNullNode()) {
            return false;
        }
        PrintTreeSys.PhraseVec(synTree, 2, node.getIndex_int(), sentenceResult, printWriter);
        return true;
    }

    protected static Node GetAssocNode(SynTree synTree, Node node, String string) {
        int n = node.getIndex_int();
        Node node2 = node;
        while (!node2.IsNullNode()) {
            Node node3 = synTree.FirstDaughter(node2 = synTree.GetMother(node2));
            if (!node3.getLabel().startsWith(string)) continue;
            return node3;
        }
        return new Node("NULL");
    }

    protected static void PrintIDNode(SynTree synTree, SentenceResult sentenceResult, PrintWriter printWriter) {
        if (!synTree.ID_POS.IsNullNode()) {
            PrintTreeSys.PrintLeafNode(synTree, synTree.ID_POS, sentenceResult, printWriter);
        }
    }

    protected static void PrintLeafNode(SynTree synTree, Node node, SentenceResult sentenceResult, PrintWriter printWriter) {
        printWriter.print("(");
        if (Parameters.print_indices) {
            Integer n = node.getIndex();
            printWriter.print(n + " ");
        }
        Node node2 = synTree.FirstDaughter(node);
        PrintTreeSys.PrintWithColor(node, sentenceResult, true, printWriter);
        PrintTreeSys.PrintWithColor(node2, sentenceResult, false, printWriter);
        printWriter.print(")");
    }

    protected static void PrintWithColor(Node node, SentenceResult sentenceResult, boolean bl, PrintWriter printWriter) {
        boolean bl2 = false;
        if (sentenceResult.containsNode(node)) {
            printWriter.print("<FONT COLOR=\"RED\">");
            bl2 = true;
        }
        PrintTreeSys.PrintWithEscape(node.getLabel(), printWriter);
        if (bl2) {
            printWriter.print("</FONT>");
        }
        if (bl) {
            printWriter.print("&nbsp;");
        }
    }

    protected static void PrintWithEscape(String string, PrintWriter printWriter) {
        if (string.startsWith("<")) {
            printWriter.print("&lt;" + string.substring(1));
        } else {
            printWriter.print(string);
        }
    }

    public static void Sentence(SynTree synTree, SentenceResult sentenceResult, PrintWriter printWriter) {
        if (synTree.intEndDexAt(0) == 1) {
            PrintTreeSys.PrintLeafNode(synTree, synTree.NodeAt(0), sentenceResult, printWriter);
            printWriter.println("");
            return;
        }
        PrintTreeSys.PhraseVec(synTree, 0, 0, sentenceResult, printWriter);
        printWriter.println("");
    }

    protected static int HandleIndices(Node node, int n, PrintWriter printWriter) {
        if (Parameters.print_indices) {
            Integer n2 = node.getIndex();
            String string = Integer.toString(n2);
            n += string.length() + 1;
            printWriter.print(string + " ");
        }
        return n;
    }

    protected static void PrintIDStuff(SynTree synTree, SentenceResult sentenceResult, PrintWriter printWriter) {
        printWriter.println("");
        printWriter.print("  ");
        PrintTreeSys.PrintIDNode(synTree, sentenceResult, printWriter);
        printWriter.println(")");
        printWriter.print("");
    }

    protected static void IndentIt(int n, PrintWriter printWriter) {
        int n2;
        printWriter.println("");
        for (n2 = 0; n2 < n / 8; ++n2) {
            printWriter.print("\t");
        }
        for (n2 = 0; n2 < n % 8; ++n2) {
            printWriter.print(" ");
        }
    }

    protected static boolean notDupe(Node node) {
        for (int i = 0; i < bound_list.size(); ++i) {
            Node node2 = (Node)bound_list.elementAt(i);
            if (!node2.equals(node)) continue;
            return false;
        }
        bound_list.addElement(node);
        return true;
    }

    public static void PrintToken(SynTree synTree, PrintWriter printWriter) {
        if (synTree.isEmpty()) {
            return;
        }
        if (Parameters.ur_text_only) {
            return;
        }
        PrintTreeSys.Sentence(synTree, new SentenceResult(), printWriter);
    }

    public static void PrintToken(SynTree synTree, SentenceResult sentenceResult, PrintWriter printWriter) {
        if (synTree.isEmpty()) {
            return;
        }
        if (Parameters.ur_text_only) {
            return;
        }
        if (sentenceResult.isEmpty()) {
            PrintTreeSys.Sentence(synTree, sentenceResult, printWriter);
            return;
        }
        if (!Parameters.nodes_only) {
            PrintTreeSys.Sentence(synTree, sentenceResult, printWriter);
            return;
        }
        if (!Parameters.remove_nodes) {
            PrintTreeSys.Nodes(synTree, sentenceResult, printWriter);
            return;
        }
        RemoveSys.Nodes(synTree, sentenceResult, printWriter);
    }
}

