/*
 * Decompiled with CFR 0.152.
 */
package print;

import java.io.PrintWriter;
import java.util.Vector;
import print.Parameters;
import print.PrintTreeSys;
import print.Remove;
import search_result.SentenceResult;
import search_result.SubResult;
import syntree.Node;
import syntree.SynTree;

public class PrintTree
extends Parameters {
    protected static boolean previous_leaf = false;
    protected static Vector bound_list = new Vector();

    protected static void PhraseVec(SynTree synTree, int n, PrintWriter printWriter, int n2) {
        String string = "";
        try {
            try {
                Node node = synTree.NodeAt(n2);
                string = node.getLabel();
                int n3 = n;
                n3 += 1 + string.length() + 1;
                if (previous_leaf) {
                    PrintTree.IndentIt(n, printWriter);
                    previous_leaf = false;
                }
                printWriter.print("(");
                n3 = PrintTree.HandleIndices(node, printWriter, n3);
                printWriter.print(string + " ");
                Vector vector = synTree.GetDaughters(n2);
                boolean bl = PrintTree.HasJustLeaves(synTree, vector);
                for (int i = 0; i < vector.size(); ++i) {
                    Node node2 = (Node)vector.elementAt(i);
                    Integer n4 = node2.getIndex();
                    if (!synTree.IsLeafPOS(n4)) {
                        PrintTree.PhraseVec(synTree, n3, printWriter, n4);
                        continue;
                    }
                    if (i > 0 && !bl) {
                        PrintTree.IndentIt(n3, printWriter);
                    }
                    PrintTree.PrintLeafNode(synTree, printWriter, node2);
                    if (!bl || i >= vector.size() - 1) continue;
                    printWriter.print(" ");
                }
                printWriter.print(")");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.err.println("in PrintTree:  sparse_dex:  " + n2);
                synTree.PrintToSystemErr();
            }
        }
        catch (Throwable throwable) {}
    }

    public static void Nodes(SynTree synTree, SentenceResult sentenceResult, PrintWriter printWriter) {
        synTree.setConstantNodes();
        PrintTree.subNodes(synTree, 0, sentenceResult, printWriter);
        bound_list.removeAllElements();
    }

    protected static void subNodes(SynTree synTree, int n, SentenceResult sentenceResult, PrintWriter printWriter) {
        Node node;
        SubResult subResult;
        int n2;
        Node node2 = synTree.NodeAt(n);
        for (n2 = 0; n2 < sentenceResult.size(); ++n2) {
            subResult = sentenceResult.subResultAt(n2);
            node = subResult.getBoundary();
            if (!node.equals(node2) || !PrintTree.notDupe(node)) continue;
            previous_leaf = false;
            if (node.equals(synTree.METAROOT)) {
                PrintTree.PhraseVec(synTree, 0, printWriter, n);
                printWriter.println("");
                return;
            }
            printWriter.print("( ");
            PrintTree.CodingAndMetadata(synTree, printWriter, node);
            PrintTree.PhraseVec(synTree, 2, printWriter, n);
            PrintTree.PrintIDStuff(synTree, printWriter);
        }
        Vector vector = synTree.GetDaughters(n);
        for (int i = 0; i < vector.size(); ++i) {
            Node node3 = (Node)vector.elementAt(i);
            int n3 = node3.getIndex_int();
            if (!synTree.IsLeafPOS(node3)) {
                PrintTree.subNodes(synTree, n3, sentenceResult, printWriter);
                continue;
            }
            for (n2 = 0; n2 < sentenceResult.size(); ++n2) {
                subResult = sentenceResult.subResultAt(n2);
                node = subResult.getBoundary();
                if (!node.equals(node3) || !PrintTree.notDupe(node)) continue;
                PrintTree.PrintLeafTree(synTree, printWriter, node3);
            }
        }
    }

    protected static boolean HasJustLeaves(SynTree synTree, Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            Node node = (Node)vector.elementAt(i);
            if (!synTree.IsLeafPOS(node)) {
                return false;
            }
            previous_leaf = true;
            Node node2 = synTree.FirstDaughter(node);
            String string = node2.getLabel();
            if (!string.startsWith("*") && !string.startsWith("RMV") && string.indexOf(":") <= 0) continue;
            return false;
        }
        return true;
    }

    protected static void PrintLeafTree(SynTree synTree, PrintWriter printWriter, Node node) {
        printWriter.println("");
        printWriter.print("( ");
        PrintTree.PrintLeafNode(synTree, printWriter, node);
        PrintTree.PrintIDNode(synTree, printWriter);
        printWriter.println(" )");
    }

    protected static void CodingAndMetadata(SynTree synTree, PrintWriter printWriter, Node node) {
        boolean bl = false;
        bl = PrintTree.PrintMETADATA(synTree, printWriter);
        PrintTree.PrintCODINGNode(synTree, node, "( ", printWriter, bl);
    }

    protected static boolean PrintCODINGNode(SynTree synTree, Node node, String string, PrintWriter printWriter, boolean bl) {
        Node node2 = PrintTree.GetAssocNode(synTree, node, "CODING");
        if (!node2.IsNullNode()) {
            if (bl) {
                printWriter.println("");
                printWriter.print("  ");
            }
            PrintTree.PrintLeafNode(synTree, printWriter, node2);
            return true;
        }
        return false;
    }

    protected static boolean PrintMETADATA(SynTree synTree, PrintWriter printWriter) {
        Node node = synTree.getMETADATA();
        if (node.IsNullNode()) {
            return false;
        }
        PrintTree.PhraseVec(synTree, 2, printWriter, node.getIndex_int());
        return true;
    }

    protected static Node GetAssocNode(SynTree synTree, Node node, String string) {
        int n = node.getIndex_int();
        Node node2 = node;
        while (!node2.IsNullNode()) {
            Node node3 = synTree.FirstDaughter(node2 = synTree.GetMother(node2));
            if (!node3.getLabel().startsWith(string)) continue;
            return node3;
        }
        return new Node("NULL");
    }

    protected static void PrintIDNode(SynTree synTree, PrintWriter printWriter) {
        if (!synTree.ID_POS.IsNullNode()) {
            PrintTree.PrintLeafNode(synTree, printWriter, synTree.ID_POS);
        }
    }

    protected static void PrintLeafNode(SynTree synTree, PrintWriter printWriter, Node node) {
        printWriter.print("(");
        if (Parameters.print_indices) {
            Integer n = node.getIndex();
            printWriter.print(n + " ");
        }
        Node node2 = synTree.FirstDaughter(node);
        printWriter.print(node.getLabel() + " ");
        printWriter.print(node2.getLabel());
        printWriter.print(")");
    }

    public static void Sentence(SynTree synTree, PrintWriter printWriter) {
        if (synTree.intEndDexAt(0) == 1) {
            PrintTree.PrintLeafNode(synTree, printWriter, synTree.NodeAt(0));
            printWriter.println("");
            return;
        }
        PrintTree.PhraseVec(synTree, 0, printWriter, 0);
        printWriter.println("");
    }

    protected static int HandleIndices(Node node, PrintWriter printWriter, int n) {
        if (Parameters.print_indices) {
            Integer n2 = node.getIndex();
            String string = Integer.toString(n2);
            n += string.length() + 1;
            printWriter.print(string + " ");
        }
        return n;
    }

    protected static void PrintIDStuff(SynTree synTree, PrintWriter printWriter) {
        printWriter.println("");
        printWriter.print("  ");
        PrintTree.PrintIDNode(synTree, printWriter);
        printWriter.println(") ");
        printWriter.println("");
    }

    protected static void IndentIt(int n, PrintWriter printWriter) {
        int n2;
        printWriter.println("");
        for (n2 = 0; n2 < n / 8; ++n2) {
            printWriter.print("\t");
        }
        for (n2 = 0; n2 < n % 8; ++n2) {
            printWriter.print(" ");
        }
    }

    protected static boolean notDupe(Node node) {
        for (int i = 0; i < bound_list.size(); ++i) {
            Node node2 = (Node)bound_list.elementAt(i);
            if (!node2.equals(node)) continue;
            return false;
        }
        bound_list.addElement(node);
        return true;
    }

    public static void PrintToken(SynTree synTree, PrintWriter printWriter) {
        if (synTree.isEmpty()) {
            return;
        }
        if (Parameters.ur_text_only) {
            return;
        }
        PrintTree.Sentence(synTree, printWriter);
    }

    public static void PrintToken(SynTree synTree, SentenceResult sentenceResult, PrintWriter printWriter) {
        if (Parameters.output_format.equals("HTML")) {
            PrintTreeSys.PrintToken(synTree, sentenceResult, printWriter);
            return;
        }
        if (synTree.isEmpty()) {
            return;
        }
        if (Parameters.ur_text_only) {
            return;
        }
        if (sentenceResult.isEmpty()) {
            PrintTree.Sentence(synTree, printWriter);
            return;
        }
        if (!Parameters.nodes_only) {
            PrintTree.Sentence(synTree, printWriter);
            return;
        }
        if (!Parameters.remove_nodes) {
            PrintTree.Nodes(synTree, sentenceResult, printWriter);
            return;
        }
        Remove.Nodes(synTree, sentenceResult, printWriter);
    }
}

