/*
 * Decompiled with CFR 0.152.
 */
package print;

import basicinfo.Vitals;
import command.CommandInfo;
import io.OutFileDominatrix;
import io.VectorAux;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.Date;
import java.util.Vector;
import print.Parameters;
import revise.OneTask;
import revise.TaskList;
import search_result.SentenceResult;
import search_result.SubResult;
import stats.StatsPerFile;
import stats.StatsPerSearch;
import syntree.Node;
import syntree.SynTree;

public class PrintOut
extends Parameters {
    public static void Queries(String string, int n, PrintWriter printWriter) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "";
        String string3 = "";
        int n2 = 0;
        int n3 = 0;
        StringReader stringReader = new StringReader(string);
        try {
            try {
                do {
                    int n4;
                    if ((n2 = stringReader.read()) > 32) {
                        stringBuffer.append((char)n2);
                        continue;
                    }
                    string2 = stringBuffer.toString();
                    stringBuffer = new StringBuffer();
                    if (string2.equals("AND") || string2.equals("OR") || string2.equals("XOR")) {
                        printWriter.println("");
                        for (n4 = 0; n4 < n; ++n4) {
                            printWriter.print(" ");
                        }
                        n3 = n;
                    }
                    if (!string2.startsWith("(") && !string2.startsWith(")")) {
                        if ((n3 += string2.length()) > Parameters.margin) {
                            printWriter.println("");
                            for (n4 = 0; n4 < n; ++n4) {
                                printWriter.print(" ");
                            }
                            n3 = n;
                        }
                        if (!string3.startsWith("(") && !string3.endsWith(")")) {
                            printWriter.print(" ");
                            ++n3;
                        }
                        printWriter.print(string2 + " ");
                    } else {
                        if ((n3 += string2.length()) > Parameters.margin) {
                            printWriter.println("");
                            for (n4 = 0; n4 < n; ++n4) {
                                printWriter.print(" ");
                            }
                            n3 = n;
                        }
                        if (string3.endsWith("AND") || string3.endsWith("OR") || string3.endsWith("XOR")) {
                            printWriter.print(" ");
                            ++n3;
                        }
                        printWriter.print(string2 + " ");
                    }
                    string3 = string2;
                } while (n2 != -1);
                printWriter.println("");
            }
            catch (Exception exception) {
                System.err.println("In PrintOut.Queries:  ");
                System.err.println("queer:  " + string);
                System.err.println("next_val:  " + string2);
                System.err.println(exception.getMessage());
            }
        }
        catch (Throwable throwable) {}
    }

    public static void StringVec(Vector vector, int n, PrintWriter printWriter, boolean bl) {
        for (int i = 0; i < vector.size(); ++i) {
            if (i > 0 || bl) {
                for (int j = 0; j < n; ++j) {
                    printWriter.print(" ");
                }
            }
            printWriter.println((String)vector.elementAt(i));
        }
    }

    public static void Preface(String string, String string2, PrintWriter printWriter, Vector vector) {
        PrintOut.CommonPreface(string, string2, printWriter, vector);
        printWriter.println("node:   " + CommandInfo.node);
        if (CommandInfo.reconstruct) {
            printWriter.println("reconstruct:  " + CommandInfo.recon_str);
        }
        printWriter.print("query:  ");
        PrintOut.Queries(CommandInfo.query, 2, printWriter);
        if (CommandInfo.revise) {
            PrintOut.PrefaceRevise(printWriter, CommandInfo.tasker);
        }
        printWriter.println("*/");
    }

    public static void PrefaceComplement(String string, String string2, PrintWriter printWriter, Vector vector) {
        PrintOut.CommonPreface(string, string2, printWriter, vector);
        printWriter.println("node:   " + CommandInfo.node);
        printWriter.print("query:  ");
        PrintOut.Queries(CommandInfo.query, 2, printWriter);
        printWriter.println("");
        printWriter.println("COMPLEMENT FILE.");
        printWriter.println("*/");
    }

    public static void Preface(OutFileDominatrix outFileDominatrix, String string, Vector vector) {
        PrintWriter printWriter = outFileDominatrix.getPrintWriter();
        String string2 = outFileDominatrix.FILE_NAME;
        PrintOut.CommonPreface(string2, string, printWriter, vector);
        printWriter.println("node:   " + CommandInfo.node);
        if (CommandInfo.reconstruct) {
            printWriter.println("reconstruct:  " + CommandInfo.recon_str);
        }
        printWriter.print("query:  ");
        PrintOut.Queries(CommandInfo.query, 2, printWriter);
        if (CommandInfo.revise) {
            PrintOut.PrefaceRevise(printWriter, CommandInfo.tasker);
        }
        printWriter.println("*/");
    }

    public static void PrefaceRevise(PrintWriter printWriter, TaskList taskList) {
        printWriter.println("");
        for (int i = 0; i < taskList.size(); ++i) {
            OneTask oneTask = taskList.taskAt(i);
            printWriter.println(oneTask.getCommand());
        }
    }

    public static void CommonPreface(String string, String string2, PrintWriter printWriter, Vector vector) {
        Date date = new Date();
        String string3 = new String("didn't unload date properly");
        string3 = date.toString();
        printWriter.println("/*");
        printWriter.println("PREFACE:  ");
        printWriter.println(Vitals.c_note);
        printWriter.println("Date:  " + string3);
        PrintOut.FileBlock(printWriter, vector, string, string2);
        if (Parameters.remark_exists) {
            printWriter.print("remark:  ");
            PrintOut.StringVec(Parameters.remark, 2, printWriter, false);
            printWriter.println("");
        }
        if (CommandInfo.use_def_file) {
            printWriter.print("definition file:  ");
            printWriter.println(CommandInfo.def_name);
        }
    }

    public static void PrefaceFrames(String string, String string2, PrintWriter printWriter, Vector vector) {
        PrintOut.CommonPreface(string, string2, printWriter, vector);
        printWriter.print("local frames:  ");
        PrintOut.Queries(CommandInfo.query, 2, printWriter);
        printWriter.println("*/");
    }

    public static void PrefaceLexicon(String string, String string2, PrintWriter printWriter, Vector vector) {
        PrintOut.CommonPreface(string, string2, printWriter, vector);
        printWriter.println("Lexicon:  ");
        printWriter.println("*/");
        printWriter.println("");
    }

    public static void PrefaceLabelLexicon(String string, String string2, PrintWriter printWriter, Vector vector) {
        PrintOut.CommonPreface(string, string2, printWriter, vector);
        printWriter.println("Label Lexicon:  ");
        printWriter.println("*/");
        printWriter.println("");
    }

    public static void PrefaceTagList(String string, String string2, PrintWriter printWriter, Vector vector) {
        PrintOut.CommonPreface(string, string2, printWriter, vector);
        printWriter.println("Tag List:  for use with CorpusDraw:  ");
        printWriter.println("*/");
        printWriter.println("");
    }

    public static void PrefaceCoding(String string, String string2, PrintWriter printWriter, Vector vector) {
        PrintOut.CommonPreface(string, string2, printWriter, vector);
        printWriter.println("node: " + CommandInfo.node);
        if (CommandInfo.reconstruct) {
            printWriter.println("reconstruct:  " + CommandInfo.recon_str);
        }
        printWriter.println("coding_query:  ");
        PrintOut.PrintCodingQuery(CommandInfo.coding_query, printWriter);
        printWriter.println("*/");
        printWriter.println("");
    }

    public static void PrintCodingQuery(String string, PrintWriter printWriter) {
        StringBuffer stringBuffer = new StringBuffer("");
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (bl2 && c == ' ') {
                bl2 = false;
                continue;
            }
            stringBuffer.append(c);
            if (c == '{') {
                bl = true;
                printWriter.print(stringBuffer.toString());
                stringBuffer.delete(0, stringBuffer.length());
                continue;
            }
            if (c == ':' && bl) {
                printWriter.println("");
                printWriter.print("    " + stringBuffer.toString());
                stringBuffer.delete(0, stringBuffer.length());
                continue;
            }
            if (c == ' ') {
                printWriter.print(stringBuffer);
                stringBuffer.delete(0, stringBuffer.length());
                continue;
            }
            if (c != '}') continue;
            bl = false;
            bl2 = true;
            printWriter.println("");
            printWriter.println("}");
            stringBuffer.delete(0, stringBuffer.length());
        }
    }

    public static void Header(String string, PrintWriter printWriter) {
        printWriter.println("/*");
        printWriter.println("HEADER:");
        printWriter.println("source file:  " + string);
        printWriter.println("*/");
    }

    public static void Footer(StatsPerFile statsPerFile, PrintWriter printWriter) {
        printWriter.println("/*");
        printWriter.println("FOOTER");
        statsPerFile.PrintToPrintWriter(printWriter);
        printWriter.println("*/");
    }

    public static void BigFooter(StatsPerSearch statsPerSearch, PrintWriter printWriter) {
        try {
            try {
                printWriter.println("/*");
                printWriter.println("SUMMARY:  ");
                statsPerSearch.PrintToPrintWriter(printWriter);
                printWriter.println("*/");
                if (Parameters.output_format.equals("HTML")) {
                    printWriter.println("</PRE></HTML>");
                }
            }
            catch (Exception exception) {
                System.err.println("ERROR!  in PrintOut.BigFooter:  ");
                System.err.println(exception.getMessage());
            }
        }
        catch (Throwable throwable) {}
    }

    public static void Comments(SentenceResult sentenceResult, PrintWriter printWriter) {
        String string;
        int n;
        int n2 = 0;
        boolean bl = true;
        if (Parameters.ur_text_only) {
            return;
        }
        printWriter.println("/*");
        sentenceResult.setNoDupes();
        for (n = 0; n < sentenceResult.size(); ++n) {
            SubResult subResult = sentenceResult.NoDupesAt(n);
            if (subResult.IsNull()) continue;
            n2 = 0;
            Node node = subResult.getBoundary();
            string = node.getIndex() + " " + node.getLabel() + ":  ";
            n2 += string.length();
            printWriter.print(string);
            bl = true;
            for (int i = 0; i < subResult.size(); ++i) {
                Node node2 = subResult.NoDupesAt(i);
                if (node2.IsNullNode()) continue;
                if (bl) {
                    string = node2.getIndex() + " " + node2.getLabel();
                    bl = false;
                } else {
                    string = ", " + node2.getIndex() + " " + node2.getLabel();
                }
                if ((n2 += string.length()) > Parameters.margin) {
                    printWriter.println("");
                    n2 = 0;
                }
                printWriter.print(string);
            }
            printWriter.println("");
        }
        printWriter.println("*/");
        for (n = 0; n < sentenceResult.commentsSize(); ++n) {
            string = sentenceResult.getComment(n);
            printWriter.println("/*");
            printWriter.println(string);
            printWriter.println("*/");
        }
    }

    public static void FileBlock(PrintWriter printWriter, Vector vector, String string, String string2) {
        String string3;
        printWriter.println("");
        if (!Parameters.output_format.equals("HTML")) {
            printWriter.println("command file:     " + string2);
        }
        if (CommandInfo.use_prefs) {
            printWriter.println("preference file:  " + CommandInfo.prefs_name);
        }
        if (!(string3 = (String)vector.firstElement()).endsWith(Parameters.corpus_file_extension)) {
            if (vector.size() == 1) {
                printWriter.println("input file:       " + string3);
            } else {
                String string4 = (String)vector.lastElement();
                printWriter.println("input files:      " + string3);
                printWriter.println("through:          " + string4);
                printWriter.println(vector.size() + " files.");
            }
        }
        if (!Parameters.output_format.equals("HTML")) {
            printWriter.println("output file:      " + string);
        }
        printWriter.println("");
    }

    public static void UrTextStuff(Vector vector, SynTree synTree, PrintWriter printWriter) {
        if (vector.isEmpty()) {
            Parameters.urk.PureText(synTree, printWriter);
            return;
        }
        PrintOut.StringVec(VectorAux.ur_vec, 0, printWriter, false);
    }
}

