/*
 * Decompiled with CFR 0.152.
 */
package lexicon;

import java.util.Vector;
import lexicon.NumPOS;
import lexicon.POSPair;
import lexicon.POSStat;

public class LexEntry {
    private String canonical;
    private Vector variations;
    private Vector pos_stats;
    private int total;

    public LexEntry() {
        this.variations = new Vector();
        this.pos_stats = new Vector();
        this.total = 0;
    }

    public LexEntry(String string) {
        this.canonical = string;
        this.variations = new Vector();
        this.pos_stats = new Vector();
        this.total = 0;
    }

    public LexEntry(POSPair pOSPair) {
        try {
            this.pos_stats = new Vector();
            this.variations = new Vector();
            this.canonical = pOSPair.GetTextStr().toLowerCase();
            this.variations.addElement(this.canonical);
            if (this.canonical.startsWith("$")) {
                this.canonical = this.canonical.substring(1, this.canonical.length());
            }
            POSStat pOSStat = new POSStat(pOSPair.GetPOSStr());
            this.pos_stats.addElement(pOSStat);
            ++this.total;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean belongs(POSPair pOSPair) {
        String string = pOSPair.GetTextStr();
        if (string.startsWith("$")) {
            string = string.substring(1, string.length());
        }
        return string.equalsIgnoreCase(this.canonical);
    }

    public void addPOSPair(POSPair pOSPair) {
        int n;
        String string = pOSPair.GetTextStr();
        for (n = 0; n < this.variations.size() && !string.equals((String)this.variations.elementAt(n)); ++n) {
            if (n != this.variations.size() - 1) continue;
            this.variations.addElement(string);
            break;
        }
        String string2 = pOSPair.GetPOSStr();
        for (n = 0; n < this.pos_stats.size(); ++n) {
            POSStat pOSStat = (POSStat)this.pos_stats.elementAt(n);
            String string3 = pOSStat.getString();
            if (string3.equals(string2)) {
                pOSStat.incrementTotal();
                break;
            }
            if (n != this.pos_stats.size() - 1) continue;
            POSStat pOSStat2 = new POSStat(string2);
            this.pos_stats.addElement(pOSStat2);
            break;
        }
        ++this.total;
    }

    public void setCanonical(String string) {
        this.canonical = string.toLowerCase();
    }

    public String getCanonical() {
        return this.canonical;
    }

    public Vector getVariations() {
        return this.variations;
    }

    public void addToVariations(String string) {
        this.variations.addElement(string);
    }

    public void addToPOSStats(NumPOS numPOS) {
        this.pos_stats.addElement(numPOS);
    }

    public Vector getPOSStats() {
        return this.pos_stats;
    }

    public void incrementTotal() {
        ++this.total;
    }

    public int getTotal() {
        return this.total;
    }

    public boolean LaterEntry(LexEntry lexEntry) {
        return this.canonical.compareTo(lexEntry.getCanonical()) > 0;
    }

    public void PrintToSystemErr() {
        System.err.println("LexEntry:  ");
        System.err.println("canonical:  " + this.canonical);
        System.err.println("variations:  " + this.variations);
        System.err.println("pos_stats:  ");
        for (int i = 0; i < this.pos_stats.size(); ++i) {
            POSStat pOSStat = (POSStat)this.pos_stats.elementAt(i);
            pOSStat.PrintToSystemErr();
        }
        System.err.println("total:  " + this.total);
    }
}

