/*
 * Decompiled with CFR 0.152.
 */
package drawtree;

import basicinfo.PipeList;
import drawtree.CatTagList;
import drawtree.CorpusTags;
import drawtree.OneTag;
import drawtree.POSTagList;
import drawtree.SynTagList;
import io.InFileDominatrix;
import java.util.Vector;

public class UberList
extends CorpusTags {
    private POSTagList postle;
    private SynTagList syntle;
    private CatTagList cattle;
    private InFileDominatrix tags_in_file;
    private String file_name;
    private String syn_divide_str;
    private String pos_divide_str;
    private String empty_divide_str;
    private Vector syn_divide;
    private Vector pos_divide;
    private Vector empty_divide;

    public boolean makeUberList(String string) {
        boolean bl = true;
        try {
            try {
                this.file_name = string;
                this.tags_in_file = new InFileDominatrix(string);
                this.postle = new POSTagList();
                this.syntle = new SynTagList();
                this.ReadTagsFile(this.tags_in_file);
                this.syn_divide = PipeList.makeCharacterList(this.syn_divide_str);
                this.pos_divide = PipeList.makeCharacterList(this.pos_divide_str);
                this.empty_divide = PipeList.makeCharacterList(this.empty_divide_str);
            }
            catch (Exception exception) {
                System.err.print("WARNING! unable to process ");
                System.err.println(string + " as tags file.");
                System.err.println("");
                bl = false;
            }
        }
        catch (Throwable throwable) {}
        return bl;
    }

    private void ReadTagsFile(InFileDominatrix inFileDominatrix) {
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        while (!inFileDominatrix.EOF) {
            String string = inFileDominatrix.NextString();
            if (inFileDominatrix.EOF) break;
            if (string.equals("~SYNTACTIC")) {
                bl = true;
                inFileDominatrix.FlushLine();
                continue;
            }
            if (string.equals("~SYN_DIVIDERS:")) {
                this.syn_divide_str = inFileDominatrix.NextString();
                continue;
            }
            if (string.equals("~POS")) {
                bl = false;
                bl2 = true;
                inFileDominatrix.FlushLine();
                continue;
            }
            if (string.equals("~POS_DIVIDERS:")) {
                this.pos_divide_str = inFileDominatrix.NextString();
                continue;
            }
            if (string.equals("~EMPTY")) {
                bl = false;
                bl2 = false;
                bl3 = true;
                inFileDominatrix.FlushLine();
                continue;
            }
            if (string.equals("~EMPTY_CAT_DIVIDERS:")) {
                this.empty_divide_str = inFileDominatrix.NextString();
                continue;
            }
            if (bl3) {
                this.cattle = new CatTagList(string);
                continue;
            }
            OneTag oneTag = new OneTag(string);
            if (bl) {
                this.syntle.addOneTag(oneTag);
                continue;
            }
            if (!bl2) continue;
            this.postle.addOneTag(oneTag);
        }
        inFileDominatrix.Close();
    }

    public boolean legitSynTag(String string) {
        return this.syntle.legitTag(string, this.syn_divide);
    }

    public boolean legitPOSTag(String string) {
        return this.postle.legitTag(string, this.pos_divide);
    }

    public boolean legitCatTag(String string) {
        return this.cattle.legitTag(string, this.empty_divide);
    }

    public POSTagList getPOSTagList() {
        return this.postle;
    }

    public SynTagList getSynTagList() {
        return this.syntle;
    }

    public CatTagList getCatTagList() {
        return this.cattle;
    }

    public void PrintToSystemErr() {
        System.err.println("tags file:  " + this.file_name);
        this.postle.PrintToSystemErr();
        this.syntle.PrintToSystemErr();
    }
}

