/*
 * Decompiled with CFR 0.152.
 */
package drawtree;

import drawtree.ChangeGraphicTree;
import drawtree.CorpusDraw;
import drawtree.GraphicNode;
import drawtree.TreeCanvas;
import java.awt.ScrollPane;
import syntree.Node;

public class TreeView
extends CorpusDraw {
    private ScrollPane treeScroll;
    protected TreeCanvas treece;
    int curr_scroll_ht;
    int curr_scroll_wd;

    public TreeView() {
        this.Init();
    }

    private void Init() {
        this.treece = new TreeCanvas();
        this.treeScroll = new ScrollPane(1);
        this.treeScroll.add(this.treece);
        this.treeScroll.setWheelScrollingEnabled(true);
        this.moveScrollBars();
    }

    public ScrollPane getScrollPane() {
        return this.treeScroll;
    }

    public void scrollToRoot() {
        this.scrollToGNode(CorpusDraw.currTree().getRootGNode());
    }

    public void scrollToGNode(GraphicNode graphicNode) {
        CorpusDraw.currTree().setScrollWordDex(graphicNode);
        this.moveScrollBars(CorpusDraw.currTree().getWordScrollWdth(), CorpusDraw.currTree().getWordScrollHt());
    }

    public Node scrollToWord(int n, String string) {
        Node node = CorpusDraw.currTree().setScrollWordDex(n, string);
        this.moveScrollBars(CorpusDraw.currTree().getWordScrollWdth(), CorpusDraw.currTree().getWordScrollHt());
        return node;
    }

    public int getHeight() {
        return this.getHeight();
    }

    public void initScrollBars() {
        this.moveScrollBars(0, 300000);
    }

    public void moveScrollBars() {
        this.moveScrollBars(this.curr_scroll_wd, this.curr_scroll_ht);
    }

    public void moveScrollBars(int n, int n2) {
        this.curr_scroll_ht = n2;
        this.curr_scroll_wd = n;
        this.treeScroll.setScrollPosition(n, n2);
    }

    public void moveScrollBars(ChangeGraphicTree changeGraphicTree) {
        this.curr_scroll_ht = changeGraphicTree.getScrollHt();
        this.curr_scroll_wd = changeGraphicTree.getScrollHt();
        this.moveScrollBars(this.curr_scroll_wd, this.curr_scroll_ht);
    }
}

