/*
 * Decompiled with CFR 0.152.
 */
package drawtree;

import drawtree.CorpusDraw;
import drawtree.GraphicNode;
import drawtree.MyEvents;
import drawtree.ToolColors;
import drawtree.TreeCanvas;
import drawtree.TreeCursor;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import syntree.Node;

public class TreeTextField
extends TreeCanvas {
    protected GraphicNode my_gnode;
    protected String my_string;
    protected Graphics my_graphite;
    protected TreeCursor my_cursor;
    protected FontMetrics fontmet;
    protected Character my_Char;
    protected int my_x;
    protected int my_y;
    protected int my_width;
    protected int my_height;
    protected int curse_dex;
    protected boolean selected_text;

    public TreeTextField() {
        this.my_string = "";
    }

    public TreeTextField(GraphicNode graphicNode, Graphics graphics) {
        this.Init(graphicNode, graphics);
    }

    public TreeTextField(Graphics graphics) {
        this.selected_text = true;
        this.my_gnode = CorpusDraw.currTree().getRootGNode();
        this.my_graphite = graphics;
        this.my_Char = new Character('Q');
        this.my_string = "";
        this.my_x = this.my_gnode.getXStart() - 6;
        this.my_y = this.my_gnode.getYEnd() - 200;
        this.my_height = this.my_gnode.getYStart() - this.my_gnode.getYEnd() + 6;
        this.eraseField();
        this.my_cursor = new TreeCursor(this.my_string);
        this.drawInfo();
    }

    protected void Init(GraphicNode graphicNode, Graphics graphics) {
        this.selected_text = true;
        super.requestFocusInWindow();
        this.my_graphite = graphics;
        this.my_gnode = graphicNode;
        this.my_string = this.my_gnode.getNode().getLabel();
        this.my_x = this.my_gnode.getXStart() - 6;
        this.my_y = this.my_gnode.getYEnd();
        this.my_height = this.my_gnode.getYStart() - this.my_gnode.getYEnd() + 6;
        this.my_cursor = new TreeCursor(this.my_string);
        this.drawInfo();
    }

    protected void refresh() {
        this.drawInfo();
    }

    protected void eraseField() {
        this.fontmet = this.getFontMetrics(this.my_graphite.getFont());
        int n = this.fontmet.stringWidth(this.my_string);
        this.my_graphite.setColor(ToolColors.BACKGROUND);
        this.my_graphite.drawRect(this.my_x, this.my_y, n + 20, this.my_height);
        this.my_graphite.fillRect(this.my_x, this.my_y, n + 20, this.my_height);
    }

    protected int ttfStringWidth(String string) {
        this.fontmet = this.getFontMetrics(this.my_graphite.getFont());
        int n = this.fontmet.stringWidth(string);
        return n;
    }

    protected void drawInfo() {
        this.fontmet = this.getFontMetrics(this.my_graphite.getFont());
        int n = this.fontmet.stringWidth(this.my_string);
        if (n < 12) {
            n = 12;
        }
        this.my_graphite.setColor(Color.white);
        if (this.selected_text) {
            this.my_graphite.setColor(ToolColors.SELECT_TEXT);
        }
        this.my_graphite.fillRect(this.my_x, this.my_y, n + 20, this.my_height);
        this.my_graphite.setColor(Color.black);
        this.my_graphite.drawRect(this.my_x, this.my_y, n + 20, this.my_height);
        String string = this.my_cursor.getPre(this.my_string);
        int n2 = this.fontmet.stringWidth(string);
        this.my_graphite.drawString(string, this.my_x + 6, this.my_y + 12);
        this.my_graphite.setColor(Color.red);
        this.my_graphite.drawString("|", this.my_x + 6 + n2, this.my_y + 12);
        this.my_graphite.setColor(Color.black);
        String string2 = this.my_cursor.getPost(this.my_string);
        n2 = this.fontmet.stringWidth(string + "|");
        this.my_graphite.drawString(string2, this.my_x + 6 + n2, this.my_y + 12);
    }

    protected void addDigit(char c) {
        if (c == '\b' || c == '\n') {
            this.drawInfo();
            return;
        }
        this.eraseField();
        if (this.selected_text) {
            this.my_string = "";
            this.selected_text = false;
            this.drawInfo();
        }
        if (!Character.isDigit(c)) {
            MyEvents.warn("not digit:  " + c);
            return;
        }
        this.my_string = this.my_cursor.addChar(c, this.my_string);
        this.drawInfo();
    }

    protected void addChar(char c) {
        if (c == '\b' || c == '\n') {
            this.drawInfo();
            return;
        }
        this.eraseField();
        if (this.selected_text) {
            this.my_string = "";
            this.selected_text = false;
        }
        this.my_string = this.my_cursor.addChar(c, this.my_string);
        this.drawInfo();
    }

    protected void deleteChar() {
        this.eraseField();
        if (this.selected_text) {
            this.my_string = "";
            this.selected_text = false;
        }
        this.my_string = this.my_cursor.deleteChar(this.my_string);
        this.drawInfo();
    }

    protected void arrowRight() {
        if (this.selected_text) {
            this.selected_text = false;
            this.drawInfo();
            return;
        }
        this.my_cursor.plusOne(this.my_string);
        this.drawInfo();
    }

    protected void arrowLeft() {
        if (this.selected_text) {
            this.my_cursor.setWhere(0);
            this.selected_text = false;
            this.drawInfo();
            return;
        }
        this.my_cursor.minusOne(this.my_string);
        this.drawInfo();
    }

    protected String getString() {
        return this.my_string.trim();
    }

    protected String getSynString() {
        return this.my_string.toUpperCase().trim();
    }

    protected GraphicNode getGNode() {
        return this.my_gnode;
    }

    protected int getNumber() {
        int n = -1;
        try {
            try {
                Integer n2 = new Integer(this.my_string);
                n = n2;
            }
            catch (Exception exception) {
                n = -1;
            }
        }
        catch (Throwable throwable) {}
        return n;
    }

    protected Node getNode() {
        return this.my_gnode.getNode();
    }

    protected void PrintToSystemErr() {
        System.err.println("my_string: " + this.my_string);
    }
}

