/*
 * Decompiled with CFR 0.152.
 */
package drawtree;

import basicinfo.ArgList;
import drawtree.CorpusDraw;
import drawtree.DrawGraphicTree;
import drawtree.DrawLoop;
import drawtree.GraphicNode;
import drawtree.MyEvents;
import drawtree.ToolColors;
import drawtree.ToolView;
import drawtree.TreeTextField;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import syntree.Node;

public class TreeCanvas
extends Canvas
implements MouseListener,
KeyListener {
    protected Graphics graphite;
    protected Font fonto;
    protected FontMetrics font_met;
    protected GraphicNode grunt1;
    protected Node nodal;
    protected String font_name;
    protected String labell;
    protected String message;
    protected TreeTextField my_text_field;
    protected boolean ctrl_pressed;
    protected boolean esc_pressed;
    protected boolean shift_pressed;
    protected boolean tab_pressed;
    protected boolean enter_pressed;
    protected boolean getting_text;
    protected boolean getting_number;
    protected boolean did_it;
    protected boolean new_trace_POS;
    protected boolean new_trace_text;
    protected boolean will_coindex;
    protected boolean found_error;
    protected boolean will_delete;
    protected boolean ctrl_x;
    protected int num;
    protected int must_undo;
    protected int num_clicks;

    public TreeCanvas() {
        this.Init();
    }

    public void addTree() {
        MyEvents.setUrText(CorpusDraw.currTree());
        MyEvents.anntf.put(this.makeFileString());
        MyEvents.numtf.put(this.makeSentNum());
        this.initBooleans();
        this.graphite = this.getGraphics();
        this.setSizeCurrTree();
        ToolView.treeve.initScrollBars();
        this.paint(this.graphite);
    }

    private void initBooleans() {
        this.esc_pressed = false;
        this.ctrl_pressed = false;
        this.shift_pressed = false;
        this.tab_pressed = false;
        this.enter_pressed = false;
        this.getting_text = false;
        this.getting_number = false;
        this.ctrl_x = false;
        this.will_delete = false;
        this.found_error = false;
        this.must_undo = 0;
        this.num_clicks = 0;
    }

    public void correctUrText() {
    }

    public void setSizeCurrTree() {
        this.setSize(CorpusDraw.currTree().getOptWidth(), CorpusDraw.currTree().getOptHeight());
    }

    private void printSizeToSystemErr() {
        System.err.print("opt width, height, my width, height:  ");
        System.err.print(CorpusDraw.currTree().getOptWidth() + ", ");
        System.err.print(CorpusDraw.currTree().getOptHeight() + ", ");
        System.err.println(this.getWidth() + ", " + this.getHeight());
    }

    private String makeFileString() {
        String string;
        try {
            string = CorpusDraw.currTree().getShortFileName();
        }
        catch (Exception exception) {
            string = "UNKNOWN";
        }
        return string;
    }

    private int makeSentNum() {
        int n = 0;
        try {
            n = CorpusDraw.currTree().getChangeTree().getNumID();
        }
        catch (Exception exception) {
            n = -1;
        }
        return n;
    }

    public void resetTree() {
        this.initBooleans();
        CorpusDraw.currTree().setBulletNode();
        this.paint(this.graphite);
    }

    private void Init() {
        this.graphite = this.getGraphics();
        this.setBackground(ToolColors.BACKGROUND);
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.requestFocusInWindow();
        this.initBooleans();
    }

    public void paint(Graphics graphics) {
        graphics = this.getGraphics();
        this.clearMyRect(graphics);
        DrawGraphicTree.drawTree(CorpusDraw.currTree(), graphics);
        if (this.getting_number || this.getting_text) {
            this.my_text_field.refresh();
        }
    }

    public void clearMyRect(Graphics graphics) {
        graphics.clearRect(0, 0, CorpusDraw.MIN_WDTH, CorpusDraw.MIN_HT);
    }

    public void update(Graphics graphics) {
        super.update(graphics);
    }

    public void setCanvasBackground(Color color) {
        this.setBackground(color);
    }

    public void setEndOfFile() {
        this.clearMyRect(this.graphite);
        this.graphite.setColor(ToolColors.WARNING);
        this.graphite.drawString("END OF FILE", 100, 100);
    }

    public void draw_show_only() {
        if (CorpusDraw.show_list.isEmpty()) {
            this.set_show_only();
            return;
        }
        CorpusDraw.show_only = true;
        this.resetTree();
    }

    public void draw_show_all() {
        CorpusDraw.show_only = false;
        this.resetTree();
    }

    public void set_show_only() {
        CorpusDraw.currTree().showOnlyList();
        CorpusDraw.show_list = new ArgList(CorpusDraw.show_str);
        CorpusDraw.show_only = true;
        this.resetTree();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        GraphicNode graphicNode;
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.num_clicks = mouseEvent.getClickCount();
        if (this.num_clicks == 2 && !(graphicNode = CorpusDraw.currTree().getNodeforCoords(n, n2)).IsNullGNode()) {
            CorpusDraw.currTree().addToSelected(graphicNode);
            this.replaceLabelCanvas();
            return;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.requestFocusInWindow();
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        GraphicNode graphicNode = CorpusDraw.currTree().getNodeforCoords(n, n2);
        if (graphicNode.IsNullGNode()) {
            if (mouseEvent.getButton() == 1 && !this.getting_text && !this.getting_number) {
                CorpusDraw.currTree().clearSelected();
                this.resetTree();
                return;
            }
            if (mouseEvent.getButton() == 3 && !this.getting_text && !this.getting_number) {
                if (this.shift_pressed) {
                    CorpusDraw.currTree().redo();
                    this.resetTree();
                    return;
                }
                CorpusDraw.currTree().undo();
                this.resetTree();
                return;
            }
        }
        if (this.num_clicks != 2) {
            CorpusDraw.currTree().toggleSelected(graphicNode);
        }
        DrawGraphicTree.whichSelect(CorpusDraw.currTree(), graphicNode);
        if (mouseEvent.getButton() == 1 && !this.getting_text && !this.getting_number) {
            if (this.ctrl_pressed && this.shift_pressed) {
                CorpusDraw.currTree().delete_node();
                this.resetTree();
                return;
            }
            if (this.shift_pressed && !this.ctrl_pressed) {
                this.replaceLabelCanvas();
                this.resetTree();
                return;
            }
            if (this.ctrl_pressed && !this.shift_pressed) {
                this.addNodeCanvas();
                return;
            }
        }
        if (!(mouseEvent.getButton() != 3 || this.getting_text || this.getting_number || this.ctrl_pressed || this.shift_pressed)) {
            CorpusDraw.currTree().moveTo();
            this.resetTree();
            return;
        }
        if (this.ctrl_pressed && this.shift_pressed) {
            this.traceAfterCanvas();
            return;
        }
        if (this.ctrl_pressed && !this.shift_pressed) {
            this.traceBeforeCanvas();
            return;
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.requestFocusInWindow();
        if (KeyEvent.getKeyText(keyEvent.getKeyCode()).equals("Escape")) {
            this.esc_pressed = true;
            return;
        }
        if (keyEvent.getKeyCode() == 88 && keyEvent.getModifiersEx() == 128) {
            this.ctrl_x = true;
            return;
        }
        if (keyEvent.getKeyCode() == 83 && keyEvent.getModifiersEx() == 128 && this.ctrl_x) {
            this.ctrl_x = false;
            DrawLoop.saveFile();
            return;
        }
        if (KeyEvent.getKeyText(keyEvent.getKeyCode()).equals("Ctrl")) {
            this.ctrl_pressed = true;
            return;
        }
        if (KeyEvent.getKeyText(keyEvent.getKeyCode()).equals("Tab")) {
            this.tab_pressed = true;
            return;
        }
        if (KeyEvent.getKeyText(keyEvent.getKeyCode()).equals("Shift")) {
            this.shift_pressed = true;
            return;
        }
        if (KeyEvent.getKeyText(keyEvent.getKeyCode()).equals("Backspace")) {
            this.will_delete = true;
            return;
        }
        if (KeyEvent.getKeyText(keyEvent.getKeyCode()).equals("Enter")) {
            if (this.getting_number) {
                this.num = this.my_text_field.getNumber();
                if (this.num <= 0) {
                    this.message = "not a legit number: " + this.my_text_field.getString();
                    MyEvents.warn(this.message);
                } else {
                    CorpusDraw.currTree().goTo2(this.my_text_field.getString());
                    DrawLoop.goToTree(DrawLoop.getMyTBToRix(), this.my_text_field.getNumber());
                }
            }
            if (this.new_trace_POS) {
                this.newTracePOS();
                return;
            }
            if (this.new_trace_text) {
                this.newTraceText();
                return;
            }
            if (this.getting_text) {
                this.labell = this.my_text_field.getString();
                this.did_it = CorpusDraw.currTree().cleanLabel(this.labell, this.my_text_field.getNode());
                if (!this.did_it) {
                    this.found_error = true;
                    this.requestFocusInWindow();
                    MyEvents.intf.clear();
                    return;
                }
                this.labell = CorpusDraw.currTree().getMyNewLabel();
                CorpusDraw.currTree().replaceLabel2(this.labell, this.my_text_field.getNode(), this.must_undo);
                this.resetTree();
                return;
            }
            this.enter_pressed = true;
            return;
        }
        if (keyEvent.isActionKey() && KeyEvent.getKeyText(keyEvent.getKeyCode()).equals("Down")) {
            DrawGraphicTree.clearBullet(CorpusDraw.currTree(), CorpusDraw.currTree().getGraphicBulletNode());
            CorpusDraw.currTree().moveBulletDown();
            DrawGraphicTree.drawBullet(CorpusDraw.currTree(), CorpusDraw.currTree().getGraphicBulletNode());
            return;
        }
        if (keyEvent.isActionKey() && KeyEvent.getKeyText(keyEvent.getKeyCode()).equals("Up")) {
            DrawGraphicTree.clearBullet(CorpusDraw.currTree(), CorpusDraw.currTree().getGraphicBulletNode());
            CorpusDraw.currTree().moveBulletUp();
            DrawGraphicTree.drawBullet(CorpusDraw.currTree(), CorpusDraw.currTree().getGraphicBulletNode());
            return;
        }
        if (keyEvent.isActionKey() && KeyEvent.getKeyText(keyEvent.getKeyCode()).equals("Right")) {
            if (this.getting_text || this.getting_number) {
                this.my_text_field.arrowRight();
                return;
            }
            DrawGraphicTree.clearBullet(CorpusDraw.currTree(), CorpusDraw.currTree().getGraphicBulletNode());
            CorpusDraw.currTree().moveBulletRight();
            DrawGraphicTree.drawBullet(CorpusDraw.currTree(), CorpusDraw.currTree().getGraphicBulletNode());
            return;
        }
        if (keyEvent.isActionKey() && KeyEvent.getKeyText(keyEvent.getKeyCode()).equals("Left")) {
            if (this.getting_text || this.getting_number) {
                this.my_text_field.arrowLeft();
                return;
            }
            DrawGraphicTree.clearBullet(CorpusDraw.currTree(), CorpusDraw.currTree().getGraphicBulletNode());
            CorpusDraw.currTree().moveBulletLeft();
            DrawGraphicTree.drawBullet(CorpusDraw.currTree(), CorpusDraw.currTree().getGraphicBulletNode());
            return;
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (!this.new_trace_POS && !this.new_trace_text && !this.getting_text && KeyEvent.getKeyText(keyEvent.getKeyCode()).equals("Ctrl")) {
            this.ctrl_pressed = false;
        }
        if (KeyEvent.getKeyText(keyEvent.getKeyCode()).equals("Escape")) {
            this.esc_pressed = false;
        }
        if (KeyEvent.getKeyText(keyEvent.getKeyCode()).equals("Shift")) {
            this.shift_pressed = false;
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.requestFocusInWindow();
        if (this.will_delete) {
            this.my_text_field.deleteChar();
            this.will_delete = false;
            return;
        }
        if (this.found_error) {
            this.my_text_field.refresh();
            this.found_error = false;
            return;
        }
        char c = keyEvent.getKeyChar();
        if (c == ' ') {
            GraphicNode graphicNode = CorpusDraw.currTree().getGraphicBulletNode();
            CorpusDraw.currTree().toggleSelected(graphicNode);
            DrawGraphicTree.whichSelect(CorpusDraw.currTree(), graphicNode);
            return;
        }
        if (!this.esc_pressed && !keyEvent.isActionKey() && this.getting_text) {
            this.my_text_field.addChar(c);
            return;
        }
        if (!this.esc_pressed && !keyEvent.isActionKey() && this.getting_number) {
            this.my_text_field.addDigit(c);
            return;
        }
        if (this.esc_pressed) {
            if (c == 'm') {
                CorpusDraw.currTree().moveTo();
                this.resetTree();
                return;
            }
            if (c == 'd') {
                CorpusDraw.currTree().delete_node();
                this.resetTree();
                return;
            }
            if (c == 'n') {
                this.addNodeCanvas();
            }
            if (c == 'r') {
                CorpusDraw.currTree().redo();
                this.resetTree();
                return;
            }
            if (c == 'u') {
                CorpusDraw.currTree().undo();
                this.resetTree();
                return;
            }
            if (c == 'c') {
                CorpusDraw.currTree().co_index();
                this.resetTree();
                return;
            }
            if (c == 'l') {
                this.replaceLabelCanvas();
            }
            if (c == 'a') {
                this.leafAfterCanvas();
            }
            if (c == 'b') {
                this.leafBeforeCanvas();
            }
            if (c == 'x') {
                this.traceAfterCanvas();
            }
            if (c == 'y') {
                this.traceBeforeCanvas();
            }
            if (c == 'p') {
                CorpusDraw.currTree().mergePrevious();
                this.resetTree();
                return;
            }
            if (c == 'f') {
                CorpusDraw.currTree().mergeFollowing();
                this.resetTree();
                return;
            }
            if (c == 's') {
                CorpusDraw.currTree().split();
                this.resetTree();
                return;
            }
            if (c == 'g') {
                this.goToCanvas();
            }
            if (c == '1') {
                MyEvents.setNextToken();
                this.resetTree();
                return;
            }
            if (c == '2') {
                MyEvents.setPrevToken();
                this.resetTree();
                return;
            }
        }
    }

    private void goToCanvas() {
        ToolView.treeve.scrollToRoot();
        this.requestFocusInWindow();
        this.getting_number = true;
        this.graphite = this.getGraphics();
        this.my_text_field = new TreeTextField(this.graphite);
        MyEvents.warn("goto:  type number in window:");
        this.esc_pressed = false;
    }

    private void traceAfterCanvas() {
        this.enter_pressed = false;
        GraphicNode graphicNode = CorpusDraw.currTree().blankTraceAfter();
        if (graphicNode.IsNullGNode()) {
            this.resetTree();
            return;
        }
        this.resetTree();
        this.my_text_field = new TreeTextField(graphicNode, this.graphite);
        this.getting_text = true;
        this.new_trace_POS = true;
        this.will_coindex = true;
    }

    private void traceBeforeCanvas() {
        this.enter_pressed = false;
        GraphicNode graphicNode = CorpusDraw.currTree().blankTraceBefore();
        if (graphicNode.IsNullGNode()) {
            this.resetTree();
            return;
        }
        this.resetTree();
        this.my_text_field = new TreeTextField(graphicNode, this.graphite);
        this.getting_text = true;
        this.new_trace_POS = true;
        this.will_coindex = true;
    }

    private void leafAfterCanvas() {
        GraphicNode graphicNode = CorpusDraw.currTree().blankLeafAfter();
        if (graphicNode.IsNullGNode()) {
            this.resetTree();
            return;
        }
        this.resetTree();
        this.my_text_field = new TreeTextField(graphicNode, this.graphite);
        this.getting_text = true;
        this.new_trace_POS = true;
        this.esc_pressed = false;
    }

    private void leafBeforeCanvas() {
        GraphicNode graphicNode = CorpusDraw.currTree().blankLeafBefore();
        if (graphicNode.IsNullGNode()) {
            this.resetTree();
            return;
        }
        this.resetTree();
        this.my_text_field = new TreeTextField(graphicNode, this.graphite);
        this.getting_text = true;
        this.new_trace_POS = true;
        this.esc_pressed = false;
    }

    private void addNodeCanvas() {
        GraphicNode graphicNode = CorpusDraw.currTree().addBlankSynNode();
        if (graphicNode.IsNullGNode()) {
            this.resetTree();
            return;
        }
        this.resetTree();
        this.must_undo = 1;
        this.getting_text = true;
        this.my_text_field = new TreeTextField(graphicNode, this.graphite);
        this.esc_pressed = false;
    }

    private void replaceLabelCanvas() {
        this.did_it = CorpusDraw.currTree().replaceLabel0();
        if (!this.did_it) {
            this.resetTree();
            return;
        }
        this.getting_text = true;
        GraphicNode graphicNode = CorpusDraw.currTree().popSelected();
        this.my_text_field = new TreeTextField(graphicNode, this.graphite);
        this.esc_pressed = false;
    }

    private void newTracePOS() {
        this.labell = this.my_text_field.getSynString();
        this.did_it = CorpusDraw.currTree().legitTracePOS(this.labell);
        if (!this.did_it) {
            this.found_error = true;
            this.requestFocusInWindow();
            MyEvents.intf.clear();
            return;
        }
        CorpusDraw.currTree().replaceLabel2(this.labell, this.my_text_field.getNode());
        this.nodal = CorpusDraw.currTree().sparse.FirstDaughter(this.my_text_field.getNode());
        GraphicNode graphicNode = CorpusDraw.currTree().getGNode(this.nodal);
        this.resetTree();
        this.my_text_field = new TreeTextField(graphicNode, this.graphite);
        this.new_trace_POS = false;
        this.getting_text = true;
        this.new_trace_text = true;
    }

    private void newTraceText() {
        this.labell = this.my_text_field.getString();
        this.did_it = CorpusDraw.currTree().legitEmptyCat(this.labell);
        if (!this.did_it) {
            this.found_error = true;
            this.requestFocusInWindow();
            MyEvents.intf.clear();
            return;
        }
        CorpusDraw.currTree().replaceLabel2(this.labell, this.my_text_field.getNode());
        this.new_trace_text = false;
        if (this.will_coindex) {
            this.nodal = CorpusDraw.currTree().getNewNode(this.my_text_field.getNode());
            CorpusDraw.currTree().co_index(this.nodal, CorpusDraw.currTree().getUpSNode2(), 3);
            this.will_coindex = false;
        }
        this.resetTree();
    }

    protected void displayInfo(KeyEvent keyEvent, String string) {
        int n;
        String string2;
        int n2;
        int n3 = keyEvent.getID();
        if (n3 == 400) {
            n2 = keyEvent.getKeyChar();
            string2 = "key character = '" + (char)n2 + "'";
            n = keyEvent.getKeyCode();
            string2 = string2 + new StringBuffer(":  keyCode = ").append(n);
        } else {
            n2 = keyEvent.getKeyCode();
            string2 = "key code = " + n2 + " (" + KeyEvent.getKeyText(n2) + ")";
        }
        n2 = keyEvent.getModifiersEx();
        String string3 = "modifiers = " + n2;
        String string4 = InputEvent.getModifiersExText(n2);
        string3 = string4.length() > 0 ? string3 + new StringBuffer(" (").append(string4).append(")") : string3 + " (no modifiers)";
        String string5 = "action key? ";
        string5 = keyEvent.isActionKey() ? string5 + "YES" : string5 + "NO";
        String string6 = "key location: ";
        n = keyEvent.getKeyLocation();
        string6 = n == 1 ? string6 + "standard" : (n == 2 ? string6 + "left" : (n == 3 ? string6 + "right" : (n == 4 ? string6 + "numpad" : string6 + "unknown")));
        System.err.println(string);
        System.err.println("keyString:  " + string2);
        System.err.println("modString:  " + string3);
    }
}

