/*
 * Decompiled with CFR 0.152.
 */
package drawtree;

import drawtree.ChangeGraphicTree;
import drawtree.CorpusDraw;
import drawtree.DrawLoop;
import java.util.BitSet;
import java.util.Vector;
import syntree.ChangeTree;

public class TreeBuffer {
    Vector master_buffer = new Vector();
    BitSet fits_query = new BitSet(0);
    int showing_dex = -1;

    public boolean isEmpty() {
        return this.master_buffer.isEmpty();
    }

    public int size() {
        return this.master_buffer.size();
    }

    public int getShowDex() {
        return this.showing_dex;
    }

    public void setShowDex(int n) {
        this.showing_dex = n;
    }

    public ChangeGraphicTree changeGraphicTreeAt(int n) {
        return (ChangeGraphicTree)this.master_buffer.elementAt(n);
    }

    public ChangeTree changeTreeAt(int n) {
        ChangeGraphicTree changeGraphicTree = this.changeGraphicTreeAt(n);
        ChangeTree changeTree = changeGraphicTree.getChangeTree();
        return changeTree;
    }

    public ChangeGraphicTree getCurrTree() {
        ChangeGraphicTree changeGraphicTree = new ChangeGraphicTree();
        if (this.isEmpty()) {
            return new ChangeGraphicTree();
        }
        try {
            try {
                changeGraphicTree = this.changeGraphicTreeAt(this.showing_dex);
            }
            catch (Exception exception) {
                System.err.println("in TreeBuffer: getCurrTree:  ");
                exception.printStackTrace();
                System.exit(1);
            }
        }
        catch (Throwable throwable) {}
        return changeGraphicTree;
    }

    public void rmPrev() {
        if (this.showing_dex < 1) {
            return;
        }
        this.master_buffer.removeElementAt(this.showing_dex - 1);
        --this.showing_dex;
    }

    public void rmFoll() {
        if (this.showing_dex + 1 >= this.master_buffer.size()) {
            return;
        }
        this.master_buffer.removeElementAt(this.showing_dex + 1);
    }

    public void showLast() {
        this.showing_dex = this.master_buffer.size() - 1;
    }

    public void blindAddToTreeBuffer(ChangeGraphicTree changeGraphicTree) {
        ChangeGraphicTree changeGraphicTree2 = changeGraphicTree.copy();
        this.master_buffer.add(changeGraphicTree2);
    }

    public void addToTreeBuffer(ChangeGraphicTree changeGraphicTree) {
        ChangeGraphicTree changeGraphicTree2 = changeGraphicTree.copy();
        this.master_buffer.add(changeGraphicTree2);
        ++this.showing_dex;
    }

    public void pushForward(ChangeGraphicTree changeGraphicTree) {
        try {
            try {
                this.master_buffer.insertElementAt(changeGraphicTree, this.showing_dex + 1);
            }
            catch (Exception exception) {
                System.err.println("in TreeBuffer.pushForward:  ");
                exception.printStackTrace();
            }
        }
        catch (Throwable throwable) {}
    }

    public boolean setNext() {
        if (CorpusDraw.hasQuery()) {
            return this.setNextHasQuery();
        }
        return this.setNextNoQuery();
    }

    public boolean setNextNoQuery() {
        if (this.gotForward()) {
            ++this.showing_dex;
            return true;
        }
        return false;
    }

    public boolean setNextHasQuery() {
        int n = this.fits_query.nextSetBit(this.showing_dex + 1);
        if (n == -1) {
            return false;
        }
        this.showing_dex = n;
        return true;
    }

    public boolean setPrevious() {
        if (CorpusDraw.hasQuery()) {
            return this.setPreviousHasQuery();
        }
        return this.setPreviousNoQuery();
    }

    public boolean setPreviousNoQuery() {
        if (this.gotPrevious()) {
            --this.showing_dex;
            return true;
        }
        return false;
    }

    public boolean setPreviousHasQuery() {
        int n = this.prevSetBit(this.fits_query, this.showing_dex - 1);
        if (n == -1) {
            return false;
        }
        this.showing_dex = n;
        return true;
    }

    public int prevSetBit(BitSet bitSet, int n) {
        for (int i = n; i >= 0; --i) {
            if (!this.fits_query.get(i)) continue;
            return i;
        }
        return 0;
    }

    public ChangeGraphicTree previousTree() {
        if (this.gotPrevious()) {
            return this.changeGraphicTreeAt(this.showing_dex - 1);
        }
        return new ChangeGraphicTree();
    }

    public ChangeGraphicTree followingTree() {
        if (this.gotForward()) {
            return this.changeGraphicTreeAt(this.showing_dex + 1);
        }
        return new ChangeGraphicTree(DrawLoop.readNextTree());
    }

    public boolean gotPrevious() {
        return this.showing_dex > 0;
    }

    public boolean gotForward() {
        return this.showing_dex < this.master_buffer.size() - 1;
    }

    public boolean goToPrevious(int n) {
        if (n - 1 >= this.master_buffer.size() || n - 1 < 0) {
            return false;
        }
        this.showing_dex = n - 1;
        return true;
    }

    public void blindAddToTreeBuffer(ChangeGraphicTree changeGraphicTree, boolean bl) {
        this.blindAddToTreeBuffer(changeGraphicTree);
        this.addToFitsQuery(bl);
    }

    public void addToTreeBuffer(ChangeGraphicTree changeGraphicTree, boolean bl) {
        this.addToTreeBuffer(changeGraphicTree);
        this.addToFitsQuery(bl);
    }

    public void addToFitsQuery(boolean bl) {
        BitSet bitSet = new BitSet(this.master_buffer.size());
        if (bl) {
            bitSet.set(this.master_buffer.size() - 1);
        }
        for (int i = 0; i < this.fits_query.size(); ++i) {
            if (!this.fits_query.get(i)) continue;
            bitSet.set(i);
        }
        this.fits_query = bitSet;
    }

    public void printToSystemErr() {
        this.printToSystemErr(0, this.size());
    }

    public void printToSystemErr(int n, int n2) {
        if (this.isEmpty()) {
            System.err.println("tree buffer is empty.");
            return;
        }
        if (n < 0) {
            n = 0;
        }
        if (n2 > this.size()) {
            n2 = this.size();
        }
        for (int i = n; i < n2; ++i) {
            System.err.print(i + ".)  ");
            ChangeGraphicTree changeGraphicTree = this.changeGraphicTreeAt(i);
            System.err.println("sentence num:  " + changeGraphicTree.getNumID());
        }
    }
}

