/*
 * Decompiled with CFR 0.152.
 */
package drawtree;

import drawtree.GraphicNode;
import drawtree.GraphicTree;
import java.util.Vector;
import search_result.SentenceResult;
import syntree.ChangeTree;
import syntree.Node;

public class SetVertGraphicTree
extends GraphicTree {
    public void Init(ChangeTree changeTree) {
        super.Init(changeTree);
        this.setTreeCoords();
    }

    public void Init(ChangeTree changeTree, SentenceResult sentenceResult) {
        super.Init(changeTree, sentenceResult);
        this.setTreeCoords();
    }

    public void setTreeCoords() {
        if (this.sparse.isEmpty()) {
            return;
        }
        super.partInit();
        this.setVertCoords();
    }

    public void setVertCoords() {
        int n = 10;
        int n2 = 10;
        int n3 = n2 + this.Y_DIFF;
        Node node = this.sparse.getRootNode();
        int n4 = this.myXEnd(node, n);
        GraphicNode graphicNode = new GraphicNode(node, n, n4, n2, n3);
        super.addGraphicNode(graphicNode);
        Vector vector = this.sparse.getDaughters(node);
        this.setDaughters(vector, n4 + 2 * this.X_DIFF, n2);
    }

    private void setDaughters(Vector vector, int n, int n2) {
        if (vector.isEmpty()) {
            return;
        }
        int n3 = n;
        int n4 = n2;
        for (int i = 0; i < vector.size(); ++i) {
            Node node = (Node)vector.elementAt(i);
            int n5 = this.myXEnd(node, n3);
            int n6 = n4 + this.Y_DIFF;
            GraphicNode graphicNode = new GraphicNode(node, n3, n5, n4, n6);
            super.addGraphicNode(graphicNode);
            Vector vector2 = this.sparse.getDaughters(node);
            this.setDaughters(vector2, n5 + 2 * this.X_DIFF, n4);
            n4 += 2 * this.Y_DIFF;
        }
    }

    private void setXandY(GraphicNode graphicNode, GraphicNode graphicNode2, GraphicNode graphicNode3, int n) {
        int n2 = graphicNode2.getXStart();
        int n3 = graphicNode3.getXEnd();
        int n4 = this.lengthPerFont(graphicNode.getLabel()) / 2;
        int n5 = (n2 + n3) / 2 - n4;
        int n6 = n5 + this.lengthPerFont(graphicNode.getLabel() + "  ");
        graphicNode.setXs(n5, n6);
        graphicNode.setYs(n, n - this.FONT_SZ);
    }

    protected void setHighlights() {
        if (!this.has_indices) {
            return;
        }
        for (int i = 0; i < super.size(); ++i) {
            GraphicNode graphicNode = super.graphicNodeAt(i);
            if (super.inHighNodes(graphicNode.getNode())) {
                graphicNode.setHighlight1(true);
                continue;
            }
            if (!super.inHighBounds(graphicNode.getNode())) continue;
            graphicNode.setHighlight2(true);
        }
    }

    protected boolean is2or3Subtree(Node node) {
        Node node2;
        if (this.sparse.IsLeafPOS(node) || this.sparse.IsLeafText(node)) {
            return true;
        }
        Vector vector = this.sparse.GetDaughters(node);
        return vector.size() == 1 && this.sparse.IsLeafPOS(node2 = (Node)vector.firstElement());
    }

    private int myXEnd(Node node, int n) {
        if (super.justInits()) {
            return n + this.lengthPerFont(2);
        }
        return n + this.lengthPerFont(node.getLabel());
    }

    protected void compress() {
        int n;
        Vector vector = this.sparse.GetDaughters(this.sparse.getRootNode());
        for (n = 0; n < vector.size(); ++n) {
            Node node = (Node)vector.elementAt(n);
            if (this.sparse.IsLeafPOS(node)) continue;
            super.shiftDownSubtree(node, 10 * this.Y_DIFF);
        }
        for (n = 1; n < this.size(); ++n) {
            int n2 = super.xSpaceBehind(n);
            if (n2 < 0) {
                super.shiftRight(n, -n2 + this.X_DIFF);
                continue;
            }
            if (this.sparse.IsLeafText(n) || this.sparse.isFirstChild(n) || n2 <= 2 * this.X_DIFF) continue;
            super.OKShiftLeft(n, n2);
        }
        super.correctRoot((Node)vector.firstElement(), (Node)vector.lastElement());
    }

    protected int lengthPerFont(String string) {
        return string.length() * (this.FONT_SZ / 2);
    }

    protected int lengthPerFont(int n) {
        return n * this.FONT_SZ / 2;
    }

    protected int getMiddleX(GraphicNode graphicNode) {
        int n = 0;
        n = graphicNode.getXStart();
        try {
            n += this.lengthPerFont(graphicNode.getLabel()) / 2;
        }
        catch (NullPointerException nullPointerException) {
            graphicNode.PrintToSystemErr();
        }
        return n;
    }
}

