/*
 * Decompiled with CFR 0.152.
 */
package drawtree;

import drawtree.GraphicNode;
import drawtree.GraphicTree;
import drawtree.TreeCanvas;
import java.util.Vector;
import search_result.SentenceResult;
import syntree.ChangeTree;
import syntree.Node;

public class SetCompressTree
extends GraphicTree {
    public void Init(ChangeTree changeTree) {
        super.Init(changeTree);
        this.setTreeCoords();
    }

    public void Init(ChangeTree changeTree, SentenceResult sentenceResult) {
        super.Init(changeTree, sentenceResult);
        this.setTreeCoords();
    }

    public void setTreeCoords() {
        if (this.sparse.isEmpty()) {
            return;
        }
        super.partInit();
        if (!TreeCanvas.lapse.willCollapse()) {
            this.bottomUp();
            this.setHighlights();
            super.resetHeight();
            return;
        }
        this.bottomUpCollapse();
        this.setHighlights();
    }

    private void bottomUpCollapse() {
        TreeCanvas.lapse.setCollapsedBits(this.sparse);
        int n = this.MIN_HT - this.lengthPerFont(this.Y_DIFF);
        int n2 = n - this.FONT_SZ;
        int n3 = 10;
        for (int i = 0; i < this.sparse.size(); ++i) {
            Node node = this.sparse.NodeAt(i);
            if (!this.sparse.IsLeafText(node)) continue;
            super.setMaxDepth(node);
            if (TreeCanvas.lapse.isCollapsed(i)) {
                int n4;
                int n5 = this.setCollapsedLeaves(i, n3, n);
                n3 = n5 + this.lengthPerFont(this.X_DIFF);
                i = n4 = TreeCanvas.lapse.getCollapsedEnd(node, this.sparse);
                continue;
            }
            n3 = this.oneLeaf(node, n3, n);
        }
        for (int i = super.getMaxDepth(); i >= 0; --i) {
            this.subBottomCollapse(i, n -= this.lengthPerFont(this.Y_DIFF));
        }
        this.adjustLeavesCollapse();
    }

    private int setCollapsedLeaves(int n, int n2, int n3) {
        int n4;
        Vector vector = TreeCanvas.lapse.getCollapsedLeaves(n, this.sparse);
        Node node = TreeCanvas.lapse.getCollRoot(vector, this.sparse);
        int n5 = n4 = n2 + this.lengthPerFont(this.X_DIFF);
        int n6 = n3 - this.lengthPerFont(2) * (vector.size() - 1);
        for (int i = 0; i < vector.size(); ++i) {
            Node node2 = (Node)vector.elementAt(i);
            super.setMaxDepth(node2);
            n5 = this.myXEnd(node2, n2);
            int n7 = n2;
            if (n5 > n4) {
                n4 = n5;
            }
            int n8 = n6 - this.FONT_SZ;
            GraphicNode graphicNode = new GraphicNode(node2, n7, n4, n6, n8);
            super.addGraphicNode(graphicNode);
            n6 += this.lengthPerFont(1) + this.Y_DIFF;
        }
        return n4;
    }

    private void bottomUp() {
        int n = this.MIN_HT - this.lengthPerFont(this.Y_DIFF);
        int n2 = 10;
        for (int i = 0; i < this.sparse.size(); ++i) {
            Node node = this.sparse.NodeAt(i);
            if (!this.sparse.IsLeafText(node)) continue;
            try {
                super.setMaxDepth(node);
            }
            catch (Exception exception) {
                super.Init();
                super.setMaxDepth(node);
                return;
            }
            n2 = this.oneLeaf(node, n2, n);
        }
        for (int i = super.getMaxDepth(); i >= 0; --i) {
            this.subBottom(i, n -= this.lengthPerFont(this.Y_DIFF));
        }
        this.adjustLeaves();
    }

    private int oneLeaf(Node node, int n, int n2) {
        int n3 = n2 - this.FONT_SZ;
        int n4 = this.myXEnd(node, n);
        GraphicNode graphicNode = new GraphicNode(node, n, n4, n2, n3);
        super.addGraphicNode(graphicNode);
        int n5 = n4 + this.lengthPerFont(this.X_DIFF);
        return n5;
    }

    private int myXEnd(Node node, int n) {
        if (super.justInits()) {
            return n + this.lengthPerFont(2);
        }
        return n + this.lengthPerFont(node.getLabel());
    }

    private void adjustLeavesCollapse() {
        for (int i = 0; i < super.size(); ++i) {
            GraphicNode graphicNode = super.graphicNodeAt(i);
            Node node = graphicNode.getNode();
            if (!this.sparse.IsLeafText(node)) continue;
            if (TreeCanvas.lapse.isCollapsed(i)) {
                int n;
                i = n = this.adjustCollBlock(i);
                continue;
            }
            this.adjustOneLeaf(graphicNode, node);
        }
    }

    private int adjustCollBlock(int n) {
        Vector vector = TreeCanvas.lapse.getCollapsedLeaves(n, this.sparse);
        Node node = (Node)vector.firstElement();
        GraphicNode graphicNode = super.graphicNodeFor(node);
        Node node2 = TreeCanvas.lapse.getCollRoot(vector);
        GraphicNode graphicNode2 = super.graphicNodeFor(node2);
        int n2 = graphicNode.getYStart();
        graphicNode.setYs(graphicNode2.getYStart() + this.lengthPerFont(this.Y_DIFF), graphicNode2.getYEnd() + this.lengthPerFont(this.Y_DIFF));
        n2 -= graphicNode2.getYStart() + this.lengthPerFont(this.Y_DIFF);
        for (int i = 1; i < vector.size(); ++i) {
            Node node3 = (Node)vector.elementAt(i);
            GraphicNode graphicNode3 = super.graphicNodeFor(node3);
            graphicNode3.setYs(graphicNode3.getYStart() - n2, graphicNode3.getYEnd() - n2);
        }
        Node node4 = (Node)vector.lastElement();
        int n3 = node4.getIndex_int();
        return n3 + 1;
    }

    private void adjustLeaves() {
        for (int i = 0; i < super.size(); ++i) {
            GraphicNode graphicNode = super.graphicNodeAt(i);
            Node node = graphicNode.getNode();
            if (!this.sparse.IsLeafText(node)) continue;
            this.adjustOneLeaf(graphicNode, node);
        }
    }

    private void adjustOneLeaf(Node node) {
        GraphicNode graphicNode = super.graphicNodeFor(node);
        this.adjustOneLeaf(graphicNode, node);
    }

    private void adjustOneLeaf(GraphicNode graphicNode, Node node) {
        Node node2 = this.sparse.GetMother(node);
        GraphicNode graphicNode2 = super.graphicNodeFor(node2);
        graphicNode.setYs(graphicNode2.getYStart() + this.lengthPerFont(this.Y_DIFF), graphicNode2.getYEnd() + this.lengthPerFont(this.Y_DIFF));
    }

    private void subBottom(int n, int n2) {
        Node node = new Node("NULL");
        Vector vector = this.sparse.getAllNodesforDepth(n);
        for (int i = 0; i < vector.size(); ++i) {
            node = (Node)vector.elementAt(i);
            if (this.sparse.IsLeafText(node)) continue;
            this.setSynNode(node, n2);
        }
    }

    private void setSynNode(Node node, int n) {
        Vector vector = this.sparse.GetDaughters(node);
        Node node2 = (Node)vector.firstElement();
        Node node3 = (Node)vector.lastElement();
        GraphicNode graphicNode = new GraphicNode(node, n, n - this.FONT_SZ);
        GraphicNode graphicNode2 = super.getGNode(node2);
        GraphicNode graphicNode3 = super.getGNode(node3);
        this.setXandY(graphicNode, graphicNode2, graphicNode3, n);
        super.addGraphicNode(graphicNode);
    }

    private void setSynNodeCollapse(Node node, int n) {
        Vector vector = this.sparse.getText(node);
        Node node2 = (Node)vector.firstElement();
        GraphicNode graphicNode = new GraphicNode(node, n, n - this.FONT_SZ);
        GraphicNode graphicNode2 = super.getGNode(node2);
        this.setXandY(graphicNode, graphicNode2, graphicNode2, n);
        super.addGraphicNode(graphicNode);
    }

    private void subBottomCollapse(int n, int n2) {
        Node node = new Node("NULL");
        int n3 = n2 - this.FONT_SZ;
        Vector vector = this.sparse.getAllNodesforDepth(n);
        for (int i = 0; i < vector.size(); ++i) {
            node = (Node)vector.elementAt(i);
            if (TreeCanvas.lapse.isCollapseSubRoot(node, this.sparse)) {
                this.setSynNodeCollapse(node, n2);
                continue;
            }
            if (this.sparse.IsLeafText(node) || TreeCanvas.lapse.isCollapsed(node.getIndex_int())) continue;
            this.setSynNode(node, n2);
        }
    }

    private void setXandY(GraphicNode graphicNode, GraphicNode graphicNode2, GraphicNode graphicNode3, int n) {
        int n2 = graphicNode2.getXStart();
        int n3 = graphicNode3.getXEnd();
        int n4 = this.lengthPerFont(graphicNode.getLabel()) / 2;
        int n5 = (n2 + n3) / 2 - n4;
        int n6 = n5 + this.lengthPerFont(graphicNode.getLabel() + "  ");
        graphicNode.setXs(n5, n6);
        graphicNode.setYs(n, n - this.FONT_SZ);
    }

    protected void setHighlights() {
        if (!this.has_indices) {
            return;
        }
        for (int i = 0; i < super.size(); ++i) {
            GraphicNode graphicNode = super.graphicNodeAt(i);
            if (super.inHighNodes(graphicNode.getNode())) {
                graphicNode.setHighlight1(true);
                continue;
            }
            if (!super.inHighBounds(graphicNode.getNode())) continue;
            graphicNode.setHighlight2(true);
        }
    }

    protected int lengthPerFont(String string) {
        return string.length() * (this.FONT_SZ / 2);
    }

    protected int lengthPerFont(int n) {
        return n * this.FONT_SZ / 2;
    }

    protected int getMiddleX(GraphicNode graphicNode) {
        int n = 0;
        n = graphicNode.getXStart();
        try {
            n += this.lengthPerFont(graphicNode.getLabel()) / 2;
        }
        catch (NullPointerException nullPointerException) {
            graphicNode.PrintToSystemErr();
        }
        return n;
    }
}

