/*
 * Decompiled with CFR 0.152.
 */
package drawtree;

import drawtree.ActionRecord;
import drawtree.CollapseIt;
import drawtree.CorpusDraw;
import drawtree.GraphicNode;
import drawtree.MyEvents;
import java.awt.FontMetrics;
import java.util.Stack;
import java.util.Vector;
import search_result.SentenceResult;
import syntree.ChangeTree;
import syntree.Node;

public class GraphicTree {
    protected ChangeTree sparse;
    protected FontMetrics font_met;
    protected Stack undoing;
    protected Stack redoing;
    protected Vector selected;
    protected Vector tree_list;
    protected Vector high_bounds;
    protected Vector high_nodes;
    protected ActionRecord actor;
    protected SentenceResult indices;
    protected boolean has_indices;
    protected boolean just_inits;
    protected boolean has_lapse;
    protected Node bullet_node;
    protected int max_depth;
    protected int X_DIFF;
    protected int Y_DIFF;
    protected int opt_height;
    protected int opt_width;
    protected int MIN_HT;
    protected int MIN_WDTH;
    protected int FONT_SZ;
    protected int word_scroll_ht;
    protected int word_scroll_wdth;
    protected CollapseIt lapse;

    private /* synthetic */ void finit$() {
        this.has_indices = false;
        this.FONT_SZ = 12;
    }

    public GraphicTree() {
        this.finit$();
        this.lapse = new CollapseIt();
        this.Init();
    }

    public GraphicTree(ChangeTree changeTree) {
        this.finit$();
        this.lapse = new CollapseIt();
        this.Init(changeTree);
    }

    public GraphicTree(ChangeTree changeTree, SentenceResult sentenceResult) {
        this.finit$();
        this.lapse = new CollapseIt();
        this.Init(changeTree, sentenceResult);
    }

    public void Init(ChangeTree changeTree, SentenceResult sentenceResult) {
        this.setIndices(sentenceResult);
        this.Init(changeTree);
    }

    public void Init(ChangeTree changeTree) {
        this.sparse = changeTree;
        this.Init();
    }

    public void Init() {
        this.tree_list = new Vector();
        this.selected = new Vector();
        this.undoing = new Stack();
        this.redoing = new Stack();
        this.setBulletNode();
        this.max_depth = 0;
        this.X_DIFF = 4;
        this.Y_DIFF = 6;
        this.just_inits = false;
        this.MIN_HT = CorpusDraw.MIN_HT;
        this.MIN_WDTH = CorpusDraw.MIN_WDTH;
        this.opt_height = this.MIN_HT;
        this.opt_width = this.MIN_WDTH;
    }

    public void partInit() {
        this.tree_list.removeAllElements();
        this.setBulletNode();
        this.max_depth = 0;
        this.X_DIFF = 4;
        this.Y_DIFF = 6;
        this.just_inits = false;
        this.MIN_HT = CorpusDraw.MIN_HT;
        this.MIN_WDTH = CorpusDraw.MIN_WDTH;
        this.opt_height = this.MIN_HT;
        this.opt_width = this.MIN_WDTH;
    }

    public void setCollapsedBits() {
        this.lapse.setCollapsedBits(this.sparse);
    }

    public void shrink() {
        if (this.X_DIFF > 0) {
            --this.X_DIFF;
            if (this.X_DIFF == 0) {
                this.just_inits = true;
            }
        }
        if (this.Y_DIFF > 3) {
            --this.Y_DIFF;
        }
    }

    public void swell() {
        ++this.X_DIFF;
        if (this.X_DIFF > 0) {
            this.just_inits = false;
        }
        ++this.Y_DIFF;
    }

    public int get_X_DIFF() {
        return this.X_DIFF;
    }

    public int get_Y_DIFF() {
        return this.Y_DIFF;
    }

    public boolean justInits() {
        return this.just_inits;
    }

    public void resetHeight() {
        Node node = this.sparse.getRootNode();
        GraphicNode graphicNode = this.graphicNodeFor(node);
        int n = graphicNode.getYEnd();
        this.opt_width = this.calcOptWidth();
        this.opt_height = this.calcOptHeight();
        if (n > 0) {
            return;
        }
        int n2 = 0 - n + 10;
        for (int i = 0; i < this.gt_size(); ++i) {
            GraphicNode graphicNode2 = this.graphicNodeAt(i);
            int n3 = graphicNode2.getYStart() + n2;
            graphicNode2.setYStart(n3);
            int n4 = graphicNode2.getYEnd() + n2;
            graphicNode2.setYEnd(n4);
        }
    }

    private int calcOptHeight() {
        int n = 0;
        Node node = this.sparse.getRootNode();
        GraphicNode graphicNode = this.graphicNodeFor(node);
        int n2 = graphicNode.getYEnd();
        for (int i = 0; i < this.gt_size(); ++i) {
            GraphicNode graphicNode2 = this.graphicNodeAt(i);
            if (graphicNode2.getYStart() <= n) continue;
            n = graphicNode2.getYStart();
        }
        int n3 = n;
        if (n2 < 0) {
            n3 -= n2;
        }
        if ((n3 += 100 + 12 * this.Y_DIFF) < this.MIN_HT) {
            return this.MIN_HT;
        }
        return n3;
    }

    private int calcOptWidth() {
        GraphicNode graphicNode = this.graphicNodeAt(this.gt_size() - 1);
        int n = graphicNode.getXEnd() + 20;
        if (n < this.MIN_WDTH) {
            return this.MIN_WDTH;
        }
        return n;
    }

    public int getOptHeight() {
        return this.opt_height;
    }

    public int getOptWidth() {
        return this.opt_width;
    }

    public int getScrollHt() {
        Node node = this.sparse.getRootNode();
        GraphicNode graphicNode = this.graphicNodeFor(node);
        int n = graphicNode.getYStart();
        int n2 = CorpusDraw.toole.getFrameHt();
        if ((n -= 2 * this.FONT_SZ) - 2 * this.FONT_SZ > n2) {
            this.shiftUp(graphicNode.getYStart() - 4 * this.FONT_SZ);
            n = 2 * this.FONT_SZ;
        }
        if (n < 0) {
            n = 0;
        }
        return n;
    }

    protected void shiftUp(int n) {
        this.shiftUp(0, n);
    }

    protected void shiftUp(int n, int n2) {
        for (int i = n; i < this.gt_size(); ++i) {
            GraphicNode graphicNode = this.graphicNodeAt(i);
            graphicNode.shiftUp(n2);
        }
    }

    protected void shiftDown(int n) {
        this.shiftUp(0, n);
    }

    protected void shiftDown(int n, int n2) {
        for (int i = n; i < this.gt_size(); ++i) {
            GraphicNode graphicNode = this.graphicNodeAt(i);
            graphicNode.shiftDown(n2);
        }
    }

    protected void shiftDownSubtree(Node node, int n) {
        this.shiftDownSubtree(node.getIndex_int(), n);
    }

    protected void shiftDownSubtree(int n, int n2) {
        GraphicNode graphicNode = this.graphicNodeAt(n);
        graphicNode.shiftDown(n2);
        Vector vector = this.sparse.GetDescendants(n);
        for (int i = 0; i < vector.size(); ++i) {
            Node node = (Node)vector.elementAt(i);
            graphicNode = this.graphicNodeFor(node);
            graphicNode.shiftDown(n2);
        }
    }

    protected void shiftDown(int n, int n2, int n3) {
        for (int i = n; i < n2; ++i) {
            GraphicNode graphicNode = this.graphicNodeAt(i);
            graphicNode.shiftDown(n3);
        }
    }

    protected void shiftRight(int n) {
        this.shiftRight(0, n);
    }

    protected void shiftRight(int n, int n2) {
        for (int i = n; i < this.gt_size(); ++i) {
            GraphicNode graphicNode = this.graphicNodeAt(i);
            graphicNode.shiftRight(n2);
        }
    }

    protected void shiftLeft(int n) {
        this.shiftLeft(0, n);
    }

    protected void shiftLeft(int n, int n2) {
        this.shiftLeft(n, this.gt_size(), n2);
    }

    protected void shiftLeft(int n, int n2, int n3) {
        for (int i = n; i < n2; ++i) {
            GraphicNode graphicNode = this.graphicNodeAt(i);
            graphicNode.shiftLeft(n3);
        }
    }

    protected void shiftLeftSubtree(int n, int n2) {
        Node node = this.sparse.NodeAt(n);
        Node node2 = this.sparse.LastDaughter(node);
        int n3 = node2.getIndex_int();
        this.shiftLeft(n, n3 + 1, n2);
    }

    public int getScrollWidth() {
        Node node = this.sparse.getRootNode();
        GraphicNode graphicNode = this.graphicNodeFor(node);
        int n = CorpusDraw.toole.getFrameWdth() / 2;
        int n2 = graphicNode.getXStart();
        if ((n2 -= n) < 0) {
            this.shiftRight(n);
            n2 += CorpusDraw.toole.getFrameWdth() / 2;
        }
        return n2;
    }

    public GraphicNode gNodeForWordDex(int n, String string) {
        Node node = this.correctNode(n, string);
        GraphicNode graphicNode = this.graphicNodeFor(node);
        return graphicNode;
    }

    private Node correctNode(int n, String string) {
        Vector vector = MyEvents.urt.toScrollVec(this.sparse);
        if (n < 0) {
            n = 0;
        }
        if (n > vector.size() - 1) {
            n = vector.size() - 1;
        }
        Node node = (Node)vector.elementAt(n);
        for (int i = n; i < vector.size(); ++i) {
            node = (Node)vector.elementAt(i);
            if (!node.getLabel().equals(string.trim())) continue;
            return node;
        }
        return (Node)vector.elementAt(n);
    }

    public Node setScrollWordDex(int n, String string) {
        GraphicNode graphicNode = this.gNodeForWordDex(n, string);
        return this.setScrollWordDex(graphicNode);
    }

    public Node setScrollWordDex(GraphicNode graphicNode) {
        this.word_scroll_ht = graphicNode.getYEnd();
        this.word_scroll_ht -= CorpusDraw.toole.getFrameHt() / 2;
        this.word_scroll_wdth = graphicNode.getXStart() - 4 * this.FONT_SZ;
        this.word_scroll_wdth -= CorpusDraw.toole.getFrameWdth() / 2;
        if (this.word_scroll_wdth < 0) {
            this.word_scroll_wdth = 0;
        }
        return graphicNode.getNode();
    }

    public int getWordScrollHt() {
        return this.word_scroll_ht;
    }

    public int getWordScrollWdth() {
        return this.word_scroll_wdth;
    }

    public void decNumID() {
        this.sparse.setNumID(this.sparse.getNumID() - 1);
    }

    public void setNumID(int n) {
        this.sparse.setNumID(n);
    }

    public int getNumID() {
        return this.sparse.getNumID();
    }

    public boolean selectIsEmpty() {
        return this.selected.isEmpty();
    }

    public void setBulletNode() {
        try {
            try {
                if (this.has_indices) {
                    this.bullet_node = (Node)this.high_bounds.firstElement();
                    return;
                }
                this.bullet_node = this.sparse.getRootNode();
            }
            catch (Exception exception) {
                this.bullet_node = new Node("NULL");
            }
        }
        catch (Throwable throwable) {}
    }

    public void setBulletNode(Node node) {
        this.bullet_node = node;
    }

    public Node getBulletNode() {
        return this.bullet_node;
    }

    public GraphicNode getGraphicBulletNode() {
        return this.graphicNodeFor(this.bullet_node);
    }

    public boolean getsBullet(GraphicNode graphicNode) {
        return this.getsBullet(graphicNode.getNode());
    }

    public boolean getsBullet(Node node) {
        return this.bullet_node.equals(node);
    }

    public void moveBulletDown() {
        Vector vector = this.sparse.GetDaughters(this.bullet_node);
        if (vector.isEmpty()) {
            return;
        }
        if (vector.size() == 1) {
            this.bullet_node = (Node)vector.firstElement();
            return;
        }
        int n = vector.size() / 2;
        this.bullet_node = (Node)vector.elementAt(n);
    }

    public void moveBulletUp() {
        if (this.bullet_node.equals(this.sparse.getRootNode())) {
            return;
        }
        Node node = this.sparse.GetMother(this.bullet_node);
        if (!node.IsNullNode()) {
            this.bullet_node = node;
        }
    }

    public void moveBulletRight() {
        Vector vector = this.getNodesforYStart(this.bullet_node);
        for (int i = 0; i < vector.size(); ++i) {
            GraphicNode graphicNode = (GraphicNode)vector.elementAt(i);
            if (!graphicNode.getNode().equals(this.bullet_node)) continue;
            if (i == vector.size() - 1) {
                return;
            }
            graphicNode = (GraphicNode)vector.elementAt(i + 1);
            this.bullet_node = graphicNode.getNode();
            return;
        }
    }

    public void moveBulletLeft() {
        Vector vector = this.getNodesforYStart(this.bullet_node);
        for (int i = 0; i < vector.size(); ++i) {
            GraphicNode graphicNode = (GraphicNode)vector.elementAt(i);
            if (!graphicNode.getNode().equals(this.bullet_node)) continue;
            if (i == 0) {
                return;
            }
            graphicNode = (GraphicNode)vector.elementAt(i - 1);
            this.bullet_node = graphicNode.getNode();
            return;
        }
    }

    public Vector getNodesforYStart(Node node) {
        return this.getNodesforYStart(this.graphicNodeFor(node));
    }

    public Vector getNodesforYStart(GraphicNode graphicNode) {
        return this.getNodesforYStart(graphicNode.getYStart());
    }

    public Vector getNodesforYStart(int n) {
        Vector<GraphicNode> vector = new Vector<GraphicNode>();
        for (int i = 0; i < this.gt_size(); ++i) {
            GraphicNode graphicNode = this.graphicNodeAt(i);
            if (graphicNode.getYStart() != n) continue;
            vector.addElement(graphicNode);
        }
        return vector;
    }

    public boolean isEmpty() {
        return this.tree_list.isEmpty();
    }

    public void setIndices(SentenceResult sentenceResult) {
        if (sentenceResult.isEmpty()) {
            return;
        }
        this.indices = sentenceResult;
        this.has_indices = true;
        this.high_bounds = sentenceResult.getBoundList();
        this.high_nodes = sentenceResult.getNodeList();
    }

    public void updateIndices() {
        if (!this.has_indices) {
            return;
        }
        this.indices.update(this.sparse);
        this.high_bounds = this.indices.getBoundList();
        this.high_nodes = this.indices.getNodeList();
    }

    public boolean inHighBounds(Node node) {
        return this.inList(this.high_bounds, node);
    }

    public boolean inHighNodes(Node node) {
        return this.inList(this.high_nodes, node);
    }

    public boolean inList(Vector vector, Node node) {
        for (int i = 0; i < vector.size(); ++i) {
            Node node2 = (Node)vector.elementAt(i);
            if (!node2.equals(node)) continue;
            return true;
        }
        return false;
    }

    public SentenceResult getIndices() {
        return this.indices;
    }

    public boolean hasIndices() {
        return this.has_indices;
    }

    public String getShortFileName() {
        String string;
        try {
            String string2 = this.sparse.getFileName();
            int n = string2.lastIndexOf("/");
            if (n < 0) {
                return string2;
            }
            string = string2.substring(n + 1);
        }
        catch (Exception exception) {
            string = "NO_FILE_NAME_FOUND";
        }
        return string;
    }

    public String getFileName() {
        return this.sparse.getFileName();
    }

    public void setFileName(String string) {
        this.sparse.setFileName(string);
    }

    public GraphicNode graphicNodeFor(Node node) {
        return this.graphicNodeAt(node.getIndex());
    }

    public GraphicNode graphicNodeAt(Integer n) {
        return this.graphicNodeAt((int)n);
    }

    public GraphicNode graphicNodeAt(int n) {
        GraphicNode graphicNode = new GraphicNode("NULL");
        try {
            try {
                graphicNode = (GraphicNode)this.tree_list.elementAt(n);
            }
            catch (Exception exception) {}
        }
        catch (Throwable throwable) {}
        return graphicNode;
    }

    public Node NodeAt(int n) {
        GraphicNode graphicNode = this.graphicNodeAt(n);
        return graphicNode.getNode();
    }

    public boolean IsLeafText(Node node) {
        return this.sparse.IsLeafText(node);
    }

    public void reset() {
        this.sparse.changesInit();
        this.tree_list.removeAllElements();
        this.selected = new Vector();
    }

    public void removeAllElements() {
        this.tree_list.removeAllElements();
        this.sparse.removeAllElements();
        this.selected.removeAllElements();
        this.undoing.removeAllElements();
        this.redoing.removeAllElements();
        this.has_indices = false;
        this.max_depth = 0;
    }

    public void calcDepth() {
        this.max_depth = 0;
        int n = this.sparse.getSubtreeDepth(this.sparse.getRootNode());
        this.setMaxDepth(n);
    }

    public void setMaxDepth(int n) {
        if (n > this.max_depth) {
            this.max_depth = n;
        }
    }

    public void setMaxDepth(Node node) {
        int n = this.sparse.getDepth(node);
        this.setMaxDepth(n);
    }

    public int getMaxDepth() {
        return this.max_depth;
    }

    public void addGraphicNode(GraphicNode graphicNode) {
        int n = graphicNode.getNode().getIndex_int();
        if (n >= this.tree_list.size()) {
            for (int i = this.tree_list.size(); i <= n; ++i) {
                GraphicNode graphicNode2 = new GraphicNode("NULL");
                this.tree_list.addElement(graphicNode2);
            }
        }
        this.tree_list.setElementAt(graphicNode, n);
    }

    public ChangeTree getChangeTree() {
        return this.sparse;
    }

    public void addToSelected(GraphicNode graphicNode) {
        this.selected.addElement(graphicNode);
    }

    public void removeFromSelected(GraphicNode graphicNode) {
        for (int i = 0; i < this.selected.size(); ++i) {
            GraphicNode graphicNode2 = (GraphicNode)this.selected.elementAt(i);
            if (!graphicNode2.equals(graphicNode)) continue;
            this.selected.removeElementAt(i);
        }
    }

    public void clearSelected() {
        this.selected.removeAllElements();
    }

    public boolean isSelected(GraphicNode graphicNode) {
        for (int i = 0; i < this.selected.size(); ++i) {
            GraphicNode graphicNode2 = (GraphicNode)this.selected.elementAt(i);
            if (!graphicNode2.equals(graphicNode)) continue;
            return true;
        }
        return false;
    }

    public void toggleSelected(GraphicNode graphicNode) {
        if (this.isSelected(graphicNode)) {
            this.removeFromSelected(graphicNode);
        } else {
            this.addToSelected(graphicNode);
        }
    }

    public GraphicNode peekSelected() {
        if (this.selected.isEmpty()) {
            return new GraphicNode("NULL");
        }
        return (GraphicNode)this.selected.lastElement();
    }

    public GraphicNode popSelected() {
        GraphicNode graphicNode = new GraphicNode("NULL");
        if (this.selected.isEmpty()) {
            return graphicNode;
        }
        graphicNode = (GraphicNode)this.selected.lastElement();
        this.selected.removeElementAt(this.selected.size() - 1);
        return graphicNode;
    }

    public GraphicNode getSelected(int n) {
        if (n < 0 || n >= this.selected.size()) {
            return new GraphicNode("NULL");
        }
        return (GraphicNode)this.selected.elementAt(n);
    }

    public int selectedSize() {
        return this.selected.size();
    }

    public void setHighlight1(Node node) {
        GraphicNode graphicNode = this.graphicNodeAt(node.getIndex());
        graphicNode.setHighlight1(true);
    }

    public void setHighlight2(Node node) {
        GraphicNode graphicNode = this.graphicNodeAt(node.getIndex());
        graphicNode.setHighlight2(true);
    }

    public int gt_size() {
        return this.tree_list.size();
    }

    public GraphicNode getNodeforCoords(int n, int n2) {
        GraphicNode graphicNode;
        for (int i = 0; i < this.tree_list.size(); ++i) {
            graphicNode = this.graphicNodeAt(i);
            if (!graphicNode.containsCoords(n, n2)) continue;
            return graphicNode;
        }
        graphicNode = new GraphicNode("NULL");
        return graphicNode;
    }

    public GraphicNode getGNode(Node node) {
        int n = node.getIndex_int();
        return this.graphicNodeAt(n);
    }

    public GraphicNode getMother(GraphicNode graphicNode) {
        Node node = graphicNode.getNode();
        Node node2 = this.sparse.GetMother(node);
        return this.getGNode(node);
    }

    public void OKShiftLeft(int n, int n2) {
        int n3 = 6 * this.X_DIFF;
        int n4 = n2;
        for (int i = n + 1; i < this.sparse.size(); ++i) {
            int n5 = this.xSpaceBehind(i, n);
            if (n5 < 0 || n4 <= n5) continue;
            n4 = n5;
        }
        if (n4 <= n3) {
            return;
        }
        this.shiftLeft(n, n4 - n3);
    }

    public int xSpaceBehind(Node node) {
        int n = node.getIndex_int();
        return this.xSpaceBehind(n, n);
    }

    public int xSpaceBehind(int n) {
        return this.xSpaceBehind(n, n);
    }

    public int xSpaceBehind(int n, int n2) {
        int n3 = -3;
        if (n == 0) {
            return 0;
        }
        GraphicNode graphicNode = this.graphicNodeAt(n);
        int n4 = graphicNode.getXStart();
        for (int i = n2 - 1; i > 0; --i) {
            GraphicNode graphicNode2 = this.graphicNodeAt(i);
            if (!graphicNode2.sameY(graphicNode)) continue;
            int n5 = graphicNode2.getXEnd();
            n3 = n4 - n5;
            return n3;
        }
        return n3;
    }

    protected void correctRoot(Node node, Node node2) {
        GraphicNode graphicNode = this.graphicNodeFor(node);
        GraphicNode graphicNode2 = this.graphicNodeFor(node2);
        int n = (graphicNode.getXStart() + graphicNode2.getXStart()) / 2;
        GraphicNode graphicNode3 = this.graphicNodeFor(this.sparse.getRootNode());
        graphicNode3.setXStart(n);
        graphicNode3.setXEnd(n + this.X_DIFF * this.FONT_SZ / 2);
    }

    public void PrintHighNodes() {
        for (int i = 0; i < this.high_nodes.size(); ++i) {
            Node node = (Node)this.high_nodes.elementAt(i);
            System.err.print(node.toString() + ", ");
        }
        System.err.println("");
    }

    public void PrintToSystemErr() {
        this.PrintToSystemErr(0, this.gt_size());
    }

    public void PrintToSystemErr(int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        if (n2 > this.gt_size()) {
            n2 = this.gt_size();
        }
        for (int i = n; i < n2; ++i) {
            GraphicNode graphicNode = this.graphicNodeAt(i);
            graphicNode.PrintToSystemErr();
        }
    }

    public void PrintSelectToSystemErr() {
        System.err.print("selected nodes: ");
        for (int i = 0; i < this.selected.size(); ++i) {
            GraphicNode graphicNode = (GraphicNode)this.selected.elementAt(i);
            Node node = graphicNode.getNode();
            System.err.print(node.toString());
            if (i >= this.selected.size() - 1) continue;
            System.err.print(", ");
        }
        System.err.println("");
    }
}

