/*
 * Decompiled with CFR 0.152.
 */
package drawtree;

import drawtree.ChangeGraphicTree;
import drawtree.CorpusDraw;
import drawtree.DrawLoop;
import drawtree.GraphicNode;
import drawtree.ToolColors;
import drawtree.ToolView;
import drawtree.TreeCanvas;
import java.awt.Graphics;
import java.util.Vector;
import syntree.ChangeTree;
import syntree.Node;

public class DrawGraphicTree
extends TreeCanvas {
    public static Graphics my_graphite;
    protected static int Y_BUFFER;

    public static void drawTree(ChangeGraphicTree changeGraphicTree, Graphics graphics) {
        my_graphite = graphics;
        ToolView.treeve.treece.setSizeCurrTree();
        if (changeGraphicTree.isEmpty()) {
            return;
        }
        changeGraphicTree.setCollapseList(DrawLoop.getCollapseList());
        changeGraphicTree.setCollapsedBits();
        if (!changeGraphicTree.willCollapse()) {
            DrawGraphicTree.bottomUp(changeGraphicTree);
            return;
        }
        DrawGraphicTree.bottomUpCollapse(changeGraphicTree);
    }

    protected static void bottomUpCollapse(ChangeGraphicTree changeGraphicTree) {
        for (int i = 0; i < changeGraphicTree.gt_size(); ++i) {
            GraphicNode graphicNode = changeGraphicTree.graphicNodeAt(i);
            Node node = graphicNode.getNode();
            if (!changeGraphicTree.IsLeafText(node)) continue;
            if (changeGraphicTree.isCollapsed(i)) {
                int n;
                i = n = changeGraphicTree.getCollapsedEnd(node);
                continue;
            }
            DrawGraphicTree.drawGNodeString(changeGraphicTree, graphicNode);
        }
        for (int i = changeGraphicTree.getMaxDepth(); i >= 0; --i) {
            DrawGraphicTree.subBottomCollapse(changeGraphicTree, i);
        }
    }

    protected static void bottomUp(ChangeGraphicTree changeGraphicTree) {
        for (int i = 0; i < changeGraphicTree.gt_size(); ++i) {
            GraphicNode graphicNode = changeGraphicTree.graphicNodeAt(i);
            Node node = graphicNode.getNode();
            if (!changeGraphicTree.IsLeafText(node)) continue;
            DrawGraphicTree.drawGNodeString(changeGraphicTree, graphicNode);
        }
        for (int i = changeGraphicTree.getMaxDepth(); i >= 0; --i) {
            DrawGraphicTree.subBottom(changeGraphicTree, i);
        }
    }

    protected static void subBottom(ChangeGraphicTree changeGraphicTree, int n) {
        Node node = new Node("NULL");
        Vector vector = changeGraphicTree.getChangeTree().getAllNodesforDepth(n);
        for (int i = 0; i < vector.size(); ++i) {
            node = (Node)vector.elementAt(i);
            if (changeGraphicTree.getChangeTree().IsLeafText(node)) continue;
            GraphicNode graphicNode = changeGraphicTree.getGNode(node);
            DrawGraphicTree.drawGStringLines(changeGraphicTree, graphicNode);
        }
    }

    protected static void subBottomCollapse(ChangeGraphicTree changeGraphicTree, int n) {
        Node node = new Node("NULL");
        Vector vector = changeGraphicTree.getChangeTree().getAllNodesforDepth(n);
        for (int i = 0; i < vector.size(); ++i) {
            node = (Node)vector.elementAt(i);
            if (changeGraphicTree.isCollapseSubRoot(node)) {
                GraphicNode graphicNode = changeGraphicTree.getGNode(node);
                DrawGraphicTree.drawGStringLinesCollapseRoot(changeGraphicTree, graphicNode);
                continue;
            }
            if (changeGraphicTree.getChangeTree().IsLeafText(node) || changeGraphicTree.isCollapsed(node.getIndex_int())) continue;
            GraphicNode graphicNode = changeGraphicTree.getGNode(node);
            DrawGraphicTree.drawGStringLines(changeGraphicTree, graphicNode);
        }
    }

    protected static void drawMomLines(ChangeGraphicTree changeGraphicTree, GraphicNode graphicNode) {
        Node node = new Node("NULL");
        try {
            try {
                my_graphite.setColor(ToolColors.LINE);
                node = graphicNode.getNode();
                if (node.IsNullNode() || node.getIndex_int() == 0) {
                    return;
                }
                if (changeGraphicTree.sparse.getRootNode().equals(node)) {
                    DrawGraphicTree.drawMomRootLines(changeGraphicTree, graphicNode);
                    return;
                }
                Vector vector = changeGraphicTree.getChangeTree().GetDaughters(node);
                int n = changeGraphicTree.getMiddleX(graphicNode);
                int n2 = graphicNode.getYEnd() + Y_BUFFER;
                for (int i = 0; i < vector.size(); ++i) {
                    Node node2 = (Node)vector.elementAt(i);
                    GraphicNode graphicNode2 = changeGraphicTree.graphicNodeFor(node2);
                    int n3 = vector.size() == 1 ? n : changeGraphicTree.getMiddleX(graphicNode2);
                    int n4 = graphicNode2.getYEnd();
                    my_graphite.drawLine(n, n2, n3, n4);
                }
            }
            catch (Exception exception) {
                System.err.println("will print cgt:  ");
                changeGraphicTree.PrintToSystemErr(node.getIndex_int() - 5, node.getIndex_int() + 5);
                System.err.println("in DrawGraphicTree.drawMomLines:  ");
                System.err.println("gmom:  " + graphicNode.getNode().toString());
                System.exit(1);
            }
        }
        catch (Throwable throwable) {}
    }

    protected static void drawMomRootLines(ChangeGraphicTree changeGraphicTree, GraphicNode graphicNode) {
        try {
            try {
                my_graphite.setColor(ToolColors.LINE);
                Node node = graphicNode.getNode();
                if (node.IsNullNode() || node.getIndex_int() == 0) {
                    return;
                }
                Vector vector = changeGraphicTree.getChangeTree().GetDaughters(node);
                int n = changeGraphicTree.getMiddleX(graphicNode);
                int n2 = graphicNode.getYEnd() + Y_BUFFER;
                for (int i = 0; i < vector.size(); ++i) {
                    Node node2 = (Node)vector.elementAt(i);
                    GraphicNode graphicNode2 = changeGraphicTree.getGNode(node2);
                    int n3 = vector.size() == 1 ? n : changeGraphicTree.getMiddleX(graphicNode2);
                    int n4 = graphicNode2.getYEnd();
                    my_graphite.drawLine(n3, n2, n3, n4);
                    my_graphite.drawLine(n3, n2, n, n2);
                }
            }
            catch (Exception exception) {
                System.err.println("in DrawGraphicTree.drawMomLines:  ");
                System.exit(1);
            }
        }
        catch (Throwable throwable) {}
    }

    protected static void drawGCircle(ChangeGraphicTree changeGraphicTree, GraphicNode graphicNode) {
        my_graphite.setColor(ToolColors.COLLAPSE);
        Node node = graphicNode.getNode();
        int n = changeGraphicTree.getMiddleX(graphicNode);
        int n2 = graphicNode.getYEnd() + Y_BUFFER;
        my_graphite.drawOval(n, n2, 8, 8);
    }

    protected static Node getOnlyAncestor(ChangeTree changeTree, Node node, Node node2) {
        Node node3 = node;
        Node node4 = node;
        while (!node3.IsNullNode() && !node3.equals(node2)) {
            if ((node3 = changeTree.GetMother(node3)).IsNullNode() || node3.equals(node2)) {
                return node4;
            }
            if (!CorpusDraw.show_list.hasMatch(node3)) continue;
            node4 = node3;
        }
        return node3;
    }

    protected static void drawGStringLines(ChangeGraphicTree changeGraphicTree, GraphicNode graphicNode) {
        DrawGraphicTree.drawGNodeString(changeGraphicTree, graphicNode);
        DrawGraphicTree.drawMomLines(changeGraphicTree, graphicNode);
    }

    protected static void drawGStringLinesCollapseRoot(ChangeGraphicTree changeGraphicTree, GraphicNode graphicNode) {
        if (CorpusDraw.show_only && !CorpusDraw.show_list.isEmpty() && !CorpusDraw.show_list.hasMatch(graphicNode.getLabel())) {
            return;
        }
        DrawGraphicTree.drawCollGNodeString(changeGraphicTree, graphicNode);
        DrawGraphicTree.drawGCircle(changeGraphicTree, graphicNode);
    }

    protected static void drawGNodeString(ChangeGraphicTree changeGraphicTree, GraphicNode graphicNode) {
        try {
            try {
                if (graphicNode.isHighlighted1()) {
                    DrawGraphicTree.drawHighlight1(graphicNode);
                }
                if (graphicNode.isHighlighted2()) {
                    DrawGraphicTree.drawHighlight2(graphicNode);
                }
                if (changeGraphicTree.getsBullet(graphicNode)) {
                    DrawGraphicTree.drawBullet(changeGraphicTree, graphicNode);
                }
                my_graphite.setColor(ToolColors.TEXT);
                if (!changeGraphicTree.justInits()) {
                    my_graphite.drawString(graphicNode.getLabel(), graphicNode.getXStart(), graphicNode.getYStart());
                } else {
                    my_graphite.drawString(graphicNode.getLabel().substring(0, 1), graphicNode.getXStart(), graphicNode.getYStart());
                }
                if (changeGraphicTree.isSelected(graphicNode)) {
                    DrawGraphicTree.drawSelect(changeGraphicTree, graphicNode);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        catch (Throwable throwable) {}
    }

    protected static void drawCollGNodeString(ChangeGraphicTree changeGraphicTree, GraphicNode graphicNode) {
        try {
            try {
                if (graphicNode.isHighlighted1()) {
                    DrawGraphicTree.drawHighlight1(graphicNode);
                }
                if (graphicNode.isHighlighted2()) {
                    DrawGraphicTree.drawHighlight2(graphicNode);
                }
                if (changeGraphicTree.getsBullet(graphicNode)) {
                    DrawGraphicTree.drawBullet(changeGraphicTree, graphicNode);
                }
                my_graphite.setColor(ToolColors.COLLAPSE);
                my_graphite.drawString(graphicNode.getLabel(), graphicNode.getXStart(), graphicNode.getYStart());
                if (changeGraphicTree.isSelected(graphicNode)) {
                    DrawGraphicTree.drawSelect(changeGraphicTree, graphicNode);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        catch (Throwable throwable) {}
    }

    protected static void whichSelect(ChangeGraphicTree changeGraphicTree, GraphicNode graphicNode) {
        if (changeGraphicTree.isSelected(graphicNode)) {
            DrawGraphicTree.drawSelect(changeGraphicTree, graphicNode);
            return;
        }
        DrawGraphicTree.drawUnSelect(changeGraphicTree, graphicNode);
    }

    protected static void drawSelect(ChangeGraphicTree changeGraphicTree, GraphicNode graphicNode) {
        my_graphite.setColor(ToolColors.SELECT);
        DrawGraphicTree.drawSelectRectangle(changeGraphicTree, graphicNode);
    }

    protected static void drawUnSelect(ChangeGraphicTree changeGraphicTree, GraphicNode graphicNode) {
        my_graphite.setColor(ToolColors.BACKGROUND);
        DrawGraphicTree.drawSelectRectangle(changeGraphicTree, graphicNode);
    }

    protected static void drawSelectRectangle(ChangeGraphicTree changeGraphicTree, GraphicNode graphicNode) {
        my_graphite.drawRect(graphicNode.getXStart() - 2, graphicNode.getYEnd(), graphicNode.getXEnd() - graphicNode.getXStart() + 2, graphicNode.getYStart() - graphicNode.getYEnd());
    }

    protected static void drawHighlight1(GraphicNode graphicNode) {
        my_graphite.setColor(ToolColors.HIGHLIGHT1);
        DrawGraphicTree.fillHighlightRect(graphicNode);
    }

    protected static void drawHighlight2(GraphicNode graphicNode) {
        my_graphite.setColor(ToolColors.HIGHLIGHT2);
        DrawGraphicTree.fillHighlightRect(graphicNode);
    }

    protected static void fillHighlightRect(GraphicNode graphicNode) {
        my_graphite.fillRect(graphicNode.getXStart() - 2, graphicNode.getYEnd() + 1, graphicNode.getXEnd() - graphicNode.getXStart() + 2, graphicNode.getYStart() - graphicNode.getYEnd() - 1);
    }

    protected static void drawBullet(ChangeGraphicTree changeGraphicTree, GraphicNode graphicNode) {
        my_graphite.setColor(ToolColors.BULLET);
        DrawGraphicTree.subBullet(changeGraphicTree, graphicNode);
    }

    protected static void subBullet(ChangeGraphicTree changeGraphicTree, GraphicNode graphicNode) {
        my_graphite.fillOval(changeGraphicTree.getMiddleX(graphicNode), graphicNode.getYEnd() - 8, 6, 6);
    }

    protected static void clearBullet(ChangeGraphicTree changeGraphicTree, GraphicNode graphicNode) {
        my_graphite.setColor(ToolColors.BACKGROUND);
        DrawGraphicTree.subBullet(changeGraphicTree, graphicNode);
    }

    static {
        Y_BUFFER = 16;
    }
}

