/*
 * Decompiled with CFR 0.152.
 */
package drawtree;

import CSParse.ParseQuery;
import basicinfo.ArgList;
import basicinfo.Goodbye;
import basicinfo.Vitals;
import command.CommandInfo;
import command.ReadIn;
import drawtree.ChangeGraphicTree;
import drawtree.CorpusTags;
import drawtree.DrawLoop;
import drawtree.DrawMeat;
import drawtree.MyEvents;
import drawtree.ToolView;
import drawtree.TreeBuffer;
import io.OutFileDominatrix;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.Vector;
import print.PrintTree;
import print.UrText;
import search_result.SentenceResult;
import syntree.ChangeTree;
import syntree.SynTree;

public class CorpusDraw {
    public static ChangeGraphicTree for_undo;
    public static ChangeGraphicTree for_undo1;
    public static ChangeGraphicTree for_undo2;
    public static String prev_file_name;
    public static String file_name;
    public static String curr_file_name;
    public static String command_name;
    public static String dest_name;
    public static String show_str;
    public static String query;
    public static ToolView toole;
    public static ArgList show_list;
    public static int MIN_HT;
    public static int MIN_WDTH;
    public static int file_dex;
    public static int max_ht;
    public static int max_wdth;
    public static Vector source_list;
    public static OutFileDominatrix out_dom;
    public static PrintWriter out_stuff;
    public static CorpusTags corpse_tags;
    public static boolean has_query;
    public static boolean show_only;
    public static boolean copy_corpus;
    public static boolean first_out_file;
    public static TreeBuffer tree_buff;

    public static void main(String[] stringArray) {
        try {
            try {
                CorpusDraw.PrintBookmark();
                CorpusDraw.Init();
                prev_file_name = "RAO_QING_TIAN";
                first_out_file = true;
                MyEvents.urt = new UrText();
                if (stringArray.length == 1) {
                    file_name = stringArray[0];
                    source_list.addElement(file_name);
                    toole = new ToolView();
                    DrawMeat.CrankThrough(source_list, toole);
                }
                if (stringArray.length > 1) {
                    command_name = stringArray[0];
                    if (command_name.endsWith(".q") || command_name.endsWith(".c")) {
                        file_dex = 1;
                        ReadIn.PrefsAndQuery(command_name);
                        CorpusDraw.Init();
                    }
                    if (CommandInfo.gotQuery()) {
                        has_query = true;
                        query = CommandInfo.query;
                        ParseQuery.makeQueryTree(new StringReader(CommandInfo.query));
                    }
                    show_only = CommandInfo.show_only;
                    show_str = CommandInfo.show_str;
                    if (show_only) {
                        show_list = new ArgList(show_str);
                    }
                    toole = new ToolView();
                    for (int i = file_dex; i < stringArray.length; ++i) {
                        file_name = stringArray[i];
                        source_list.addElement(file_name);
                    }
                    DrawMeat.CrankThrough(source_list, toole);
                }
                if (stringArray.length < 1) {
                    CorpusDraw.WrongArgsMessage();
                }
            }
            catch (Exception exception) {
                System.err.println("in CorpusDraw: main: ");
                exception.printStackTrace();
                Goodbye.SearchExit();
            }
        }
        catch (Throwable throwable) {}
        System.exit(1);
    }

    public static boolean hasQuery() {
        return has_query;
    }

    private static void Init() {
        tree_buff = new TreeBuffer();
        source_list = new Vector();
        has_query = false;
        show_only = false;
        copy_corpus = CommandInfo.copy_corpus;
        max_ht = 0;
        max_wdth = 0;
    }

    public static ChangeGraphicTree currTree() {
        return tree_buff.getCurrTree();
    }

    public static ChangeGraphicTree previousTree() {
        return tree_buff.previousTree();
    }

    public static ChangeGraphicTree followingTree() {
        return tree_buff.followingTree();
    }

    public static int getShowDex() {
        return tree_buff.getShowDex();
    }

    public static void setShowDex(int n) {
        tree_buff.setShowDex(n);
    }

    public static void popForward() {
        tree_buff.setNext();
    }

    public static void rmPrev() {
        tree_buff.rmPrev();
    }

    public static void rmFoll() {
        tree_buff.rmFoll();
    }

    public static boolean gotForward() {
        return tree_buff.gotForward();
    }

    public static void addToBuffer(SynTree synTree, int n, String string) {
        ChangeTree changeTree = new ChangeTree(synTree, n, string);
        ChangeGraphicTree changeGraphicTree = DrawLoop.hasCollapseList() ? new ChangeGraphicTree(changeTree, DrawLoop.getCollapseList()) : new ChangeGraphicTree(changeTree);
        CorpusDraw.addToBuffer(changeGraphicTree);
    }

    public static void showLast() {
        tree_buff.showLast();
    }

    public static void addToBuffer(ChangeGraphicTree changeGraphicTree) {
        if (changeGraphicTree.getOptHeight() > max_ht) {
            max_ht = changeGraphicTree.getOptHeight();
        }
        if (changeGraphicTree.getOptWidth() > max_wdth) {
            max_wdth = changeGraphicTree.getOptWidth();
        }
        tree_buff.addToTreeBuffer(changeGraphicTree);
    }

    public static void blindAddToBuffer(SynTree synTree, int n, String string, SentenceResult sentenceResult) {
        ChangeTree changeTree = new ChangeTree(synTree, n, string);
        ChangeGraphicTree changeGraphicTree = new ChangeGraphicTree(changeTree, sentenceResult);
        tree_buff.blindAddToTreeBuffer(changeGraphicTree, sentenceResult.isEmpty() ^ true);
    }

    public static void blindAddToBuffer(SynTree synTree, int n, String string) {
        ChangeTree changeTree = new ChangeTree(synTree, n, string);
        ChangeGraphicTree changeGraphicTree = new ChangeGraphicTree(changeTree);
        CorpusDraw.blindAddToBuffer(changeGraphicTree);
    }

    public static void blindAddToBuffer(ChangeGraphicTree changeGraphicTree) {
        tree_buff.blindAddToTreeBuffer(changeGraphicTree);
    }

    public static void addToBuffer(SynTree synTree, int n, String string, SentenceResult sentenceResult) {
        ChangeTree changeTree = new ChangeTree(synTree, n, string);
        ChangeGraphicTree changeGraphicTree = new ChangeGraphicTree(changeTree, sentenceResult);
        CorpusDraw.addToBuffer(changeGraphicTree, sentenceResult.isEmpty() ^ true);
    }

    public static void addToBuffer(ChangeGraphicTree changeGraphicTree, boolean bl) {
        tree_buff.addToTreeBuffer(changeGraphicTree, bl);
    }

    public static void pushForward(ChangeGraphicTree changeGraphicTree, int n) {
        if (n == 1 || n == -1) {
            DrawLoop.incSentNumID();
        }
        tree_buff.pushForward(changeGraphicTree);
    }

    public static boolean goBack() {
        return tree_buff.setPrevious();
    }

    public static boolean goToPrevious(int n) {
        return tree_buff.goToPrevious(n);
    }

    public static void saveAll() {
        CorpusDraw.printTreeBuffer();
    }

    public static void printTreeBuffer() {
        out_dom = new OutFileDominatrix(dest_name);
        out_stuff = out_dom.getPrintWriter();
        for (int i = 0; i < tree_buff.size(); ++i) {
            CorpusDraw.printToCorrectOutput(tree_buff.changeTreeAt(i));
        }
        out_stuff.println("");
        out_stuff.flush();
    }

    public static void printToCorrectOutput(ChangeTree changeTree) {
        if (changeTree.isEmpty()) {
            return;
        }
        try {
            curr_file_name = changeTree.getFileName();
            CorpusDraw.correctOutDom();
            PrintTree.PrintToken(changeTree, out_stuff);
        }
        catch (NullPointerException nullPointerException) {
            System.err.println("in CorpusDraw.printToCorrectOutput:  ");
            changeTree.PrintToSystemErr(0, 5);
            System.err.println("");
            System.exit(1);
        }
    }

    public static void correctOutDom() {
        if (prev_file_name.equals(curr_file_name)) {
            return;
        }
        if (!first_out_file) {
            out_stuff.flush();
            out_stuff.println("");
            out_dom.close();
            CorpusDraw.OutMessage();
        }
        first_out_file = false;
        dest_name = curr_file_name + ".new";
        out_dom = new OutFileDominatrix(dest_name);
        out_stuff = out_dom.getPrintWriter();
        prev_file_name = curr_file_name;
    }

    public static void PrintBookmark() {
        System.err.println("");
        System.err.println(Vitals.c_note);
        System.err.println("");
        System.err.println("CorpusDraw version " + Vitals.version_number);
        System.err.println("");
        System.err.print("CorpusDraw Manual:  ");
        System.err.println(Vitals.manual_address);
        System.err.println("");
    }

    public static void WrongArgsMessage() {
        System.err.println("");
        System.err.println("to run CorpusDraw, use 1 or 2 arguments:  ");
        System.err.println("    CorpusDraw <source_file_name>");
        System.err.println("or:  ");
        System.err.print("    CorpusDraw <query_file_name> ");
        System.err.println("<source_file_name>");
        System.err.println("");
    }

    public static void OutMessage() {
        System.err.println("");
        System.err.println("");
        System.err.println("Output file is ");
        System.err.println("    " + dest_name);
        System.err.println("");
        System.err.println("");
    }

    static {
        show_str = "";
        show_list = new ArgList();
        MIN_HT = 1200;
        MIN_WDTH = 20000;
        file_dex = 0;
    }
}

