/*
 * Decompiled with CFR 0.152.
 */
package drawtree;

import basicinfo.ArgList;
import drawtree.CorpusDraw;
import drawtree.GraphicNode;
import java.util.BitSet;
import java.util.Vector;
import syntree.ChangeTree;
import syntree.Node;

public class CollapseIt {
    private BitSet collapsed_bits;
    private Vector selected_coll_roots;
    private Vector expanded_roots;
    private Vector listed_coll_roots;
    private static boolean collapse;
    private static boolean expand_all;
    private static boolean expand_selected;
    private static String collapse_str;
    private static ArgList collapse_list;

    public CollapseIt() {
        this.Init();
    }

    public void Init() {
        this.selected_coll_roots = new Vector();
        this.listed_coll_roots = new Vector();
        this.expanded_roots = new Vector();
        collapse = false;
    }

    public void clearCollapsed() {
        this.selected_coll_roots.removeAllElements();
        this.expanded_roots.removeAllElements();
        collapse_str = "";
        collapse = false;
    }

    public String toString() {
        String string = "";
        for (int i = 0; i < this.selected_coll_roots.size(); ++i) {
            Node node = (Node)this.selected_coll_roots.elementAt(i);
            string = string + new StringBuffer().append(node.toString()).append("  ");
        }
        if (!collapse_str.equals("")) {
            string = string + new StringBuffer("[").append(collapse_str).append("]");
        }
        return string;
    }

    public boolean rootsEmpty() {
        return this.selected_coll_roots.isEmpty() && this.listed_coll_roots.isEmpty();
    }

    public void removeAllCollapsed() {
        this.selected_coll_roots.removeAllElements();
        if (collapse_str.equals("")) {
            collapse = false;
        }
    }

    public void removeAllExpanded() {
        expand_selected = false;
        this.expanded_roots.removeAllElements();
    }

    public void expandAll() {
        expand_all = true;
    }

    public void expandAll(boolean bl) {
        expand_all = bl;
    }

    public void expandSelected() {
        expand_selected = true;
    }

    public void setCollapseList(ChangeTree changeTree, String string) {
        collapse_str = string;
        this.listed_coll_roots.removeAllElements();
        if (string.equals("")) {
            this.setCollapsedBits(changeTree);
            return;
        }
        collapse_list = new ArgList(collapse_str);
        collapse = true;
        this.getRootsFromList(changeTree);
        this.setCollapsedBits(changeTree);
    }

    public String getCollapseStr() {
        return collapse_str;
    }

    public void setCollapse(boolean bl) {
        if (bl) {
            this.expanded_roots.removeAllElements();
        }
        collapse = bl;
    }

    public boolean willCollapse() {
        return collapse;
    }

    public boolean isCollapsed(int n) {
        return this.collapsed_bits.get(n);
    }

    public boolean isCollapsed(Integer n) {
        return this.isCollapsed((int)n);
    }

    public void addToCollapsedRoots(ChangeTree changeTree, GraphicNode graphicNode) {
        this.addToCollapsedRoots(changeTree, graphicNode.getNode());
    }

    public void addToCollapsedRoots(ChangeTree changeTree, Node node) {
        collapse = true;
        expand_all = false;
        expand_selected = false;
        this.removeNodeFromList(node, this.expanded_roots);
        Vector vector = changeTree.GetAncestors(node);
        this.removeList1FromList2(vector, this.selected_coll_roots);
        this.removeNodeFromList(node, this.selected_coll_roots);
        this.selected_coll_roots.addElement(node);
    }

    public void removeFromCollapsedRoots(GraphicNode graphicNode) {
        this.removeFromCollapsedRoots(graphicNode.getNode());
    }

    public void removeFromCollapsedRoots(Node node) {
        this.expanded_roots.addElement(node);
    }

    public void getRootsFromList(ChangeTree changeTree) {
        if (collapse_list.isEmpty()) {
            if (this.listed_coll_roots.isEmpty()) {
                collapse = false;
                return;
            }
            collapse = true;
            return;
        }
        for (int i = 0; i < changeTree.size(); ++i) {
            Node node = changeTree.NodeAt(i);
            if (!collapse_list.hasMatch(node)) continue;
            this.addNodeToListNoDupes(node, this.listed_coll_roots);
        }
        collapse = !this.listed_coll_roots.isEmpty();
    }

    public void setCollapsedBits(ChangeTree changeTree) {
        try {
            try {
                int n;
                int n2;
                Node node;
                int n3;
                this.collapsed_bits = new BitSet(changeTree.size());
                if (expand_all) {
                    collapse = false;
                    return;
                }
                this.removeList1FromList2(this.expanded_roots, this.selected_coll_roots);
                this.removeList1FromList2(this.expanded_roots, this.listed_coll_roots);
                if (!expand_selected) {
                    for (n3 = 0; n3 < this.selected_coll_roots.size(); ++n3) {
                        collapse = true;
                        node = (Node)this.selected_coll_roots.elementAt(n3);
                        n2 = changeTree.intEndDexAt(node.getIndex());
                        for (n = node.getIndex_int(); n <= n2; ++n) {
                            this.collapsed_bits.set(n);
                        }
                    }
                }
                for (n3 = 0; n3 < this.listed_coll_roots.size(); ++n3) {
                    collapse = true;
                    node = (Node)this.listed_coll_roots.elementAt(n3);
                    n2 = changeTree.intEndDexAt(node.getIndex());
                    for (n = node.getIndex_int(); n <= n2; ++n) {
                        this.collapsed_bits.set(n);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        catch (Throwable throwable) {}
    }

    public Vector getCollapsedLeaves(int n, ChangeTree changeTree) {
        Node node;
        Vector<Node> vector = new Vector<Node>();
        if (!collapse) {
            return vector;
        }
        Node node2 = changeTree.NodeAt(n);
        Node node3 = node = changeTree.GetMother(node2);
        while (!node.IsNullNode()) {
            int n2 = node.getIndex_int();
            if (!this.collapsed_bits.get(n2)) {
                node = node3;
                break;
            }
            node3 = node;
            node = changeTree.GetMother(node3);
        }
        int n3 = changeTree.intEndDexAt(node.getIndex_int());
        for (int i = n; i <= n3; ++i) {
            if (!changeTree.IsLeafText(i)) continue;
            vector.addElement(changeTree.NodeAt(i));
        }
        return vector;
    }

    public Node getCollRoot(Vector vector) {
        return this.getCollRoot(vector, CorpusDraw.currTree().getChangeTree());
    }

    public Node getCollRoot(Vector vector, ChangeTree changeTree) {
        Node node = new Node("NULL");
        Node node2 = new Node("NULL");
        Node node3 = new Node("NULL");
        if (vector.isEmpty()) {
            return node3;
        }
        try {
            try {
                node = (Node)vector.firstElement();
                node2 = (Node)vector.lastElement();
                node3 = changeTree.GetCommonAncestor(node, node2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.err.println("first:  " + node.toString());
                System.err.println("last:  " + node2.toString());
            }
        }
        catch (Throwable throwable) {}
        return node3;
    }

    public Node getCollapseSubRoot(Node node) {
        return this.getCollapseSubRoot(node, CorpusDraw.currTree().getChangeTree());
    }

    public Node getCollapseSubRoot(Node node, ChangeTree changeTree) {
        Node node2;
        Node node3 = node2 = changeTree.GetMother(node);
        while (this.collapsed_bits.get(node2.getIndex_int())) {
            node3 = node2;
            node2 = changeTree.GetMother(node2);
        }
        return node3;
    }

    public boolean isCollapseSubRoot(Node node) {
        return this.isCollapseSubRoot(node, CorpusDraw.currTree().getChangeTree());
    }

    public boolean isCollapseSubRoot(Node node, ChangeTree changeTree) {
        Node node2 = changeTree.GetMother(node);
        return this.collapsed_bits.get(node.getIndex_int()) && !this.collapsed_bits.get(node2.getIndex_int());
    }

    public int getCollapsedEnd(Node node) {
        return this.getCollapsedEnd(node, CorpusDraw.currTree().getChangeTree());
    }

    public int getCollapsedEnd(Node node, ChangeTree changeTree) {
        Node node2 = this.getCollapseSubRoot(node, changeTree);
        int n = changeTree.intEndDexAt(node2.getIndex_int());
        return n;
    }

    public void PrintToSystemErr() {
        System.err.print("collapse:  " + collapse + ",  ");
        System.err.println("expand_all:  " + expand_all);
        this.PrintNodesVectorToSystemErr(this.selected_coll_roots, "selected_coll_roots");
        this.PrintNodesVectorToSystemErr(this.listed_coll_roots, "listed_coll_roots");
        this.PrintNodesVectorToSystemErr(this.expanded_roots, "expanded_roots");
    }

    public void PrintNodesVectorToSystemErr(Vector vector, String string) {
        System.err.println(string + ": ");
        System.err.print("  ");
        for (int i = 0; i < vector.size(); ++i) {
            Node node = (Node)vector.elementAt(i);
            System.err.print(node.toString());
            if (i >= vector.size() - 1) continue;
            System.err.print(", ");
        }
        if (vector.isEmpty()) {
            System.err.print("EMPTY");
        }
        System.err.println("");
    }

    public void removeList1FromList2(Vector vector, Vector vector2) {
        if (vector.isEmpty() || vector2.isEmpty()) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            Node node = (Node)vector.elementAt(i);
            for (int j = 0; j < vector2.size(); ++j) {
                Node node2 = (Node)vector2.elementAt(j);
                if (!node.equals(node2)) continue;
                vector2.removeElementAt(j);
            }
        }
    }

    public void removeNodeFromList(Node node, Vector vector) {
        if (vector.isEmpty()) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            Node node2 = (Node)vector.elementAt(i);
            if (!node2.equals(node)) continue;
            vector.removeElementAt(i);
        }
    }

    public void addNodeToListNoDupes(Node node, Vector vector) {
        if (vector.isEmpty()) {
            vector.addElement(node);
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            Node node2 = (Node)vector.elementAt(i);
            if (!node2.equals(node)) continue;
            return;
        }
        vector.addElement(node);
    }
}

