/*
 * Decompiled with CFR 0.152.
 */
package csearch;

import CSParse.ParseQuery;
import basicinfo.Goodbye;
import command.CommandInfo;
import csearch.CorpusSearch;
import csearch.Meat;
import csearch.SentenceLoopOtt;
import csearch.SentenceLoopPOS_1;
import io.InFileDominatrix;
import io.TBToRix;
import io.VectorAux;
import print.PrintOut;
import print.PrintTree;
import search.Revisions;
import search_result.SentenceResult;
import stats.StatsPerFile;
import syntree.ChangeTree;
import syntree.SynTree;

public class SentenceLoop
extends Meat {
    public static String prev_ID = "NO_FILE_ID";
    public static SynTree sparse;
    public static boolean did_it;

    public static void thruFile(String string) {
        InFileDominatrix inFileDominatrix = new InFileDominatrix(string);
        if (inFileDominatrix.getFormat().equals("POS_0")) {
            SentenceLoopOtt.thruFile(inFileDominatrix, Meat.OutStuff);
            return;
        }
        if (inFileDominatrix.getFormat().equals("POS_1")) {
            SentenceLoopPOS_1.thruFile(inFileDominatrix, Meat.OutStuff);
            return;
        }
        TBToRix tBToRix = new TBToRix(inFileDominatrix, Meat.OutStuff);
        try {
            try {
                Meat.file_info = new StatsPerFile(string);
                if (CommandInfo.print_complement) {
                    Meat.comp_file_info = new StatsPerFile(CorpusSearch.comp_name);
                }
                PrintOut.Header(Meat.file_info.getFileID(), Meat.OutStuff);
                while (!(sparse = tBToRix.OneSentence()).isEmpty()) {
                    int n;
                    SentenceResult sentenceResult = ParseQuery.evaluable(sparse);
                    if (CommandInfo.reconstruct) {
                        SynTree synTree = sparse.synCopy();
                        ChangeTree changeTree = new ChangeTree(synTree);
                        did_it = changeTree.reconstruct(CommandInfo.recon_arg);
                        sentenceResult = ParseQuery.evaluable(synTree);
                    }
                    if (Meat.searching_output) {
                        SentenceLoop.outputFileNames();
                    }
                    Meat.file_info.totalAdd1();
                    if (CommandInfo.print_complement) {
                        Meat.comp_file_info.totalAdd1();
                    }
                    if (!sentenceResult.isEmpty()) {
                        if (CommandInfo.revise) {
                            Revisions.Plain(sparse, CommandInfo.tasker, sentenceResult);
                        }
                        n = sentenceResult.CountHits();
                        Meat.file_info.hitsAdd(n);
                        Meat.file_info.tokensAdd1();
                        PrintOut.UrTextStuff(VectorAux.ur_vec, sparse, Meat.OutStuff);
                        PrintOut.Comments(sentenceResult, Meat.OutStuff);
                        PrintTree.PrintToken(sparse, sentenceResult, Meat.OutStuff);
                    } else if (CommandInfo.print_complement) {
                        n = sentenceResult.CountHits();
                        Meat.comp_file_info.hitsAdd(n);
                        Meat.comp_file_info.tokensAdd1();
                        PrintOut.UrTextStuff(VectorAux.ur_vec, sparse, Meat.CompStuff);
                        PrintTree.PrintToken(sparse, sentenceResult, Meat.CompStuff);
                    }
                    if (!sparse.isEmpty()) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                System.err.println("in SentenceLoop.thruFile:  ");
                System.err.println(exception.getMessage());
                exception.printStackTrace();
                tBToRix.CorpusError();
                Goodbye.SearchExit();
            }
        }
        catch (Throwable throwable) {}
        Meat.search_info.file_statsAdd(Meat.file_info);
        PrintOut.Footer(Meat.file_info, Meat.OutStuff);
        if (CommandInfo.print_complement) {
            Meat.comp_search_info.file_statsAdd(Meat.comp_file_info);
            PrintOut.Footer(Meat.comp_file_info, Meat.CompStuff);
        }
    }

    private static void outputFileNames() {
        if (prev_ID.equals("NO_FILE_ID")) {
            Meat.file_info = new StatsPerFile(VectorAux.file_ID);
            PrintOut.Header(VectorAux.file_ID, Meat.OutStuff);
            if (CommandInfo.print_complement) {
                Meat.comp_file_info = new StatsPerFile(VectorAux.file_ID);
                PrintOut.Header(VectorAux.file_ID, Meat.CompStuff);
            }
        } else if (!VectorAux.file_ID.equals(prev_ID)) {
            PrintOut.Footer(Meat.file_info, Meat.OutStuff);
            PrintOut.Header(VectorAux.file_ID, Meat.OutStuff);
            Meat.search_info.file_statsAdd(Meat.file_info);
            Meat.file_info = new StatsPerFile(VectorAux.file_ID);
            if (CommandInfo.print_complement) {
                PrintOut.Footer(Meat.file_info, Meat.CompStuff);
                PrintOut.Header(VectorAux.file_ID, Meat.CompStuff);
                Meat.comp_search_info.file_statsAdd(Meat.comp_file_info);
                Meat.comp_file_info = new StatsPerFile(VectorAux.file_ID);
            }
        }
        prev_ID = VectorAux.file_ID;
    }
}

