/*
 * Decompiled with CFR 0.152.
 */
package command;

import basicinfo.ArgList;
import basicinfo.Goodbye;
import command.CommandInfo;
import command.Definite;
import command.ReadAuxStr;
import io.IoInfo;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import lexicon.LocalLoop;
import print.Parameters;

public class BasicStrCommands
extends CommandInfo {
    private static String begin = "NO_BEGIN_COMMENT_FOUND";
    private static String end = "NO_END_COMMENT_FOUND";

    public static boolean Store(String string) {
        if (BasicStrCommands.Fundamentals(string)) {
            return true;
        }
        if (BasicStrCommands.Basics(string)) {
            return true;
        }
        if (BasicStrCommands.CorpusSpecs(string)) {
            return true;
        }
        if (BasicStrCommands.PrintSpecs(string)) {
            return true;
        }
        if (BasicStrCommands.ReviseSpecs(string)) {
            return true;
        }
        if (BasicStrCommands.LexStuff(string)) {
            return true;
        }
        if (BasicStrCommands.DrawStuff(string)) {
            return true;
        }
        BasicStrCommands.CodingQueryError(string);
        return false;
    }

    public static boolean Fundamentals(String string) {
        if (string.startsWith("begin_remark:")) {
            ReadAuxStr.Get_Remark(string);
            return true;
        }
        if (string.startsWith("node:")) {
            CommandInfo.node = ReadAuxStr.Get_String(string);
            return true;
        }
        if (string.startsWith("define:")) {
            CommandInfo.def_name = ReadAuxStr.Get_String(string);
            CommandInfo.use_def_file = true;
            Definite.MakeDefVector(CommandInfo.def_name);
            return true;
        }
        if (string.startsWith("reconstruct:")) {
            CommandInfo.recon_str = ReadAuxStr.Get_String(string);
            CommandInfo.reconstruct = true;
            CommandInfo.recon_arg = new ArgList(CommandInfo.recon_str);
            return true;
        }
        return false;
    }

    public static boolean LexStuff(String string) {
        if (string.startsWith("make_lexicon:")) {
            CommandInfo.make_lexicon = ReadAuxStr.Get_boolean(string);
            return true;
        }
        if (string.startsWith("make_label_lexicon:")) {
            CommandInfo.make_label_lexicon = ReadAuxStr.Get_boolean(string);
            return true;
        }
        if (string.startsWith("pos_labels:")) {
            LocalLoop.SetPosLabels(ReadAuxStr.Get_String(string));
            return true;
        }
        if (string.startsWith("text_labels:")) {
            LocalLoop.SetTextLabels(ReadAuxStr.Get_String(string));
            return true;
        }
        if (string.startsWith("make_tag_list:")) {
            CommandInfo.ignore = "";
            CommandInfo.make_tag_list = ReadAuxStr.Get_boolean(string);
            return true;
        }
        return false;
    }

    public static boolean CorpusSpecs(String string) {
        if (string.startsWith("corpus_file_extension:")) {
            return true;
        }
        if (string.startsWith("corpus_comment_begin:")) {
            begin = ReadAuxStr.Get_String(string);
            return true;
        }
        if (string.startsWith("corpus_comment_end:")) {
            end = ReadAuxStr.Get_String(string);
            IoInfo.commie.addCommPair(begin, end);
            return true;
        }
        if (string.startsWith("corpus_line_comment:")) {
            begin = ReadAuxStr.Get_String(string);
            IoInfo.linie.addLineComm(begin);
            return true;
        }
        if (string.startsWith("corpus_encoding:")) {
            CommandInfo.char_encoding = ReadAuxStr.Get_String(string);
            IoInfo.setCorpusEncoding(CommandInfo.char_encoding);
            return true;
        }
        if (string.startsWith("errors_to_output:")) {
            IoInfo.setErrorsToOutput(ReadAuxStr.Get_boolean(string));
            return true;
        }
        return false;
    }

    public static boolean PrintSpecs(String string) {
        if (string.startsWith("set_margin:")) {
            Parameters.margin = ReadAuxStr.Get_int(string);
            return true;
        }
        if (string.startsWith("nodes_only:")) {
            Parameters.nodes_only = ReadAuxStr.Get_boolean(string);
            if (!Parameters.nodes_only) {
                Parameters.remove_nodes = false;
            }
            return true;
        }
        if (string.startsWith("remove_nodes:")) {
            Parameters.remove_nodes = ReadAuxStr.Get_boolean(string);
            return true;
        }
        if (string.startsWith("print_indices:")) {
            Parameters.print_indices = ReadAuxStr.Get_boolean(string);
            return true;
        }
        if (string.startsWith("print_complement:")) {
            CommandInfo.print_complement = ReadAuxStr.Get_boolean(string);
            return true;
        }
        if (string.startsWith("copy_corpus:")) {
            CommandInfo.copy_corpus = ReadAuxStr.Get_boolean(string);
            Parameters.print_indices = false;
            return true;
        }
        if (string.startsWith("reformat_corpus:")) {
            CommandInfo.reformat_corpus = ReadAuxStr.Get_boolean(string);
            Parameters.print_indices = false;
            return true;
        }
        if (string.startsWith("print_only:")) {
            CommandInfo.lonely = ReadAuxStr.Get_String(string);
            CommandInfo.print_only = true;
            return true;
        }
        if (string.startsWith("ur_text_only:")) {
            Parameters.ur_text_only = ReadAuxStr.Get_boolean(string);
            return true;
        }
        if (string.startsWith("output_format:")) {
            CommandInfo.output_format = ReadAuxStr.Get_String(string);
            Parameters.setOutputFormat(CommandInfo.output_format);
            return true;
        }
        if (string.startsWith("multi_output:")) {
            CommandInfo.multi_output = ReadAuxStr.Get_boolean(string);
            return true;
        }
        return false;
    }

    public static void setOutputFormat(String string) {
        CommandInfo.output_format = string;
        Parameters.setOutputFormat(string);
    }

    public static boolean ReviseSpecs(String string) {
        if (string.startsWith("replace_label") || string.startsWith("append_label") || string.startsWith("prepend_label") || string.startsWith("post_crop_label") || string.startsWith("pre_crop_label") || string.startsWith("add_leaf") || string.startsWith("move_up_node") || string.startsWith("delete") || string.startsWith("add_internal_node") || string.startsWith("make_daughter") || string.startsWith("trace") || string.startsWith("move_to")) {
            CommandInfo.revise = true;
            return true;
        }
        return false;
    }

    public static boolean Basics(String string) {
        if (string.startsWith("ignore_nodes:")) {
            CommandInfo.ignore = ReadAuxStr.Get_String(string);
            if (CommandInfo.ignore.equals("null")) {
                CommandInfo.ignore = "";
            }
            return true;
        }
        if (string.startsWith("add_to_ignore:")) {
            CommandInfo.ignore = CommandInfo.ignore + new StringBuffer("|").append(ReadAuxStr.Get_String(string));
            return true;
        }
        if (string.startsWith("ignore_words:")) {
            CommandInfo.word_ignore = ReadAuxStr.Get_String(string);
            if (CommandInfo.word_ignore.equals("null")) {
                CommandInfo.word_ignore = "";
            }
            return true;
        }
        if (string.startsWith("add_to_ignore_words:")) {
            CommandInfo.word_ignore = CommandInfo.word_ignore + new StringBuffer("|").append(ReadAuxStr.Get_String(string));
            return true;
        }
        return false;
    }

    public static boolean DrawStuff(String string) {
        if (string.startsWith("show_only:")) {
            CommandInfo.show_str = ReadAuxStr.Get_String(string);
            CommandInfo.show_only = true;
            return true;
        }
        return false;
    }

    public static void CommandNotFoundError(String string) {
        try {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                String string2 = "";
                System.err.println("ERROR! command not recognized:  " + string);
                System.err.print("Search aborted because of error ");
                System.err.println("in command file.");
                System.err.println("");
            }
            catch (Exception exception) {
                System.err.println("In BasicCommands.CommandNotFoundError:  ");
                System.err.println(exception.getMessage());
            }
        }
        catch (Throwable throwable) {}
        Goodbye.SearchExit();
    }

    public static void CodingQueryError(String string) {
        Character c = new Character('Q');
        for (int i = 0; i < string.length() - 1; ++i) {
            if (Character.isDigit(string.charAt(i))) continue;
            return;
        }
        System.err.print("ERROR!  Coding queries ");
        System.err.println("must now begin with this line:");
        System.err.println("    coding_query:    ");
        System.err.println("Search aborted.");
        Goodbye.SearchExit();
    }
}

