/*
 * Decompiled with CFR 0.152.
 */
package command;

import basicinfo.ArgList;
import basicinfo.Goodbye;
import command.CommandInfo;
import command.Definite;
import command.ReadAux;
import io.InFileDominatrix;
import io.IoInfo;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import lexicon.LocalLoop;
import print.Parameters;
import revise.OneTask;

public class BasicCommands
extends CommandInfo {
    private static String begin = "NO_BEGIN_COMMENT_FOUND";
    private static String end = "NO_END_COMMENT_FOUND";

    public static boolean Store(String string, InFileDominatrix inFileDominatrix) {
        if (BasicCommands.Fundamentals(string, inFileDominatrix)) {
            return true;
        }
        if (BasicCommands.Basics(string, inFileDominatrix)) {
            return true;
        }
        if (BasicCommands.CorpusSpecs(string, inFileDominatrix)) {
            return true;
        }
        if (BasicCommands.PrintSpecs(string, inFileDominatrix)) {
            return true;
        }
        if (BasicCommands.ReviseSpecs(string, inFileDominatrix)) {
            return true;
        }
        if (BasicCommands.LexStuff(string, inFileDominatrix)) {
            return true;
        }
        if (BasicCommands.DrawStuff(string, inFileDominatrix)) {
            return true;
        }
        BasicCommands.CodingQueryError(string, inFileDominatrix);
        return false;
    }

    public static boolean Fundamentals(String string, InFileDominatrix inFileDominatrix) {
        if (string.startsWith("query:")) {
            CommandInfo.orig_query = CommandInfo.query = ReadAux.Get_Query(string, inFileDominatrix);
            return true;
        }
        if (string.startsWith("begin_remark:")) {
            ReadAux.Get_Remark(string, inFileDominatrix);
            return true;
        }
        if (string.startsWith("node:")) {
            CommandInfo.node = ReadAux.Get_String(string, inFileDominatrix);
            return true;
        }
        if (string.startsWith("define:")) {
            CommandInfo.def_name = ReadAux.Get_String(string, inFileDominatrix);
            CommandInfo.use_def_file = true;
            Definite.MakeDefVector(CommandInfo.def_name);
            return true;
        }
        if (string.startsWith("local_frames:")) {
            CommandInfo.do_frames = true;
            CommandInfo.orig_query = CommandInfo.query = ReadAux.Get_Query(string, inFileDominatrix);
            return true;
        }
        if (string.startsWith("reconstruct:")) {
            CommandInfo.recon_str = ReadAux.Get_String(string, inFileDominatrix);
            CommandInfo.reconstruct = true;
            CommandInfo.recon_arg = new ArgList(CommandInfo.recon_str);
            return true;
        }
        if (string.startsWith("coding_query:")) {
            CommandInfo.orig_coding_query = CommandInfo.coding_query = ReadAux.Get_Query(string, inFileDominatrix);
            CommandInfo.do_coding = true;
            return true;
        }
        return false;
    }

    public static boolean LexStuff(String string, InFileDominatrix inFileDominatrix) {
        if (string.startsWith("make_lexicon:")) {
            CommandInfo.make_lexicon = ReadAux.Get_boolean(string, inFileDominatrix);
            return true;
        }
        if (string.startsWith("make_label_lexicon:")) {
            CommandInfo.make_label_lexicon = ReadAux.Get_boolean(string, inFileDominatrix);
            return true;
        }
        if (string.startsWith("pos_labels:")) {
            LocalLoop.SetPosLabels(ReadAux.Get_String(string, inFileDominatrix));
            return true;
        }
        if (string.startsWith("text_labels:")) {
            LocalLoop.SetTextLabels(ReadAux.Get_String(string, inFileDominatrix));
            return true;
        }
        if (string.startsWith("make_tag_list:")) {
            CommandInfo.ignore = "";
            CommandInfo.make_tag_list = ReadAux.Get_boolean(string, inFileDominatrix);
            return true;
        }
        return false;
    }

    public static boolean CorpusSpecs(String string, InFileDominatrix inFileDominatrix) {
        if (string.startsWith("corpus_file_extension:")) {
            return true;
        }
        if (string.startsWith("corpus_comment_begin:")) {
            begin = ReadAux.Get_String(string, inFileDominatrix);
            return true;
        }
        if (string.startsWith("corpus_comment_end:")) {
            end = ReadAux.Get_String(string, inFileDominatrix);
            IoInfo.commie.addCommPair(begin, end);
            return true;
        }
        if (string.startsWith("corpus_line_comment:")) {
            begin = ReadAux.Get_String(string, inFileDominatrix);
            IoInfo.linie.addLineComm(begin);
            return true;
        }
        if (string.startsWith("corpus_encoding:")) {
            CommandInfo.char_encoding = ReadAux.Get_String(string, inFileDominatrix);
            IoInfo.setCorpusEncoding(CommandInfo.char_encoding);
            return true;
        }
        if (string.startsWith("errors_to_output:")) {
            IoInfo.setErrorsToOutput(ReadAux.Get_boolean(string, inFileDominatrix));
            return true;
        }
        return false;
    }

    public static boolean PrintSpecs(String string, InFileDominatrix inFileDominatrix) {
        if (string.startsWith("append_to_CODING:")) {
            CommandInfo.append_to_CODING = "-" + ReadAux.Get_String(string, inFileDominatrix);
            return true;
        }
        if (string.startsWith("set_margin:")) {
            Parameters.margin = ReadAux.Get_int(string, inFileDominatrix);
            return true;
        }
        if (string.startsWith("nodes_only:")) {
            Parameters.nodes_only = ReadAux.Get_boolean(string, inFileDominatrix);
            if (!Parameters.nodes_only) {
                Parameters.remove_nodes = false;
            }
            return true;
        }
        if (string.startsWith("remove_nodes:")) {
            Parameters.remove_nodes = ReadAux.Get_boolean(string, inFileDominatrix);
            return true;
        }
        if (string.startsWith("print_indices:")) {
            Parameters.print_indices = ReadAux.Get_boolean(string, inFileDominatrix);
            return true;
        }
        if (string.startsWith("print_complement:")) {
            CommandInfo.print_complement = ReadAux.Get_boolean(string, inFileDominatrix);
            return true;
        }
        if (string.startsWith("copy_corpus:")) {
            CommandInfo.copy_corpus = ReadAux.Get_boolean(string, inFileDominatrix);
            Parameters.print_indices = false;
            return true;
        }
        if (string.startsWith("reformat_corpus:")) {
            CommandInfo.reformat_corpus = ReadAux.Get_boolean(string, inFileDominatrix);
            Parameters.print_indices = false;
            return true;
        }
        if (string.startsWith("print_only:")) {
            CommandInfo.lonely = ReadAux.Get_String(string, inFileDominatrix);
            CommandInfo.print_only = true;
            return true;
        }
        if (string.startsWith("add_IDs:")) {
            CommandInfo.print_only_add_IDs = ReadAux.Get_boolean(string, inFileDominatrix);
            return true;
        }
        if (string.startsWith("ur_text_only:")) {
            Parameters.ur_text_only = ReadAux.Get_boolean(string, inFileDominatrix);
            return true;
        }
        if (string.startsWith("output_format:")) {
            CommandInfo.output_format = ReadAux.Get_String(string, inFileDominatrix);
            Parameters.setOutputFormat(CommandInfo.output_format);
            return true;
        }
        if (string.startsWith("multi_output:")) {
            CommandInfo.multi_output = ReadAux.Get_boolean(string, inFileDominatrix);
            return true;
        }
        return false;
    }

    public static void setOutputFormat(String string) {
        CommandInfo.output_format = string;
        Parameters.setOutputFormat(string);
    }

    public static boolean ReviseSpecs(String string, InFileDominatrix inFileDominatrix) {
        if (string.startsWith("replace_label") || string.startsWith("append_label") || string.startsWith("prepend_label") || string.startsWith("post_crop_label") || string.startsWith("pre_crop_label") || string.startsWith("add_leaf") || string.startsWith("move_up_node") || string.startsWith("delete") || string.startsWith("add_internal_node") || string.startsWith("make_daughter") || string.startsWith("trace") || string.startsWith("co_index") || string.startsWith("move_to") || string.startsWith("concat") || string.startsWith("extend_span")) {
            CommandInfo.revise = true;
            OneTask oneTask = new OneTask(string + inFileDominatrix.RestOfLine());
            CommandInfo.tasker.addTask(oneTask);
            return true;
        }
        return false;
    }

    public static boolean Basics(String string, InFileDominatrix inFileDominatrix) {
        if (string.startsWith("ignore_nodes:")) {
            CommandInfo.ignore = ReadAux.Get_String(string, inFileDominatrix);
            if (CommandInfo.ignore.equals("null")) {
                CommandInfo.ignore = "";
            }
            return true;
        }
        if (string.startsWith("add_to_ignore:")) {
            CommandInfo.ignore = CommandInfo.ignore + new StringBuffer("|").append(ReadAux.Get_String(string, inFileDominatrix));
            return true;
        }
        if (string.startsWith("ignore_words:")) {
            CommandInfo.word_ignore = ReadAux.Get_String(string, inFileDominatrix);
            if (CommandInfo.word_ignore.equals("null")) {
                CommandInfo.word_ignore = "";
            }
            return true;
        }
        if (string.startsWith("add_to_ignore_words:")) {
            CommandInfo.word_ignore = CommandInfo.word_ignore + new StringBuffer("|").append(ReadAux.Get_String(string, inFileDominatrix));
            return true;
        }
        return false;
    }

    public static boolean DrawStuff(String string, InFileDominatrix inFileDominatrix) {
        if (string.startsWith("show_only:")) {
            CommandInfo.show_str = ReadAux.Get_String(string, inFileDominatrix);
            CommandInfo.show_only = true;
            return true;
        }
        return false;
    }

    public static void CommandNotFoundError(String string, InFileDominatrix inFileDominatrix) {
        try {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                String string2 = "";
                System.err.println("ERROR! command not recognized:  " + string);
                System.err.print("Search aborted because of error ");
                System.err.println("in command file.");
                System.err.println("");
            }
            catch (Exception exception) {
                System.err.println("In BasicCommands.CommandNotFoundError:  ");
                System.err.println(exception.getMessage());
            }
        }
        catch (Throwable throwable) {}
        Goodbye.SearchExit();
    }

    public static void CodingQueryError(String string, InFileDominatrix inFileDominatrix) {
        Character c = new Character('Q');
        for (int i = 0; i < string.length() - 1; ++i) {
            if (Character.isDigit(string.charAt(i))) continue;
            return;
        }
        System.err.print("ERROR!  Coding queries ");
        System.err.println("must now begin with this line:");
        System.err.println("    coding_query:    ");
        System.err.println("Search aborted.");
        Goodbye.SearchExit();
    }
}

