/*
 * Decompiled with CFR 0.152.
 */
package basicinfo;

import basicinfo.RegExpStr;
import java.util.BitSet;
import java.util.Vector;

public class OneTerm
extends RegExpStr {
    boolean has_char_set;
    boolean has_plus;
    boolean has_period;
    boolean last_term;
    boolean has_question_mark;
    boolean plain_char;
    boolean negate;
    boolean has_star;
    boolean is_in_star;
    boolean is_last_star;
    int start_dex;
    int end_dex;
    String orig_term;
    String orig_str;
    char my_char;
    BitSet my_char_set;
    Vector zero_list;

    public OneTerm() {
        this.Init();
    }

    public OneTerm(String string) {
        this.Init();
        this.doString(string);
    }

    public OneTerm(String string, int n) {
        this.Init();
        this.doString(string, n);
    }

    private void Init() {
        this.has_char_set = false;
        this.has_star = false;
        this.has_plus = false;
        this.has_period = false;
        this.plain_char = true;
        this.is_in_star = false;
        this.is_last_star = false;
        this.negate = false;
        this.my_char = (char)81;
        this.orig_term = "";
        this.orig_str = "";
        this.last_term = false;
    }

    public int getEndDex() {
        return this.end_dex;
    }

    public boolean hasStar() {
        return this.has_star;
    }

    public boolean hasPlus() {
        return this.has_plus;
    }

    public boolean hasPeriod() {
        return this.has_period;
    }

    public void markAsLast() {
        this.last_term = true;
        if (this.has_star && !this.has_period && !this.plain_char && !this.has_char_set) {
            this.is_last_star = true;
        }
    }

    public boolean isLastTerm() {
        return this.last_term;
    }

    public boolean isLastStar() {
        return this.is_last_star;
    }

    public void markInternalStar() {
        if (this.last_term) {
            return;
        }
        if (this.has_period && this.has_plus) {
            this.is_in_star = true;
            return;
        }
        if (this.has_star && !this.has_char_set) {
            this.is_in_star = true;
            return;
        }
    }

    public boolean isInternalStar() {
        return this.is_in_star;
    }

    public BitSet getBitSet() {
        if (this.plain_char) {
            BitSet bitSet = new BitSet(this.BIT_SET_SIZE);
            int n = this.getBucketDex(this.my_char);
            bitSet.set(n);
            return bitSet;
        }
        if (this.has_char_set) {
            return this.my_char_set;
        }
        if (this.is_in_star || this.has_period) {
            BitSet bitSet = new BitSet(this.BIT_SET_SIZE);
            for (int i = 0; i < this.BIT_SET_SIZE; ++i) {
                bitSet.set(i);
            }
            return bitSet;
        }
        System.out.println("WARNING:  in OneTerm.getBitSet:  temporary hack:");
        this.PrintToSystemErr();
        BitSet bitSet = new BitSet(this.BIT_SET_SIZE);
        return bitSet;
    }

    private void doString(String string) {
        this.doString(string, 0);
    }

    private void doString(String string, int n) {
        char c;
        this.start_dex = n;
        this.end_dex = n + 1;
        this.orig_str = string;
        if (string.equals("*")) {
            System.err.print("WARNING!  Found \"*\" argument.  ");
            System.err.println("Will interpret as \".*\".");
            this.has_period = true;
        }
        if ((c = this.orig_str.charAt(n)) == '[') {
            this.readCharSet(this.orig_str, n);
            return;
        }
        if (c == '.') {
            this.readPeriod(this.orig_str, n);
            return;
        }
        if (c == '*') {
            this.readStar(this.orig_str, n);
            return;
        }
        if (c == '\\') {
            this.readBackSlash(this.orig_str, n);
            return;
        }
        this.my_char = c;
    }

    private void readPeriod(String string, int n) {
        this.has_period = true;
        this.plain_char = false;
        this.checkStarPlus(string, n);
    }

    private void readStar(String string, int n) {
        this.has_star = true;
        this.plain_char = false;
    }

    private void readBackSlash(String string, int n) {
        if (n + 1 >= string.length()) {
            this.backSlashError(string);
        }
        this.my_char = string.charAt(n + 1);
        this.end_dex = n + 2;
        this.plain_char = true;
    }

    private void readCharSet(String string, int n) {
        boolean bl = true;
        this.has_char_set = true;
        this.plain_char = false;
        this.my_char_set = new BitSet(this.BIT_SET_SIZE);
        if (n + 1 > string.length()) {
            return;
        }
        if (string.charAt(n + 1) == '^') {
            this.readNegCharSet(string, n + 2);
            return;
        }
        for (int i = n + 1; i <= string.length(); ++i) {
            char c;
            if (i == string.length()) {
                this.bracketError(string);
            }
            if ((c = string.charAt(i)) == ']') {
                this.checkStarPlus(string, i);
                return;
            }
            int n2 = this.getBucketDex(c);
            this.my_char_set.set(n2);
            if (n2 != 0) continue;
            if (bl) {
                this.zero_list = new Vector();
                bl = false;
            }
            this.zero_list.addElement(new Character(c));
        }
    }

    private void readNegCharSet(String string, int n) {
        int n2;
        boolean bl = true;
        this.has_char_set = true;
        this.plain_char = false;
        this.my_char_set = new BitSet(this.BIT_SET_SIZE);
        for (n2 = n + 1; n2 < this.BIT_SET_SIZE; ++n2) {
            this.my_char_set.set(n2);
        }
        for (n2 = n + 1; n2 <= string.length(); ++n2) {
            char c;
            if (n2 == string.length()) {
                this.bracketError(string);
            }
            if ((c = string.charAt(n2)) == ']') {
                this.checkStarPlus(string, n2);
                return;
            }
            int n3 = this.getBucketDex(c);
            this.my_char_set.clear(n3);
            if (n3 != 0) continue;
            if (bl) {
                this.zero_list = new Vector();
                bl = false;
            }
            this.zero_list.addElement(new Character(c));
        }
    }

    private void checkStarPlus(String string, int n) {
        if (n + 1 >= string.length()) {
            this.end_dex = n + 1;
            return;
        }
        char c = string.charAt(n + 1);
        if (c == '+') {
            this.has_plus = true;
            this.end_dex = n + 2;
            return;
        }
        if (c == '*') {
            this.has_star = true;
            this.end_dex = n + 2;
            return;
        }
        if (c == '?') {
            this.has_question_mark = true;
            this.end_dex = n + 2;
            return;
        }
        this.end_dex = n + 1;
    }

    public int match(String string, int n) {
        if (this.plain_char) {
            if (string.charAt(n) == this.my_char) {
                return n + 1;
            }
            return -1;
        }
        if (this.has_char_set) {
            if (this.has_star) {
                if (n >= string.length()) {
                    return n + 1;
                }
                for (int i = n; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    if (this.charInBitSet(c)) continue;
                    return i;
                }
                return string.length() + 1;
            }
            if (this.has_plus) {
                if (n >= string.length()) {
                    return -1;
                }
                for (int i = n; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    if (this.charInBitSet(c)) continue;
                    if (i == n) {
                        return -1;
                    }
                    return i;
                }
                return string.length() + 1;
            }
            char c = string.charAt(n);
            if (this.charInBitSet(c)) {
                return n + 1;
            }
            return -1;
        }
        if (this.has_star) {
            if (this.last_term) {
                return string.length() + 1;
            }
            return -1;
        }
        if (this.has_period) {
            return n + 1;
        }
        return -1;
    }

    private boolean charInBitSet(char c) {
        int n = this.getBucketDex(c);
        if (!this.my_char_set.get(n)) {
            return false;
        }
        if (n == 0) {
            return this.charInZeroList(c);
        }
        return true;
    }

    private boolean charInZeroList(char c) {
        for (int i = 0; i < this.zero_list.size(); ++i) {
            Character c2 = (Character)this.zero_list.elementAt(i);
            if (c2.charValue() != c) continue;
            return true;
        }
        return false;
    }

    private void bracketError(String string) {
        String string2 = "ERROR! unclosed [ in string: " + string;
        System.err.println(string2);
        System.exit(1);
    }

    private void backSlashError(String string) {
        String string2 = "ERROR! backslash at end of string:  " + string;
        System.err.println(string2);
        System.exit(1);
    }

    public String toString() {
        String string = "";
        if (this.plain_char) {
            if (this.my_char == '*') {
                string = string + '\\';
            }
            string = string + this.my_char;
            return string;
        }
        if (this.has_char_set) {
            string = string + "[";
            for (int i = 0; i < this.my_char_set.size(); ++i) {
                if (!this.my_char_set.get(i)) continue;
                string = string + this.getCharForDex(i);
            }
            string = string + "]";
            if (this.has_star) {
                string = string + "*";
            }
            if (this.has_plus) {
                string = string + "+";
            }
            if (this.has_question_mark) {
                string = string + "?";
            }
            return string;
        }
        if (this.has_period) {
            string = string + ".";
        }
        if (this.has_star) {
            string = this.is_in_star ? string + "in*" : (this.is_last_star ? string + "last*" : string + "*");
        }
        if (this.has_question_mark) {
            string = string + "?";
        }
        return string;
    }

    public void PrintToSystemErr() {
        System.err.println("has_period:  " + this.has_period);
        System.err.println(this.toString());
    }
}

